/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.action;

import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.helper.StreamScanConfigurationPair;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryView;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ShowScanResultsAction
extends Action
implements IObjectActionDelegate {
    private IScanConfiguration scanConfiguration;
    private IWorkspace stream;
    private IWorkbenchPart workbench;

    public ShowScanResultsAction() {
        super(Messages.ShowScanResultsAction_LABEL);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/elcl16/showScanResults.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/dlcl16/showScanResults.gif"));
    }

    public void run() {
        this.run(null);
    }

    public void run(IAction action) {
        Shell activeShell = this.workbench == null ? Display.getCurrent().getActiveShell() : this.workbench.getSite().getShell();
        if (this.scanConfiguration == null || this.stream == null) {
            MessageDialog.openError((Shell)activeShell, (String)Messages.ERROR_DIALOG_TITLE, (String)Messages.ShowScanResultsAction_NO_SCAN_CONFIGURATION_SELECTED);
            return;
        }
        ScanQueryView.openQueryView(this.scanConfiguration, this.stream);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.scanConfiguration = null;
        this.stream = null;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof StreamScanConfigurationPair) {
            StreamScanConfigurationPair pair = (StreamScanConfigurationPair)obj;
            this.scanConfiguration = pair.getScanConfiguration();
            this.stream = pair.getStream();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbench = targetPart;
    }
}

