/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.action;

import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQuery;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryResult;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryRow;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryView;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IWorkspace;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;

public abstract class RunScanQueryAction
extends Action {
    private ScanQueryView view;

    public RunScanQueryAction(ScanQueryView view) {
        this.view = view;
    }

    protected abstract ScanQuery getScanQuery();

    public void run() {
        Job job = new Job(Messages.ScanResultsView_RUN_SCAN_QUERY_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ScanQuery scanQuery = RunScanQueryAction.this.getScanQuery();
                    ITeamRepository repository = scanQuery.getRepository();
                    IScdClient scdClient = (IScdClient)repository.getClientLibrary(IScdClient.class);
                    ScanQueryResult scanQueryResult = new ScanQueryResult();
                    IScanResult[] scanResults = scdClient.queryScanResults(scanQuery.getScanConfigurations());
                    HashMap<UUID, IWorkspace> streamMap = new HashMap<UUID, IWorkspace>();
                    IScanResult[] iScanResultArray = scanResults;
                    int n = scanResults.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IScanResult scanResult = iScanResultArray[n2];
                        ScanQueryRow row = ScanQueryRow.createScanQueryRow(scanResult, streamMap, monitor);
                        if (row != null) {
                            scanQueryResult.addScanQueryRow(row);
                        }
                        ++n2;
                    }
                    scanQuery.setResult(scanQueryResult);
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.scd.ide.ui", e.getLocalizedMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                RunScanQueryAction.this.view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RunScanQueryAction.this.view.setInput(RunScanQueryAction.this.getScanQuery());
                        RunScanQueryAction.this.view.refresh();
                    }
                });
            }
        });
        job.schedule();
    }
}

