/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.action;

import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.common.model.IScanRequest;
import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.helper.StreamScanConfigurationPair;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryView;
import com.ibm.team.enterprise.scd.ide.ui.wizard.RequestScanWizard;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;

public class RequestScanAction
extends Action
implements IObjectActionDelegate {
    private IScanConfiguration scanConfiguration;
    private IWorkspace stream;
    private IWorkbenchPart workbench;

    public RequestScanAction() {
        super(Messages.RequestScanAction_LABEL);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/elcl16/requestScan.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/dlcl16/requestScan.gif"));
    }

    public void run() {
        this.run(null);
    }

    public void run(IAction action) {
        Shell activeShell = this.workbench == null ? Display.getCurrent().getActiveShell() : this.workbench.getSite().getShell();
        if (this.scanConfiguration == null || this.stream == null) {
            MessageDialog.openError((Shell)activeShell, (String)Messages.ERROR_DIALOG_TITLE, (String)Messages.RequestScanAction_NO_SCAN_CONFIGURATION_SELECTED);
            return;
        }
        RequestScanWizard wizard = new RequestScanWizard(this.scanConfiguration, this.stream);
        WizardDialog wizardDialog = new WizardDialog(activeShell, (IWizard)wizard);
        if (wizardDialog.open() == 0) {
            final ITeamRepository repository = (ITeamRepository)this.scanConfiguration.getOrigin();
            final IScanRequest scanRequest = wizard.getScanRequest();
            new Job(Messages.RequestScanAction_JOB_LABEL){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ((IScdClient)repository.getClientLibrary(IScdClient.class)).requestScan(scanRequest, monitor);
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(8, "com.ibm.team.enterprise.scd.ide.ui", e.getLocalizedMessage(), (Throwable)e);
                    }
                    new UIJob(Messages.RequestScanAction_JOB_LABEL){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            ScanQueryView.openQueryView(RequestScanAction.this.scanConfiguration, RequestScanAction.this.stream);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.scanConfiguration = null;
        this.stream = null;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof StreamScanConfigurationPair) {
            StreamScanConfigurationPair pair = (StreamScanConfigurationPair)obj;
            this.scanConfiguration = pair.getScanConfiguration();
            this.stream = pair.getStream();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbench = targetPart;
    }
}

