/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.action;

import com.ibm.team.enterprise.scd.common.model.IScanResultHandle;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryRow;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryView;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.progress.UIJob;

public class DeleteScanResultsAction
implements IViewActionDelegate {
    private List<IScanResultHandle> scanResultHandles;
    private ScanQueryView view;

    public void run(IAction action) {
        if (this.view == null || this.scanResultHandles == null) {
            return;
        }
        if (this.scanResultHandles.size() == 0) {
            MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)Messages.ERROR_DIALOG_TITLE, (String)Messages.DeleteScanResultAction_ERROR_NO_SELECTION);
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.view.getSite().getShell(), (String)Messages.CONFIRM_DIALOG_TITLE, (String)Messages.DeleteScanResultAction_CONFIRM)) {
            return;
        }
        this.deleteScanResults();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        List selectedRows = ((IStructuredSelection)selection).toList();
        this.scanResultHandles = new ArrayList<IScanResultHandle>(selectedRows.size());
        for (ScanQueryRow selectedRow : selectedRows) {
            this.scanResultHandles.add((IScanResultHandle)selectedRow.getScanResult());
        }
    }

    public void init(IViewPart view) {
        this.view = (ScanQueryView)view;
    }

    private void deleteScanResults() {
        Job job = new Job(Messages.DeleteScanResultAction_JOB_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                ITeamRepository repository = (ITeamRepository)((IScanResultHandle)DeleteScanResultsAction.this.scanResultHandles.get(0)).getOrigin();
                IScdClient scdClient = (IScdClient)repository.getClientLibrary(IScdClient.class);
                try {
                    scdClient.deleteScanResults(DeleteScanResultsAction.this.scanResultHandles, monitor);
                }
                catch (TeamRepositoryException e) {
                    return new Status(8, "com.ibm.team.enterprise.scd.ide.ui", e.getLocalizedMessage(), (Throwable)e);
                }
                UIJob updateUIJob = new UIJob(Messages.DeleteScanResultAction_JOB_LABEL){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        DeleteScanResultsAction.this.view.rerunQuery();
                        return Status.OK_STATUS;
                    }
                };
                updateUIJob.schedule();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

