/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.action;

import com.ibm.team.enterprise.scd.common.model.IScanResultHandle;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryRow;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryView;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class CancelScanResultAction
implements IViewActionDelegate {
    private IScanResultHandle scanResultHandle;
    private ScanQueryView view;

    public void run(IAction action) {
        if (this.view == null || this.scanResultHandle == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.view.getSite().getShell(), (String)Messages.CONFIRM_DIALOG_TITLE, (String)Messages.CancelScanResultAction_CONFIRM)) {
            return;
        }
        this.cancelScanResult();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.scanResultHandle = null;
        if (selection != null && !selection.isEmpty()) {
            ScanQueryRow row = (ScanQueryRow)((IStructuredSelection)selection).getFirstElement();
            this.scanResultHandle = row.getScanResult();
        }
    }

    public void init(IViewPart view) {
        this.view = (ScanQueryView)view;
    }

    private void cancelScanResult() {
        Job job = new Job(Messages.CancelScanResultAction_JOB_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                ITeamRepository repository = (ITeamRepository)CancelScanResultAction.this.scanResultHandle.getOrigin();
                IScdClient scdClient = (IScdClient)repository.getClientLibrary(IScdClient.class);
                try {
                    scdClient.cancelScanResults(CancelScanResultAction.this.scanResultHandle);
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.scd.ide.ui", e.getLocalizedMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStatus rc = event.getResult();
                        if (rc.isOK()) {
                            CancelScanResultAction.this.view.rerunQuery();
                        }
                    }
                });
            }
        });
        job.schedule();
    }
}

