/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.common.ui.EESharedImages;
import com.ibm.team.enterprise.scd.common.IntegerValidator;
import com.ibm.team.enterprise.scd.common.LongValidator;
import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.common.model.ScanState;
import com.ibm.team.enterprise.scd.common.model.ScanStatus;
import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.helper.StreamScanConfigurationPair;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ScdUIUtil {
    public static LongValidator delayIntervalValidator = new LongValidator(1L, Long.MAX_VALUE, false);
    public static LongValidator maxWaitTimeValidator = new LongValidator(1L, Long.MAX_VALUE, false);
    public static IntegerValidator scanResultsToKeepValidator = new IntegerValidator(Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE), false);

    public static String convertToDateTime(long date) {
        try {
            return DateFormat.getDateTimeInstance().format(new Date(date));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static IProjectAreaHandle getProjectArea(IScanConfiguration scanConfiguration, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspace stream;
        if (scanConfiguration == null || scanConfiguration.getStream() == null) {
            return null;
        }
        if (scanConfiguration.getStream() instanceof IWorkspace) {
            stream = (IWorkspace)scanConfiguration.getStream();
        } else {
            Collections.singletonList(IWorkspace.OWNER_PROPERTY);
            stream = (IWorkspace)((ITeamRepository)scanConfiguration.getStream().getOrigin()).itemManager().fetchPartialItem((IItemHandle)scanConfiguration.getStream(), 0, Collections.singletonList(IWorkspace.OWNER_PROPERTY), monitor);
        }
        if (stream == null) {
            return null;
        }
        IAuditableHandle auditableHandle = stream.getOwner();
        if (!(auditableHandle instanceof IProcessAreaHandle)) {
            return null;
        }
        IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)auditableHandle;
        ITeamRepository repository = (ITeamRepository)processAreaHandle.getOrigin();
        IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, null);
        if (processArea == null) {
            return null;
        }
        return processArea.getProjectArea();
    }

    public static RGB getRGB(String key) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().getRGB(key);
    }

    public static Color getStatusBackgroundColor(IScanResult scanResult, LocalResourceManager resourceManager) {
        String key = "";
        key = scanResult.getState() == ScanState.CANCELLED ? "com.ibm.team.build.ui.INCOMPLETE_COLOR_BACKGROUND" : (scanResult.getStatus() == ScanStatus.ERROR ? "com.ibm.team.build.ui.ERROR_COLOR_BACKGROUND" : (scanResult.getStatus() == ScanStatus.WARNING ? "com.ibm.team.build.ui.WARNING_COLOR_BACKGROUND" : "com.ibm.team.build.ui.SUCCESS_COLOR_BACKGROUND"));
        RGB backgroundRGB = ScdUIUtil.getRGB(key);
        return JazzResources.getColor((ResourceManager)resourceManager, (RGB)backgroundRGB);
    }

    public static Color getStatusForegroundColor(IScanResult scanResult, LocalResourceManager resourceManager) {
        String key = "";
        key = scanResult.getState() == ScanState.CANCELLED ? "com.ibm.team.build.ui.INCOMPLETE_COLOR_FOREGROUND" : (scanResult.getStatus() == ScanStatus.ERROR ? "com.ibm.team.build.ui.ERROR_COLOR_FOREGROUND" : (scanResult.getStatus() == ScanStatus.WARNING ? "com.ibm.team.build.ui.WARNING_COLOR_FOREGROUND" : "com.ibm.team.build.ui.SUCCESS_COLOR_FOREGROUND"));
        RGB backgroundRGB = ScdUIUtil.getRGB(key);
        return JazzResources.getColor((ResourceManager)resourceManager, (RGB)backgroundRGB);
    }

    public static RGB getStatusTrendRGB(IScanResult scanResult, LocalResourceManager resourceManager) {
        String key = "";
        key = scanResult.getState() == ScanState.CANCELLED ? "com.ibm.team.build.ui.INCOMPLETE_COLOR_TREND" : (scanResult.getStatus() == ScanStatus.ERROR ? "com.ibm.team.build.ui.ERROR_COLOR_TREND" : (scanResult.getStatus() == ScanStatus.WARNING ? "com.ibm.team.build.ui.WARNING_COLOR_TREND" : "com.ibm.team.build.ui.SUCCESS_COLOR_TREND"));
        return ScdUIUtil.getRGB(key);
    }

    public static Image getStatusImage(IScanResult scanResult) {
        Image image = null;
        if (scanResult.getState() == ScanState.COMPLETED) {
            if (scanResult.getStatus() == ScanStatus.OK) {
                image = Activator.getImage("/icons/obj16/success.gif");
            } else if (scanResult.getStatus() == ScanStatus.ERROR) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            } else if (scanResult.getStatus() == ScanStatus.WARNING) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
        }
        return image;
    }

    public static IAuditable fetchRequestor(IAuditableHandle requestorHandle) {
        if (requestorHandle != null) {
            try {
                ITeamRepository repository = (ITeamRepository)requestorHandle.getOrigin();
                if (requestorHandle instanceof IContributorHandle) {
                    return (IContributor)repository.itemManager().fetchPartialItem((IItemHandle)requestorHandle, 0, Arrays.asList(IContributor.NAME_PROPERTY), null);
                }
                if (requestorHandle instanceof IBuildResultHandle) {
                    return (IBuildResult)repository.itemManager().fetchPartialItem((IItemHandle)requestorHandle, 0, Arrays.asList(IBuildResult.PROPERTY_LABEL), null);
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getRequestorName(IAuditable requestor) {
        if (requestor != null) {
            if (requestor instanceof IContributor) {
                return ((IContributor)requestor).getName();
            }
            if (requestor instanceof IBuildResult) {
                return NLS.bind((String)Messages.BUILD_REQUESTOR, (Object)((IBuildResult)requestor).getLabel());
            }
        } else {
            return Messages.BACKGROUND_SCAN_REQUESTOR;
        }
        return Messages.UNKNOWN;
    }

    public static Text createNonEditableText(Composite parent, String value, FormToolkit toolkit) {
        return ScdUIUtil.createNonEditableText(parent, value, 4, toolkit);
    }

    public static Text createNonEditableText(Composite parent, String value, int style, FormToolkit toolkit) {
        int savedBorderStyle = toolkit.getBorderStyle();
        toolkit.setBorderStyle(0);
        Text text = toolkit.createText(parent, value, style);
        text.setEditable(false);
        toolkit.setBorderStyle(savedBorderStyle);
        return text;
    }

    public static Label createInfoLabel(Composite parent, FormToolkit toolkit) {
        Label label = toolkit.createLabel(parent, "");
        label.setImage(EESharedImages.getInstance().getImage("IMG_INFO"));
        return label;
    }

    public static ListSelectionDialog getComponentSelectionDialog(Shell shell, final ITeamRepository repo, final IWorkspaceHandle workspaceHandle, String title, String message, final List<IComponentHandle> excludedComponents) {
        final ArrayList components = new ArrayList();
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspaceHandle, monitor);
                    IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(connection.getComponents(), 0, monitor);
                    for (Object o : fetchResult.getRetrievedItems()) {
                        IComponent component;
                        if (!(o instanceof IComponent) || ScdUIUtil.hasComponent((IComponentHandle)(component = (IComponent)o), excludedComponents)) continue;
                        components.add((IComponent)o);
                    }
                    Collections.sort(components, new Comparator<IComponent>(){

                        @Override
                        public int compare(IComponent o1, IComponent o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ListSelectionDialog dialog = new ListSelectionDialog(shell, components, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new ComponentLabelProvider(), message);
        dialog.setTitle(title);
        return dialog;
    }

    public static void contentToFile(IContent content, File file, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.RETRIEVING_CONTENT, 100);
        if (content != null && teamRepository != null) {
            FileOutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    outputStream = new FileOutputStream(file);
                    IContentManager contentManager = teamRepository.contentManager();
                    inputStream = contentManager.retrieveContentStream(content, monitor);
                    byte[] buffer = new byte[32000];
                    int numbytes = inputStream.read(buffer);
                    while (numbytes > -1) {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        outputStream.write(buffer, 0, numbytes);
                        numbytes = inputStream.read(buffer);
                    }
                }
                catch (IOException ioe) {
                    TeamRepositoryException tre = new TeamRepositoryException((Throwable)ioe);
                    tre.setOrigin((Object)teamRepository);
                    throw tre;
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static File createScdTempFile(String filename) {
        File tmpFile;
        try {
            File tmpDir = File.createTempFile("scd", null);
            tmpDir.delete();
            if (!tmpDir.mkdir()) {
                tmpDir.deleteOnExit();
            }
            tmpFile = new File(tmpDir, filename);
            tmpFile.deleteOnExit();
        }
        catch (IOException e) {
            Activator.log(e);
            tmpFile = null;
        }
        return tmpFile;
    }

    public static Hyperlink createWorkspaceLink(Composite parent, IWorkspace workspace, FormToolkit toolkit, final IWorkbenchPage workbenchPage) {
        Hyperlink link = toolkit.createHyperlink(parent, workspace == null ? "" : workspace.getName(), 64);
        link.setHref((Object)workspace);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkspace workspace = (IWorkspace)e.getHref();
                if (workspace != null) {
                    TeamPlacePart2.open((IWorkbenchPage)workbenchPage, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)workspace)));
                }
            }
        });
        return link;
    }

    public static Spinner createSpinner(Composite parent, int initial, int min, int max) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setMinimum(min);
        spinner.setMaximum(max);
        spinner.setSelection(initial);
        return spinner;
    }

    public static int getSortDirection(Table table) {
        return table.getSortDirection() == 0 ? 1024 : table.getSortDirection();
    }

    public static List<StreamScanConfigurationPair> getStreamScanConfigurationPairs(IProjectAreaHandle projectArea, boolean filterOutNoScanConfiguration, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        criteria.getFilterByOwnerOptional().addAll(ConnectedProjectAreaRegistry.getDefault().getSelectedProcessAreas(projectArea));
        List streamHandles = workspaceManager.findWorkspaces(criteria, Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(50));
        ArrayList<StreamScanConfigurationPair> pairs = new ArrayList<StreamScanConfigurationPair>(streamHandles.size());
        if (streamHandles.size() > 0) {
            IScdClient scdClient = (IScdClient)repository.getClientLibrary(IScdClient.class);
            IScanConfiguration[] scanConfigurations = scdClient.getScanConfigurations(streamHandles.toArray(new IWorkspaceHandle[streamHandles.size()]));
            HashMap<UUID, IScanConfiguration> streamScanConfigurationMap = new HashMap<UUID, IScanConfiguration>();
            IScanConfiguration[] iScanConfigurationArray = scanConfigurations;
            int n = scanConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                IScanConfiguration scanConfiguration = iScanConfigurationArray[n2];
                streamScanConfigurationMap.put(scanConfiguration.getStream().getItemId(), scanConfiguration);
                ++n2;
            }
            List streams = repository.itemManager().fetchPartialItems(streamHandles, 1, Arrays.asList(IWorkspace.NAME_PROPERTY, IWorkspace.STREAM_PROPERTY), (IProgressMonitor)progress.newChild(50));
            for (IWorkspace stream : streams) {
                IScanConfiguration scanConfiguration = (IScanConfiguration)streamScanConfigurationMap.get(stream.getItemId());
                if (filterOutNoScanConfiguration && scanConfiguration == null) continue;
                pairs.add(new StreamScanConfigurationPair(stream, scanConfiguration));
            }
        }
        return pairs;
    }

    private static boolean hasComponent(IComponentHandle aComponent, List<IComponentHandle> components) {
        if (components != null) {
            for (IComponentHandle component : components) {
                if (!component.sameItemId((IItemHandle)aComponent)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ComponentLabelProvider
    extends BaseLabelProvider {
        private Image componentImage;

        private ComponentLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof IComponent) {
                label.setText(((IComponent)element).getName());
            }
            if (this.componentImage == null) {
                this.componentImage = this.getImage(ImagePool.COMPONENT);
            }
            label.setImage(this.componentImage);
        }
    }
}

