/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.internal.common.transport;

import com.ibm.team.enterprise.scd.common.api.IScdProperty;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyFile;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyValue;
import com.ibm.team.enterprise.scd.common.model.IAttribute;
import com.ibm.team.enterprise.scd.common.model.IBooleanAttribute;
import com.ibm.team.enterprise.scd.common.model.IComplexAttribute;
import com.ibm.team.enterprise.scd.common.model.IDependency;
import com.ibm.team.enterprise.scd.common.model.IFileSourceCodeData;
import com.ibm.team.enterprise.scd.common.model.INumberAttribute;
import com.ibm.team.enterprise.scd.common.model.IStringAttribute;
import com.ibm.team.enterprise.scd.internal.common.api.ScdPropertyFactory;
import com.ibm.team.enterprise.scd.internal.common.model.impl.ComplexAttributeImpl;
import com.ibm.team.enterprise.scd.internal.common.transport.ScdScmProperty;
import com.ibm.team.enterprise.scd.internal.common.transport.TransportFile;
import com.ibm.team.enterprise.scd.internal.common.transport.TransportProperty;
import com.ibm.team.enterprise.scd.internal.common.transport.TransportPropertyValue;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TransportUtil {
    public static final String PROPERTIES_TAG = "properties";
    public static final String FILE_TAG = "file";
    public static final String RESOURCE_URI_TAG = "resourceURI";
    public static final String PROPERTY_NAMESPACE_TAG = "propertyNS";
    public static final String NAMESPACE_TAG = "ns";
    public static final String PROPERTY_TAG = "property";
    public static final String NAME_TAG = "name";
    public static final String USER_ADDED_TAG = "userAdded";
    public static final String TYPE_TAG = "type";
    public static final String VALUE_TYPE_STRING = "string";
    public static final String VALUE_TYPE_BOOLEAN = "boolean";
    public static final String VALUE_TYPE_NUMBER = "number";
    public static final String VALUE_TYPE_INT = "int";
    public static final String VALUE_TYPE_LONG = "long";
    public static final String VALUE_TYPE_SHORT = "short";
    public static final String VALUE_TYPE_FLOAT = "float";
    public static final String VALUE_TYPE_DOUBLE = "double";
    public static final String VALUE_TYPE_LIST = "list";
    public static final String FILE_SCD_BASE_URI = "http://www.ibm.com/xmlns/prod/rational/rtc/scd/file/";
    public static final String ITEM_ID_TAG = "_itemId=";
    private static final String YES = "yes";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    private static final String THREE = "3";
    private static final String UTF_8 = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String toXML(List<TransportFile> files) throws TeamRepositoryException {
        String xmlString = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
            Element properties = document.createElement(PROPERTIES_TAG);
            document.appendChild(properties);
            for (TransportFile transportFile : files) {
                Element file = document.createElement(FILE_TAG);
                properties.appendChild(file);
                file.setAttribute(RESOURCE_URI_TAG, transportFile.getMetadataURI());
                HashMap<String, List<TransportProperty>> namespaceMap = TransportUtil.createNamespaceMap(transportFile);
                for (Map.Entry<String, List<TransportProperty>> namespace : namespaceMap.entrySet()) {
                    Element propertyNS = document.createElement(PROPERTY_NAMESPACE_TAG);
                    file.appendChild(propertyNS);
                    propertyNS.setAttribute(NAMESPACE_TAG, namespace.getKey());
                    List<TransportProperty> transportProperties = namespace.getValue();
                    for (TransportProperty transportProperty : transportProperties) {
                        TransportUtil.addPropertyElement(transportProperty, propertyNS, document);
                    }
                }
            }
            xmlString = TransportUtil.getXmlString(document);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return xmlString;
    }

    private static void addPropertyElement(TransportProperty transportProperty, Element parent, Document document) {
        Element property = document.createElement(PROPERTY_TAG);
        parent.appendChild(property);
        property.setAttribute(NAME_TAG, transportProperty.getLocalName());
        property.setAttribute(USER_ADDED_TAG, Boolean.toString(transportProperty.isUserAdded()));
        property.setAttribute(TYPE_TAG, TransportUtil.getPropertyType(transportProperty.getValue()));
        TransportPropertyValue value = transportProperty.getValue();
        Text text = null;
        switch (value.getValueType()) {
            case 3: {
                List<TransportProperty> properties = value.getPropertyList();
                for (TransportProperty tProp : properties) {
                    TransportUtil.addPropertyElement(tProp, property, document);
                }
                break;
            }
            case 0: {
                text = document.createTextNode(value.getStringValue());
                property.appendChild(text);
                break;
            }
            case 2: {
                text = document.createTextNode(value.getNumberValue().toString());
                property.appendChild(text);
                break;
            }
            case 1: {
                text = document.createTextNode(value.getBooleanValue().toString());
                property.appendChild(text);
            }
        }
    }

    public static List<TransportFile> fromFileSourceCodeMetadata(Collection<? extends IFileSourceCodeData> metadatas) {
        ArrayList<TransportFile> fileList = new ArrayList<TransportFile>();
        for (IFileSourceCodeData iFileSourceCodeData : metadatas) {
            fileList.add(TransportUtil.getTransportFile(iFileSourceCodeData));
        }
        return fileList;
    }

    public static TransportFile getTransportFile(IFileSourceCodeData metadata) {
        TransportFile tFile = new TransportFile("http://www.ibm.com/xmlns/prod/rational/rtc/scd/file/_itemId=" + metadata.getFile().getItemId().getUuidValue());
        tFile.getProperties().addAll(TransportUtil.getTransportProperties((EObject)metadata));
        return tFile;
    }

    protected static List<TransportProperty> getTransportProperties(EObject eObject) {
        ArrayList<TransportProperty> props = new ArrayList<TransportProperty>();
        for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
            List<TransportProperty> prop;
            if (feature.isTransient() || !eObject.eIsSet(feature) || (prop = TransportUtil.getTransportProperty(feature, eObject.eGet(feature))) == null) continue;
            props.addAll(prop);
        }
        return props;
    }

    protected static List<TransportProperty> getTransportProperties(List<? extends IAttribute> attribs) {
        ArrayList<TransportProperty> props = new ArrayList<TransportProperty>();
        for (IAttribute iAttribute : attribs) {
            TransportProperty prop = new TransportProperty(iAttribute.getNamespace(), iAttribute.getLocalName());
            if (iAttribute instanceof IStringAttribute) {
                prop.setValue(new TransportPropertyValue(((IStringAttribute)iAttribute).getValue()));
            } else if (iAttribute instanceof INumberAttribute) {
                prop.setValue(new TransportPropertyValue(((INumberAttribute)iAttribute).getValue()));
            } else if (iAttribute instanceof IBooleanAttribute) {
                prop.setValue(new TransportPropertyValue(((IBooleanAttribute)iAttribute).isValue()));
            } else if (iAttribute instanceof IComplexAttribute) {
                prop.setValue(new TransportPropertyValue(TransportUtil.getTransportProperties((EObject)((ComplexAttributeImpl)iAttribute))));
            }
            props.add(prop);
        }
        return props;
    }

    public static List<TransportProperty> getTransportProperty(EStructuralFeature feature, Object value) {
        if (value == null) {
            return null;
        }
        if (feature.getEContainingClass().getClassifierID() == 40) {
            switch (feature.getFeatureID()) {
                case 22: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "fileName", new TransportPropertyValue((String)value)));
                }
                case 23: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "filePath", new TransportPropertyValue((String)value)));
                }
                case 18: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "fileType", new TransportPropertyValue((String)value)));
                }
                case 20: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "logicalName", new TransportPropertyValue((String)value)));
                }
                case 19: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "language", new TransportPropertyValue((String)value)));
                }
                case 21: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "fileItemId", new TransportPropertyValue(((IVersionableHandle)value).getItemId().getUuidValue())));
                }
                case 24: {
                    ArrayList<TransportProperty> props = new ArrayList<TransportProperty>();
                    for (Object dh : (Collection)value) {
                        if (!(dh instanceof IDependency)) continue;
                        TransportProperty p = new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependency", new TransportPropertyValue(TransportUtil.getTransportProperties((EObject)dh)));
                        props.add(p);
                    }
                    return props;
                }
                case 25: {
                    return TransportUtil.getTransportProperties((List)value);
                }
                case 26: {
                    return TransportUtil.getTransportProperties((List)value);
                }
                case 27: {
                    return TransportUtil.getTransportProperties((List)value);
                }
                case 28: {
                    return TransportUtil.getTransportProperties((List)value);
                }
            }
        } else if (feature.getEContainingClass().getClassifierID() == 44) {
            switch (feature.getFeatureID()) {
                case 18: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependencyFileType", new TransportPropertyValue((String)value)));
                }
                case 19: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependencyLogicalName", new TransportPropertyValue((String)value)));
                }
                case 20: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependencyPath", new TransportPropertyValue((String)value)));
                }
                case 21: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependencyReferenceType", new TransportPropertyValue((String)value)));
                }
                case 22: {
                    return Collections.singletonList(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "ignoreInBuild", new TransportPropertyValue((Boolean)value != false ? "YES" : "NO")));
                }
                case 23: {
                    return TransportUtil.getTransportProperties((List)value);
                }
                case 24: {
                    return TransportUtil.getTransportProperties((List)value);
                }
                case 25: {
                    return TransportUtil.getTransportProperties((List)value);
                }
                case 26: {
                    return TransportUtil.getTransportProperties((List)value);
                }
            }
        } else if (feature.getEContainingClass().getClassifierID() == 54) {
            switch (feature.getFeatureID()) {
                case 21: {
                    return TransportUtil.getTransportProperties((List)value);
                }
                case 22: {
                    return TransportUtil.getTransportProperties((List)value);
                }
                case 23: {
                    return TransportUtil.getTransportProperties((List)value);
                }
                case 24: {
                    return TransportUtil.getTransportProperties((List)value);
                }
            }
        }
        return null;
    }

    public static List<TransportFile> fromXML(String xml) throws TeamRepositoryException {
        ArrayList<TransportFile> fileList = new ArrayList<TransportFile>();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(UTF_8));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
            Element properties = document.getDocumentElement();
            NodeList files = properties.getElementsByTagName(FILE_TAG);
            int i = 0;
            while (i < files.getLength()) {
                Element file = (Element)files.item(i);
                TransportFile tFile = new TransportFile(file.getAttribute(RESOURCE_URI_TAG));
                NodeList namespaces = file.getElementsByTagName(PROPERTY_NAMESPACE_TAG);
                int j = 0;
                while (j < namespaces.getLength()) {
                    Element namespaceElement = (Element)namespaces.item(j);
                    String namespace = namespaceElement.getAttribute(NAMESPACE_TAG);
                    NodeList children = namespaceElement.getChildNodes();
                    int k = 0;
                    while (k < children.getLength()) {
                        Node node = children.item(k);
                        if (node.getNodeType() == 1 && node.getNodeName().equals(PROPERTY_TAG)) {
                            Element property = (Element)node;
                            tFile.getProperties().add(TransportUtil.createTransportProperty(namespace, property));
                        }
                        ++k;
                    }
                    ++j;
                }
                fileList.add(tFile);
                ++i;
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return fileList;
    }

    private static TransportProperty createTransportProperty(String namespace, Element propertyElement) {
        String name = propertyElement.getAttribute(NAME_TAG);
        String userAddedString = propertyElement.getAttribute(USER_ADDED_TAG);
        String type = propertyElement.getAttribute(TYPE_TAG);
        TransportPropertyValue value = null;
        NodeList nodes = propertyElement.getChildNodes();
        if (type.equals(VALUE_TYPE_LIST)) {
            ArrayList<TransportProperty> properties = new ArrayList<TransportProperty>();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equals(PROPERTY_TAG)) {
                    Element property = (Element)node;
                    properties.add(TransportUtil.createTransportProperty(namespace, property));
                }
                ++i;
            }
            value = new TransportPropertyValue(properties);
        } else {
            Node node = nodes.item(0);
            if (node == null) {
                value = new TransportPropertyValue("");
            } else if (node.getNodeType() == 3) {
                String valueString = ((Text)node).getNodeValue();
                if (type.equals(VALUE_TYPE_BOOLEAN)) {
                    value = new TransportPropertyValue(new Boolean(valueString));
                } else if (type.equals(VALUE_TYPE_STRING)) {
                    value = new TransportPropertyValue(valueString);
                } else if (type.equals(VALUE_TYPE_INT)) {
                    value = new TransportPropertyValue(new Integer(valueString));
                } else if (type.equals(VALUE_TYPE_SHORT)) {
                    value = new TransportPropertyValue(new Short(valueString));
                } else if (type.equals(VALUE_TYPE_LONG)) {
                    value = new TransportPropertyValue(new Long(valueString));
                } else if (type.equals(VALUE_TYPE_FLOAT)) {
                    value = new TransportPropertyValue(new Float(valueString));
                } else if (type.equals(VALUE_TYPE_DOUBLE)) {
                    value = new TransportPropertyValue(new Double(valueString));
                } else if (type.equals(VALUE_TYPE_NUMBER)) {
                    value = new TransportPropertyValue(new Double(valueString));
                }
            }
        }
        boolean userAdded = false;
        if (userAddedString != null) {
            userAdded = Boolean.valueOf(userAddedString);
        }
        return new TransportProperty(namespace, name, value, userAdded);
    }

    private static HashMap<String, List<TransportProperty>> createNamespaceMap(TransportFile transportFile) {
        HashMap<String, List<TransportProperty>> namespaceMap = new HashMap<String, List<TransportProperty>>();
        List<TransportProperty> properties = transportFile.getProperties();
        for (TransportProperty property : properties) {
            if (namespaceMap.containsKey(property.getNamespace())) {
                namespaceMap.get(property.getNamespace()).add(property);
                continue;
            }
            ArrayList<TransportProperty> propertyList = new ArrayList<TransportProperty>();
            propertyList.add(property);
            namespaceMap.put(property.getNamespace(), propertyList);
        }
        return namespaceMap;
    }

    private static String getPropertyType(TransportPropertyValue value) {
        if (value.getValueType() == 0) {
            return VALUE_TYPE_STRING;
        }
        if (value.getValueType() == 2) {
            Number number = value.getNumberValue();
            if (number instanceof Integer) {
                return VALUE_TYPE_INT;
            }
            if (number instanceof Long) {
                return VALUE_TYPE_LONG;
            }
            if (number instanceof Short) {
                return VALUE_TYPE_SHORT;
            }
            if (number instanceof Float) {
                return VALUE_TYPE_FLOAT;
            }
            if (number instanceof Double) {
                return VALUE_TYPE_DOUBLE;
            }
            return VALUE_TYPE_NUMBER;
        }
        if (value.getValueType() == 1) {
            return VALUE_TYPE_BOOLEAN;
        }
        if (value.getValueType() == 3) {
            return VALUE_TYPE_LIST;
        }
        return VALUE_TYPE_STRING;
    }

    private static String getXmlString(Document document) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        DOMSource source = new DOMSource(document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", YES);
        transformer.setOutputProperty(INDENT_AMOUNT, THREE);
        transformer.transform(source, result);
        return outputStream.toString(UTF_8);
    }

    public static List<TransportFile> fromScdPropertyFiles(List<IScdPropertyFile> scdFiles) {
        ArrayList<TransportFile> tFiles = new ArrayList<TransportFile>();
        for (IScdPropertyFile scdFile : scdFiles) {
            tFiles.add(new TransportFile(scdFile));
        }
        return tFiles;
    }

    public static List<IScdPropertyFile> toScdPropertyFiles(List<TransportFile> tFiles) {
        ArrayList<IScdPropertyFile> scdFiles = new ArrayList<IScdPropertyFile>();
        for (TransportFile tFile : tFiles) {
            IScdPropertyFile scdFile = TransportUtil.toScdPropertyFile(tFile);
            if (scdFile == null) continue;
            scdFiles.add(scdFile);
        }
        return scdFiles;
    }

    public static IScdPropertyFile toScdPropertyFile(TransportFile tFile) {
        IFileItemHandle file;
        if (tFile == null) {
            return null;
        }
        IScdPropertyFile scdFile = null;
        String fileItemId = TransportUtil.getFileItemId(tFile.getMetadataURI());
        if (fileItemId != null && (file = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)fileItemId), null)) != null) {
            ScdPropertyFactory scdPropertyFactory = new ScdPropertyFactory();
            scdFile = scdPropertyFactory.createPropertyFile(file);
        }
        if (scdFile != null) {
            scdFile.addProperties(TransportUtil.toScdProperties(tFile.getProperties()));
        }
        return scdFile;
    }

    public static List<IScdProperty> toScdProperties(List<TransportProperty> tProps) {
        ArrayList<IScdProperty> scdProps = new ArrayList<IScdProperty>();
        ScdPropertyFactory scdPropertyFactory = new ScdPropertyFactory();
        for (TransportProperty tProp : tProps) {
            TransportPropertyValue tValue = tProp.getValue();
            IScdPropertyValue scdValue = null;
            if (tValue.getValueType() == 1) {
                scdValue = scdPropertyFactory.createPropertyValue(tProp.getValue().getBooleanValue());
            } else if (tValue.getValueType() == 0) {
                scdValue = scdPropertyFactory.createPropertyValue(tProp.getValue().getStringValue());
            } else if (tValue.getValueType() == 2) {
                scdValue = scdPropertyFactory.createPropertyValue(tProp.getValue().getNumberValue());
            } else if (tValue.getValueType() == 3) {
                scdValue = scdPropertyFactory.createPropertyValue(TransportUtil.toScdProperties(tProp.getValue().getPropertyList()));
            }
            if ("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/".equals(tProp.getNamespace())) {
                scdProps.add(new ScdScmProperty(tProp.getLocalName(), scdValue));
                continue;
            }
            if (tProp.isUserAdded()) {
                scdProps.add(scdPropertyFactory.createProperty(tProp.getNamespace(), tProp.getLocalName(), scdValue));
                continue;
            }
            scdProps.add(scdPropertyFactory.createScanProperty(tProp.getNamespace(), tProp.getLocalName(), scdValue));
        }
        return scdProps;
    }

    public static String getFileItemId(String fileMetadataURI) {
        String itemId = null;
        int idx = fileMetadataURI.lastIndexOf(ITEM_ID_TAG);
        if (idx > -1) {
            itemId = fileMetadataURI.substring(idx + ITEM_ID_TAG.length());
        }
        return itemId;
    }
}

