/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.internal.common.transport;

import com.ibm.team.enterprise.scd.common.api.IScdProperty;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyValue;
import com.ibm.team.enterprise.scd.internal.common.transport.TransportProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TransportPropertyValue {
    public static final int VALUE_TYPE_NOT_SET = -1;
    public static final int VALUE_TYPE_STRING = 0;
    public static final int VALUE_TYPE_BOOLEAN = 1;
    public static final int VALUE_TYPE_NUMBER = 2;
    public static final int VALUE_TYPE_PROPERTY_LIST = 3;
    private Object value;

    public TransportPropertyValue(String value) {
        this.value = value;
    }

    public TransportPropertyValue(Boolean value) {
        this.value = value;
    }

    public TransportPropertyValue(Number value) {
        this.value = value;
    }

    public TransportPropertyValue(List<TransportProperty> value) {
        this.value = value;
    }

    public TransportPropertyValue(IScdPropertyValue scdValue) {
        this.value = scdValue.getType() == IScdPropertyValue.Type.PROPERTY_LIST ? this.convertScdPropertyList(scdValue.getPropertyList()) : scdValue.getValue();
    }

    public Boolean getBooleanValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return null;
    }

    public Number getNumberValue() {
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        return null;
    }

    public List<TransportProperty> getPropertyList() {
        if (this.value instanceof List) {
            return (List)this.value;
        }
        return null;
    }

    public String getStringValue() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public int getValueType() {
        if (this.value == null) {
            return -1;
        }
        if (this.value instanceof String) {
            return 0;
        }
        if (this.value instanceof Boolean) {
            return 1;
        }
        if (this.value instanceof Number) {
            return 2;
        }
        if (this.value instanceof List) {
            return 3;
        }
        return -1;
    }

    public boolean equals(TransportPropertyValue v2) {
        if (this.getValue() == null || v2.getValue() == null) {
            return false;
        }
        if (this.getValueType() != v2.getValueType()) {
            return false;
        }
        switch (this.getValueType()) {
            case 1: {
                return this.getBooleanValue().booleanValue() == v2.getBooleanValue().booleanValue();
            }
            case 0: {
                return this.getStringValue().equals(v2.getStringValue());
            }
            case 2: {
                Number number1 = this.getNumberValue();
                Number number2 = v2.getNumberValue();
                if (number1 instanceof Integer) {
                    return number1.intValue() == number2.intValue();
                }
                if (number1 instanceof Short) {
                    return number1.shortValue() == number2.shortValue();
                }
                if (number1 instanceof Long) {
                    return number1.longValue() == number2.longValue();
                }
                if (number1 instanceof Float) {
                    return Float.floatToIntBits(number1.floatValue()) == Float.floatToIntBits(number2.floatValue());
                }
                if (number1 instanceof Double) {
                    return Double.doubleToLongBits(number1.doubleValue()) == Double.doubleToLongBits(number2.doubleValue());
                }
                if (number1 instanceof BigDecimal && number2 instanceof BigDecimal) {
                    return ((BigDecimal)number1).compareTo((BigDecimal)number2) == 0;
                }
                return false;
            }
            case 3: {
                List<TransportProperty> thisPropList = this.getPropertyList();
                List<TransportProperty> v2PropList = v2.getPropertyList();
                if (thisPropList == null || v2PropList == null || thisPropList.size() != v2PropList.size()) {
                    return false;
                }
                for (TransportProperty p : thisPropList) {
                    if (this.isPropertyInList(p, v2PropList)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isPropertyInList(TransportProperty p, List<TransportProperty> pl) {
        for (TransportProperty plProp : pl) {
            if (!plProp.equals(p)) continue;
            return true;
        }
        return false;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public void setValue(List<TransportProperty> value) {
        this.value = value;
    }

    private List<TransportProperty> convertScdPropertyList(List<IScdProperty> scdList) {
        ArrayList<TransportProperty> transList = new ArrayList<TransportProperty>();
        for (IScdProperty scdProp : scdList) {
            transList.add(new TransportProperty(scdProp));
        }
        return transList;
    }
}

