/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.internal.common.transport;

import com.ibm.team.enterprise.scd.common.api.IScdProperty;
import com.ibm.team.enterprise.scd.internal.common.transport.TransportPropertyValue;

public class TransportProperty {
    private String localName;
    private String namespace;
    private TransportPropertyValue value;
    private boolean userAdded;

    public TransportProperty(String namespace, String localName, TransportPropertyValue value) {
        this(namespace, localName, value, false);
    }

    public TransportProperty(String namespace, String localName, TransportPropertyValue value, boolean userAdded) {
        this.namespace = namespace;
        this.localName = localName;
        this.value = value;
        this.userAdded = userAdded;
    }

    public TransportProperty(String namespace, String localName) {
        this.namespace = namespace;
        this.localName = localName;
    }

    public TransportProperty(IScdProperty scdProperty) {
        this.namespace = scdProperty.getNamespace();
        this.localName = scdProperty.getName();
        this.value = new TransportPropertyValue(scdProperty.getValue());
        this.userAdded = !scdProperty.isScanProperty();
    }

    public boolean equals(TransportProperty prop2) {
        if (prop2 != null && this.getQualifiedName().equals(prop2.getQualifiedName())) {
            if (this.getValue() != null && prop2.getValue() != null) {
                return this.getValue().equals(prop2.getValue());
            }
            return false;
        }
        return false;
    }

    public boolean isDuplicate(TransportProperty prop2) {
        return prop2 != null && this.getQualifiedName().equals(prop2.getQualifiedName());
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getQualifiedName() {
        return String.valueOf(this.namespace) + this.localName;
    }

    public TransportPropertyValue getValue() {
        return this.value;
    }

    public void setValue(TransportPropertyValue value) {
        this.value = value;
    }

    public boolean isUserAdded() {
        return this.userAdded;
    }

    public void setUserAdded(boolean userAdded) {
        this.userAdded = userAdded;
    }
}

