/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.internal.common.transport;

import com.ibm.team.enterprise.scd.common.api.IScdProperty;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyFile;
import com.ibm.team.enterprise.scd.internal.common.transport.TransportProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TransportFile {
    private ArrayList<TransportProperty> properties;
    private String metadataURI;

    public TransportFile(String metadataURI) {
        this.metadataURI = metadataURI;
        this.properties = new ArrayList();
    }

    public TransportFile(IScdPropertyFile scdFile) {
        this.metadataURI = "http://www.ibm.com/xmlns/prod/rational/rtc/scd/file/_itemId=" + scdFile.getFile().getItemId().getUuidValue();
        this.properties = new ArrayList();
        for (IScdProperty property : scdFile.getAllProperties(true)) {
            this.properties.add(new TransportProperty(property));
        }
    }

    public String getMetadataURI() {
        return this.metadataURI;
    }

    public List<TransportProperty> getProperties() {
        return this.properties;
    }

    public boolean containsDuplicate(TransportProperty property) {
        for (TransportProperty p : this.properties) {
            if (!p.isDuplicate(property)) continue;
            return true;
        }
        return false;
    }

    public boolean containsProperty(TransportProperty property) {
        for (TransportProperty p : this.properties) {
            if (!p.equals(property)) continue;
            return true;
        }
        return false;
    }

    public void removeDuplicates(String qualifiedPropertyName) {
        if (qualifiedPropertyName == null || qualifiedPropertyName.length() == 0) {
            return;
        }
        Iterator<TransportProperty> it = this.properties.iterator();
        while (it.hasNext()) {
            TransportProperty prop = it.next();
            if (!qualifiedPropertyName.equals(prop.getQualifiedName())) continue;
            it.remove();
        }
    }

    public boolean isIsomorphic(TransportFile tf) {
        if (tf == null) {
            return false;
        }
        List<TransportProperty> props = tf.getProperties();
        if (props.size() != this.properties.size()) {
            return false;
        }
        for (TransportProperty prop : props) {
            if (this.containsProperty(prop)) continue;
            return false;
        }
        return true;
    }
}

