/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.internal.common.api;

import com.ibm.team.enterprise.scd.common.AssertHelper;
import com.ibm.team.enterprise.scd.common.api.IScdProperty;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyFile;
import com.ibm.team.filesystem.common.IFileItemHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ScdPropertyFile
implements IScdPropertyFile {
    private IFileItemHandle file;
    private List<IScdProperty> properties;

    protected ScdPropertyFile(IFileItemHandle file) {
        this.file = file;
        this.properties = new ArrayList<IScdProperty>();
    }

    @Override
    public IFileItemHandle getFile() {
        return this.file;
    }

    @Override
    public IScdProperty getProperty(String namespace, String name) {
        AssertHelper.validateParam(namespace, "namespace");
        AssertHelper.validateParam(name, "name");
        for (IScdProperty prop : this.properties) {
            if (!prop.getName().equals(name) || !prop.getNamespace().equals(namespace)) continue;
            return prop;
        }
        return null;
    }

    @Override
    public List<IScdProperty> getAllProperties(String namespace, String name) {
        AssertHelper.validateParam(namespace, "namespace");
        AssertHelper.validateParam(name, "name");
        ArrayList<IScdProperty> props = new ArrayList<IScdProperty>();
        for (IScdProperty prop : this.properties) {
            if (!prop.getName().equals(name) || !prop.getNamespace().equals(namespace)) continue;
            props.add(prop);
        }
        return props;
    }

    @Override
    public List<IScdProperty> getAllProperties(boolean includeScm) {
        ArrayList<IScdProperty> props = new ArrayList<IScdProperty>();
        for (IScdProperty prop : this.properties) {
            if ("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/".equals(prop.getNamespace()) && !includeScm) continue;
            props.add(prop);
        }
        return props;
    }

    @Override
    public void addProperty(IScdProperty newProperty) {
        AssertHelper.validateParam(newProperty, "newProperty");
        AssertHelper.validateDuplicateProperty(this.properties, newProperty);
        this.properties.add(newProperty);
    }

    @Override
    public void addProperties(List<IScdProperty> newProperties) {
        AssertHelper.validateParam(newProperties, "newProperties");
        for (IScdProperty newProperty : newProperties) {
            AssertHelper.validateDuplicateProperty(this.properties, newProperty);
            this.properties.add(newProperty);
        }
    }

    @Override
    public void removeProperty(String namespace, String name) {
        AssertHelper.validateParam(namespace, "namespace");
        AssertHelper.validateParam(name, "name");
        Iterator<IScdProperty> it = this.properties.iterator();
        while (it.hasNext()) {
            IScdProperty prop = it.next();
            if (!namespace.equals(prop.getNamespace()) || !name.equals(prop.getName())) continue;
            it.remove();
            break;
        }
    }

    @Override
    public void removeAllProperties(String namespace, String name) {
        AssertHelper.validateParam(namespace, "namespace");
        AssertHelper.validateParam(name, "name");
        Iterator<IScdProperty> it = this.properties.iterator();
        while (it.hasNext()) {
            IScdProperty prop = it.next();
            if (!namespace.equals(prop.getNamespace()) || !name.equals(prop.getName())) continue;
            it.remove();
        }
    }

    @Override
    public boolean containsProperty(String namespace, String name) {
        AssertHelper.validateParam(namespace, "namespace");
        AssertHelper.validateParam(name, "name");
        return this.getProperty(namespace, name) != null;
    }

    @Override
    public int propertySize() {
        return this.properties.size();
    }
}

