/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.internal.common.api;

import com.ibm.team.enterprise.scd.common.AssertHelper;
import com.ibm.team.enterprise.scd.common.api.IScdProperty;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyFactory;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyFile;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyValue;
import com.ibm.team.enterprise.scd.internal.common.api.ScdProperty;
import com.ibm.team.enterprise.scd.internal.common.api.ScdPropertyFile;
import com.ibm.team.enterprise.scd.internal.common.api.ScdPropertyValue;
import com.ibm.team.filesystem.common.IFileItemHandle;
import java.util.ArrayList;
import java.util.List;

public class ScdPropertyFactory
implements IScdPropertyFactory {
    @Override
    public IScdPropertyFile createPropertyFile(IFileItemHandle file) {
        AssertHelper.validateParam(file, "file");
        return new ScdPropertyFile(file);
    }

    @Override
    public IScdProperty createBooleanProperty(String namespace, String name, boolean value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        return new ScdProperty(namespace, name, new ScdPropertyValue(value), false);
    }

    @Override
    public IScdProperty createStringProperty(String namespace, String name, String value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        AssertHelper.validateParam(value, "value");
        return new ScdProperty(namespace, name, new ScdPropertyValue(value), false);
    }

    @Override
    public IScdProperty createNumberProperty(String namespace, String name, Number value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        AssertHelper.validateParam(value, "value");
        return new ScdProperty(namespace, name, new ScdPropertyValue(value), false);
    }

    @Override
    public IScdProperty createNumberProperty(String namespace, String name, int value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        return new ScdProperty(namespace, name, new ScdPropertyValue(value), false);
    }

    @Override
    public IScdProperty createNumberProperty(String namespace, String name, float value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        return new ScdProperty(namespace, name, new ScdPropertyValue(Float.valueOf(value)), false);
    }

    @Override
    public IScdProperty createPropertyListProperty(String namespace, String name, List<IScdProperty> value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        AssertHelper.validateParam(value, "value");
        return new ScdProperty(namespace, name, new ScdPropertyValue(value), false);
    }

    @Override
    public IScdProperty createBooleanScanProperty(String namespace, String name, boolean value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        return new ScdProperty(namespace, name, new ScdPropertyValue(value), true);
    }

    @Override
    public IScdProperty createStringScanProperty(String namespace, String name, String value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        AssertHelper.validateParam(value, "value");
        return new ScdProperty(namespace, name, new ScdPropertyValue(value), true);
    }

    @Override
    public IScdProperty createNumberScanProperty(String namespace, String name, Number value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        AssertHelper.validateParam(value, "value");
        return new ScdProperty(namespace, name, new ScdPropertyValue(value), true);
    }

    @Override
    public IScdProperty createNumberScanProperty(String namespace, String name, int value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        return new ScdProperty(namespace, name, new ScdPropertyValue(value), true);
    }

    @Override
    public IScdProperty createNumberScanProperty(String namespace, String name, float value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        return new ScdProperty(namespace, name, new ScdPropertyValue(Float.valueOf(value)), true);
    }

    @Override
    public IScdProperty createPropertyListScanProperty(String namespace, String name, List<IScdProperty> value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        AssertHelper.validateParam(value, "value");
        return new ScdProperty(namespace, name, new ScdPropertyValue(value), true);
    }

    @Override
    public IScdProperty createDependencyProperty(String dependencyFileType, String dependencyLogicalName, String dependencyPath, String dependencyReferenceType) {
        ArrayList<IScdProperty> properties = new ArrayList<IScdProperty>();
        properties.add(this.createStringScanProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependencyFileType", dependencyFileType != null ? dependencyFileType : ""));
        properties.add(this.createStringScanProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependencyLogicalName", dependencyLogicalName != null ? dependencyLogicalName : ""));
        properties.add(this.createStringScanProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependencyPath", dependencyPath != null ? dependencyPath : ""));
        properties.add(this.createStringScanProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependencyReferenceType", dependencyReferenceType != null ? dependencyReferenceType : ""));
        return this.createPropertyListProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependency", properties);
    }

    @Override
    public IScdProperty createDependencyProperty(String dependencyFileType, String dependencyLogicalName, String dependencyPath, String dependencyReferenceType, List<IScdProperty> additionalDependencyProperties) {
        IScdProperty property = this.createDependencyProperty(dependencyFileType, dependencyLogicalName, dependencyPath, dependencyReferenceType);
        if (additionalDependencyProperties != null) {
            property.getValue().getPropertyList().addAll(additionalDependencyProperties);
        }
        return property;
    }

    @Override
    public IScdProperty createScanDependencyProperty(String dependencyFileType, String dependencyLogicalName, String dependencyPath, String dependencyReferenceType) {
        IScdProperty property = this.createDependencyProperty(dependencyFileType, dependencyLogicalName, dependencyPath, dependencyReferenceType);
        property.setScanProperty(true);
        return property;
    }

    @Override
    public IScdProperty createScanDependencyProperty(String dependencyFileType, String dependencyLogicalName, String dependencyPath, String dependencyReferenceType, List<IScdProperty> additionalDependencyProperties) {
        IScdProperty property = this.createDependencyProperty(dependencyFileType, dependencyLogicalName, dependencyPath, dependencyReferenceType);
        if (additionalDependencyProperties != null) {
            property.getValue().getPropertyList().addAll(additionalDependencyProperties);
        }
        property.setScanProperty(true);
        return property;
    }

    @Override
    public IScdProperty createProperty(String namespace, String name, IScdPropertyValue value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        AssertHelper.validateParam(value, "value");
        return new ScdProperty(namespace, name, value, false);
    }

    @Override
    public IScdProperty createScanProperty(String namespace, String name, IScdPropertyValue value) {
        AssertHelper.validateNamespace(namespace);
        AssertHelper.validateParam(name, "name");
        AssertHelper.validateParam(value, "value");
        return new ScdProperty(namespace, name, value, true);
    }

    @Override
    public IScdPropertyValue createPropertyValue(String value) {
        AssertHelper.validateParam(value, "value");
        return new ScdPropertyValue(value);
    }

    @Override
    public IScdPropertyValue createPropertyValue(Boolean value) {
        AssertHelper.validateParam(value, "value");
        return new ScdPropertyValue(value);
    }

    @Override
    public IScdPropertyValue createPropertyValue(Number value) {
        AssertHelper.validateParam(value, "value");
        return new ScdPropertyValue(value);
    }

    @Override
    public IScdPropertyValue createPropertyValue(List<IScdProperty> value) {
        AssertHelper.validateParam(value, "value");
        return new ScdPropertyValue(value);
    }
}

