/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.internal.common.api;

import com.ibm.team.enterprise.scd.common.AssertHelper;
import com.ibm.team.enterprise.scd.common.api.IScdProperty;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyValue;

public class ScdProperty
implements IScdProperty {
    private String namespace;
    private String name;
    private IScdPropertyValue value;
    private boolean scanProperty;

    protected ScdProperty(String namespace, String name, IScdPropertyValue value, boolean isScanProperty) {
        AssertHelper.isModifiableProperty(namespace, name);
        this.namespace = namespace;
        this.name = name;
        this.value = value;
        this.scanProperty = isScanProperty;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IScdPropertyValue getValue() {
        return this.value;
    }

    @Override
    public boolean isScanProperty() {
        return this.scanProperty;
    }

    @Override
    public void setNamespace(String namespace) {
        AssertHelper.isModifiableProperty(namespace, this.name);
        this.namespace = namespace;
    }

    @Override
    public void setName(String name) {
        AssertHelper.isModifiableProperty(this.namespace, name);
        this.name = name;
    }

    @Override
    public void setValue(IScdPropertyValue value) {
        AssertHelper.isModifiableProperty(this.namespace, this.name);
        this.value = value;
    }

    @Override
    public void setScanProperty(boolean isScanProperty) {
        AssertHelper.isModifiableProperty(this.namespace, this.name);
        this.scanProperty = isScanProperty;
    }

    @Override
    public boolean isDuplicate(IScdProperty property) {
        return this.namespace.equals(property.getNamespace()) && this.name.equals(property.getName());
    }
}

