/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.common.query.util;

import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.Prefix;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ScdQueryUtil {
    public static final String EXTENSION_TYPE_STRING = "string_extension";
    public static final String EXTENSION_TYPE_BOOLEAN = "boolean_extension";
    public static final String EXTENSION_TYPE_NUMBER = "number_extension";
    public static final String EXTENSION_TYPE_COMPLEX = "complex_extension";
    public static final String EXTENSION_TYPE_COMPLEX_STRING = "complex_string_extension";
    public static final String EXTENSION_TYPE_COMPLEX_BOOLEAN = "complex_boolean_extension";
    public static final String EXTENSION_TYPE_COMPLEX_NUMBER = "complex_number_extension";
    public static final String EXTENSION_TYPE_COMPLEX_COMPLEX = "complex_complex_extension";

    public static String getFullyQualifiedName(IAttribute attr, List<Prefix> prefixes) {
        String fullName = "";
        IAttribute parent = attr.getParent();
        if (parent != null) {
            fullName = String.valueOf(ScdQueryUtil.getFullyQualifiedName(parent, prefixes)) + ">";
        }
        return String.valueOf(fullName) + ScdQueryUtil.getQualifiedName(attr, prefixes);
    }

    public static String getQualifiedName(IAttribute attr, List<Prefix> prefixes) {
        return String.valueOf(ScdQueryUtil.getResolvedNamespace(attr, prefixes)) + attr.getDisplayName();
    }

    public static String getResolvedNamespace(IAttribute attr, List<Prefix> prefixes) {
        String namespace = attr.getNamespace();
        for (Prefix prefix : prefixes) {
            if (!namespace.equals(prefix.getName())) continue;
            namespace = prefix.getUri();
            break;
        }
        return namespace;
    }

    public static boolean isBuiltInProperty(IAttribute attr, List<Prefix> prefixes) {
        boolean builtInProperty = false;
        String namespace = ScdQueryUtil.getResolvedNamespace(attr, prefixes);
        if ("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/".equals(namespace)) {
            if ("fileItemId".equals(attr.getDisplayName()) || "streamId".equals(attr.getDisplayName()) || "componentId".equals(attr.getDisplayName()) || "fileName".equals(attr.getDisplayName()) || "filePath".equals(attr.getDisplayName()) || "componentName".equals(attr.getDisplayName()) || "streamName".equals(attr.getDisplayName())) {
                builtInProperty = true;
            }
        } else if ("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/".equals(namespace) && ("fileType".equals(attr.getDisplayName()) || "language".equals(attr.getDisplayName()) || "logicalName".equals(attr.getDisplayName()) || ScdQueryUtil.isBuiltInDependencyProperty(attr, prefixes))) {
            builtInProperty = true;
        }
        return builtInProperty;
    }

    public static boolean isBuiltInDependencyProperty(IAttribute attr, List<Prefix> prefixes) {
        String namespace = ScdQueryUtil.getResolvedNamespace(attr, prefixes);
        return "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/".equals(namespace) && ("dependencyFileType".equals(attr.getDisplayName()) || "dependencyLogicalName".equals(attr.getDisplayName()) || "dependencyPath".equals(attr.getDisplayName()) || "dependencyReferenceType".equals(attr.getDisplayName()) || "ignoreInBuild".equals(attr.getDisplayName()));
    }

    public static boolean hasExtensionData(Statement statement) {
        for (AttributeColumn col : statement.getSelectClause().getColumns()) {
            if (ScdQueryUtil.isBuiltInProperty(col.getAttribute(), statement.getPrefixes())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDependencyData(Statement statement) {
        for (AttributeColumn col : statement.getSelectClause().getColumns()) {
            if (!ScdQueryUtil.isBuiltInDependencyProperty(col.getAttribute(), statement.getPrefixes())) continue;
            return true;
        }
        return false;
    }

    public static List<String> getExtensionDataTypesSelectionOrder(Statement statement) {
        ArrayList<String> types = new ArrayList<String>();
        for (AttributeColumn col : statement.getSelectClause().getColumns()) {
            String extensionType = ScdQueryUtil.getExtensionDataType(col.getAttribute(), statement.getPrefixes());
            if (extensionType == null || types.contains(extensionType)) continue;
            types.add(extensionType);
        }
        return types;
    }

    public static String getExtensionDataType(IAttribute attr, List<Prefix> prefixes) {
        String type = null;
        if (!ScdQueryUtil.isBuiltInProperty(attr, prefixes)) {
            if (attr.getType() == IAttribute.AttributeType.STRING) {
                type = attr.getParent() != null ? EXTENSION_TYPE_COMPLEX_STRING : EXTENSION_TYPE_STRING;
            } else if (attr.getType() == IAttribute.AttributeType.BOOLEAN) {
                type = attr.getParent() != null ? EXTENSION_TYPE_COMPLEX_BOOLEAN : EXTENSION_TYPE_BOOLEAN;
            } else if (attr.getType() == IAttribute.AttributeType.NUMBER) {
                type = attr.getParent() != null ? EXTENSION_TYPE_COMPLEX_NUMBER : EXTENSION_TYPE_NUMBER;
            }
        }
        return type;
    }

    public static String createATOMFeed(List<Map<String, Object>> results, int totalResultSize) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<feed xmlns=\"http://www.w3.org/2005/Atom\">\n");
        buffer.append("  <title>Converted Query Results</title>\n");
        buffer.append("  <generator>EWM-EE SCD Service</generator>\n");
        Iterator<Map<String, Object>> resultIterator = results.iterator();
        int counter = 0;
        while (resultIterator.hasNext()) {
            Map<String, Object> bindings = resultIterator.next();
            buffer.append("  <entry>\n");
            buffer.append("    <title>Result " + counter + "</title>\n");
            buffer.append("    <content type=\"application/sparql-results+xml\">");
            buffer.append("    <result xmlns=\"http://www.w3.org/2005/sparql-results#\">");
            buffer.append("    <totalResults>" + totalResultSize + "</totalResults>");
            ++counter;
            for (Map.Entry<String, Object> binding : bindings.entrySet()) {
                if (binding.getKey() == null || binding.getKey().length() <= 0 || binding.getValue() == null) continue;
                buffer.append("<binding name=\"" + binding.getKey() + "\">");
                Object value = binding.getValue();
                if (value instanceof String) {
                    buffer.append("<literal>" + (String)value + "</literal>");
                } else if (value instanceof Boolean) {
                    buffer.append("<literal>" + value + "</literal>");
                } else if (value instanceof Number) {
                    buffer.append("<literal>" + value + "</literal>");
                } else if (value instanceof UUID) {
                    buffer.append("<literal>" + ((UUID)value).getUuidValue() + "</literal>");
                }
                buffer.append("</binding>");
            }
            buffer.append("\n");
            buffer.append("    </result>\n");
            buffer.append("    </content>\n");
            buffer.append("  </entry>\n");
        }
        buffer.append("</feed>");
        return buffer.toString();
    }
}

