/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.common;

import com.ibm.team.enterprise.scd.common.model.ScanStatus;
import java.util.HashSet;
import java.util.Set;

public class Status {
    private HashSet<String> warnings = new HashSet();
    private HashSet<String> errors = new HashSet();
    private HashSet<Throwable> exceptions = new HashSet();

    public boolean isOK() {
        return this.warnings.size() == 0 && this.errors.size() == 0 && this.exceptions.size() == 0;
    }

    public ScanStatus getStatus() {
        if (this.errors.size() > 0 || this.exceptions.size() > 0) {
            return ScanStatus.ERROR;
        }
        if (this.warnings.size() > 0) {
            return ScanStatus.WARNING;
        }
        return ScanStatus.OK;
    }

    public void addWarning(String warningMessage) {
        this.warnings.add(warningMessage);
    }

    public void addError(String errorMessage) {
        this.errors.add(errorMessage);
    }

    public void addException(Throwable exception) {
        this.exceptions.add(exception);
    }

    public Set<String> getWarnings() {
        return this.warnings;
    }

    public Set<String> getErrors() {
        return this.errors;
    }

    public Set<Throwable> getExceptions() {
        return this.exceptions;
    }
}

