/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.common;

import com.ibm.team.enterprise.scd.common.ScanArgumentParser;
import com.ibm.team.enterprise.scd.common.model.IComponentEntry;
import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.common.model.IScanConfigurationInstance;
import com.ibm.team.enterprise.scd.common.model.IScanRequest;
import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.common.model.ScanScope;
import com.ibm.team.enterprise.scd.common.model.ScanState;
import com.ibm.team.enterprise.scd.common.model.ScanStatus;
import com.ibm.team.enterprise.scd.common.model.ScanType;
import com.ibm.team.enterprise.scd.internal.common.model.ComponentEntry;
import com.ibm.team.enterprise.scd.internal.common.model.ScanConfigurationInstance;
import com.ibm.team.enterprise.scd.internal.common.model.ScanScheduleEntry;
import com.ibm.team.enterprise.scd.internal.common.model.ScdFactory;
import com.ibm.team.enterprise.scd.internal.common.model.ScdPackage;
import com.ibm.team.enterprise.scd.internal.common.nls.Messages;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;

public class ScdCommonUtil {
    static final long ONE_B = 1024L;
    static final long TEN_KB = 10240L;
    static final long ONE_MB = 0x100000L;
    static final long TEN_MB = 0xA00000L;
    static final long ONE_GB = 0x40000000L;
    static final long TEN_GB = 0x280000000L;
    static final long ONE_TB = 0x10000000000L;
    static final long TEN_TB = 0xA0000000000L;

    public static IScanConfiguration createDefaultScanConfiguration(IWorkspaceHandle stream) {
        IScanConfiguration scanConfiguration = (IScanConfiguration)IScanConfiguration.ITEM_TYPE.createItem();
        ScanScheduleEntry scanSchedule = ScdPackage.eINSTANCE.getScdFactory().createScanScheduleEntry();
        scanSchedule.setScanInterval(3600L);
        scanConfiguration.setScanScheduleEntry(scanSchedule);
        scanConfiguration.setStream(stream);
        scanConfiguration.setScanResultPruningPolicy(ScdPackage.eINSTANCE.getScdFactory().createScanResultPruningPolicy());
        return scanConfiguration;
    }

    public static IScanResult createDefaultScanResult(IScanRequest scanRequest) {
        IScanResult scanResult = (IScanResult)IScanResult.ITEM_TYPE.createItem();
        scanResult.setContextId(scanRequest.getContextId());
        scanResult.setScanConfiguration(scanRequest.getScanConfigurationInstance().getScanConfiguration());
        scanResult.setScanRequest(scanRequest);
        scanResult.setStatus(ScanStatus.OK);
        scanResult.setState(ScanState.NOT_STARTED);
        return scanResult;
    }

    public static IScanConfigurationInstance createScanConfigurationInstance(IScanConfiguration scanConfiguration) {
        ScanConfigurationInstance scanConfigurationInstance = ScdFactory.eINSTANCE.createScanConfigurationInstance();
        scanConfigurationInstance.setStream(scanConfiguration.getStream());
        scanConfigurationInstance.setScanWorkspace(scanConfiguration.getScanWorkspace());
        scanConfigurationInstance.setSyncWorkspace(scanConfiguration.getSyncWorkspace());
        scanConfigurationInstance.setScanConfiguration(scanConfiguration);
        scanConfigurationInstance.setBackgroundScanDelayInterval(scanConfiguration.getScanScheduleEntry().getScanInterval());
        scanConfigurationInstance.setBackgroundScanOnlyIfChanges(scanConfiguration.isBackgroundScanOnlyIfChanges());
        return scanConfigurationInstance;
    }

    public static IScanRequest createDefaultScanRequest(IScanConfiguration scanConfiguration, IAuditableHandle requestor, ScanType scanType) {
        return ScdCommonUtil.createDefaultScanRequest(scanConfiguration, requestor, scanType, ScanScope.STREAM);
    }

    public static IScanRequest createDefaultScanRequest(IScanConfiguration scanConfiguration, IAuditableHandle requestor, ScanType scanType, ScanScope scanScope) {
        IScanRequest scanRequest = (IScanRequest)IScanRequest.ITEM_TYPE.createItem();
        scanRequest.setProcessed(false);
        scanRequest.setRequestor(requestor);
        scanRequest.setScanConfigurationInstance(ScdCommonUtil.createScanConfigurationInstance(scanConfiguration));
        scanRequest.setType(scanType);
        scanRequest.setScope(scanScope);
        scanRequest.setStartNow(false);
        scanRequest.setContinueOnError(scanConfiguration.isContinueOnError());
        scanRequest.setMaxWaitTimeToScan(scanConfiguration.getMaxWaitTimeToScan());
        scanRequest.setScanArguments(scanConfiguration.getScanArguments());
        for (IComponentEntry object : scanConfiguration.getComponents()) {
            ComponentEntry entry = ScdFactory.eINSTANCE.createComponentEntry();
            entry.setComponent(object.getComponent());
            scanRequest.getComponents().add(entry);
        }
        scanRequest.setContextId(scanConfiguration.getContextId());
        return scanRequest;
    }

    public static String formatTimeInHMS(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        if (hours == 0L && (minutes %= 60L) == 0L) {
            return NLS.bind((String)Messages.ScdCommonUtil_TIME_FORMAT_S, (Object)seconds);
        }
        if (hours == 0L) {
            return NLS.bind((String)Messages.ScdCommonUtil_TIME_FORMAT_MS, (Object[])new Object[]{Long.toString(minutes), Long.toString(seconds)});
        }
        return NLS.bind((String)Messages.ScdCommonUtil_TIME_FORMAT_HMS, (Object[])new Object[]{Long.toString(hours), Long.toString(minutes), Long.toString(seconds)});
    }

    public static void fixNullItemAttribute(EObject eObj) {
        EList features = eObj.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            if (!feature.isMany() || eObj.eIsSet(feature) || !ItemUtil.isPersistent((EClass)eObj.eClass(), (EStructuralFeature)feature)) continue;
            eObj.eSet(feature, (Object)Collections.EMPTY_LIST);
        }
    }

    public static boolean sameComponentList(IScanRequest request1, IScanRequest request2) {
        if (request1.getComponents().size() != request2.getComponents().size()) {
            return false;
        }
        List components2 = request2.getComponents();
        for (IComponentEntry component1 : request1.getComponents()) {
            if (ScdCommonUtil.isComponentInList(component1, components2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isComponentInList(IComponentEntry component, List<IComponentEntry> components) {
        for (IComponentEntry nextComponent : components) {
            if (!nextComponent.getComponent().sameItemId((IItemHandle)component.getComponent())) continue;
            return true;
        }
        return false;
    }

    public static boolean sameScanList(IScanRequest request1, IScanRequest request2) {
        if (request1.getScanList().size() != request2.getScanList().size()) {
            return false;
        }
        List scanItems2 = request2.getScanList();
        for (UUID scanItem1 : request1.getScanList()) {
            if (ScdCommonUtil.isUUIDInList(scanItem1, scanItems2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isUUIDInList(UUID uuid, List<UUID> uuids) {
        for (UUID nextUuid : uuids) {
            if (!nextUuid.equals((Object)uuid)) continue;
            return true;
        }
        return false;
    }

    public static boolean sameScanArguments(String args1, String args2) {
        ScanArgumentParser parser1 = new ScanArgumentParser();
        parser1.parse(args1);
        ScanArgumentParser parser2 = new ScanArgumentParser();
        parser2.parse(args2);
        if (parser1.getNumberOfOption() != parser2.getNumberOfOption()) {
            return false;
        }
        for (ScanArgumentParser.Option option : parser1.getAllOptions()) {
            if (!parser2.hasOption(option)) {
                return false;
            }
            String value1 = parser1.getOptionValue(option);
            String value2 = parser2.getOptionValue(option);
            if (!(value1 == null && value2 != null || value1 != null && value2 == null) && (value1 == null || value2 == null || value1.equals(value2))) continue;
            return false;
        }
        return true;
    }

    public static String getTranslatedString(ScanState scanState) {
        if (scanState == ScanState.NOT_STARTED) {
            return Messages.ScanState_PENDING;
        }
        if (scanState == ScanState.SCANNING) {
            return Messages.ScanState_SCANNING;
        }
        if (scanState == ScanState.INDEXING) {
            return Messages.ScanState_INDEXING;
        }
        if (scanState == ScanState.COMPLETED) {
            return Messages.ScanState_COMPLETED;
        }
        if (scanState == ScanState.CANCELLED) {
            return Messages.ScanState_CANCELLED;
        }
        return "";
    }

    public static String getTranslatedString(ScanStatus scanStatus) {
        if (scanStatus == ScanStatus.OK) {
            return Messages.ScanStatus_OK;
        }
        if (scanStatus == ScanStatus.ERROR) {
            return Messages.ScanStatus_FAILED;
        }
        if (scanStatus == ScanStatus.WARNING) {
            return Messages.ScanStatus_WARNING;
        }
        return "";
    }

    public static String getTranslatedString(ScanScope scanScope) {
        if (scanScope == ScanScope.STREAM) {
            return Messages.ScanScope_STREAM;
        }
        if (scanScope == ScanScope.COMPONENT) {
            return Messages.ScanScope_COMPONENT;
        }
        if (scanScope == ScanScope.LANGDEF) {
            return Messages.ScanScope_LANGDEF;
        }
        if (scanScope == ScanScope.FILE) {
            return Messages.ScanScope_FILE;
        }
        return "";
    }

    public static String getTranslatedString(ScanType scanType) {
        if (scanType == ScanType.RESET) {
            return Messages.ScanType_RESET;
        }
        if (scanType == ScanType.UPDATE) {
            return Messages.ScanType_UPDATE;
        }
        return "";
    }

    public static String formatFileSize(long size) {
        if (size == 0L) {
            return "";
        }
        if (size < 1024L) {
            return NLS.bind((String)Messages.ScdCommonUtil_SIZE_IN_BYTES, (Object[])new String[]{String.format("%,d", size)});
        }
        if (size < 10240L) {
            return NLS.bind((String)Messages.ScdCommonUtil_SIZE_IN_KILOBYTES, (Object[])new String[]{String.format("%,.1f", Float.valueOf((float)size / 1024.0f))});
        }
        if (size < 0x100000L) {
            return NLS.bind((String)Messages.ScdCommonUtil_SIZE_IN_KILOBYTES, (Object[])new String[]{String.format("%,d", size / 1024L)});
        }
        if (size < 0xA00000L) {
            return NLS.bind((String)Messages.ScdCommonUtil_SIZE_IN_MEGABYTES, (Object[])new String[]{String.format("%,.1f", Float.valueOf((float)size / 1048576.0f))});
        }
        if (size < 0x40000000L) {
            return NLS.bind((String)Messages.ScdCommonUtil_SIZE_IN_MEGABYTES, (Object[])new String[]{String.format("%,d", size / 0x100000L)});
        }
        if (size < 0x280000000L) {
            return NLS.bind((String)Messages.ScdCommonUtil_SIZE_IN_GIGABYTES, (Object[])new String[]{String.format("%,.1f", Float.valueOf((float)size / 1.0737418E9f))});
        }
        if (size < 0x10000000000L) {
            return NLS.bind((String)Messages.ScdCommonUtil_SIZE_IN_GIGABYTES, (Object[])new String[]{String.format("%,d", size / 0x40000000L)});
        }
        if (size < 0xA0000000000L) {
            return NLS.bind((String)Messages.ScdCommonUtil_SIZE_IN_TERABYTES, (Object[])new String[]{String.format("%,.1f", Float.valueOf((float)size / 1.0995116E12f))});
        }
        return NLS.bind((String)Messages.ScdCommonUtil_SIZE_IN_TERABYTES, (Object[])new String[]{String.format("%,d", size / 0x10000000000L)});
    }
}

