/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.common;

import com.ibm.team.enterprise.scd.common.Status;
import com.ibm.team.enterprise.scd.internal.common.nls.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class ScanArgumentParser {
    private static final char ARG_INDICATOR = '-';
    private static Option[] options = new Option[]{Option.DEBUG, Option.PREVIEW, Option.DUMP, Option.DELETE, Option.SHARE, Option.ORPHANED_FRAGMENTS, Option.TIMESTAMPS, Option.INDEXING_TIMEOUT};
    private final Map<Option, String> optionValuePairs = new HashMap<Option, String>();
    private final Status status;

    public ScanArgumentParser() {
        this(null);
    }

    public ScanArgumentParser(Status status) {
        this.status = status != null ? status : new Status();
    }

    public boolean isDebugOn() {
        return this.hasOption(Option.DEBUG);
    }

    public boolean isLogTimestampsOn() {
        return this.hasOption(Option.TIMESTAMPS);
    }

    public boolean isOrphanedFragmentsOn() {
        return this.hasOption(Option.ORPHANED_FRAGMENTS);
    }

    public boolean isPreviewOn() {
        return this.hasOption(Option.PREVIEW);
    }

    public boolean isDeleteOn() {
        return this.hasOption(Option.DELETE);
    }

    protected void addOption(Option option, String value) {
        this.optionValuePairs.put(option, value);
    }

    public boolean hasOption(Option option) {
        return this.optionValuePairs.containsKey((Object)option);
    }

    public String getOptionValue(Option option) {
        return this.optionValuePairs.get((Object)option);
    }

    public boolean hasAnyOption() {
        return this.optionValuePairs.size() > 0;
    }

    public Set<Option> getAllOptions() {
        return this.optionValuePairs.keySet();
    }

    public int getNumberOfOption() {
        return this.optionValuePairs.size();
    }

    public Status parse(String arguments) {
        if (arguments == null || arguments.trim().length() == 0) {
            return this.status;
        }
        String[] args = arguments.split(" ");
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (ScanArgumentParser.isOption(arg)) {
                String argName = ScanArgumentParser.getArgumentName(arg);
                if (argName != null) {
                    Option option = ScanArgumentParser.findOption(argName);
                    if (option != null) {
                        String possibleValue = null;
                        if (option.isValueRequired()) {
                            if (++i >= args.length) {
                                if (option.getDefaultValue() == null) {
                                    this.status.addError(NLS.bind((String)Messages.ScanArgumentParser_MISSING_VALUE, (Object)option.getName()));
                                } else {
                                    possibleValue = option.getDefaultValue();
                                }
                            } else {
                                possibleValue = args[i];
                                if (ScanArgumentParser.isOption(possibleValue) && option.getDefaultValue() != null) {
                                    possibleValue = option.getDefaultValue();
                                    --i;
                                } else if (!option.validateValue(possibleValue)) {
                                    this.status.addError(NLS.bind((String)Messages.ScanArgumentParser_INVALID_VALUE, (Object)possibleValue, (Object)option.getName()));
                                }
                            }
                        } else {
                            String nextArg;
                            int j = i + 1;
                            if (j < args.length && !ScanArgumentParser.isOption(nextArg = args[j])) {
                                this.status.addError(NLS.bind((String)Messages.ScanArgumentParser_VALUE_NOT_ALLOWED, (Object)option.getName()));
                            }
                        }
                        this.addOption(option, possibleValue);
                    } else {
                        this.status.addError(NLS.bind((String)Messages.ScanArgumentParser_INVALID_ARGUMENT, (Object)argName));
                    }
                }
            } else {
                this.status.addError(NLS.bind((String)Messages.ScanArgumentParser_INVALID_ARGUMENT, (Object)arg));
            }
            ++i;
        }
        return this.status;
    }

    private static String getArgumentName(String arg) {
        if (arg.length() <= 1) {
            return null;
        }
        return arg.substring(1);
    }

    private static Option findOption(String argName) {
        Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (argName.equalsIgnoreCase(option.getName()) || argName.equalsIgnoreCase(option.getAbbreviation())) {
                return option;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isOption(String arg) {
        return arg.length() > 0 && arg.charAt(0) == '-';
    }

    public static void main(String[] args) {
        String forTest = null;
        ScanArgumentParser parser = null;
        Status status = null;
        String errorMessage = null;
        Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            System.out.println("***************************************************");
            System.out.println("Test option: " + option.getName());
            forTest = String.valueOf('-') + option.getName();
            parser = new ScanArgumentParser();
            status = parser.parse(forTest);
            if (!status.isOK()) {
                errorMessage = status.getErrors().iterator().next();
            }
            if (!option.isValueRequired() || option.getDefaultValue() != null) {
                Assert.isTrue((errorMessage == null ? 1 : 0) != 0, (String)("Do not expect 'IllegalArgument " + errorMessage + "' when parsing: '" + forTest + "'"));
                Assert.isTrue((boolean)parser.hasOption(option), (String)("Expect " + option.getName() + " in '" + forTest + "'"));
            } else {
                Assert.isTrue((errorMessage != null ? 1 : 0) != 0, (String)("Expect IllegalArgument when parsing: '" + forTest + "'"));
                Assert.isTrue((!parser.hasOption(option) ? 1 : 0) != 0, (String)("Do not expect " + option.getName() + " in '" + forTest + "'"));
            }
            System.out.println("Successfully testing with: '" + forTest + "'");
            errorMessage = null;
            forTest = String.valueOf('-') + option.getName() + ' ' + (option.isValueRequired() && option.getAllPossibleValues().length > 0 ? option.getAllPossibleValues()[0] : "aValue");
            parser = new ScanArgumentParser();
            status = parser.parse(forTest);
            if (!status.isOK()) {
                errorMessage = status.getErrors().iterator().next();
            }
            if (!option.isValueRequired() || option.getAllPossibleValues().length == 0) {
                Assert.isTrue((errorMessage != null ? 1 : 0) != 0, (String)("Expect IllegalArgument when parsing: '" + forTest + "'"));
            } else {
                Assert.isTrue((errorMessage == null ? 1 : 0) != 0, (String)("Do not expect 'IllegalArgument " + errorMessage + "' when parsing: '" + forTest + "'"));
                Assert.isTrue((boolean)option.getAllPossibleValues()[0].equals(parser.getOptionValue(option)), (String)("Expect option " + option.getName() + " with value 'aValue' instead of '" + parser.getOptionValue(option) + "' in '" + forTest + "'"));
            }
            System.out.println("Successfully testing with: '" + forTest + "'");
            errorMessage = null;
            forTest = String.valueOf('-') + option.getName() + ' ' + "-Value";
            parser = new ScanArgumentParser();
            status = parser.parse(forTest);
            if (!status.isOK()) {
                errorMessage = status.getErrors().iterator().next();
            }
            if (!option.isValueRequired()) {
                Assert.isTrue((errorMessage == null ? 1 : 0) != 0, (String)("Do not expect 'IllegalArgumentException " + errorMessage + "' when parsing: '" + forTest + "'"));
            } else if (option.getDefaultValue() == null) {
                Assert.isTrue((errorMessage != null ? 1 : 0) != 0, (String)("Expect IllegalArgumentException when parsing: '" + forTest + "'"));
            } else {
                Assert.isTrue((errorMessage == null ? 1 : 0) != 0, (String)("Do not expect 'IllegalArgumentException " + errorMessage + "' when parsing: '" + forTest + "'"));
                Assert.isTrue((boolean)option.getDefaultValue().equals(parser.getOptionValue(option)));
            }
            System.out.println("Successfully testing with: '" + forTest + "'");
            System.out.println("***************************************************");
            ++n2;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Option {
        DEBUG("debug"),
        TIMESTAMPS("timestamps"),
        PREVIEW("preview"),
        DELETE("delete"),
        ORPHANED_FRAGMENTS("orphanedFragments"),
        SHARE("share"){

            @Override
            public boolean isValueRequired() {
                return true;
            }
        }
        ,
        INDEXING_TIMEOUT("indexingTimeout"){

            @Override
            public boolean isValueRequired() {
                return true;
            }
        }
        ,
        DUMP("dump"){

            @Override
            public boolean isValueRequired() {
                return true;
            }

            @Override
            public String[] getAllPossibleValues() {
                return new String[]{"a", "m", "o"};
            }

            @Override
            public String getDefaultValue() {
                return "a";
            }
        };

        private String name;

        private Option(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getAbbreviation() {
            return null;
        }

        public boolean isValueRequired() {
            return false;
        }

        public boolean validateValue(String value) {
            if (this.isValueRequired()) {
                if (value == null || value.length() == 0) {
                    return false;
                }
                if (ScanArgumentParser.isOption(value)) {
                    return false;
                }
                if (this.getAllPossibleValues().length > 0) {
                    String[] stringArray = this.getAllPossibleValues();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String possibleValue = stringArray[n2];
                        if (possibleValue.equals(value)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            }
            return true;
        }

        public String getDefaultValue() {
            return null;
        }

        public String[] getAllPossibleValues() {
            return new String[0];
        }
    }
}

