/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.common;

import com.ibm.team.enterprise.scd.common.api.IScdProperty;
import com.ibm.team.enterprise.scd.internal.common.nls.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import java.net.URI;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class AssertHelper {
    public static void validateParam(Object param, String paramName) throws IllegalArgumentException {
        if (param == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.AssertHelper_ERROR_NULL_PARAM, (Object)paramName));
        }
    }

    public static void isNotNull(Object object, String errorMessage) throws TeamRepositoryException {
        if (object == null) {
            throw new TeamRepositoryException(errorMessage);
        }
    }

    public static void isStream(IWorkspace workspace) throws IllegalArgumentException {
        if (!workspace.isStream()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.AssertHelper_ERROR_IS_NOT_STREAM, (Object)workspace.getName()));
        }
    }

    public static void validateNamespace(String namespace) throws IllegalArgumentException {
        if (namespace == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.AssertHelper_ERROR_NULL_PARAM, (Object)"namespace"));
        }
        if (!namespace.endsWith("/")) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.AssertHelper_ERROR_INVALID_NAMESPACE, (Object)namespace));
        }
        URI.create(namespace);
    }

    public static void validateDuplicateProperty(List<IScdProperty> properties, IScdProperty property) throws IllegalArgumentException {
        for (IScdProperty listProperty : properties) {
            if (!listProperty.isDuplicate(property) || listProperty.getValue() == null || property.getValue() == null || listProperty.getValue().getType() == property.getValue().getType()) continue;
            throw new IllegalArgumentException();
        }
    }

    public static void isModifiableProperty(IScdProperty property) throws UnsupportedOperationException {
        if ("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/".equals(property.getNamespace())) {
            throw new UnsupportedOperationException(NLS.bind((String)Messages.AssertHelper_ERROR_READ_ONLY_PROPERTY, (Object)property.getName()));
        }
    }

    public static void isModifiableProperty(String namespace, String name) throws UnsupportedOperationException {
        if ("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/".equals(namespace)) {
            throw new UnsupportedOperationException(NLS.bind((String)Messages.AssertHelper_ERROR_READ_ONLY_PROPERTY, (Object)name));
        }
    }
}

