/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.common;

import com.ibm.team.enterprise.scd.internal.common.nls.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractNumberValidator<T extends Number> {
    protected T min;
    protected T max;
    private boolean allowEmpty;

    protected abstract Comparable<T> parseInput(String var1);

    public AbstractNumberValidator(T min, T max, boolean allowEmpty) {
        this.min = min;
        this.max = max;
        this.allowEmpty = allowEmpty;
    }

    public IStatus validate(Object object) {
        Assert.isNotNull((Object)object);
        String input = object.toString().trim();
        if (input.length() == 0) {
            if (!this.allowEmpty) {
                return this.getErrorStatus(Messages.NumberValidator_NOT_NUMBER);
            }
        } else {
            try {
                Comparable<T> value = this.parseInput(input);
                if (!this.isInRange(value)) {
                    return this.getErrorStatus(NLS.bind((String)Messages.NumberValidator_RANGE_ERROR, this.min, this.max));
                }
            }
            catch (NumberFormatException e) {
                return this.getErrorStatus(Messages.NumberValidator_NOT_NUMBER, e);
            }
        }
        return Status.OK_STATUS;
    }

    protected boolean isInRange(Comparable<T> value) {
        return (this.min == null || value.compareTo(this.min) >= 0) && (this.max == null || value.compareTo(this.max) <= 0);
    }

    private IStatus getErrorStatus(String errorMessage) {
        return this.getErrorStatus(errorMessage, null);
    }

    private IStatus getErrorStatus(String errorMessage, Throwable t) {
        return new Status(4, "com.ibm.team.enterprise.scd.common", errorMessage, t);
    }
}

