/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.internal.client;

import com.ibm.team.enterprise.scd.client.IScdClientAPI;
import com.ibm.team.enterprise.scd.common.api.IScanResultAPI;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyFactory;
import com.ibm.team.enterprise.scd.common.api.IScdPropertyFile;
import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.common.model.IScanResultContribution;
import com.ibm.team.enterprise.scd.common.model.IScanSummary;
import com.ibm.team.enterprise.scd.common.model.ScanState;
import com.ibm.team.enterprise.scd.common.model.ScanStatus;
import com.ibm.team.enterprise.scd.internal.common.IScdService;
import com.ibm.team.enterprise.scd.internal.common.api.ScdPropertyFactory;
import com.ibm.team.enterprise.scd.internal.common.transport.TransportUtil;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScdClientAPI
implements IScdClientAPI {
    private IClientLibraryContext context;

    public ScdClientAPI(IClientLibraryContext context) {
        this.context = context;
    }

    private IScdService getScdInternalService() {
        return (IScdService)this.context.getServiceInterface(IScdService.class);
    }

    protected <T> T callCancelableService(IProgressMonitor monitor, IClientLibraryContext.IServiceRunnable<T> serviceRunnable) throws TeamRepositoryException {
        return (T)this.context.callCancelableService(serviceRunnable, monitor);
    }

    @Override
    public IScdPropertyFile[] getSourceCodeData(final IWorkspaceHandle stream, final IFileItemHandle[] files, IProgressMonitor monitor) throws TeamRepositoryException {
        IScdPropertyFile[] propertyFiles = this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<IScdPropertyFile[]>(){

            public IScdPropertyFile[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                String transportFileString = ScdClientAPI.this.getScdInternalService().getSourceCodeDataAPI(stream, files);
                List transportFiles = TransportUtil.fromXML((String)transportFileString);
                return TransportUtil.toScdPropertyFiles((List)transportFiles).toArray(new IScdPropertyFile[0]);
            }
        });
        return propertyFiles;
    }

    @Override
    public void deleteSourceCodeData(final IWorkspaceHandle stream, final IFileItemHandle[] files, final boolean scanPropertiesOnly, final int maxUpdateWaitTime, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ScdClientAPI.this.getScdInternalService().deleteSourceCodeDataAPI(stream, files, scanPropertiesOnly, maxUpdateWaitTime);
                return null;
            }
        });
    }

    @Override
    public void appendSourceCodeData(final IWorkspaceHandle stream, final IScdPropertyFile[] scdFiles, final int maxUpdateWaitTime, final boolean createScdIfNeeded, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                List tFiles = TransportUtil.fromScdPropertyFiles(Arrays.asList(scdFiles));
                String transportFileString = TransportUtil.toXML((List)tFiles);
                ScdClientAPI.this.getScdInternalService().appendSourceCodeDataAPI(stream, transportFileString, maxUpdateWaitTime, createScdIfNeeded);
                return null;
            }
        });
    }

    @Override
    public void replaceSourceCodeData(final IWorkspaceHandle stream, final IScdPropertyFile[] scdFiles, final int maxUpdateWaitTime, final boolean createScdIfNeeded, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                List tFiles = TransportUtil.fromScdPropertyFiles(Arrays.asList(scdFiles));
                String transportFileString = TransportUtil.toXML((List)tFiles);
                ScdClientAPI.this.getScdInternalService().replaceSourceCodeDataAPI(stream, transportFileString, maxUpdateWaitTime, createScdIfNeeded);
                return null;
            }
        });
    }

    @Override
    public void setSourceCodeData(final IWorkspaceHandle stream, final IScdPropertyFile[] scdFiles, final int maxUpdateWaitTime, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                List tFiles = TransportUtil.fromScdPropertyFiles(Arrays.asList(scdFiles));
                String transportFileString = TransportUtil.toXML((List)tFiles);
                ScdClientAPI.this.getScdInternalService().setSourceCodeDataAPI(stream, transportFileString, maxUpdateWaitTime);
                return null;
            }
        });
    }

    @Override
    public IScanResultAPI scanFiles(IVersionableHandle[] versionableHandles, IWorkspaceHandle workspaceHandle, boolean continueOnError) throws TeamRepositoryException {
        final IScanResult scanResult = this.getScdInternalService().scanFiles(versionableHandles, workspaceHandle, continueOnError);
        IScanResultContribution scanResultContribution = scanResult.getScanLog();
        final InputStream logContents = scanResultContribution == null || scanResultContribution.getContributionData() == null ? null : ((ITeamRepository)scanResult.getOrigin()).contentManager().retrieveContentStream(scanResultContribution.getContributionData(), null);
        return new IScanResultAPI(){

            public String getLabel() {
                return scanResult.getLabel();
            }

            public ScanStatus getStatus() {
                return scanResult.getStatus();
            }

            public ScanState getState() {
                return scanResult.getState();
            }

            public long getScanFinishTime() {
                return scanResult.getScanFinishTime();
            }

            public long getScanStartTime() {
                return scanResult.getScanStartTime();
            }

            public InputStream getScanLog() {
                return logContents;
            }

            public IScanSummary getScanSummary() {
                return scanResult.getScanSummary();
            }
        };
    }

    @Override
    public IScdPropertyFactory createScdPropertyFactory() {
        return new ScdPropertyFactory();
    }
}

