/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.internal.client;

import com.ibm.team.enterprise.scd.client.ScanResultTrend;
import com.ibm.team.enterprise.scd.common.AssertHelper;
import com.ibm.team.enterprise.scd.common.ScdCommonUtil;
import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.common.model.IScanConfigurationHandle;
import com.ibm.team.enterprise.scd.common.model.IScanRequest;
import com.ibm.team.enterprise.scd.common.model.IScanRequestHandle;
import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.common.model.IScanResultHandle;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.enterprise.scd.internal.client.nls.Messages;
import com.ibm.team.enterprise.scd.internal.common.IScanRequestService;
import com.ibm.team.enterprise.scd.internal.common.IScdQueryService;
import com.ibm.team.enterprise.scd.internal.common.IScdService;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScdClient
implements IScdClient {
    private final IClientLibraryContext context;

    public ScdClient(IClientLibraryContext context) {
        this.context = context;
    }

    private IScdService getScdService() {
        return (IScdService)this.context.getServiceInterface(IScdService.class);
    }

    private IScdQueryService getScdQueryService() {
        return (IScdQueryService)this.context.getServiceInterface(IScdQueryService.class);
    }

    private IScanRequestService getScanRequestService() {
        return (IScanRequestService)this.context.getServiceInterface(IScanRequestService.class);
    }

    @Override
    public IScanConfiguration createDefaultScanConfiguration(IWorkspace stream) {
        AssertHelper.validateParam((Object)stream, (String)"stream");
        AssertHelper.isStream((IWorkspace)stream);
        return ScdCommonUtil.createDefaultScanConfiguration((IWorkspaceHandle)stream);
    }

    @Override
    public IScanConfiguration saveScanConfiguration(final IScanConfiguration scanConfiguration) throws TeamRepositoryException {
        AssertHelper.validateParam((Object)scanConfiguration, (String)"scanConfiguration");
        return (IScanConfiguration)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IScanConfiguration>(){

            public IScanConfiguration run(IProgressMonitor monitor) throws TeamRepositoryException {
                class SaveProcessRunnable
                extends ProcessRunnable {
                    protected IScanConfiguration savedScanConfiguration;
                    private final /* synthetic */ IScanConfiguration val$scanConfiguration;

                    SaveProcessRunnable(IScanConfiguration iScanConfiguration) {
                        this.val$scanConfiguration = iScanConfiguration;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        this.savedScanConfiguration = ScdClient.this.getScdService().saveScanConfiguration(this.val$scanConfiguration);
                        return null;
                    }
                }
                SaveProcessRunnable runnable = new SaveProcessRunnable(scanConfiguration);
                IProcessClientService processService = (IProcessClientService)ScdClient.this.getTeamRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.ScdClient_SAVE_PROCESS_OPERATION_ID, monitor);
                return runnable.savedScanConfiguration;
            }
        }, null);
    }

    @Override
    public IScanConfiguration createAndSaveDefaultScanConfiguration(IWorkspace stream) throws TeamRepositoryException {
        IScanConfiguration scanConfiguration = this.createDefaultScanConfiguration(stream);
        return this.saveScanConfiguration(scanConfiguration);
    }

    @Override
    public void deleteScanConfiguration(final IScanConfiguration scanConfiguration) throws TeamRepositoryException {
        AssertHelper.validateParam((Object)scanConfiguration, (String)"scanConfiguration");
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class DeleteProcessRunnable
                extends ProcessRunnable {
                    private final /* synthetic */ IScanConfiguration val$scanConfiguration;

                    DeleteProcessRunnable(IScanConfiguration iScanConfiguration) {
                        this.val$scanConfiguration = iScanConfiguration;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ScdClient.this.getScdService().deleteScanConfiguration(this.val$scanConfiguration);
                        return null;
                    }
                }
                DeleteProcessRunnable runnable = new DeleteProcessRunnable(scanConfiguration);
                IProcessClientService processService = (IProcessClientService)ScdClient.this.getTeamRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.ScdClient_DELETE_PROCESS_OPERATION_ID, monitor);
                return null;
            }
        }, null);
    }

    @Override
    public IScanConfiguration getScanConfiguration(IWorkspaceHandle streamHandle) throws TeamRepositoryException {
        return this.getScdQueryService().queryScanConfiguration(streamHandle);
    }

    @Override
    public IScanConfiguration[] getAllScanConfigurations() throws TeamRepositoryException {
        return this.getScdQueryService().getAllScanConfigurations();
    }

    @Override
    public IScanConfiguration[] getScanConfigurations(IWorkspaceHandle[] streamHandles) throws TeamRepositoryException {
        return this.getScdQueryService().getScanConfigurations(streamHandles);
    }

    @Override
    public IScanRequest requestScan(final IScanRequest scanRequest, IProgressMonitor monitor) throws TeamRepositoryException {
        AssertHelper.validateParam((Object)scanRequest, (String)"scanRequest");
        return (IScanRequest)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IScanRequest>(){

            public IScanRequest run(IProgressMonitor monitor) throws TeamRepositoryException {
                class RequestProcessRunnable
                extends ProcessRunnable {
                    protected IScanRequest resultScanRequest;
                    private final /* synthetic */ IScanRequest val$scanRequest;

                    RequestProcessRunnable(IScanRequest iScanRequest) {
                        this.val$scanRequest = iScanRequest;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        this.resultScanRequest = ScdClient.this.getScanRequestService().requestScan(this.val$scanRequest);
                        return null;
                    }
                }
                RequestProcessRunnable runnable = new RequestProcessRunnable(scanRequest);
                IProcessClientService processService = (IProcessClientService)ScdClient.this.getTeamRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.ScdClient_REQUEST_SCAN_OPERATION_ID, monitor);
                return runnable.resultScanRequest;
            }
        }, monitor);
    }

    @Override
    public IScanRequest createBuildScanRequest(IScanConfiguration scanConfiguration, IAuditableHandle buildResultHandle, boolean reset) throws TeamRepositoryException {
        return this.getScanRequestService().createBuildScanRequest(scanConfiguration, buildResultHandle, reset);
    }

    @Override
    public IScanResult[] queryScanResults(List<IScanConfigurationHandle> scanConfigurations) throws TeamRepositoryException {
        if (scanConfigurations.size() == 0) {
            return new IScanResult[0];
        }
        return this.getScdQueryService().queryAllScanResults(scanConfigurations.toArray(new IScanConfigurationHandle[scanConfigurations.size()]));
    }

    @Override
    public String executeScdQuery(final String queryXML, final int rowLimit, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String atomFeed = ScdClient.this.getScdService().executeScdQuery(queryXML, rowLimit);
                return atomFeed;
            }
        });
    }

    @Override
    public List<ScanResultTrend> queryScanResultTrends(IScanResultHandle scanResultHandle, int maxScanResults, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IScanResult> scanResults = new ArrayList<IScanResult>(maxScanResults);
        IScanResult scanResult = (IScanResult)((ITeamRepository)scanResultHandle.getOrigin()).itemManager().fetchCompleteItem((IItemHandle)scanResultHandle, 0, monitor);
        scanResults.add(scanResult);
        int subTotalResults = maxScanResults - 1;
        if (subTotalResults > 1) {
            IScanResult[] previousScanResults = this.getScdQueryService().queryPreviousScanResults(scanResultHandle, subTotalResults);
            IScanResult[] nextScanResults = this.getScdQueryService().queryNextScanResults(scanResultHandle, subTotalResults);
            Iterator<Object> previousScanResultIterator = Arrays.asList(previousScanResults).iterator();
            Iterator<IScanResult> nextScanResultIterator = Arrays.asList(nextScanResults).iterator();
            int availableScanResults = previousScanResults.length + nextScanResults.length;
            int resultsIncludedInTrend = 0;
            while (resultsIncludedInTrend < availableScanResults && resultsIncludedInTrend < subTotalResults) {
                if (previousScanResultIterator.hasNext()) {
                    scanResults.add(0, (IScanResult)previousScanResultIterator.next());
                    ++resultsIncludedInTrend;
                }
                if (resultsIncludedInTrend >= availableScanResults || resultsIncludedInTrend >= subTotalResults || !nextScanResultIterator.hasNext()) continue;
                scanResults.add(nextScanResultIterator.next());
                ++resultsIncludedInTrend;
            }
        }
        ArrayList<IScanRequestHandle> scanRequestHandles = new ArrayList<IScanRequestHandle>(scanResults.size());
        for (IScanResult sResult : scanResults) {
            scanRequestHandles.add(sResult.getScanRequest());
        }
        List scanRequests = ((ITeamRepository)scanResultHandle.getOrigin()).itemManager().fetchPartialItems(scanRequestHandles, 0, Arrays.asList(IScanRequest.PROPERTY_SCAN_TYPE), monitor);
        ArrayList<ScanResultTrend> trends = new ArrayList<ScanResultTrend>(scanResults.size());
        int i = 0;
        while (i < scanResults.size()) {
            IScanResult result = (IScanResult)scanResults.get(i);
            IScanRequest request = (IScanRequest)scanRequests.get(i);
            if (result != null && request != null) {
                trends.add(new ScanResultTrend(result, request));
            }
            ++i;
        }
        return trends;
    }

    @Override
    public List<IScanRequestHandle> getScanRequests(IScanConfiguration scanConfiguration) throws TeamRepositoryException {
        return Arrays.asList(this.getScdQueryService().queryAllScanRequests((IScanConfigurationHandle)scanConfiguration));
    }

    @Override
    public List<IScanRequestHandle> getScanRequestOrphans() throws TeamRepositoryException {
        return Arrays.asList(this.getScdQueryService().queryScanRequestsWithDanglingReferences(0));
    }

    @Override
    public void deleteScanRequest(final IScanRequest scanRequest, IProgressMonitor monitor) throws TeamRepositoryException {
        AssertHelper.validateParam((Object)scanRequest, (String)"scanRequest");
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class DeleteProcessRunnable
                extends ProcessRunnable {
                    private final /* synthetic */ IScanRequest val$scanRequest;

                    DeleteProcessRunnable(IScanRequest iScanRequest) {
                        this.val$scanRequest = iScanRequest;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ScdClient.this.getScanRequestService().deleteScanRequest(this.val$scanRequest);
                        return null;
                    }
                }
                DeleteProcessRunnable runnable = new DeleteProcessRunnable(scanRequest);
                IProcessClientService processService = (IProcessClientService)ScdClient.this.getTeamRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, "delete scanRequest", monitor);
                return null;
            }
        }, null);
    }

    @Override
    public void deleteScanRequests(final List<IScanRequestHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        AssertHelper.validateParam(handles, (String)"scanRequestHandle");
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class DeleteProcessRunnable
                extends ProcessRunnable {
                    private final /* synthetic */ List val$handles;

                    DeleteProcessRunnable(List list) {
                        this.val$handles = list;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ScdClient.this.getScanRequestService().deleteScanRequests(this.val$handles.toArray(new IScanRequestHandle[0]));
                        return null;
                    }
                }
                DeleteProcessRunnable runnable = new DeleteProcessRunnable(handles);
                IProcessClientService processService = (IProcessClientService)ScdClient.this.getTeamRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, "delete scanRequests", monitor);
                return null;
            }
        }, null);
    }

    @Override
    public void deleteScanResults(final List<IScanResultHandle> scanResultHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        AssertHelper.validateParam(scanResultHandles, (String)"scanResultHandles");
        if (scanResultHandles.size() == 0) {
            return;
        }
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class DeleteScanResultProcessRunnable
                extends ProcessRunnable {
                    private final /* synthetic */ List val$scanResultHandles;

                    DeleteScanResultProcessRunnable(List list) {
                        this.val$scanResultHandles = list;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ScdClient.this.getScdService().deleteScanResults(this.val$scanResultHandles.toArray(new IScanResultHandle[this.val$scanResultHandles.size()]));
                        return null;
                    }
                }
                DeleteScanResultProcessRunnable runnable = new DeleteScanResultProcessRunnable(scanResultHandles);
                IProcessClientService processService = (IProcessClientService)ScdClient.this.getTeamRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.ScdClient_DELETE_SCAN_RESULT_OPERATION_ID, monitor);
                return null;
            }
        }, monitor);
    }

    @Override
    public void cancelScanResults(IScanResultHandle scanResultHandle) throws TeamRepositoryException {
        this.getScdService().cancelScanResult(scanResultHandle);
    }

    protected <T> T callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable<T> serviceRunnable) throws TeamRepositoryException {
        return (T)this.context.callCancelableService(serviceRunnable, progressMonitor);
    }

    private ITeamRepository getTeamRepository() {
        return this.context.teamRepository();
    }
}

