/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.nodes;

import com.ibm.team.enterprise.common.common.ZComponentNature;
import com.ibm.team.enterprise.ref.integrity.internal.Activator;
import com.ibm.team.enterprise.ref.integrity.internal.Images;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceTreeNode;
import com.ibm.team.process.common.IProjectArea;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.dialogs.PropertyDialog;

public class FileTreeNode
extends ReferenceTreeNode {
    public FileTreeNode(Object value) {
        super(value);
    }

    @Override
    public Image getImage() {
        try {
            IFile file = (IFile)this.value;
            IProject project = file.getProject();
            if (project.hasNature(ZComponentNature.ID)) {
                return Activator.getImage("icons/obj16/zfile_nav.gif");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Images.getSpecifiedImage("etool16/file_obj");
    }

    @Override
    public String getLabel() {
        return ((IFile)this.getValue()).getName();
    }

    @Override
    public void handleDoubleClick(IWorkbenchSite site, IProjectArea projectArea) {
        this.openFileEditor(site);
    }

    @Override
    public void performAction(String actionKey, IWorkbenchSite site) {
        if (actionKey.equals("edit_properties")) {
            this.openPropertiesEditor(site);
        }
        if (actionKey.equals("open")) {
            this.openFileEditor(site);
        }
    }

    private void openPropertiesEditor(IWorkbenchSite site) {
        PropertyDialog dialog = PropertyDialog.createDialogOn((Shell)site.getShell(), null, (Object)this.getValue());
        if (dialog != null) {
            dialog.open();
        }
    }

    private void openFileEditor(IWorkbenchSite site) {
        if (this.getValue() instanceof IFile) {
            IFile file = (IFile)this.getValue();
            try {
                IDE.openEditor((IWorkbenchPage)site.getPage(), (IFile)file);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean supportsAction(String actionKey) {
        return actionKey.equals("open") || actionKey.equals("edit_properties");
    }

    @Override
    public Image getActiveImage() {
        return null;
    }

    @Override
    public Image getArchivedImage() {
        return null;
    }
}

