/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.internal.search;

import com.ibm.team.enterprise.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceSearchQuery;
import com.ibm.team.enterprise.ref.integrity.internal.search.IRetargetDialogWrapper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class SystemDefinitionsRegistry {
    private boolean initialized;
    private List<IConfigurationElement> contributions = new ArrayList<IConfigurationElement>();
    private HashMap<String, List<IConfigurationElement>> bySystem = new HashMap();
    public static final SystemDefinitionsRegistry singleton = new SystemDefinitionsRegistry();

    private void initialize() {
        this.initialized = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor("com.ibm.team.enterprise.ref.integrity.systemDefinition");
        int i = 0;
        while (i < conf.length) {
            List<Object> elements;
            IConfigurationElement currentConf = conf[i];
            this.contributions.add(currentConf);
            String system = currentConf.getAttribute("systemID");
            if (this.bySystem.containsKey(system)) {
                elements = this.bySystem.get(system);
                elements.add(currentConf);
            } else {
                elements = new ArrayList<IConfigurationElement>();
                elements.add(currentConf);
                this.bySystem.put(system, elements);
            }
            ++i;
        }
    }

    public List<IConfigurationElement> getContributions() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.contributions;
    }

    public List<IConfigurationElement> getContributionsForSystem(String system) {
        if (!this.initialized) {
            this.initialize();
        }
        return this.bySystem.get(system);
    }

    public IReferenceSearchQuery getQuery(IConfigurationElement contribution) throws InvocationTargetException {
        if (!this.initialized) {
            this.initialize();
        }
        IReferenceSearchQuery result = null;
        try {
            result = (IReferenceSearchQuery)contribution.createExecutableExtension("query");
        }
        catch (Exception exc) {
            throw new InvocationTargetException(exc, Messages.message_search_failed);
        }
        return result;
    }

    public IRetargetDialogWrapper getReReferenceDIalogWrapper(IConfigurationElement contribution) throws InvocationTargetException {
        if (!this.initialized) {
            this.initialize();
        }
        IRetargetDialogWrapper result = null;
        try {
            result = (IRetargetDialogWrapper)contribution.createExecutableExtension("retargetDialogWrapper");
        }
        catch (Exception exc) {
            throw new InvocationTargetException(exc, Messages.message_search_failed);
        }
        return result;
    }
}

