/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.internal.search;

import com.ibm.team.enterprise.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceResolver;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ResolversRegistry {
    private boolean initialized;
    private List<IConfigurationElement> contributions = new ArrayList<IConfigurationElement>();
    private HashMap<String, List<IConfigurationElement>> bySystemDefinitionID = new HashMap();
    public static final ResolversRegistry singleton = new ResolversRegistry();

    private void initialize() {
        this.initialized = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor("com.ibm.team.enterprise.ref.integrity.ReferenceResolver");
        int i = 0;
        while (i < conf.length) {
            List<Object> contributions;
            IConfigurationElement currentConf = conf[i];
            this.contributions.add(currentConf);
            String systemDefinitionID = currentConf.getAttribute("systemDefinitionID");
            if (this.bySystemDefinitionID.containsKey(systemDefinitionID)) {
                contributions = this.bySystemDefinitionID.get(systemDefinitionID);
                contributions.add(currentConf);
            } else {
                contributions = new ArrayList<IConfigurationElement>();
                contributions.add(currentConf);
                this.bySystemDefinitionID.put(systemDefinitionID, contributions);
            }
            ++i;
        }
    }

    public List<IConfigurationElement> getContributions() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.contributions;
    }

    public List<IConfigurationElement> getContributionsFor(String systemDefinition) {
        List<IConfigurationElement> elements;
        if (!this.initialized) {
            this.initialize();
        }
        if ((elements = this.bySystemDefinitionID.get(systemDefinition)) == null) {
            elements = new ArrayList<IConfigurationElement>();
        }
        return elements;
    }

    public IReferenceResolver getResolver(IConfigurationElement contribution) throws InvocationTargetException {
        if (!this.initialized) {
            this.initialize();
        }
        IReferenceResolver result = null;
        try {
            result = (IReferenceResolver)contribution.createExecutableExtension("class");
        }
        catch (Exception exc) {
            throw new InvocationTargetException(exc, Messages.message_search_failed);
        }
        return result;
    }
}

