/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.internal.search;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.common.ui.IMenuAction;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ref.integrity.internal.Activator;
import com.ibm.team.enterprise.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceSearchQuery;
import com.ibm.team.enterprise.ref.integrity.internal.search.IRetargetDialogWrapper;
import com.ibm.team.enterprise.ref.integrity.internal.ui.dialog.ViewBuildDefinitionDialog;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.node.AbstractEnterpriseExtensionsSystemDefinitionNode;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class ReferencesAction
extends Action
implements IMenuAction {
    private IWorkbenchPartSite fPartSite;
    protected IStructuredSelection fSelection = null;
    private IWorkbenchWindow window;

    public ReferencesAction() {
        this.setText(this.hasOptionalBuildDef() ? Messages.references_to_label2 : Messages.references_to_label);
    }

    public ReferencesAction(IWorkbenchPartSite site, IProjectAreaHandle projectAreaHandle, IStructuredSelection selection) {
        this.fPartSite = site;
        this.fSelection = selection;
        this.setText(this.hasOptionalBuildDef() ? Messages.references_to_label2 : Messages.references_to_label);
    }

    protected boolean hasOptionalBuildDef() {
        return false;
    }

    public boolean isEnabled() {
        IStructuredSelection selection = this.getSelection();
        return selection != null && selection.size() == 1;
    }

    public void internalRunWithoutBuildDef() {
        IWorkbenchWindow workbenchWindow = this.fPartSite.getWorkbenchWindow();
        IWorkbenchPage page = null;
        if (workbenchWindow != null) {
            page = workbenchWindow.getActivePage();
        }
        if (page != null) {
            final AbstractEnterpriseExtensionsNode node = this.getEENode();
            final ITeamRepository repository = this.getRepository();
            new UIUpdaterJob(""){
                IReferenceSearchQuery query;

                public IStatus runInBackground(IProgressMonitor monitor) {
                    this.query = ReferencesAction.this.getQuery();
                    ReferencesAction.this.populateSearchParameters(this.query, ReferencesAction.this.fSelection, repository, null, node);
                    return Status.OK_STATUS;
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    NewSearchUI.runQueryInBackground((ISearchQuery)this.query);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void run() {
        if (this.hasOptionalBuildDef()) {
            this.internalRunWithBuildDef();
        } else {
            this.internalRunWithoutBuildDef();
        }
    }

    public void internalRunWithBuildDef() {
        IWorkbenchWindow workbenchWindow = this.fPartSite.getWorkbenchWindow();
        IWorkbenchPage page = null;
        if (workbenchWindow != null) {
            page = workbenchWindow.getActivePage();
        }
        if (page != null) {
            Shell shell;
            ViewBuildDefinitionDialog dlg;
            final AbstractEnterpriseExtensionsNode node = this.getEENode();
            final ITeamRepository repository = this.getRepository();
            if (this.window == null) {
                this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
            if ((dlg = new ViewBuildDefinitionDialog(repository, shell = this.window.getShell())).open() == 0) {
                final IBuildDefinition buildDefinition = dlg.getBuildDefinition();
                new UIUpdaterJob(""){
                    IReferenceSearchQuery query;

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        this.query = ReferencesAction.this.getQuery();
                        ReferencesAction.this.populateSearchParameters(this.query, ReferencesAction.this.fSelection, repository, buildDefinition, node);
                        return Status.OK_STATUS;
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        NewSearchUI.runQueryInBackground((ISearchQuery)this.query);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    protected abstract IReferenceSearchQuery getQuery();

    private void populateSearchParameters(IReferenceSearchQuery query, IStructuredSelection fSelection, ITeamRepository repository, IBuildDefinition buildDefinitionOrNull, AbstractEnterpriseExtensionsNode node) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("repository", repository);
        parameters.put("limit_to", "all");
        ISystemDefinition sysDef = null;
        if (node instanceof AbstractEnterpriseExtensionsSystemDefinitionNode) {
            sysDef = ((AbstractEnterpriseExtensionsSystemDefinitionNode)node).getSystemDefinition();
            try {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repository);
                sysDef = client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)sysDef, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (TeamRepositoryException e) {
                Activator.log(e);
            }
        }
        parameters.put("target", sysDef);
        parameters.put("search_label", sysDef == null ? "" : sysDef.getName());
        parameters.put("OptionalBuildDefinition", buildDefinitionOrNull);
        parameters.put("wrapper", this.getRetargetDialogWrapper());
        query.setSearchParameters(parameters);
    }

    protected abstract IRetargetDialogWrapper getRetargetDialogWrapper();

    public void setPartSite(IWorkbenchPartSite partSite) {
        this.fPartSite = partSite;
    }

    protected IStructuredSelection getSelection() {
        ISelection selection;
        IWorkbenchPage workbenchPage;
        IViewPart view;
        IStructuredSelection result = null;
        if (this.fPartSite != null && (view = (workbenchPage = this.fPartSite.getPage()).findView("com.ibm.team.process.rcp.ui.teamArtifactsNavigator")) != null && (selection = view.getSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection) {
            result = (IStructuredSelection)selection;
        }
        return result;
    }

    protected AbstractEnterpriseExtensionsNode getEENode() {
        IStructuredSelection selection = this.getSelection();
        if (selection.getFirstElement() instanceof AbstractEnterpriseExtensionsNode) {
            return (AbstractEnterpriseExtensionsNode)selection.getFirstElement();
        }
        return null;
    }

    protected ITeamRepository getRepository() {
        try {
            AbstractEnterpriseExtensionsNode node = this.getEENode();
            IProjectAreaHandle paHandle = node.getProjectAreaHandle();
            return (ITeamRepository)paHandle.getOrigin();
        }
        catch (Exception e) {
            Activator.log(Messages.ReferencesAction_0, e);
            return null;
        }
    }
}

