/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.internal.search;

import com.ibm.team.enterprise.ref.integrity.internal.FileTreeContentProvider;
import com.ibm.team.enterprise.ref.integrity.internal.FileTreeLabelProvider;
import com.ibm.team.enterprise.ref.integrity.internal.Images;
import com.ibm.team.enterprise.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceSearchQuery;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceSearchResults;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceReTargetDialog;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceTreeNode;
import com.ibm.team.enterprise.ref.integrity.internal.search.SystemDefinitionTreeNode;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;

public class ReferenceSearchResultsPage
implements ISearchResultPage,
ISearchResultListener {
    protected IPageSite fSite;
    protected Composite fPageContainer;
    protected TreeViewer fTreeViewer;
    public ISearchResultViewPart fViewPart;
    protected String fId;
    protected Link fStatusLink;
    protected Control fControl;
    private Action fExpandAction;
    private Action fCollapseAction;
    private Action fExpandSelectedAction;
    private IActionBars fActionBars;
    protected IReferenceSearchResults fSearchResult;

    public void setID(String id) {
        this.fId = id;
    }

    public String getID() {
        return this.fId;
    }

    public String getLabel() {
        return "";
    }

    public Object getUIState() {
        return this.fTreeViewer.getSelection();
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setInput(ISearchResult search, Object uiState) {
        if (this.fSearchResult != null) {
            this.fSearchResult.removeListener(this);
        }
        if (search != null) {
            this.fSearchResult = (IReferenceSearchResults)search;
            this.fSearchResult.addListener(this);
            this.fTreeViewer.setInput(this.fSearchResult.getResults());
            this.updateStatusLink();
        } else {
            this.fStatusLink.setText("");
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.fViewPart = part;
    }

    public IPageSite getSite() {
        return this.fSite;
    }

    public void init(IPageSite site) throws PartInitException {
        this.fSite = site;
    }

    public void createControl(Composite parent) {
        this.fPageContainer = new Composite(parent, 0);
        this.fPageContainer.setLayoutData((Object)new GridData(1808));
        this.fPageContainer.setLayout((Layout)new GridLayout());
        this.makeActions();
        this.createStatusBar(this.fPageContainer);
        this.createTreeViewer(this.fPageContainer);
        this.fillContextualMenu();
        this.fControl = this.fPageContainer;
    }

    private void createTreeViewer(Composite parent) {
        Composite treeContainer = new Composite(parent, 0);
        treeContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        treeContainer.setLayout((Layout)new GridLayout());
        this.fTreeViewer = new TreeViewer(treeContainer);
        this.fTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.fTreeViewer.setContentProvider((IContentProvider)new FileTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new FileTreeLabelProvider());
        this.fTreeViewer.setInput(null);
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                TreeSelection treeSelection;
                ReferenceTreeNode node;
                if (arg0.getSelection() != null && arg0.getSelection() instanceof TreeSelection && (node = (ReferenceTreeNode)(treeSelection = (TreeSelection)arg0.getSelection()).getFirstElement()) != null && node.supportsAction("open")) {
                    IProjectArea projectArea = null;
                    if (node instanceof SystemDefinitionTreeNode) {
                        ITeamRepository repository = (ITeamRepository)((IReferenceSearchQuery)ReferenceSearchResultsPage.this.fSearchResult.getQuery()).getSearchParameters().get("repository");
                        try {
                            projectArea = (IProjectArea)repository.itemManager().fetchCompleteItem((IItemHandle)((ISystemDefinition)node.getValue()).getProjectArea(), 0, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (TeamRepositoryException e) {
                            e.printStackTrace();
                        }
                    }
                    node.handleDoubleClick((IWorkbenchSite)ReferenceSearchResultsPage.this.getSite(), projectArea);
                }
            }
        });
        this.fTreeViewer.addDragSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(ReferenceSearchResultsPage.this.fTreeViewer.getSelection());
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                }
            }
        });
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setActionBars(IActionBars actionBars) {
        this.fActionBars = actionBars;
        this.fillViewToolbar();
    }

    public void setFocus() {
    }

    public void searchResultChanged(SearchResultEvent e) {
        final ISearchResult searchResult = e.getSearchResult();
        if (searchResult instanceof IReferenceSearchResults) {
            FoundationUIJob uiJob = new FoundationUIJob(""){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    ReferenceSearchResultsPage.this.fTreeViewer.setInput(((IReferenceSearchResults)searchResult).getResults());
                    ReferenceSearchResultsPage.this.fTreeViewer.getTree().getParent().layout();
                    ReferenceSearchResultsPage.this.updateStatusLink();
                    return Status.OK_STATUS;
                }
            };
            uiJob.setSystem(true);
            uiJob.schedule();
        }
    }

    private void createStatusBar(Composite parent) {
        final Composite linkContainer = new Composite(parent, 0);
        linkContainer.setLayout((Layout)new GridLayout(1, false));
        ((GridLayout)linkContainer.getLayout()).marginWidth = 3;
        ((GridLayout)linkContainer.getLayout()).marginHeight = 3;
        ((GridLayout)linkContainer.getLayout()).marginBottom = 1;
        linkContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        linkContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(linkContainer.getDisplay().getSystemColor(15));
                Rectangle clArea = linkContainer.getClientArea();
                gc.drawLine(clArea.x, clArea.y + clArea.height - 1, clArea.x + clArea.width, clArea.y + clArea.height - 1);
            }
        });
        this.fStatusLink = new Link(linkContainer, 0);
        this.fStatusLink.setText(Messages.results_message_searching_for_references);
        this.fStatusLink.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    private void updateStatusLink() {
        String label = this.fSearchResult.getLabel();
        this.fStatusLink.setText(label);
    }

    private void makeActions() {
        this.fExpandAction = new Action(){

            public void run() {
                ReferenceSearchResultsPage.this.fTreeViewer.expandAll();
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.getExpandAllImageDescriptor();
            }

            public String getToolTipText() {
                return Messages.expand_all_action_label;
            }
        };
        this.fCollapseAction = new Action(){

            public void run() {
                ReferenceSearchResultsPage.this.fTreeViewer.collapseAll();
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.getCollapseAllImageDescriptor();
            }

            public String getToolTipText() {
                return Messages.collapse_all_action_label;
            }
        };
        this.fExpandSelectedAction = new Action(){

            public void run() {
                ISelection selection = ReferenceSearchResultsPage.this.fTreeViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object o : (IStructuredSelection)selection) {
                        if (!(o instanceof TreeNode)) continue;
                        ReferenceSearchResultsPage.this.fTreeViewer.expandToLevel(o, -1);
                    }
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.getExpandSelectedImageDescriptor();
            }

            public String getToolTipText() {
                return Messages.expand_selected_action_label;
            }
        };
    }

    private void fillViewToolbar() {
        IToolBarManager toolBarManager = this.fActionBars.getToolBarManager();
        toolBarManager.appendToGroup("group.show", (IAction)this.fExpandSelectedAction);
        toolBarManager.appendToGroup("group.show", (IAction)this.fExpandAction);
        toolBarManager.appendToGroup("group.show", (IAction)this.fCollapseAction);
        this.fActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action(){

            public void run() {
                ReferenceSearchResultsPage.this.fTreeViewer.getTree().selectAll();
            }
        });
    }

    private void fillContextualMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action openAction = new Action(Messages.open_action_label){

                    public void run() {
                        ReferenceSearchResultsPage.this.onOpen();
                    }

                    public boolean isEnabled() {
                        if (((IStructuredSelection)(this).ReferenceSearchResultsPage.this.fTreeViewer.getSelection()).size() == 1) {
                            IStructuredSelection selection = (IStructuredSelection)(this).ReferenceSearchResultsPage.this.fTreeViewer.getSelection();
                            return ((ReferenceTreeNode)selection.getFirstElement()).supportsAction("open");
                        }
                        return false;
                    }
                };
                Action openPropertiesAction = new Action(Messages.open_properties_action_label){

                    public void run() {
                        ReferenceTreeNode node;
                        IStructuredSelection selection = (IStructuredSelection)(this).ReferenceSearchResultsPage.this.fTreeViewer.getSelection();
                        Object o = selection.getFirstElement();
                        if (o instanceof ReferenceTreeNode && (node = (ReferenceTreeNode)o).supportsAction("edit_properties")) {
                            node.performAction("edit_properties", (IWorkbenchSite)ReferenceSearchResultsPage.this.getSite());
                        }
                    }

                    public boolean isEnabled() {
                        if (((IStructuredSelection)(this).ReferenceSearchResultsPage.this.fTreeViewer.getSelection()).size() == 1) {
                            IStructuredSelection selection = (IStructuredSelection)(this).ReferenceSearchResultsPage.this.fTreeViewer.getSelection();
                            return ((ReferenceTreeNode)selection.getFirstElement()).supportsAction("edit_properties");
                        }
                        return false;
                    }
                };
                Action reReferenceAction = new Action(Messages.rereference_action_label){

                    public void run() {
                        ReferenceReTargetDialog dialog = new ReferenceReTargetDialog(ReferenceSearchResultsPage.this.getSite().getShell(), (IReferenceSearchQuery)(this).ReferenceSearchResultsPage.this.fSearchResult.getQuery());
                        ReferenceTreeNode node = (ReferenceTreeNode)((IStructuredSelection)(this).ReferenceSearchResultsPage.this.fTreeViewer.getSelection()).getFirstElement();
                        dialog.setCurrentTarget(node);
                        ArrayList<ReferenceTreeNode> references = new ArrayList<ReferenceTreeNode>();
                        this.getCurrentReferences(node, references);
                        dialog.setCurrentReferences(references);
                        ITeamRepository repository = (ITeamRepository)((IReferenceSearchQuery)(this).ReferenceSearchResultsPage.this.fSearchResult.getQuery()).getSearchParameters().get("repository");
                        dialog.setRepository(repository);
                        dialog.open();
                    }

                    private void getCurrentReferences(ReferenceTreeNode node, ArrayList<ReferenceTreeNode> references) {
                        TreeNode[] children = node.getChildren();
                        if (children != null) {
                            int i = 0;
                            while (i < children.length) {
                                ReferenceTreeNode child = (ReferenceTreeNode)children[i];
                                if (child.hasChildren()) {
                                    this.getCurrentReferences(child, references);
                                } else {
                                    references.add(child);
                                }
                                ++i;
                            }
                        }
                    }

                    public boolean isEnabled() {
                        if (((IStructuredSelection)(this).ReferenceSearchResultsPage.this.fTreeViewer.getSelection()).size() != 1) {
                            return false;
                        }
                        TreeNode node = (TreeNode)((IStructuredSelection)(this).ReferenceSearchResultsPage.this.fTreeViewer.getSelection()).getFirstElement();
                        return node.getParent() == null && node.hasChildren();
                    }
                };
                manager.add((IAction)openAction);
                manager.add((IAction)openPropertiesAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)reReferenceAction);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(menu);
    }

    private void onOpen() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (!selection.isEmpty()) {
            for (Object o : selection) {
                ReferenceTreeNode node;
                if (!(o instanceof ReferenceTreeNode) || !(node = (ReferenceTreeNode)o).supportsAction("open")) continue;
                node.performAction("open", (IWorkbenchSite)this.getSite());
            }
        }
    }
}

