/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.internal.search;

import com.ibm.team.enterprise.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceSearchQuery;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceSearchResults;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;

public abstract class ReferenceSearchResults
implements IReferenceSearchResults {
    protected final List<ISearchResultListener> fListeners = new ArrayList<ISearchResultListener>();
    protected List<TreeNode> fResults = new ArrayList<TreeNode>();
    protected String fLabel;
    protected boolean fSearchFinished;
    protected ISearchQuery fQuery;

    public ReferenceSearchResults(ISearchQuery query) {
        this.fQuery = query;
    }

    @Override
    public void fireSearchResultsChanged(SearchResultEvent event) {
        for (ISearchResultListener listener : this.fListeners) {
            listener.searchResultChanged(event);
        }
    }

    @Override
    public List<TreeNode> getResults() {
        return this.fResults;
    }

    @Override
    public void setResults(List<TreeNode> results) {
        this.fSearchFinished = true;
        this.fResults = results;
        IReferenceSearchQuery query = (IReferenceSearchQuery)this.fQuery;
        this.fLabel = (String)query.getSearchParameters().get("search_label");
        if (this.fLabel == null || this.fLabel.equals("")) {
            this.fLabel = Messages.message_unspecified_label;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            if (!this.fListeners.contains(l)) {
                this.fListeners.add(l);
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getLabel() {
        String resultsStr = "";
        IReferenceSearchQuery query = (IReferenceSearchQuery)this.fQuery;
        String targetLabel = (String)query.getSearchParameters().get("search_label");
        resultsStr = !this.fSearchFinished ? Messages.results_message_search_not_complete : (!query.isReferenceFound() ? NLS.bind((String)this.getNoReferencesFoundLabel(), (Object)targetLabel) : NLS.bind((String)this.getReferencesFoundLabel(), (Object)targetLabel));
        return resultsStr;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public String getTooltip() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(l);
        }
    }
}

