/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.internal.search;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.ref.integrity.internal.Activator;
import com.ibm.team.enterprise.ref.integrity.internal.Utils;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceResolver;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceResolver2;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceSearchQuery;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceSearchResults;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceTreeNode;
import com.ibm.team.enterprise.ref.integrity.internal.search.ResolversRegistry;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.search.ui.SearchResultEvent;

public abstract class ReferenceSearchQuery
implements IReferenceSearchQuery {
    protected HashMap<String, Object> fParameters = new HashMap();
    protected ResolversRegistry registry = ResolversRegistry.singleton;
    protected boolean referenceFound = false;
    protected IReferenceSearchResults fSearchResult = null;

    @Override
    public HashMap<String, Object> getSearchParameters() {
        return this.fParameters;
    }

    @Override
    public boolean isReferenceFound() {
        return this.referenceFound;
    }

    @Override
    public void setSearchParameters(HashMap<String, Object> parameters) {
        this.fParameters = parameters;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public List<ISystemDefinition> getAllSystemDefinitionsInRepository(ITeamRepository targetRepo) throws TeamRepositoryException {
        ArrayList<ISystemDefinition> systemDefinitions = new ArrayList<ISystemDefinition>();
        List<IProjectArea> projectAreas = Utils.getProjectAreas(targetRepo);
        for (IProjectArea iProjectArea : projectAreas) {
            if (iProjectArea == null) continue;
            systemDefinitions.addAll(this.getTypedSystemDefinitions(iProjectArea, targetRepo));
        }
        return systemDefinitions;
    }

    public abstract List<ISystemDefinition> getTypedSystemDefinitions(IProjectArea var1, ITeamRepository var2);

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            monitor.beginTask(this.getLabel(), -1);
            ArrayList<TreeNode> result = new ArrayList<TreeNode>();
            ArrayList<ISystemDefinition> searchTargets = new ArrayList<ISystemDefinition>();
            String limitTo = (String)this.fParameters.get("limit_to");
            Object genericTarget = this.fParameters.get("target");
            IBuildDefinition buildDefinitionOrNull = (IBuildDefinition)this.fParameters.get("OptionalBuildDefinition");
            ITeamRepository targetRepo = (ITeamRepository)this.fParameters.get("repository");
            if (this.typeCheck(genericTarget)) {
                searchTargets.add((ISystemDefinition)genericTarget);
            } else if (genericTarget instanceof String) {
                searchTargets.addAll(Utils.getPatternMatchedSystemDefinitons(this.getAllSystemDefinitionsInRepository(targetRepo), (String)genericTarget, limitTo));
            }
            this.buildNodeList(result, searchTargets);
            List<IConfigurationElement> resolvers = this.getResolvers();
            for (IConfigurationElement configurationElement : resolvers) {
                IReferenceResolver resolver = this.registry.getResolver(configurationElement);
                List<ReferenceTreeNode> references = resolver instanceof IReferenceResolver2 ? ((IReferenceResolver2)resolver).extendedReferencesTo(searchTargets, targetRepo, buildDefinitionOrNull) : resolver.referencesTo(searchTargets, targetRepo);
                for (TreeNode treeNode : references) {
                    if (result.contains(treeNode)) {
                        TreeNode[] newChildren;
                        TreeNode parent = (TreeNode)result.get(result.indexOf(treeNode));
                        TreeNode[] childrenToAdd = treeNode.getChildren();
                        TreeNode[] existingChildren = parent.getChildren();
                        if (parent.hasChildren()) {
                            newChildren = new TreeNode[existingChildren.length + childrenToAdd.length];
                            System.arraycopy(existingChildren, 0, newChildren, 0, existingChildren.length);
                            System.arraycopy(childrenToAdd, 0, newChildren, existingChildren.length, childrenToAdd.length);
                            parent.setChildren(newChildren);
                            this.referenceFound = true;
                            continue;
                        }
                        newChildren = new TreeNode[childrenToAdd.length];
                        System.arraycopy(childrenToAdd, 0, newChildren, 0, childrenToAdd.length);
                        parent.setChildren(newChildren);
                        this.referenceFound = true;
                        continue;
                    }
                    result.add(treeNode);
                }
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                this.fSearchResult.setResults(result);
                SearchResultEvent event = new SearchResultEvent(this.fSearchResult){};
                this.fSearchResult.fireSearchResultsChanged(event);
            }
            catch (Exception e) {
                if (e.getCause() instanceof AssertionFailedException) {
                    Activator.log((IStatus)new Status(4, "com.ibm.team.enterprise.ref.integrity", e.getMessage(), (Throwable)e));
                    this.fSearchResult.setResults(new ArrayList<TreeNode>());
                    SearchResultEvent event = new SearchResultEvent(this.fSearchResult){};
                    this.fSearchResult.fireSearchResultsChanged(event);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                Status status = new Status(4, "com.ibm.team.enterprise.ref.integrity", e.getMessage(), (Throwable)e);
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected abstract boolean typeCheck(Object var1);

    protected void buildNodeList(List<TreeNode> result, List<ISystemDefinition> searchTargets) {
        for (ISystemDefinition systemDefinition : searchTargets) {
            TreeNode node = this.generateTreeNode(systemDefinition);
            result.add(node);
        }
    }

    protected abstract TreeNode generateTreeNode(ISystemDefinition var1);
}

