/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.internal.search;

import com.ibm.team.enterprise.ref.integrity.internal.Activator;
import com.ibm.team.enterprise.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ref.integrity.internal.search.HistoryItem;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceSearchQuery;
import com.ibm.team.enterprise.ref.integrity.internal.search.IRetargetDialogWrapper;
import com.ibm.team.enterprise.ref.integrity.internal.search.SystemDefinitionsRegistry;
import com.ibm.team.enterprise.ref.integrity.internal.search.SystemsRegistry;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.UUID;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ReferenceSearchPage
extends DialogPage
implements ISearchPage,
IListener {
    private ToolItem fSelectRepositoryItem;
    private Combo fSearchTargetSelector;
    private Button fLimitToArchived;
    private Button fLimitToActive;
    private Button fLimitToAll;
    private ITeamRepository fSelectedRepository;
    private Combo fSystemSelector;
    private Combo fSystemDefinitionSelector;
    private ITeamRepositoryService fTeamRepoService = TeamPlatform.getTeamRepositoryService();
    private ISearchPageContainer fSearchPageContainer;
    private StandardLabelProvider fStandardLabelProvider;
    private LocalResourceManager fResources;
    private Label fInfoLabel1;
    private Label fInfoLabel2;
    private final HashMap<String, String> systems = new HashMap();
    private final List<IConfigurationElement> systemDefintionContributions = new ArrayList<IConfigurationElement>();
    private XMLMemento fMemento;
    private static final List<HistoryItem> HISTORY = new ArrayList<HistoryItem>();
    private static final int MAX_HISTORY = 15;
    private static final String MEMENTO_DIALOG_SETTINGS = "memento";
    public static final String ID = "com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceSearchPage";
    private final SystemsRegistry systemRegistry = SystemsRegistry.singleton;
    private final SystemDefinitionsRegistry systemDefinitionRegistry = SystemDefinitionsRegistry.singleton;
    private String selectedSystem = "";

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.search_page");
        if (this.fMemento != null && HISTORY.isEmpty()) {
            HISTORY.addAll(HistoryItem.loadFrom((IMemento)this.fMemento));
        }
        this.fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        Composite pageContainer = new Composite(parent, 0);
        pageContainer.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        pageContainer.setLayout((Layout)new GridLayout());
        this.createSearchStringEntry(pageContainer);
        Composite optionsGroupContainer = new Composite(pageContainer, 0);
        optionsGroupContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        optionsGroupContainer.setLayout((Layout)new GridLayout());
        ((GridLayout)optionsGroupContainer.getLayout()).marginTop = 10;
        ((GridLayout)optionsGroupContainer.getLayout()).marginHeight = 0;
        ((GridLayout)optionsGroupContainer.getLayout()).marginWidth = 0;
        Group optionsGroup = new Group(optionsGroupContainer, 0);
        optionsGroup.setText(Messages.repository_selection_group_label);
        optionsGroup.setLayout((Layout)new GridLayout(4, false));
        optionsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        Label repositorySelectionLabel = new Label((Composite)optionsGroup, 0);
        repositorySelectionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        repositorySelectionLabel.setText(Messages.repository_selection_label);
        this.createRepositorySelector((Composite)optionsGroup);
        this.createLimitToSelector(optionsGroup);
        Composite systemAndDefintionSelectionContainer = new Composite(pageContainer, 0);
        systemAndDefintionSelectionContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        systemAndDefintionSelectionContainer.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)systemAndDefintionSelectionContainer.getLayout()).marginTop = 10;
        ((GridLayout)systemAndDefintionSelectionContainer.getLayout()).marginHeight = 0;
        ((GridLayout)systemAndDefintionSelectionContainer.getLayout()).marginWidth = 0;
        Group searchForGroup = new Group(systemAndDefintionSelectionContainer, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)searchForGroup, "com.ibm.team.build.ui.type");
        searchForGroup.setText(Messages.search_for_group_label);
        searchForGroup.setLayout((Layout)new GridLayout(4, false));
        searchForGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createSystemSelector(searchForGroup);
        this.createSystemDefinitionSelector(searchForGroup);
        this.setDefaults();
        this.updateOKStatus();
        this.setControl((Control)pageContainer);
        Dialog.applyDialogFont((Control)pageContainer);
    }

    private void createSearchStringEntry(Composite pageContainer) {
        this.fInfoLabel1 = new Label(pageContainer, 0);
        this.fInfoLabel1.setText(Messages.search_selection_label_text);
        this.fInfoLabel1.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createSearchTargetSelector(pageContainer);
        this.fInfoLabel2 = new Label(pageContainer, 0);
        this.fInfoLabel2.setText(Messages.ReferenceSearchPage_1);
        this.fInfoLabel2.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    private void createSystemSelector(Group searchForGroup) {
        Label systemSelectionLabel = new Label((Composite)searchForGroup, 0);
        systemSelectionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        systemSelectionLabel.setText(Messages.ReferenceSearchPage_2);
        this.fSystemSelector = new Combo((Composite)searchForGroup, 2056);
        this.fSystemSelector.setLayoutData((Object)new GridData(4, 1, false, false));
        List<IConfigurationElement> contributions = this.systemRegistry.getContributions();
        for (IConfigurationElement configurationElement : contributions) {
            String id = configurationElement.getAttribute("id");
            String label = configurationElement.getAttribute("label");
            this.fSystemSelector.add(label);
            this.systems.put(label, id);
        }
        this.fSystemSelector.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!ReferenceSearchPage.this.fSystemSelector.getText().equals(ReferenceSearchPage.this.selectedSystem)) {
                    ReferenceSearchPage.this.populateSystemDefinitionSelector();
                    ReferenceSearchPage.this.selectedSystem = ReferenceSearchPage.this.fSystemSelector.getText();
                    if (ReferenceSearchPage.this.fSystemDefinitionSelector.getItemCount() > 0) {
                        ReferenceSearchPage.this.fSystemDefinitionSelector.setText(ReferenceSearchPage.this.fSystemDefinitionSelector.getItem(0));
                    }
                }
            }
        });
    }

    private void createSystemDefinitionSelector(Group searchForGroup) {
        Label systemDefinitionSelectionLabel = new Label((Composite)searchForGroup, 0);
        systemDefinitionSelectionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        systemDefinitionSelectionLabel.setText(Messages.ReferenceSearchPage_5);
        this.fSystemDefinitionSelector = new Combo((Composite)searchForGroup, 2056);
        this.fSystemDefinitionSelector.setLayoutData((Object)new GridData(4, 1, false, false));
    }

    private void createLimitToSelector(Group optionsGroup) {
        Label limitToLabel = new Label((Composite)optionsGroup, 0);
        limitToLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        limitToLabel.setText(Messages.limit_to);
        this.fLimitToArchived = new Button((Composite)optionsGroup, 16);
        this.fLimitToArchived.setText(Messages.archived_label);
        this.fLimitToArchived.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fLimitToActive = new Button((Composite)optionsGroup, 16);
        this.fLimitToActive.setText(Messages.active_label);
        this.fLimitToActive.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fLimitToAll = new Button((Composite)optionsGroup, 16);
        this.fLimitToAll.setText(Messages.all_label);
        this.fLimitToAll.setLayoutData((Object)new GridData(4, 1, false, false));
    }

    private void createSearchTargetSelector(Composite pageContainer) {
        this.fSearchTargetSelector = new Combo(pageContainer, 2048);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fSearchTargetSelector, "com.ibm.team.build.ui.target");
        this.fSearchTargetSelector.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSearchTargetSelector.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ReferenceSearchPage.this.updateOKStatus();
            }
        });
        ComboViewer comboViewer = new ComboViewer(this.fSearchTargetSelector);
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                HistoryItem item = (HistoryItem)element;
                return item.getQuery();
            }
        });
        this.fSearchTargetSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReferenceSearchPage.this.updateOKStatus();
            }
        });
        int i = HISTORY.size() - 1;
        int j = 0;
        while (i >= 0 && j < 15) {
            comboViewer.add((Object)HISTORY.get(i));
            --i;
            ++j;
        }
        ISelection sel = this.fSearchPageContainer.getSelection();
        if (sel instanceof ITextSelection && ((ITextSelection)sel).getLength() > 0) {
            this.fSearchTargetSelector.setText(this.getText((ITextSelection)sel));
        } else if (!HISTORY.isEmpty()) {
            this.fSearchTargetSelector.select(0);
        }
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    HistoryItem historyItem = (HistoryItem)selection.getFirstElement();
                    ReferenceSearchPage.this.setDefaultLimitTo(historyItem.getLimitTo());
                }
            }
        });
    }

    private String getText(ITextSelection sel) {
        String text = sel.getText();
        if (text == null) {
            return "";
        }
        BufferedReader reader = new BufferedReader(new StringReader(text));
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            return "";
        }
    }

    private void setDefaults() {
        String rep_uuid = Activator.getDefault().getPreferenceStore().getString("ref_integ_repository_uuid");
        if (!rep_uuid.equals("")) {
            this.fSelectedRepository = this.getRepository(rep_uuid);
            this.updateRepositorySelector();
            this.promptForRepositorySelection();
        }
        this.setDefaultLimitTo(Activator.getDefault().getPreferenceStore().getString("limit_to"));
        String system = Activator.getDefault().getPreferenceStore().getString("system");
        this.setDefaultSystem(system);
        this.setDefaultSystemDefinition(Activator.getDefault().getPreferenceStore().getString("system_definition"));
    }

    private void setDefaultSystem(String system) {
        if (system == null) {
            system = "";
        }
        boolean found = false;
        if (!system.equals("")) {
            String[] systems = this.fSystemSelector.getItems();
            int i = 0;
            while (i < systems.length && !found) {
                String string = systems[i];
                if (string.equals(system)) {
                    this.fSystemSelector.setText(system);
                    found = true;
                }
                ++i;
            }
        }
        if (!found && this.fSystemSelector.getItemCount() > 0) {
            this.fSystemSelector.setText(this.fSystemSelector.getItem(0));
        }
        this.selectedSystem = this.fSystemSelector.getText();
    }

    private void setDefaultSystemDefinition(String systemDefinition) {
        if (systemDefinition == null) {
            systemDefinition = "";
        }
        boolean found = false;
        if (!this.fSystemSelector.getText().equals("")) {
            this.populateSystemDefinitionSelector();
        }
        if (this.fSystemDefinitionSelector.getItemCount() > 0 && !systemDefinition.equals("")) {
            String[] systems = this.fSystemDefinitionSelector.getItems();
            int i = 0;
            while (i < systems.length && !found) {
                String string = systems[i];
                if (string.equals(systemDefinition)) {
                    this.fSystemDefinitionSelector.setText(systemDefinition);
                    found = true;
                }
                ++i;
            }
        }
        if (!found && this.fSystemDefinitionSelector.getItemCount() > 0) {
            this.fSystemDefinitionSelector.setText(this.fSystemDefinitionSelector.getItem(0));
        }
    }

    private void populateSystemDefinitionSelector() {
        String system = this.fSystemSelector.getText();
        if (system != null && !system.equals("")) {
            List<IConfigurationElement> contributions = this.systemDefinitionRegistry.getContributionsForSystem(this.systems.get(system));
            int index = 0;
            this.systemDefintionContributions.clear();
            this.fSystemDefinitionSelector.removeAll();
            if (contributions != null && contributions.size() > 0) {
                for (IConfigurationElement element : contributions) {
                    this.systemDefintionContributions.add(index, element);
                    this.fSystemDefinitionSelector.add(element.getAttribute("label"), index);
                }
            }
        }
    }

    public boolean performAction() {
        IReferenceSearchQuery query;
        int index = this.fSystemDefinitionSelector.getSelectionIndex();
        IConfigurationElement contribution = this.systemDefintionContributions.get(index);
        try {
            query = this.systemDefinitionRegistry.getQuery(contribution);
        }
        catch (InvocationTargetException e) {
            Activator.log(Messages.ReferenceSearchPage_13, e);
            e.printStackTrace();
            return false;
        }
        try {
            this.populateSearchParameters(query, contribution);
        }
        catch (InvocationTargetException e) {
            Activator.log(Messages.ReferenceSearchPage_14, e);
            e.printStackTrace();
            return false;
        }
        String searchFor = this.fSearchTargetSelector.getText();
        String limitTo = this.getLimitTo();
        String system = this.fSystemSelector.getText();
        String systemDefinition = this.fSystemDefinitionSelector.getText();
        HistoryItem historyItem = new HistoryItem(searchFor, limitTo, system, systemDefinition);
        if (HISTORY.contains(historyItem)) {
            HISTORY.remove(historyItem);
        }
        HISTORY.add(historyItem);
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return true;
    }

    private void populateSearchParameters(IReferenceSearchQuery searchInstance, IConfigurationElement contribution) throws InvocationTargetException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("repository", this.fSelectedRepository);
        parameters.put("limit_to", this.getLimitTo());
        parameters.put("target", this.fSearchTargetSelector.getText());
        parameters.put("search_label", this.fSearchTargetSelector.getText());
        IRetargetDialogWrapper retarget = this.systemDefinitionRegistry.getReReferenceDIalogWrapper(contribution);
        parameters.put("wrapper", retarget);
        searchInstance.setSearchParameters(parameters);
    }

    private void createRepositorySelector(Composite parent) {
        final ToolBar toolBar = new ToolBar(parent, 0x820000);
        toolBar.setLayoutData((Object)new GridData(4, 1, false, false, 3, 1));
        this.fSelectRepositoryItem = new ToolItem(toolBar, 4);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)toolBar, "com.ibm.team.build.ui.repository");
        this.updateRepositorySelector();
        final Menu menu = new Menu((Control)toolBar);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menu.dispose();
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                ITeamRepository[] teamRepositories;
                MenuItem[] items;
                MenuItem[] menuItemArray = items = menu.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                ITeamRepository[] iTeamRepositoryArray = teamRepositories = ReferenceSearchPage.this.fTeamRepoService.getTeamRepositories();
                int n3 = teamRepositories.length;
                n = 0;
                while (n < n3) {
                    final ITeamRepository repository = iTeamRepositoryArray[n];
                    MenuItem item = new MenuItem(menu, 16);
                    item.setText(ReferenceSearchPage.this.fStandardLabelProvider.getText((Object)repository));
                    item.setImage(ReferenceSearchPage.this.fStandardLabelProvider.getImage((Object)repository));
                    item.setEnabled(repository.loggedIn());
                    if (ReferenceSearchPage.this.fSelectedRepository != null) {
                        item.setSelection(ReferenceSearchPage.this.fSelectedRepository.equals(repository));
                    } else {
                        item.setSelection(false);
                    }
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (repository != ReferenceSearchPage.this.fSelectedRepository) {
                                if (ReferenceSearchPage.this.fSelectedRepository != null) {
                                    ReferenceSearchPage.this.fSelectedRepository.removeGenericListener((Object)"state", (IListener)ReferenceSearchPage.this);
                                }
                                ReferenceSearchPage.this.fSelectedRepository = repository;
                                ReferenceSearchPage.this.fSelectedRepository.addGenericListener((Object)"state", (IListener)ReferenceSearchPage.this);
                                if (ReferenceSearchPage.this.fSelectedRepository.loggedIn()) {
                                    ReferenceSearchPage.this.handleLogin();
                                } else {
                                    ReferenceSearchPage.this.handleLogout();
                                }
                            }
                        }
                    });
                    ++n;
                }
            }
        });
        this.fSelectRepositoryItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = ReferenceSearchPage.this.fSelectRepositoryItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        this.promptForRepositorySelection();
    }

    private void promptForRepositorySelection() {
        if (this.fSelectedRepository == null || !this.fSelectedRepository.loggedIn()) {
            this.showError(Messages.message_select_logged_in_repository);
        } else {
            this.fSelectedRepository.addGenericListener((Object)"state", (IListener)this);
            this.showError(null);
        }
    }

    private void updateRepositorySelector() {
        if (this.fSelectedRepository != null) {
            this.fSelectRepositoryItem.setImage(this.fStandardLabelProvider.getImage((Object)this.fSelectedRepository));
            this.fSelectRepositoryItem.setText(this.fStandardLabelProvider.getText((Object)this.fSelectedRepository));
        } else {
            this.fSelectRepositoryItem.setImage(this.fResources.createImage(Activator.getDefault().createDescriptor("icons/obj16/repo_loggedout.gif")));
            this.fSelectRepositoryItem.setText(Messages.message_select_repository);
        }
    }

    public void setContainer(ISearchPageContainer container) {
        String settings;
        this.fSearchPageContainer = container;
        this.fTeamRepoService = TeamPlatform.getTeamRepositoryService();
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        IDialogSettings section = Activator.getDefault().getDialogSettings().getSection(ID);
        if (section != null && (settings = section.get(MEMENTO_DIALOG_SETTINGS)) != null) {
            try {
                this.fMemento = XMLMemento.createReadRoot((Reader)new StringReader(settings));
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
    }

    private ITeamRepository getRepository(String oldUuid) {
        ITeamRepository[] teamRepositories;
        ITeamRepository[] iTeamRepositoryArray = teamRepositories = this.fTeamRepoService.getTeamRepositories();
        int n = teamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            if ((oldUuid == null || oldUuid.equals("")) && teamRepository.loggedIn()) {
                return teamRepository;
            }
            UUID teamRepoId = teamRepository.getId();
            if (oldUuid != null && teamRepoId != null && oldUuid.equals(teamRepoId.getUuidValue())) {
                return teamRepository;
            }
            ++n2;
        }
        if (teamRepositories.length > 0) {
            return teamRepositories[0];
        }
        return null;
    }

    public void handleEvents(List events) {
        for (Object event : events) {
            IEventSource source;
            PropertyChangeEvent extended;
            Object property;
            if (!(event instanceof PropertyChangeEvent) || !"state".equals(property = (extended = (PropertyChangeEvent)event).getProperty()) || !((source = extended.getEventSource()) instanceof ITeamRepository)) continue;
            ITeamRepository repository = (ITeamRepository)source;
            int state = repository.getState();
            switch (state) {
                case 1: {
                    this.handleLogin();
                    break;
                }
                case 3: {
                    this.handleLogout();
                }
            }
        }
    }

    private void showError(String error) {
        if (this.fInfoLabel1 == null) {
            return;
        }
        if (error != null) {
            this.fInfoLabel1.setText(error);
            this.fInfoLabel1.setForeground(this.fInfoLabel1.getDisplay().getSystemColor(3));
        } else {
            this.fInfoLabel1.setText(Messages.search_selection_label_text);
            this.fInfoLabel1.setForeground(null);
        }
    }

    void handleLogin() {
        this.fSearchTargetSelector.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ReferenceSearchPage.this.fSearchTargetSelector.setEnabled(true);
                ReferenceSearchPage.this.fSearchPageContainer.setPerformActionEnabled(ReferenceSearchPage.this.fSearchTargetSelector.getText().length() > 0);
                ReferenceSearchPage.this.fSearchTargetSelector.setFocus();
                ReferenceSearchPage.this.showError(null);
                ReferenceSearchPage.this.updateRepositorySelector();
            }
        });
    }

    void handleLogout() {
        this.fSearchTargetSelector.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ReferenceSearchPage.this.fSearchTargetSelector.setEnabled(false);
                ReferenceSearchPage.this.fSearchPageContainer.setPerformActionEnabled(false);
                ReferenceSearchPage.this.showError(Messages.message_select_logged_in_repository);
                ReferenceSearchPage.this.updateRepositorySelector();
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.fSelectedRepository != null) {
            this.fSelectedRepository.removeGenericListener((Object)"state", (IListener)this);
        }
        this.fResources.dispose();
        if (this.fSelectedRepository != null) {
            Activator.getDefault().getPreferenceStore().setValue("ref_integ_repository_uuid", this.fSelectedRepository.getId().getUuidValue());
        }
        Activator.getDefault().getPreferenceStore().setValue("limit_to", this.getLimitTo());
        Activator.getDefault().getPreferenceStore().setValue("system", this.fSystemSelector.getText());
        Activator.getDefault().getPreferenceStore().setValue("system_definition", this.fSystemDefinitionSelector.getText());
    }

    private String getLimitTo() {
        String result = "archived";
        if (this.fLimitToActive.getSelection()) {
            result = "active";
        } else if (this.fLimitToAll.getSelection()) {
            result = "all";
        }
        return result;
    }

    private void setDefaultLimitTo(String limitTo) {
        if (limitTo != null && limitTo.length() > 0) {
            this.fLimitToActive.setSelection(limitTo.equals("active"));
            this.fLimitToAll.setSelection(limitTo.equals("all"));
            this.fLimitToArchived.setSelection(limitTo.equals("archived"));
        } else {
            this.fLimitToActive.setSelection(true);
        }
    }

    public void setVisible(boolean visible) {
        this.updateOKStatus();
        super.setVisible(visible);
    }

    final void updateOKStatus() {
        boolean isValid = this.fSearchTargetSelector.getText() != null && !this.fSearchTargetSelector.getText().equals("") && this.fSelectedRepository != null && this.fSystemSelector.getText() != "" && this.fSystemDefinitionSelector.getText() != Messages.ReferenceSearchPage_16;
        this.getContainer().setPerformActionEnabled(isValid);
    }

    private ISearchPageContainer getContainer() {
        return this.fSearchPageContainer;
    }
}

