/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.internal.search;

import com.ibm.team.enterprise.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceResolver;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceSearchQuery;
import com.ibm.team.enterprise.ref.integrity.internal.search.IRetargetDialogWrapper;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReTargetLogDialog;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceTreeNode;
import com.ibm.team.enterprise.ref.integrity.internal.search.ResolversRegistry;
import com.ibm.team.enterprise.ref.integrity.internal.search.SystemDefinitionTreeNode;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ReferenceReTargetDialog
extends Dialog {
    private ITeamRepository fRepository;
    private IReferenceSearchQuery query;
    private Text fNewTargetLabel;
    private Button fSelectNewTarget;
    private CheckboxTableViewer componentTableViewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private ISystemDefinition fNewTarget;
    private UUID fNewTargetUUID;
    private ReferenceTreeNode fCurrentTarget;
    private ArrayList<ReferenceTreeNode> fCurrentReferences;
    private final ResolversRegistry registry = ResolversRegistry.singleton;
    private final IReferenceSearchQuery fQuery;
    private ViewerFilter filter;

    public ReferenceReTargetDialog(Shell parentShell, IReferenceSearchQuery query) {
        super(parentShell);
        this.fQuery = query;
    }

    public ReferenceReTargetDialog(IShellProvider parentShell, IReferenceSearchQuery query) {
        super(parentShell);
        this.fQuery = query;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fCurrentTarget != null) {
            newShell.setText(String.valueOf(Messages.ReferenceReTargetDialog_0) + this.fCurrentTarget.getLabel());
        }
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        top.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        top.setLayoutData((Object)layoutData);
        this.createReferencesList(top);
        this.createNewTarget(top);
        return super.createContents(parent);
    }

    private void createReferencesList(Composite parent) {
        Label fComponentSelectionLabel = new Label(parent, 0);
        fComponentSelectionLabel.setText(Messages.ReferenceReTargetDialog_4);
        GridDataFactory.fillDefaults().span(2, 1).indent(-1, 5).applyTo((Control)fComponentSelectionLabel);
        Table componentTable = new Table(parent, 68386);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).indent(10, -1).hint(300, 115).applyTo((Control)componentTable);
        componentTable.pack();
        this.componentTableViewer = new CheckboxTableViewer(componentTable);
        ComponentSelectionTableContentProvider componentTableContentProvider = new ComponentSelectionTableContentProvider();
        ComponentSelectionTableLabelProvider componentTableLabelProvider = new ComponentSelectionTableLabelProvider();
        this.componentTableViewer.setContentProvider((IContentProvider)componentTableContentProvider);
        this.componentTableViewer.setLabelProvider((IBaseLabelProvider)componentTableLabelProvider);
        this.componentTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ReferenceReTargetDialog.this.canFinish();
            }
        });
        Composite buttonComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).applyTo(buttonComposite);
        this.selectAllButton = new Button(buttonComposite, 8);
        this.selectAllButton.setText("Select all");
        GridDataFactory.fillDefaults().applyTo((Control)this.selectAllButton);
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ReferenceReTargetDialog.this.componentTableViewer.setAllChecked(true);
                ReferenceReTargetDialog.this.canFinish();
            }
        });
        this.deselectAllButton = new Button(buttonComposite, 8);
        this.deselectAllButton.setText("Select none");
        GridDataFactory.fillDefaults().applyTo((Control)this.deselectAllButton);
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ReferenceReTargetDialog.this.componentTableViewer.setAllChecked(false);
                ReferenceReTargetDialog.this.canFinish();
            }
        });
        this.componentTableViewer.setInput(this.fCurrentReferences);
    }

    private void createNewTarget(Composite parent) {
        Label label = new Label(parent, 0);
        GridDataFactory.fillDefaults().span(2, 1).indent(-1, 5).applyTo((Control)label);
        label.setText(Messages.ReferenceReTargetDialog_5);
        this.fNewTargetLabel = new Text(parent, 2048);
        this.fNewTargetLabel.setEditable(false);
        GridData layoutData = new GridData(768);
        layoutData.horizontalIndent = 10;
        this.fNewTargetLabel.setLayoutData((Object)layoutData);
        Composite buttonComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().equalWidth(true).applyTo(buttonComposite);
        this.fSelectNewTarget = new Button(buttonComposite, 8);
        this.fSelectNewTarget.setText(Messages.ReferenceReTargetDialog_6);
        layoutData = new GridData(768);
        this.fSelectNewTarget.setLayoutData((Object)layoutData);
        this.fSelectNewTarget.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                ReferenceReTargetDialog.this.fNewTarget = ReferenceReTargetDialog.this.browseForNewTarget();
                if (ReferenceReTargetDialog.this.fNewTarget != null) {
                    if (ReferenceReTargetDialog.this.fNewTargetUUID.equals((Object)ReferenceReTargetDialog.this.getUUIDof(ReferenceReTargetDialog.this.fCurrentTarget))) {
                        Status status = new Status(4, "com.ibm.team.enterprise.ref.integrity", NLS.bind((String)Messages.ReferenceReTargetDialog_7, (Object[])new String[]{ReferenceReTargetDialog.this.fCurrentTarget.getLabel(), ReferenceReTargetDialog.this.fCurrentTarget.getLabel()}));
                        Shell shell = new Shell();
                        ErrorDialog.openError((Shell)shell, (String)Messages.ReferenceReTargetDialog_8, (String)Messages.ReferenceReTargetDialog_9, (IStatus)status);
                    } else {
                        ReferenceReTargetDialog.this.fNewTargetLabel.setText(ReferenceReTargetDialog.this.getNewTargetLabel());
                        ReferenceReTargetDialog.this.canFinish();
                    }
                }
            }
        });
    }

    private ISystemDefinition browseForNewTarget() {
        IRetargetDialogWrapper retargetWrapper = (IRetargetDialogWrapper)this.fQuery.getSearchParameters().get("wrapper");
        ISystemDefinition newTarget = null;
        try {
            newTarget = retargetWrapper.getRetargetObject(this.getShell(), this.fRepository, this.getFilter());
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        if (newTarget != null) {
            this.fNewTargetUUID = newTarget.getItemId();
        }
        return newTarget;
    }

    private ViewerFilter getFilter() {
        if (this.filter == null) {
            this.filter = new ViewerFilter(){
                private final UUID currentUUID;
                {
                    this.currentUUID = ReferenceReTargetDialog.this.getUUIDof(ReferenceReTargetDialog.this.fCurrentTarget);
                }

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    UUID uuid = null;
                    if (element instanceof ISystemDefinition) {
                        uuid = ((ISystemDefinition)element).getItemId();
                    } else if (element instanceof ISystemDefinitionHandle && ((ISystemDefinitionHandle)element).getItemId() != null) {
                        uuid = ((ISystemDefinitionHandle)element).getItemId();
                    }
                    if (uuid != null) {
                        return !uuid.equals((Object)this.currentUUID);
                    }
                    return true;
                }
            };
        }
        return this.filter;
    }

    private String getNewTargetLabel() {
        return this.fNewTarget.getName();
    }

    private boolean referenceNotArchived(ReferenceTreeNode child) {
        if (child instanceof SystemDefinitionTreeNode) {
            ISystemDefinition systemDefintion = (ISystemDefinition)child.getValue();
            return !systemDefintion.isArchived();
        }
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    public void setCurrentTarget(ReferenceTreeNode currentTarget) {
        this.fCurrentTarget = currentTarget;
    }

    public void setCurrentReferences(ArrayList<ReferenceTreeNode> currentReferences) {
        this.fCurrentReferences = currentReferences;
    }

    private void canFinish() {
        Button ok = this.getButton(0);
        ok.setEnabled(this.fNewTargetLabel.getText().length() > 0 && this.componentTableViewer.getCheckedElements().length > 0);
    }

    public void setRepository(ITeamRepository fRepository) {
        this.fRepository = fRepository;
    }

    private UUID getUUIDof(Object target) {
        ReferenceTreeNode node = (ReferenceTreeNode)target;
        ISystemDefinition systemDefintion = (ISystemDefinition)node.getValue();
        return systemDefintion.getItemId();
    }

    protected void okPressed() {
        ArrayList<String> log = new ArrayList<String>();
        List<IConfigurationElement> resolvers = this.fQuery.getResolvers();
        ArrayList<ReferenceTreeNode> referenceToProcess = this.generateListToProcess();
        for (IConfigurationElement configurationElement : resolvers) {
            try {
                IReferenceResolver resolver = this.registry.getResolver(configurationElement);
                log.add(String.valueOf(Messages.ReferenceReTargetDialog_2) + " " + resolver.getLoglabel());
                log.addAll(resolver.reReference(referenceToProcess, this.fNewTarget, (ISystemDefinition)this.fCurrentTarget.getValue(), this.fRepository));
            }
            catch (InvocationTargetException e) {
                log.add(NLS.bind((String)Messages.ReferenceReTargetDialog_11, (Object)configurationElement.getAttribute("id")));
                e.printStackTrace();
            }
        }
        super.okPressed();
        this.displayLog(log);
    }

    private ArrayList<ReferenceTreeNode> generateListToProcess() {
        ArrayList<ReferenceTreeNode> result = new ArrayList<ReferenceTreeNode>();
        Object[] selections = this.componentTableViewer.getCheckedElements();
        int i = 0;
        while (i < selections.length) {
            result.add((ReferenceTreeNode)selections[i]);
            ++i;
        }
        return result;
    }

    private void displayLog(ArrayList<String> log) {
        RetargetCompletedDialog completeDialog = new RetargetCompletedDialog(new Shell(), log.toArray(new String[log.size()]), this.fCurrentTarget);
        completeDialog.open();
    }

    public IReferenceSearchQuery getQuery() {
        return this.query;
    }

    public void setQuery(IReferenceSearchQuery query) {
        this.query = query;
    }

    protected class ComponentSelectionTableContentProvider
    implements IStructuredContentProvider {
        private List<ReferenceTreeNode> contentList = null;

        protected ComponentSelectionTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.contentList == null ? null : this.contentList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contentList = new ArrayList<ReferenceTreeNode>();
            for (ReferenceTreeNode child : ReferenceReTargetDialog.this.fCurrentReferences) {
                if (!ReferenceReTargetDialog.this.referenceNotArchived(child)) continue;
                this.contentList.add(child);
            }
        }
    }

    protected class ComponentSelectionTableLabelProvider
    implements ITableLabelProvider {
        protected ComponentSelectionTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((ReferenceTreeNode)element).getPath();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class RetargetCompletedDialog
    extends Dialog {
        public String[] log;
        private final ReferenceTreeNode fCurrentTarget;

        protected RetargetCompletedDialog(Shell parentShell, String[] log, ReferenceTreeNode fCurrentTarget) {
            super(parentShell);
            this.log = log;
            this.fCurrentTarget = fCurrentTarget;
        }

        protected RetargetCompletedDialog(IShellProvider parentShell, String[] log, ReferenceTreeNode fCurrentTarget) {
            super(parentShell);
            this.log = log;
            this.fCurrentTarget = fCurrentTarget;
        }

        protected void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle | 0x10);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            if (this.fCurrentTarget != null) {
                newShell.setText(Messages.ReTargetCompleted);
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 13) {
                this.showDetails();
                this.okPressed();
            } else {
                super.buttonPressed(buttonId);
            }
        }

        private void showDetails() {
            ReTargetLogDialog logDisplayer = new ReTargetLogDialog(new Shell());
            logDisplayer.setLog(this.log);
            logDisplayer.setfCurrentTarget(this.fCurrentTarget);
            logDisplayer.open();
        }
    }
}

