/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IMemento;

public class HistoryItem {
    private static final String PREF_HISTORY_ITEM_MEMENTO = "com.ibm.team.enterprise.ref.integrity.internal.search.PrefHistoryItemMemento";
    private static final String PREF_HISTORY_ITEM_QUERY = "com.ibm.team.enterprise.ref.integrity.internal.search.PrefHistoryItemQuery";
    private static final String PREF_HISTORY_LIMIT_TO = "com.ibm.team.enterprise.ref.integrity.internal.search.PrefHistoryLimitTo";
    private static final String PREF_HISTORY_SYSTEM = "com.ibm.team.enterprise.ref.integrity.internal.search.PrefHistorySystem";
    private static final String PREF_HISTORY_SYSTEM_DEFINITON = "com.ibm.teamz.ref.integrity.ui.internal.search.PrefHistorySystemDefinition";
    private String fQuery;
    private String fLimitTo;
    private String fSystem;
    private String fSystemDefinition;

    public static void saveTo(IMemento memento, List<HistoryItem> items) {
        for (HistoryItem item : items) {
            IMemento child = memento.createChild(PREF_HISTORY_ITEM_MEMENTO);
            child.putString(PREF_HISTORY_ITEM_QUERY, item.getQuery());
            child.putString(PREF_HISTORY_LIMIT_TO, item.getLimitTo());
            child.putString(PREF_HISTORY_SYSTEM, item.getSystem());
            child.putString(PREF_HISTORY_SYSTEM_DEFINITON, item.getSystemDefinition());
        }
    }

    public static List<HistoryItem> loadFrom(IMemento memento) {
        IMemento[] children;
        ArrayList<HistoryItem> items = new ArrayList<HistoryItem>();
        IMemento[] iMementoArray = children = memento.getChildren(PREF_HISTORY_ITEM_MEMENTO);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            String query = child.getString(PREF_HISTORY_ITEM_QUERY);
            String limitTo = child.getString(PREF_HISTORY_LIMIT_TO);
            String system = child.getString(PREF_HISTORY_SYSTEM);
            String systemDefinition = child.getString(PREF_HISTORY_SYSTEM_DEFINITON);
            items.add(new HistoryItem(query, limitTo, system, systemDefinition));
            ++n2;
        }
        return items;
    }

    public HistoryItem(String query, String limitTo, String system, String systemDefinition) {
        this.fQuery = query;
        this.fLimitTo = limitTo;
        this.fSystem = system;
        this.fSystemDefinition = systemDefinition;
    }

    public String getQuery() {
        return this.fQuery;
    }

    public String getLimitTo() {
        return this.fLimitTo;
    }

    public String getSystem() {
        return this.fSystem;
    }

    public String getSystemDefinition() {
        return this.fSystemDefinition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fQuery == null ? 0 : this.fQuery.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistoryItem other = (HistoryItem)obj;
        return !(this.fQuery == null ? other.fQuery != null : !this.fQuery.equals(other.fQuery));
    }
}

