/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ref.integrity.internal;

import com.ibm.team.enterprise.build.ui.metadata.api.IMetadata;
import com.ibm.team.enterprise.build.ui.metadata.api.RTCMetadataFactory;
import com.ibm.team.enterprise.common.client.util.ZComponentUtils;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.TreeNode;

public class Utils {
    public static List<IProject> buildProjectList(ITeamRepository targetRepo) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] projects = ZComponentUtils.getZComponentProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (Utils.isProjectSharedInReposiory(project, targetRepo)) {
                result.add(project);
            }
            ++i;
        }
        return result;
    }

    public static List<IFolder> getZFolderList(String projectName) {
        ArrayList<IFolder> containerList = new ArrayList<IFolder>();
        IFolder[] zFolders = ZComponentUtils.getZFolders((String)projectName);
        if (zFolders != null) {
            containerList.addAll(Arrays.asList(zFolders));
        }
        return containerList;
    }

    public static IProjectArea getIProjectArea(ITeamRepository repository, String targetUUID) throws TeamRepositoryException {
        IProjectArea result = null;
        List<IProjectArea> projectAreas = null;
        projectAreas = Utils.getProjectAreas(repository);
        for (IProjectArea projectArea : projectAreas) {
            if (projectArea == null || !targetUUID.equals(projectArea.getItemId().getUuidValue())) continue;
            result = projectArea;
        }
        return result;
    }

    public static List<IProjectArea> getProjectAreas(ITeamRepository repository) throws TeamRepositoryException {
        return repository.itemManager().fetchCompleteItems(repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean isProjectSharedInReposiory(IProject project, ITeamRepository targetRepo) {
        IShareable share;
        ITeamRepository repo;
        boolean result = false;
        if (targetRepo != null && Utils.isShared(project) && (repo = Utils.getTeamRepository(share = Utils.getSharable(project))) != null && repo.getId().equals((Object)targetRepo.getId())) {
            result = true;
        }
        return result;
    }

    public static IShareable getSharable(IProject project) {
        if (project == null) {
            return null;
        }
        return (IShareable)project.getAdapter(IShareable.class);
    }

    public static boolean isShared(IProject project) {
        IShareable shareable = Utils.getSharable(project);
        if (shareable == null) {
            return false;
        }
        IShare share = null;
        try {
            share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return share != null;
    }

    public static ITeamRepository getTeamRepository(IShareable shareable) {
        return com.ibm.team.enterprise.common.ui.util.Utils.getTeamRepository((IShareable)shareable);
    }

    public static void addChildTreeNode(TreeNode child, TreeNode parent) {
        TreeNode[] children = parent.getChildren();
        if (children == null) {
            parent.setChildren(new TreeNode[]{child});
        } else if (!Utils.arrayContains(children, child)) {
            TreeNode[] newChildren = new TreeNode[children.length + 1];
            System.arraycopy(children, 0, newChildren, 0, children.length);
            newChildren[newChildren.length - 1] = child;
            parent.setChildren(newChildren);
        }
        child.setParent(parent);
    }

    private static boolean arrayContains(TreeNode[] array, TreeNode target) {
        boolean result = false;
        int i = 0;
        while (i < array.length && !result) {
            TreeNode treeNode = array[i];
            if (treeNode.getValue().equals(target.getValue())) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public static String generateRegEx(String searchString) {
        int len = searchString.length();
        String result = "";
        char[] tempCharArray = new char[len];
        int i = 0;
        while (i < len) {
            tempCharArray[i] = searchString.charAt(i);
            ++i;
        }
        i = 0;
        while (i < tempCharArray.length) {
            char c = tempCharArray[i];
            result = c == '?' ? String.valueOf(result) + '.' + '?' : (c == '*' ? String.valueOf(result) + '.' + '*' : String.valueOf(result) + c);
            ++i;
        }
        return result;
    }

    public static List<ISystemDefinition> getPatternMatchedSystemDefinitons(List<ISystemDefinition> source, String pattern, String limitTo) {
        ArrayList<ISystemDefinition> results = new ArrayList<ISystemDefinition>();
        String regex = Utils.generateRegEx(pattern);
        for (ISystemDefinition systemDefinition : source) {
            if (!Utils.inScope(systemDefinition, limitTo) || !systemDefinition.getName().matches(regex)) continue;
            results.add(systemDefinition);
        }
        return results;
    }

    public static boolean inScope(ISystemDefinition systemDefinition, String limitTo) {
        return limitTo.equals("all") || systemDefinition.isArchived() && limitTo.equals("archived") || !systemDefinition.isArchived() && limitTo.equals("active");
    }

    public static IMetadata getMetadata(IResource resource) {
        return RTCMetadataFactory.getInstance().getBuildMetadata(resource);
    }

    public static String getArtifactVersionableProperty(IResource artifact, String propertyKey) {
        IMetadata metadata = Utils.getMetadata(artifact);
        return metadata == null ? "" : metadata.getProperty(propertyKey);
    }

    public static IStatus setArtifactVersionableProperty(IResource artifact, String UUID2, String propertyKey) {
        IMetadata metadata = Utils.getMetadata(artifact);
        return metadata.setProperty(propertyKey, UUID2);
    }
}

