/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.rdf.query.common.select.result;

import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SelectResultFeedParser
extends DefaultHandler {
    private final XMLReader fParser = XMLReaderFactory.createXMLReader();
    private List<SelectResult> fResults;
    private int totalResults;
    private int startIndex;
    private int itemsPerPage;
    private String nextPagingLink;

    public SelectResultFeedParser() throws Exception {
        this.fParser.setContentHandler(new SelectResultTagHandler());
        this.fParser.setDTDHandler(this);
        this.fParser.setEntityResolver(this);
        this.fParser.setErrorHandler(this);
    }

    public List<SelectResult> parse(InputStream inputStream) throws Exception {
        this.totalResults = 0;
        this.startIndex = 0;
        this.itemsPerPage = -1;
        this.nextPagingLink = null;
        this.fResults = new ArrayList<SelectResult>();
        this.fParser.parse(new InputSource(inputStream));
        return this.fResults;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public String getNextPagingLink() {
        return this.nextPagingLink;
    }

    private int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private class SelectResultTagHandler
    implements ContentHandler {
        SelectResult selectResult;
        String bindingName = "";
        StringBuilder chars;
        boolean inEntry = false;
        boolean inTitle = false;
        boolean inTotalResults = false;
        boolean inStartIndex = false;
        boolean inItemsPerPage = false;
        boolean inNextPagingLink = false;
        String tempNextPagingLink = "";

        private SelectResultTagHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String relationship;
            if (localName.equals("entry")) {
                this.inEntry = true;
                this.selectResult = new SelectResult();
            } else if (localName.equals("title")) {
                this.inTitle = true;
                this.chars = new StringBuilder();
            } else if (localName.equals("binding")) {
                this.bindingName = atts.getValue("name");
                this.chars = new StringBuilder();
            } else if (localName.equals("totalResults")) {
                this.inTotalResults = true;
                this.chars = new StringBuilder();
            } else if (localName.equals("startIndex")) {
                this.inStartIndex = true;
                this.chars = new StringBuilder();
            } else if (localName.equals("itemsPerPage")) {
                this.inItemsPerPage = true;
                this.chars = new StringBuilder();
            } else if (localName.equals("link") && "next".equals(relationship = atts.getValue("rel"))) {
                this.inNextPagingLink = true;
                this.tempNextPagingLink = atts.getValue("href");
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("entry")) {
                SelectResultFeedParser.this.fResults.add(this.selectResult);
                this.inEntry = false;
            } else if (localName.equals("title") && this.inEntry) {
                this.selectResult.setTitle(this.chars.toString());
                this.inTitle = false;
            } else if (localName.equals("binding")) {
                this.selectResult.add(new Binding(this.bindingName, this.chars.toString()));
                this.bindingName = "";
            } else if (localName.equals("totalResults") && this.inTotalResults) {
                SelectResultFeedParser.this.totalResults = SelectResultFeedParser.this.parseInt(this.chars.toString(), 0);
                this.inTotalResults = false;
            } else if (localName.equals("startIndex") && this.inStartIndex) {
                SelectResultFeedParser.this.startIndex = SelectResultFeedParser.this.parseInt(this.chars.toString(), 0);
                this.inStartIndex = false;
            } else if (localName.equals("itemsPerPage") && this.inItemsPerPage) {
                SelectResultFeedParser.this.itemsPerPage = SelectResultFeedParser.this.parseInt(this.chars.toString(), -1);
                this.inItemsPerPage = false;
            } else if (localName.equals("link") && this.inNextPagingLink) {
                SelectResultFeedParser.this.nextPagingLink = this.tempNextPagingLink;
                this.tempNextPagingLink = "";
                this.inNextPagingLink = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.bindingName.length() > 0 || this.inTitle || this.inTotalResults || this.inStartIndex || this.inItemsPerPage) {
                this.chars.append(new String(ch, start, length));
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

