/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.promotion.ui.listeners;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.helper.EnterpriseHelper;
import com.ibm.team.enterprise.automation.ui.AbstractAutomationNode;
import com.ibm.team.enterprise.automation.ui.listeners.AbstractAutomationNodeChangeListener;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.enterprise.promotion.ui.PromotionDefinitionQueryNode;
import com.ibm.team.enterprise.promotion.ui.PromotionNode;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;

public class PromotionNodeChangeListener
extends AbstractAutomationNodeChangeListener {
    private static final String PROMOTION_DEPLOYMENT_PATH_ID = "Promotions";

    public PromotionNodeChangeListener(EnterpriseExtensionsDomainContentProvider contentProvider, IProjectAreaHandle projectAreaHandle, PromotionNode parent, List<BuildDefinitionQueryNode> children) {
        super(contentProvider, projectAreaHandle, (AbstractAutomationNode)parent, children);
    }

    protected void addBuildDefinitions(HashSet<IItem> itemsToAdd) {
        List buildDefinitions = this.getItemsOfType(itemsToAdd, IBuildDefinition.class);
        if (!buildDefinitions.isEmpty()) {
            ArrayList<PromotionDefinitionQueryNode> nodes = new ArrayList<PromotionDefinitionQueryNode>();
            for (IBuildDefinition definition : buildDefinitions) {
                if (!EnterpriseHelper.isPromotionTemplate((String)definition.getPropertyValue("com.ibm.team.build.internal.template.id", null)) || !((PromotionNode)((Object)this.getParent())).getPathId().equals(PROMOTION_DEPLOYMENT_PATH_ID) || this.getItemIdToNodesMap().get(definition.getItemId().getUuidValue()) != null) continue;
                IBuildDefinitionStatusRecord record = this.getBuildDefinitionStatusRecord(definition);
                PromotionDefinitionQueryNode node = new PromotionDefinitionQueryNode((ITeamRepository)definition.getOrigin(), record);
                node.setParent((IEnterpriseExtensionsNode)((PromotionNode)((Object)this.getParent())));
                node.setDomainSubtreeRoot(((PromotionNode)((Object)this.getParent())).getDomainSubtreeRoot());
                node.setProjectAreaHandle(this.getProjectAreaHandle());
                node.setId(node.getBuildDefinitionId());
                node.setPathId(String.valueOf(((PromotionNode)((Object)this.getParent())).getPathId()) + "/" + node.getId());
                node.setViewer((Viewer)this.getViewer());
                nodes.add(node);
                this.getItemIdToNodesMap().put(definition.getItemId().getUuidValue(), node);
            }
            if (!nodes.isEmpty()) {
                this.addNodesToViewer(this.getParent(), nodes.toArray());
            }
        }
    }
}

