/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.promotion.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.enterprise.automation.ui.AbstractAutomationNode;
import com.ibm.team.enterprise.automation.ui.AutomationDefinitionQueryNode;
import com.ibm.team.enterprise.automation.ui.AutomationUtil;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.enterprise.internal.promotion.ui.PromotionUIPlugin;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.enterprise.promotion.ui.PromotionDefinitionQueryNode;
import com.ibm.team.enterprise.promotion.ui.listeners.PromotionNodeChangeListener;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class PromotionNode
extends AbstractAutomationNode {
    public String getLabel() {
        return Messages.TeamArtifactsView_PROMOTION_NODE_LABEL;
    }

    public Image getIcon() {
        return PromotionUIPlugin.getImage(PromotionUIPlugin.getImageDescriptor("icons/obj16/promotions_obj.gif"));
    }

    protected AutomationDefinitionQueryNode createAutomationDefinitionQueryNode(ITeamRepository repository, IBuildDefinitionStatusRecord record) {
        return new PromotionDefinitionQueryNode(repository, record);
    }

    public boolean includeBuildDefinition(IBuildDefinition definition) {
        return AutomationUtil.getInstance().includeExistingDefinition(definition, "com.ibm.team.enterprise.promotion");
    }

    protected String[] getOperationIds() {
        return new String[]{"com.ibm.teamz.promotion.promoteMetadata"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDefinitionListeners(IProjectAreaHandle projectAreaHandle, List<BuildDefinitionQueryNode> nodes) {
        PromotionNodeChangeListener promotionChangeListener = new PromotionNodeChangeListener((EnterpriseExtensionsDomainContentProvider)this.getDomain().getContentProvider(), projectAreaHandle, this, nodes);
        PromotionNode promotionNode = this;
        synchronized (promotionNode) {
            ((EnterpriseExtensionsDomainContentProvider)this.getDomain().getContentProvider()).addPromotionListener(projectAreaHandle, (AbstractBuildDefinitionChangeListener)promotionChangeListener);
        }
        this.addDefinitionItemListener(projectAreaHandle, promotionChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDefinitionListeners(IProjectAreaHandle projectAreaHandle) {
        PromotionNodeChangeListener oldPromotionChangeListener;
        PromotionNode promotionNode = this;
        synchronized (promotionNode) {
            oldPromotionChangeListener = (PromotionNodeChangeListener)((EnterpriseExtensionsDomainContentProvider)this.getDomain().getContentProvider()).removePromotionListener(projectAreaHandle);
        }
        if (oldPromotionChangeListener != null) {
            this.removeDefinitionItemListener(projectAreaHandle, oldPromotionChangeListener);
        }
    }

    private void addDefinitionItemListener(IProjectAreaHandle projectAreaHandle, PromotionNodeChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().addItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    private void removeDefinitionItemListener(IProjectAreaHandle projectAreaHandle, PromotionNodeChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().removeItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }
}

