/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.promotion.ui;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.enterprise.automation.ui.AutomationDefinitionQueryNode;
import com.ibm.team.enterprise.build.common.promotion.build.PromotionBuildPropertyFactory;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionBuildUtil;
import com.ibm.team.enterprise.internal.promotion.ui.PromotionUIPlugin;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.enterprise.promotion.ui.actions.PromoteWIAction;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;

public class PromotionDefinitionQueryNode
extends AutomationDefinitionQueryNode {
    public PromotionDefinitionQueryNode(ITeamRepository repository, IBuildDefinitionStatusRecord record) {
        super(repository, record);
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        super.contributeContextMenuActions(manager, selection);
        List<BuildDomainQueryNode> queryNodes = this.getQueryNodesFromSelection(selection);
        List<IBuildDefinitionHandle> buildDefinitionHandles = this.getBuildDefinitionsFromQueryNodes(queryNodes);
        if ((queryNodes.size() <= 1 || queryNodes.size() != buildDefinitionHandles.size()) && queryNodes.size() <= 1) {
            manager.insertAfter("request.build.type", (IAction)new PromoteWIAction(this.getViewer().getControl().getShell(), selection));
            BuildDomainQueryNode queryNode = queryNodes.get(0);
            if (queryNode.getQuery() instanceof BuildQueryByDefinition) {
                IContributionItem[] items = manager.getItems();
                IBuildDefinition promotionDefinition = (IBuildDefinition)buildDefinitionHandles.get(0);
                String elementID = null;
                elementID = PromotionBuildUtil.isIBMiPromotionBuild((IBuildDefinition)promotionDefinition) ? "com.ibm.team.enterprise.ibmi.promotion.build" : "com.ibm.team.enterprise.promotion.build";
                boolean isPromotionTypeWIOnly = false;
                boolean isPromotionTypeCompOnly = false;
                String propertyTypeWI = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("com.ibm.team.enterprise.promotion.type.wi", elementID, promotionDefinition);
                isPromotionTypeWIOnly = propertyTypeWI == null ? false : Boolean.parseBoolean(propertyTypeWI);
                String propertyTypeComp = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("com.ibm.team.enterprise.promotion.type.comp", elementID, promotionDefinition);
                isPromotionTypeCompOnly = propertyTypeComp == null ? false : Boolean.parseBoolean(propertyTypeComp);
                IContributionItem[] iContributionItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    if (item instanceof ActionContributionItem) {
                        String actionId;
                        IAction action = ((ActionContributionItem)item).getAction();
                        if (action instanceof PromoteWIAction && isPromotionTypeCompOnly) {
                            manager.remove(item);
                        }
                        if ((actionId = action.getId()).equals("request.build.type")) {
                            action.setText(Messages.PromotionAction_Component);
                            if (isPromotionTypeWIOnly) {
                                manager.remove(item);
                            }
                        } else if (actionId.equals("open.build.definition")) {
                            action.setText(Messages.PromotionDefinitionActionHelper_OPEN);
                        } else if (actionId.equals("open.latest.build")) {
                            action.setText(Messages.PromotionDefinitionActionHelper_OPEN_LATEST_BUILD);
                        } else if (actionId.equals("show.builds.tag.and.definition")) {
                            action.setText(Messages.PromotionDefinitionActionHelper_TAG_QUERY);
                        } else if (actionId.equals("jazz.open")) {
                            action.setText(Messages.PromotionDefinitionActionHelper_SHOW_RESULTS);
                        }
                    }
                    ++n2;
                }
            }
            manager.remove("move.build.items.to.folder");
        }
    }

    private List<BuildDomainQueryNode> getQueryNodesFromSelection(IStructuredSelection selection) {
        ArrayList<BuildDomainQueryNode> queryNodes = new ArrayList<BuildDomainQueryNode>();
        List list = selection.toList();
        for (Object object : list) {
            if (!(object instanceof BuildDomainQueryNode)) continue;
            queryNodes.add((BuildDomainQueryNode)object);
        }
        return queryNodes;
    }

    private List<IBuildDefinitionHandle> getBuildDefinitionsFromQueryNodes(List<BuildDomainQueryNode> queryNodes) {
        ArrayList<IBuildDefinitionHandle> buildDefinitionHandles = new ArrayList<IBuildDefinitionHandle>();
        for (BuildDomainQueryNode node : queryNodes) {
            BuildQuery query = node.getQuery();
            if (!(query instanceof BuildQueryByDefinition)) continue;
            BuildQueryByDefinition queryByType = (BuildQueryByDefinition)query;
            buildDefinitionHandles.addAll(queryByType.getBuildDefinitionHandles());
        }
        return buildDefinitionHandles;
    }

    public Image getImage() {
        Image undecoratedImage = PromotionUIPlugin.getImage(PromotionUIPlugin.getImageDescriptor("icons/obj16/promotion_obj.gif"));
        if (this.getStatus() == null) {
            return undecoratedImage;
        }
        return BuildCompositeImageRegistry.getImage((Image)undecoratedImage, (BuildStatus)this.getStatus());
    }
}

