/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.views.query.ShowHistoryAction;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemAutomationWizard;
import com.ibm.team.enterprise.build.client.promotion.IPromotionClient;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.common.promotion.PromotionPreconditionException;
import com.ibm.team.enterprise.build.common.promotion.PromotionPreconditionOverruleException;
import com.ibm.team.enterprise.build.common.promotion.build.PromotionBuildPropertyFactory;
import com.ibm.team.enterprise.internal.promotion.ui.PromotionUIPlugin;
import com.ibm.team.enterprise.internal.promotion.ui.dialogs.PromotionErrorDialog;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.IPromotionWizardConfiguration;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.PromotionWizardConfiguration;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.PromotionWorkItemChangeSetAnalysisWizardPage;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.PromotionWorkItemImpactedFilesWizardPage;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.PromotionWorkItemPreviewWizardPage;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.PromotionWorkItemSummaryWizardPage;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.PromotionWorkItemWizardPage;
import com.ibm.team.enterprise.promotion.ui.PromotionDefinitionQueryNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNode;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class WorkItemPromotionWizard
extends AbstractWorkItemAutomationWizard {
    public static String PROMOTION_TARGET_OVERRIDE = "team.enterprise.promotion.wi.buildResult.behavior";
    public static String PROMOTION_TARGET_OVERRIDE_NONE = "None";
    public static String PROMOTION_TARGET_PROMOTION = "PromotionBuild";
    public static String PROMOTION_TARGET_BUILD = "TargetBuild";
    private IPromotionWizardConfiguration configuration;
    private PromotionWorkItemWizardPage workItemSelectionPage;
    private PromotionWorkItemChangeSetAnalysisWizardPage changeSetAnalysisPage;
    private IWizardPage impactedFilesPage;
    private IWizardPage promotionSummaryPage;
    private IWizardPage previewPromotionPage;
    public List<IBuildProperty> workingCopyProperties = new ArrayList<IBuildProperty>();
    private IStructuredSelection selection;

    public WorkItemPromotionWizard(IStructuredSelection selection) {
        this.init(selection);
        this.setWindowTitle(Messages.WorkItemPromotionWizard_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IStructuredSelection selection) {
        this.selection = selection;
        this.configuration = new PromotionWizardConfiguration();
    }

    public void addPages() {
        this.workItemSelectionPage = new PromotionWorkItemWizardPage(this.getShell(), this.selection, this.configuration);
        this.changeSetAnalysisPage = new PromotionWorkItemChangeSetAnalysisWizardPage(this.getShell(), this.configuration);
        this.impactedFilesPage = new PromotionWorkItemImpactedFilesWizardPage(this.getShell(), this.configuration);
        this.promotionSummaryPage = new PromotionWorkItemSummaryWizardPage(this.getShell(), this.configuration);
        this.previewPromotionPage = new PromotionWorkItemPreviewWizardPage(this.getShell(), this.configuration);
        this.addPage((IWizardPage)this.workItemSelectionPage);
        this.addPage((IWizardPage)this.changeSetAnalysisPage);
        this.addPage(this.impactedFilesPage);
        this.addPage(this.promotionSummaryPage);
        this.addPage(this.previewPromotionPage);
    }

    public IPromotionWizardConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean performFinish() {
        IDialogSettings settings = PromotionUIPlugin.getDefault().getDialogSettings();
        if (settings == null) {
            settings = new DialogSettings("promotionSettings");
        }
        settings.put("isSourceAndBinaries", !this.configuration.isSourceOnly());
        settings.put("isIncludeChildren", this.configuration.isIncludeChildren());
        settings.put("isOpenReportWorkItem", this.configuration.isOpenReportWorkItem());
        settings.put("isConsiderIgnoreChanges", this.configuration.isConsiderIgnoreChanges());
        settings.put("isIncludeImpactedFiles", this.configuration.isIncludeImpactedFiles());
        this.workItemSelectionPage.performFinish();
        this.workingCopyProperties.addAll(((IBuildDefinition)this.getConfiguration().getChosenDefinition().getWorkingCopy()).getProperties());
        return this.performPromotion(false);
    }

    private boolean performPromotion(final boolean ignoreBuildMapValidation) {
        boolean[] rc;
        block16: {
            rc = new boolean[]{true};
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            final IWorkbenchPage activePage = window != null ? window.getActivePage() : null;
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("", -1);
                        try {
                            try {
                                IBuildDefinition promotionDefinition;
                                File htmlPreviewFile = new File("c:/report.html");
                                File xmlPreviewFile = new File("c:/report.xml");
                                boolean promoteSourceOnly = WorkItemPromotionWizard.this.configuration.isSourceOnly();
                                boolean includeWorkItemChildren = WorkItemPromotionWizard.this.configuration.isIncludeChildren();
                                boolean isConsiderIgnoreChanges = WorkItemPromotionWizard.this.configuration.isConsiderIgnoreChanges();
                                boolean isIncludeImpactedFiles = WorkItemPromotionWizard.this.configuration.isIncludeImpactedFiles();
                                String[] excludedImpactedFiles = WorkItemPromotionWizard.this.configuration.getExcludedImpactedFiles();
                                ItemHandleAwareHashSet<IWorkItemHandle> selectedHandles = WorkItemPromotionWizard.this.configuration.getAllWorkItems();
                                ITeamRepository targetRepository = WorkItemPromotionWizard.this.configuration.getTeamRepository();
                                boolean ignoreDoNotCalcImpactedFiles = WorkItemPromotionWizard.this.configuration.isIgnoreValidationErrorForImpactedFiles();
                                IPromotionClient promotionClient = (IPromotionClient)targetRepository.getClientLibrary(IPromotionClient.class);
                                Object selectedElement = WorkItemPromotionWizard.this.selection.getFirstElement();
                                IBuildDefinition iBuildDefinition = promotionDefinition = selectedElement instanceof PromotionDefinitionQueryNode ? ((PromotionDefinitionQueryNode)((Object)WorkItemPromotionWizard.this.selection.getFirstElement())).getBuildDefinition() : WorkItemPromotionWizard.this.configuration.getChosenDefinition();
                                if (selectedHandles != null) {
                                    IWorkspace flowWorkspace;
                                    IBuildProperty[] deletedProperties;
                                    IWorkItemHandle[] workItemHandles = (IWorkItemHandle[])selectedHandles.toArray((Object[])new IWorkItemHandle[selectedHandles.size()]);
                                    String[] properties = new String[8];
                                    properties[0] = String.valueOf(!promoteSourceOnly);
                                    properties[1] = String.valueOf(includeWorkItemChildren);
                                    properties[2] = String.valueOf(isConsiderIgnoreChanges);
                                    properties[3] = String.valueOf(false);
                                    properties[4] = String.valueOf(isIncludeImpactedFiles);
                                    if (!isIncludeImpactedFiles || excludedImpactedFiles == null || excludedImpactedFiles.length == 0) {
                                        properties[5] = null;
                                    } else {
                                        StringBuilder buf = new StringBuilder(100);
                                        String[] stringArray = excludedImpactedFiles;
                                        int n = excludedImpactedFiles.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String next = stringArray[n2];
                                            buf.append(next);
                                            buf.append(' ');
                                            ++n2;
                                        }
                                        properties[5] = buf.toString();
                                    }
                                    properties[6] = String.valueOf(ignoreBuildMapValidation);
                                    properties[7] = String.valueOf(ignoreDoNotCalcImpactedFiles);
                                    List originalBuildProperties = promotionDefinition.getProperties();
                                    List<IBuildProperty> workingCopyBuildProperties = WorkItemPromotionWizard.this.getWorkingCopyProperties();
                                    ArrayList<IBuildProperty> deletedBuildProperties = new ArrayList<IBuildProperty>();
                                    WorkItemPromotionWizard.this.removeUnwantedProperties(workingCopyBuildProperties);
                                    for (IBuildProperty originalProperty : originalBuildProperties) {
                                        boolean deleted = true;
                                        for (IBuildProperty newProperty : workingCopyBuildProperties) {
                                            if (!newProperty.getName().equals(originalProperty.getName())) continue;
                                            deleted = false;
                                            break;
                                        }
                                        if (!deleted) continue;
                                        deletedBuildProperties.add(originalProperty);
                                    }
                                    IBuildProperty[] newProperties = workingCopyBuildProperties.toArray(new IBuildProperty[workingCopyBuildProperties.size()]);
                                    final Object resultItem = promotionClient.promoteWorkItems6(workItemHandles, (IBuildDefinitionHandle)promotionDefinition, properties, newProperties, deletedProperties = deletedBuildProperties.toArray(new IBuildProperty[deletedBuildProperties.size()]), htmlPreviewFile, xmlPreviewFile, monitor);
                                    if (resultItem != null && resultItem instanceof IWorkItemHandle && WorkItemPromotionWizard.this.configuration.isOpenReportWorkItem() && activePage != null) {
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                WorkItemUI.openEditor((IWorkbenchPage)activePage, (Object)resultItem);
                                            }
                                        });
                                    }
                                    String promotionElementId = PromotionBuildPropertyFactory.getInstance().resolvePropertyId("com.ibm.team.enterprise.promotion.build", promotionDefinition);
                                    String targetBuildUUID = promotionDefinition.getConfigurationPropertyValue(promotionElementId, "team.enterprise.promotion.targetDefinition", null);
                                    IBuildDefinitionHandle handle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)targetBuildUUID), null);
                                    final IBuildDefinition targetDefinition = (IBuildDefinition)targetRepository.itemManager().fetchCompleteItem((IItemHandle)handle, 0, monitor);
                                    String workspaceElementId = DependencyBuildPropertyFactory.getInstance().resolvePropertyId("teamz.scm.workspaceUUID", targetDefinition);
                                    String buildWorkspaceUUID = targetDefinition.getPropertyValue(workspaceElementId, null);
                                    IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildWorkspaceUUID), null);
                                    IWorkspaceManager wsManager = SCMPlatform.getWorkspaceManager((ITeamRepository)targetRepository);
                                    IWorkspaceConnection wsConnection = wsManager.getWorkspaceConnection(wsHandle, monitor);
                                    IFlowTable flowTable = wsConnection.getFlowTable();
                                    IFlowEntry flowEntry = flowTable.getCurrentDeliverFlow();
                                    IFlowNodeHandle flowHandle = flowEntry.getFlowNode();
                                    IFlowNode flowNode = (IFlowNode)targetRepository.itemManager().fetchCompleteItem((IItemHandle)flowHandle, 0, monitor);
                                    String streamName = null;
                                    if (flowNode instanceof IWorkspace && (flowWorkspace = (IWorkspace)flowNode).isStream()) {
                                        streamName = flowWorkspace.getName();
                                    }
                                    String messageString = String.valueOf(Messages.PromotionAction_ConfirmationDialog_Message_Stream) + "\n\n   " + streamName;
                                    if (!WorkItemPromotionWizard.this.configuration.isSourceOnly()) {
                                        messageString = messageString.concat("\n\n" + Messages.PromotionAction_ConfirmationDialog_Message_Build + "\n\n   " + promotionDefinition.getId() + "\n\n");
                                    }
                                    final String dialogString = messageString;
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            MessageDialog.openInformation((Shell)WorkItemPromotionWizard.this.getShell(), (String)Messages.PromotionAction_ConfirmationDialog_Title, (String)dialogString);
                                            String behavior = null;
                                            IBuildProperty prop = promotionDefinition.getProperty(PROMOTION_TARGET_OVERRIDE);
                                            if (prop != null) {
                                                behavior = prop.getValue();
                                            }
                                            IBuildDefinition buildDefToUse = null;
                                            if (behavior == null || behavior.equalsIgnoreCase(PROMOTION_TARGET_PROMOTION)) {
                                                buildDefToUse = promotionDefinition;
                                            } else if (behavior.equalsIgnoreCase(PROMOTION_TARGET_BUILD)) {
                                                buildDefToUse = targetDefinition;
                                            }
                                            if (buildDefToUse != null) {
                                                ShowHistoryAction action = new ShowHistoryAction(buildDefToUse, null);
                                                action.run();
                                            }
                                        }
                                    });
                                }
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                rc[0] = false;
            }
            catch (InvocationTargetException e) {
                Object data;
                PromotionErrorDialog dialog;
                Throwable target;
                Throwable throwable = target = e.getTargetException() == null ? e : e.getTargetException();
                if (target.getCause() instanceof GapException) {
                    dialog = new MessageDialog(this.getShell(), Messages.Promote_ErrorLabel, null, Messages.PromotionFailedGapsFound, 1, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    switch (dialog.open()) {
                        case 0: {
                            rc[0] = false;
                            if (this.getContainer().getCurrentPage() == this.changeSetAnalysisPage) {
                                this.changeSetAnalysisPage.runAnalysis();
                                break;
                            }
                            this.changeSetAnalysisPage.runAnalysisOnNextView();
                            this.getContainer().showPage((IWizardPage)this.changeSetAnalysisPage);
                            break;
                        }
                    }
                } else if (target instanceof PromotionPreconditionOverruleException) {
                    dialog = new PromotionErrorDialog(this.getShell(), Messages.Promote_ErrorLabel, Messages.PromotionIgnoreBuildMapValidation, Messages.PromotionOverruleException, target.getLocalizedMessage(), true);
                    switch (dialog.open()) {
                        case 0: {
                            return this.performPromotion(true);
                        }
                    }
                } else {
                    if (target instanceof PromotionPreconditionException) {
                        dialog = new PromotionErrorDialog(this.getShell(), Messages.Promote_ErrorLabel, null, Messages.PromotionOverruleException, target.getLocalizedMessage(), false);
                        dialog.open();
                    } else {
                        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.Promote_ErrorLabel, (String)NLS.bind((String)Messages.Promote_ErrorMessage2, (Object)target.getLocalizedMessage()));
                    }
                    PromotionUIPlugin.log(target);
                }
                if (!rc[0] || !this.configuration.isOpenReportWorkItem() || !(target instanceof TeamRepositoryException) || activePage == null || !((data = ((TeamRepositoryException)target).getData()) instanceof IWorkItemHandle)) break block16;
                final IItemHandle handle = IWorkItem.ITEM_TYPE.createItemHandle((Object)this.configuration.getTeamRepository(), ((IWorkItemHandle)data).getItemId(), null);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkItemUI.openEditor((IWorkbenchPage)activePage, (Object)handle);
                    }
                });
            }
        }
        return rc[0];
    }

    private void removeUnwantedProperties(List<IBuildProperty> workingCopyBuildProperties) {
        Iterator<IBuildProperty> it = workingCopyBuildProperties.iterator();
        while (it.hasNext()) {
            String name = it.next().getName();
            if (!"team.enterprise.promotion.componentList".equals(name) && !"teamz.build.dependency.previewBuild".equals(name) && !"buildLabelPrefix".equals(name)) continue;
            it.remove();
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage next = super.getNextPage(page);
        if (!this.configuration.isIncludeImpactedFiles() && next == this.impactedFilesPage) {
            next = super.getNextPage(next);
        }
        return next;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage prev = super.getPreviousPage(page);
        if (!this.configuration.isIncludeImpactedFiles() && prev == this.impactedFilesPage) {
            prev = super.getPreviousPage(prev);
        }
        return prev;
    }

    public List<IBuildProperty> getWorkingCopyProperties() {
        return this.workingCopyProperties;
    }
}

