/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialogSectionExtension;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialogSectionExtensionManager;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractAutomationWorkItemWizardPage;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemChooser;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemTableContentProvider;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemTableLabelProvider;
import com.ibm.team.enterprise.automation.internal.ui.wizards.IAutomationWizardConfiguration;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.common.Messages;
import com.ibm.team.enterprise.build.common.promotion.build.PromotionBuildPropertyFactory;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionBuildUtil;
import com.ibm.team.enterprise.common.ui.EESharedImages;
import com.ibm.team.enterprise.internal.promotion.ui.PromotionUIPlugin;
import com.ibm.team.enterprise.internal.promotion.ui.dialogs.PromotionDefinitionSelectionDialog;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.IPromotionWizardConfiguration;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.PromotionWorkItemChooser;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PromotionWorkItemWizardPage
extends AbstractAutomationWorkItemWizardPage {
    private final IDialogSettings settings;
    private final IPromotionWizardConfiguration configuration;
    private Button sourceOnlyButton;
    private Button sourceAndBinariesButton;
    private Button includeChildrenButton;
    private Button considerIgnoreChangesButton;
    private Button ignoreValidationErrorForImpactedFilesButton;
    private Button includeImpactedFilesButton;
    private WorkItemTableContentProvider fWorkItemTableContentProvider = null;
    private WorkItemTableLabelProvider fWorkItemTableLabelProvider = null;
    private ComputeWorkItemOptionJob job;
    private boolean isInlcudeImpacted = false;
    private boolean isDecideIncludeImpacted;
    private boolean hasPermission2Override = false;
    private static final String PERMISSION_OVERRIDE_PROMOTION_SETTINGS_OPERATION_ID = "com.ibm.team.enterprise.promotion.ui.permission.workitem.override";
    private static final String PERMISSION_OVERRIDE_PROMOTION_SETTINGS_ACTION_ID = "overrideWorkitemPromotionSettingsAction";

    public PromotionWorkItemWizardPage(Shell parent, IStructuredSelection selection, IPromotionWizardConfiguration config) {
        super(parent, selection, (IAutomationWizardConfiguration)config);
        this.configuration = config;
        this.settings = PromotionUIPlugin.getDefault().getDialogSettings();
    }

    private String getPromotionPropertyValue(IBuildDefinition promotionDef, String elementID, String propertyID) {
        return PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue(propertyID, elementID, promotionDef);
    }

    private void loadPromotionSettings() {
        this.sourceOnlyButton.setEnabled(true);
        this.sourceAndBinariesButton.setEnabled(true);
        this.includeChildrenButton.setEnabled(true);
        this.considerIgnoreChangesButton.setEnabled(true);
        this.includeImpactedFilesButton.setEnabled(true);
        this.ignoreValidationErrorForImpactedFilesButton.setEnabled(true);
        boolean hasOverridePermission = this.hasPermission2Override;
        IBuildDefinition promotionDefinition = this.configuration.getChosenDefinition();
        String elementID = null;
        String buildPropertyDecideAll = null;
        String buildPropertyDecideIncludeChildren = null;
        String buildPropertyDecideIgnoreChanges = null;
        String buildPropertyDecideIncludeImpacted = null;
        String buildPropertyDecideIgnoreValidationErrorForImpactedFiles = null;
        String buildPropertySourceOnly = null;
        String buildPropertyIncludeChildren = null;
        String buildPropertyIgnoreChanges = null;
        String buildPropertyIncludeImpacted = null;
        String buildPropertyIgnoreValidationErrorForImpactedFiles = null;
        if (promotionDefinition != null) {
            elementID = PromotionBuildUtil.isIBMiPromotionBuild((IBuildDefinition)promotionDefinition) ? this.getConfigurationElementIDIBMi() : this.getConfigurationElementID();
            buildPropertyDecideAll = this.getPromotionPropertyValue(promotionDefinition, elementID, "com.ibm.team.enterprise.promotion.workitem.decide.in.promotion");
            buildPropertyDecideIncludeChildren = this.getPromotionPropertyValue(promotionDefinition, elementID, "com.ibm.team.enterprise.promotion.workitem.decide.include.children");
            buildPropertyDecideIgnoreChanges = this.getPromotionPropertyValue(promotionDefinition, elementID, "com.ibm.team.enterprise.promotion.workitem.decide.ignore.changes");
            buildPropertyDecideIncludeImpacted = this.getPromotionPropertyValue(promotionDefinition, elementID, "com.ibm.team.enterprise.promotion.workitem.decide.include.impacted");
            buildPropertySourceOnly = this.getPromotionPropertyValue(promotionDefinition, elementID, "com.ibm.team.enterprise.promotion.workitem.sourceonly");
            buildPropertyIncludeChildren = this.getPromotionPropertyValue(promotionDefinition, elementID, "com.ibm.team.enterprise.promotion.workitem.include.children");
            buildPropertyIgnoreChanges = this.getPromotionPropertyValue(promotionDefinition, elementID, "com.ibm.team.enterprise.promotion.workitem.ignore.changes");
            buildPropertyIncludeImpacted = this.getPromotionPropertyValue(promotionDefinition, elementID, "com.ibm.team.enterprise.promotion.workitem.include.impacted");
            buildPropertyIgnoreValidationErrorForImpactedFiles = this.getPromotionPropertyValue(promotionDefinition, elementID, "com.ibm.team.enterprise.promotion.workitem.ignore.validation.error.for.impacted.files");
            buildPropertyDecideIgnoreValidationErrorForImpactedFiles = this.getPromotionPropertyValue(promotionDefinition, elementID, "com.ibm.team.enterprise.promotion.workitem.decide.ignore.validation.error.for.impacted.files");
        }
        this.isInlcudeImpacted = buildPropertyIncludeImpacted == null || buildPropertyIncludeImpacted == null ? false : Boolean.parseBoolean(buildPropertyIncludeImpacted);
        boolean sourceOnly = buildPropertySourceOnly == null || buildPropertySourceOnly == null ? false : Boolean.parseBoolean(buildPropertySourceOnly);
        boolean isDecideAllInPromotion = true;
        if (buildPropertyDecideAll != null) {
            isDecideAllInPromotion = Boolean.parseBoolean(buildPropertyDecideAll);
        }
        boolean isDecideIncludeChildren = true;
        if (buildPropertyDecideIncludeChildren != null) {
            isDecideIncludeChildren = Boolean.parseBoolean(buildPropertyDecideIncludeChildren);
        }
        boolean isDecideIgnoreChanges = true;
        if (buildPropertyDecideIgnoreChanges != null) {
            isDecideIgnoreChanges = Boolean.parseBoolean(buildPropertyDecideIgnoreChanges);
        }
        boolean isDecideIgnoreValidationErrorForImpactedFiles = true;
        if (buildPropertyDecideIgnoreValidationErrorForImpactedFiles != null) {
            isDecideIgnoreValidationErrorForImpactedFiles = Boolean.parseBoolean(buildPropertyDecideIgnoreValidationErrorForImpactedFiles);
        }
        this.isDecideIncludeImpacted = true;
        if (buildPropertyDecideIncludeImpacted != null) {
            this.isDecideIncludeImpacted = Boolean.parseBoolean(buildPropertyDecideIncludeImpacted);
        }
        if (isDecideAllInPromotion || buildPropertyDecideAll == null) {
            this.sourceAndBinariesButton.setSelection(true);
            this.includeImpactedFilesButton.setEnabled(this.isDecideIncludeImpacted);
            this.configuration.setSourceOnly(false);
        } else {
            this.sourceOnlyButton.setEnabled(hasOverridePermission);
            this.sourceAndBinariesButton.setEnabled(hasOverridePermission);
            this.sourceAndBinariesButton.setSelection(!sourceOnly);
            this.sourceOnlyButton.setSelection(sourceOnly);
            this.includeImpactedFilesButton.setEnabled(!sourceOnly);
            this.configuration.setSourceOnly(sourceOnly);
        }
        if (!(!isDecideAllInPromotion && sourceOnly || buildPropertyIncludeImpacted == null || buildPropertyDecideIncludeImpacted != null && this.isDecideIncludeImpacted)) {
            this.includeImpactedFilesButton.setEnabled(hasOverridePermission);
            this.includeImpactedFilesButton.setSelection(this.isInlcudeImpacted);
            this.configuration.setIncludeImpactedFiles(this.isInlcudeImpacted);
        }
        if (!(buildPropertyIncludeChildren == null || buildPropertyDecideIncludeChildren != null && isDecideIncludeChildren)) {
            boolean isIncludeChildren = Boolean.parseBoolean(buildPropertyIncludeChildren);
            this.includeChildrenButton.setSelection(isIncludeChildren);
            this.includeChildrenButton.setEnabled(hasOverridePermission);
            this.configuration.setIncludeChildren(isIncludeChildren);
        }
        if (!(buildPropertyIgnoreChanges == null || buildPropertyDecideIgnoreChanges != null && isDecideIgnoreChanges)) {
            boolean isIgnoreChanges = Boolean.parseBoolean(buildPropertyIgnoreChanges);
            this.considerIgnoreChangesButton.setSelection(isIgnoreChanges);
            this.considerIgnoreChangesButton.setEnabled(hasOverridePermission);
            this.configuration.setConsiderIgnoreChanges(isIgnoreChanges);
        }
        if (!(buildPropertyIgnoreValidationErrorForImpactedFiles == null || buildPropertyDecideIgnoreValidationErrorForImpactedFiles != null && isDecideIgnoreValidationErrorForImpactedFiles)) {
            boolean isIgnoreValidationError = Boolean.parseBoolean(buildPropertyIgnoreValidationErrorForImpactedFiles);
            this.ignoreValidationErrorForImpactedFilesButton.setSelection(isIgnoreValidationError);
            this.ignoreValidationErrorForImpactedFilesButton.setEnabled(hasOverridePermission);
            this.configuration.setIgnoreValidationErrorForImpactedFiles(isIgnoreValidationError);
        }
    }

    public void handleInitializeDefinitionComplete(IBuildDefinition initialDefinition) {
        super.handleInitializeDefinitionComplete(initialDefinition);
        this.initializePromotionArea();
    }

    public void createCustomContentUpper(Composite parent) {
        Composite promotionComposite = new Composite(parent, 0);
        promotionComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(5, 5).create());
        promotionComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Group optionsGroup = new Group(promotionComposite, 0);
        optionsGroup.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_GROUP_PROMOTION_OPTIONS);
        optionsGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        optionsGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.sourceAndBinariesButton = new Button((Composite)optionsGroup, 16);
        this.sourceAndBinariesButton.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_TEXT_SOURCEANDOUTPUTS);
        this.sourceAndBinariesButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 5).create());
        this.sourceOnlyButton = new Button((Composite)optionsGroup, 16);
        this.sourceOnlyButton.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_TEXT_SOURCEONLY);
        this.sourceOnlyButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).create());
        this.includeChildrenButton = new Button((Composite)optionsGroup, 32);
        this.includeChildrenButton.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_TEXT_INCLUDECHILDREN);
        this.includeChildrenButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).create());
        this.includeImpactedFilesButton = new Button((Composite)optionsGroup, 32);
        this.includeImpactedFilesButton.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_TEXT_INCLUDEIMPACTED);
        this.includeImpactedFilesButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).create());
        Group ignoreValidationGroup = new Group((Composite)optionsGroup, 0);
        ignoreValidationGroup.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_TEXT_IGNOREVALIDATIONERRORS);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)ignoreValidationGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)ignoreValidationGroup);
        Composite considerIgnoreChangesComposite = new Composite((Composite)ignoreValidationGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).spacing(0, 0).applyTo(considerIgnoreChangesComposite);
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 5).applyTo((Control)considerIgnoreChangesComposite);
        this.considerIgnoreChangesButton = new Button(considerIgnoreChangesComposite, 32);
        this.considerIgnoreChangesButton.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_TEXT_IGNORECHANGES);
        this.considerIgnoreChangesButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Label considerIgnoreChangesTooltip = new Label(considerIgnoreChangesComposite, 0);
        considerIgnoreChangesTooltip.setImage(EESharedImages.getInstance().getImage("IMG_INFO"));
        considerIgnoreChangesTooltip.setToolTipText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_DESC_IGNORECHANGES);
        GridDataFactory.swtDefaults().applyTo((Control)considerIgnoreChangesTooltip);
        Composite ignoreValidationErrorForImpactedFilesComposite = new Composite((Composite)ignoreValidationGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).spacing(0, 0).applyTo(ignoreValidationErrorForImpactedFilesComposite);
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 0).applyTo((Control)ignoreValidationErrorForImpactedFilesComposite);
        this.ignoreValidationErrorForImpactedFilesButton = new Button(ignoreValidationErrorForImpactedFilesComposite, 32);
        this.ignoreValidationErrorForImpactedFilesButton.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_TEXT_IGNOREVALIDATIONERRORFORIMPACTEDFILES);
        GridDataFactory.fillDefaults().applyTo((Control)this.ignoreValidationErrorForImpactedFilesButton);
        Label ignoreValidationErrorForImpactedFilesTooltip = new Label(ignoreValidationErrorForImpactedFilesComposite, 0);
        ignoreValidationErrorForImpactedFilesTooltip.setImage(EESharedImages.getInstance().getImage("IMG_INFO"));
        ignoreValidationErrorForImpactedFilesTooltip.setToolTipText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_DESC_IGNOREVALIDATIONERRORFORIMPACTEDFILES);
        GridDataFactory.swtDefaults().applyTo((Control)ignoreValidationErrorForImpactedFilesTooltip);
        if (this.configuration.getChosenDefinition() != null) {
            this.initializePromotionArea();
        }
        this.sourceOnlyButton.addSelectionListener((SelectionListener)this);
        this.sourceAndBinariesButton.addSelectionListener((SelectionListener)this);
        this.includeChildrenButton.addSelectionListener((SelectionListener)this);
        this.considerIgnoreChangesButton.addSelectionListener((SelectionListener)this);
        this.includeImpactedFilesButton.addSelectionListener((SelectionListener)this);
        this.ignoreValidationErrorForImpactedFilesButton.addSelectionListener((SelectionListener)this);
    }

    private void initializePromotionArea() {
        new TeamBuildJob(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionConfigurationEditor_JOBNAME_LOAD_WI_PROMOTION_SETTINGS, true, this.configuration.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                PromotionWorkItemWizardPage.this.loadPermission2OverridePromotionSettings();
                return null;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PromotionWorkItemWizardPage.this.loadPromotionSettings();
                    }
                });
            }
        }.schedule();
    }

    private void loadPermission2OverridePromotionSettings() {
        try {
            ITeamRepository repository = this.getTeamRepository();
            if (this.configuration.getChosenDefinition() == null) {
                return;
            }
            IProcessAreaHandle processAreaHandle = this.configuration.getChosenDefinition().getProcessArea();
            IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, null);
            IProcessClientService processService = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
            IClientProcess clientProcess = processService.getClientProcess(processArea, null);
            boolean[] permitted = clientProcess.getPermittedActions(processArea, PERMISSION_OVERRIDE_PROMOTION_SETTINGS_OPERATION_ID, new String[]{PERMISSION_OVERRIDE_PROMOTION_SETTINGS_ACTION_ID}, null);
            this.hasPermission2Override = permitted[0];
        }
        catch (Exception e) {
            PromotionUIPlugin.log(e);
        }
    }

    public AbstractWorkItemTableContentProvider getCommonContentProvider() {
        if (this.fWorkItemTableContentProvider == null) {
            this.fWorkItemTableContentProvider = new WorkItemTableContentProvider();
        }
        return this.fWorkItemTableContentProvider;
    }

    public AbstractWorkItemTableLabelProvider getCommonLabelProvider() {
        if (this.fWorkItemTableLabelProvider == null) {
            this.fWorkItemTableLabelProvider = new WorkItemTableLabelProvider();
        }
        return this.fWorkItemTableLabelProvider;
    }

    public String getDialogFinishLabel() {
        return com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_LABEL_FINISH;
    }

    public String getDialogTitle() {
        return com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_TITLE;
    }

    public String getConfigurationElementID() {
        return "com.ibm.team.enterprise.promotion.build";
    }

    public String getConfigurationElementIDIBMi() {
        return "com.ibm.team.enterprise.ibmi.promotion.build";
    }

    public AbstractWorkItemChooser getWorkItemChooser() {
        return new PromotionWorkItemChooser(this.getShell(), this.configuration.getTeamRepository());
    }

    public void widgetSelected(SelectionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource == this.includeChildrenButton) {
            this.configuration.setIncludeChildren(this.includeChildrenButton.getSelection());
        } else if (eventSource == this.sourceOnlyButton || eventSource == this.sourceAndBinariesButton) {
            this.configuration.setSourceOnly(this.sourceOnlyButton.getSelection());
            this.updateBuildOptionsState();
            this.updateIncludeImpactedFilesEnablement();
        } else if (eventSource == this.considerIgnoreChangesButton) {
            this.configuration.setConsiderIgnoreChanges(this.considerIgnoreChangesButton.getSelection());
        } else if (eventSource == this.ignoreValidationErrorForImpactedFilesButton) {
            this.configuration.setIgnoreValidationErrorForImpactedFiles(this.ignoreValidationErrorForImpactedFilesButton.getSelection());
        } else if (eventSource == this.includeImpactedFilesButton) {
            this.configuration.setIncludeImpactedFiles(this.includeImpactedFilesButton.getSelection());
        } else if (eventSource == this.browseDefinitionButton) {
            PromotionDefinitionSelectionDialog selectionDialog = null;
            if (this.configuration.getSelectionResult() != null && this.configuration.getSelectionResult().size() > 0) {
                try {
                    IWorkItemHandle wHandle = (IWorkItemHandle)this.configuration.getSelectionResult().get(0);
                    IWorkItemCommon workItemClient = (IWorkItemCommon)this.configuration.getTeamRepository().getClientLibrary(IWorkItemCommon.class);
                    IProcessAreaHandle pAreaHandle = workItemClient.findProcessArea(wHandle, (IProgressMonitor)new NullProgressMonitor());
                    IProcessArea processArea = (IProcessArea)this.configuration.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)pAreaHandle, 0, (IProgressMonitor)new NullProgressMonitor());
                    selectionDialog = new PromotionDefinitionSelectionDialog(this.getShell(), processArea, true);
                }
                catch (TeamRepositoryException e) {
                    PromotionUIPlugin.log(e);
                }
            } else {
                selectionDialog = new PromotionDefinitionSelectionDialog(this.getShell(), null, true);
            }
            if (selectionDialog.open() == 0) {
                IBuildDefinition definition = selectionDialog.getFirstSelectedBuildDefinition();
                this.definitionText.setData((Object)definition.getItemId().getUuidValue());
                this.definitionText.setText(definition.getId());
                this.configuration.setChosenDefinition(definition);
                this.initializePromotionArea();
            }
            this.buildOptionsButton.setEnabled(!this.definitionText.getText().equalsIgnoreCase(""));
            this.validate();
        } else {
            super.widgetSelected(event);
        }
    }

    private void updateIncludeImpactedFilesEnablement() {
        if (this.sourceAndBinariesButton.getSelection()) {
            boolean hasPermission = this.hasPermission2Override;
            if (this.isDecideIncludeImpacted || hasPermission) {
                this.includeImpactedFilesButton.setEnabled(true);
            }
            if (!this.isDecideIncludeImpacted || hasPermission) {
                this.includeImpactedFilesButton.setSelection(this.isInlcudeImpacted);
            }
            this.configuration.setIncludeImpactedFiles(this.includeImpactedFilesButton.getSelection());
        } else {
            this.includeImpactedFilesButton.setSelection(false);
            this.includeImpactedFilesButton.setEnabled(false);
            this.configuration.setIncludeImpactedFiles(false);
        }
    }

    public String getDialogDescription() {
        return com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_DESCRIPTION;
    }

    protected boolean getBuildOptionsState() {
        if (this.sourceAndBinariesButton != null && !this.sourceAndBinariesButton.isDisposed()) {
            return this.sourceAndBinariesButton.getSelection();
        }
        return super.getBuildOptionsState();
    }

    protected String getHelpText() {
        return "com.ibm.team.build.ui.wizard_enterprise_promotion_workitem_selection";
    }

    public void createCustomContentLower(Composite parent) {
        if (this.job != null) {
            this.job.cancel();
        }
        this.job = new ComputeWorkItemOptionJob("");
        this.job.setSystem(true);
        this.job.schedule();
    }

    protected void validate() {
        IBuildDefinition promotionDef = this.configuration.getChosenDefinition();
        if (promotionDef != null) {
            IBuildDefinition sourceDefinition;
            String promotionConfigurationElementId = PromotionBuildPropertyFactory.getInstance().resolvePropertyId("com.ibm.team.enterprise.promotion.build", promotionDef);
            String sourceDefUUID = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("team.enterprise.promotion.sourceDefinition", promotionConfigurationElementId, promotionDef);
            if (sourceDefUUID != null && (sourceDefinition = this.resolveBuildDefinition(sourceDefUUID)) != null && IBuildUtility.isOldDependencyBuild((IBuildDefinition)sourceDefinition)) {
                this.setErrorMessage(Messages.DEPRECATED_TEMPLATE_NOT_SUPPORTED);
                this.setPageComplete(false);
                return;
            }
            String elementID = PromotionBuildUtil.isIBMiPromotionBuild((IBuildDefinition)promotionDef) ? this.getConfigurationElementIDIBMi() : this.getConfigurationElementID();
            String buildPropertyOnlyComponentPromotion = this.getPromotionPropertyValue(promotionDef, elementID, "com.ibm.team.enterprise.promotion.type.comp");
            if (Boolean.parseBoolean(buildPropertyOnlyComponentPromotion)) {
                this.setErrorMessage(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_ERROR_INVALID_PROMOTION_DEF_WI);
                this.setPageComplete(false);
                return;
            }
        }
        super.validate();
    }

    private IBuildDefinition resolveBuildDefinition(String uuidValue) {
        if (this.getTeamRepository() != null && !uuidValue.isEmpty()) {
            IItemHandle definitionHandle = IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuidValue), null);
            try {
                return (IBuildDefinition)this.getTeamRepository().itemManager().fetchCompleteItem(definitionHandle, 0, null);
            }
            catch (TeamRepositoryException e) {
                return null;
            }
        }
        return null;
    }

    public void performFinish() {
        if (!this.buildOptionsAreCustomized) {
            RequestBuildDialogSectionExtension[] extensions;
            List originalProperties = this.configuration.getChosenDefinition().getProperties();
            IBuildDefinition workingCopy = (IBuildDefinition)this.configuration.getChosenDefinition().getWorkingCopy();
            RequestBuildSection credentialSection = null;
            RequestBuildDialogSectionExtension[] requestBuildDialogSectionExtensionArray = extensions = RequestBuildDialogSectionExtensionManager.getInstance().getRequestBuildDialogSectionExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                RequestBuildDialogSectionExtension extension = requestBuildDialogSectionExtensionArray[n2];
                if (extension.getClassAttribute().equals("com.ibm.rational.buildforge.buildagent.internal.ui.dialogs.ClientCredentialSection$Factory")) {
                    try {
                        credentialSection = extension.createSectionFactory().createRequestBuildSection(this.createRequestBuildSectionSite(workingCopy, originalProperties));
                        break;
                    }
                    catch (Exception e) {
                        PromotionUIPlugin.log(e);
                    }
                }
                ++n2;
            }
            if (credentialSection != null) {
                try {
                    credentialSection.createContent((Composite)this.getControl());
                    credentialSection.getSection().setVisible(false);
                    Object layoutData = credentialSection.getSection().getLayoutData();
                    if (layoutData instanceof GridData) {
                        ((GridData)layoutData).exclude = true;
                    }
                    ((Composite)this.getControl()).layout();
                    credentialSection.initialize((IProgressMonitor)new NullProgressMonitor());
                    credentialSection.initializationComplete();
                    credentialSection.applyProperties(workingCopy);
                    this.configuration.setChosenDefinition(workingCopy);
                }
                catch (Exception e) {
                    PromotionUIPlugin.log(e);
                }
            }
            this.buildOptionsAreCustomized = true;
        }
    }

    private RequestBuildSectionSite createRequestBuildSectionSite(final IBuildDefinition buildDefinition, final List<IBuildProperty> originalProperties) {
        return new RequestBuildSectionSite(){

            public void setProperty(String propertyName, Object value) {
            }

            public void revalidate() {
            }

            public void removeWarningMessage(Object id) {
            }

            public void removeErrorMessage(Object id) {
            }

            public void layoutChanged() {
            }

            public boolean isRebuild() {
                return false;
            }

            public boolean isPersonalBuild() {
                return false;
            }

            public ITeamRepository getTeamRepository() {
                return (ITeamRepository)buildDefinition.getOrigin();
            }

            public List<IBuildProperty> getOriginalBuildProperties() {
                return originalProperties;
            }

            public IBuildEngine getHandlingEngine() {
                return null;
            }

            public IBuildResult getBuildResult() {
                return null;
            }

            public IBuildRequest getBuildRequest() {
                return null;
            }

            public IBuildDefinition getBuildDefinition() {
                return buildDefinition;
            }

            public void addWarningMessage(Object id, String warningMessage) {
            }

            public void addErrorMessage(Object id, String errorMessage) {
            }
        };
    }

    private class ComputeWorkItemOptionJob
    extends UIUpdaterJob {
        private boolean disabled;

        private ComputeWorkItemOptionJob(String name) {
            super(name);
            this.disabled = false;
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            try {
                IProcessClientService processService;
                IClientProcess clientProcess;
                IProcessConfigurationData data;
                IProcessArea processArea = PromotionWorkItemWizardPage.this.getProcessArea();
                if (processArea != null && (data = (clientProcess = (processService = (IProcessClientService)PromotionWorkItemWizardPage.this.getTeamRepository().getClientLibrary(IProcessClientService.class)).getClientProcess(processArea, null)).getProjectConfigurationData("com.ibm.team.enterprise.process.configuration.promotion.resultWorkItem", null)) != null) {
                    IProcessConfigurationElement[] elements = data.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IProcessConfigurationElement element = elements[i];
                        if ("resultWorkItem".equals(element.getName())) {
                            this.disabled = Boolean.parseBoolean(element.getAttribute("disable"));
                        }
                        ++i;
                    }
                }
            }
            catch (TeamRepositoryException ex) {
                ex.printStackTrace();
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (this.disabled) {
                PromotionWorkItemWizardPage.this.openReportWorkItemButton.setSelection(false);
                PromotionWorkItemWizardPage.this.openReportWorkItemButton.setEnabled(false);
                PromotionWorkItemWizardPage.this.configuration.setOpenReportWorkItem(false);
            } else if (PromotionWorkItemWizardPage.this.settings == null) {
                PromotionWorkItemWizardPage.this.openReportWorkItemButton.setSelection(true);
            } else {
                String keyValue = PromotionWorkItemWizardPage.this.settings.get("isOpenReportWorkItem");
                PromotionWorkItemWizardPage.this.openReportWorkItemButton.setSelection(keyValue == null ? true : Boolean.valueOf(keyValue));
                PromotionWorkItemWizardPage.this.configuration.setOpenReportWorkItem(PromotionWorkItemWizardPage.this.openReportWorkItemButton.getSelection());
            }
            return super.runInUI(monitor);
        }
    }

    protected class WorkItemTableContentProvider
    extends AbstractWorkItemTableContentProvider {
        private List<IWorkItemHandle> contentList = null;

        protected WorkItemTableContentProvider() {
        }

        public Object[] getElements(Object arg0) {
            return this.contentList == null ? null : this.contentList.toArray();
        }

        public void dispose() {
            if (this.contentList != null) {
                this.contentList.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Object input = newInput;
            if (input != null) {
                if (this.contentList == null) {
                    this.contentList = new ArrayList<IWorkItemHandle>();
                } else if (!this.contentList.isEmpty()) {
                    this.contentList.clear();
                }
                if (input instanceof IWorkItemHandle) {
                    this.contentList.add((IWorkItemHandle)input);
                } else if (input instanceof List && ((List)input).get(0) instanceof IWorkItemHandle) {
                    this.contentList.addAll((List)input);
                }
            }
        }

        public List<IWorkItemHandle> getElementsAsList() {
            return this.contentList;
        }
    }

    protected class WorkItemTableLabelProvider
    extends AbstractWorkItemTableLabelProvider {
        private String currentText = null;

        protected WorkItemTableLabelProvider() {
        }

        public Image getColumnImage(Object item, int arg1) {
            return null;
        }

        public String getColumnText(Object item, final int col) {
            final IWorkItemHandle itemHandle = (IWorkItemHandle)item;
            final IWorkItemClient workItemClient = (IWorkItemClient)PromotionWorkItemWizardPage.this.configuration.getTeamRepository().getClientLibrary(IWorkItemClient.class);
            Job resolveWorkItemJob = new Job(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_JOBNAME_RESOLVEWORKITEM){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IWorkItem workItem = (IWorkItem)workItemClient.getAuditableCommon().resolveAuditable((IAuditableHandle)itemHandle, IWorkItem.FULL_PROFILE, null);
                        if (col == 0) {
                            int itemId = workItem.getId();
                            WorkItemTableLabelProvider.this.setCurrentText(String.valueOf(itemId));
                        } else {
                            WorkItemTableLabelProvider.this.setCurrentText(workItem.getHTMLSummary().getPlainText());
                        }
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            resolveWorkItemJob.setUser(false);
            resolveWorkItemJob.schedule();
            try {
                resolveWorkItemJob.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.getCurrentText();
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        private String getCurrentText() {
            return this.currentText;
        }

        private void setCurrentText(String currentText) {
            this.currentText = currentText;
        }
    }
}

