/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.wizards;

import com.ibm.team.enterprise.automation.common.internal.summary.NodeFactory;
import com.ibm.team.enterprise.automation.common.internal.summary.SummaryNode;
import com.ibm.team.enterprise.automation.common.summary.IChangeSetNode;
import com.ibm.team.enterprise.automation.common.summary.INode;
import com.ibm.team.enterprise.automation.common.summary.ISummaryNode;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractAutomationWorkItemSummaryWizardPage;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AutomationViewerFilter;
import com.ibm.team.enterprise.automation.internal.ui.wizards.IAutomationWizardConfiguration;
import com.ibm.team.enterprise.automation.ui.AutomationUtil;
import com.ibm.team.enterprise.build.client.promotion.IPromotionClient;
import com.ibm.team.enterprise.internal.promotion.ui.PromotionUIPlugin;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.enterprise.internal.promotion.ui.utils.BuildUtils;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.IPromotionWizardConfiguration;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class PromotionWorkItemSummaryWizardPage
extends AbstractAutomationWorkItemSummaryWizardPage {
    private ISummaryNode summaryNode;
    private IPromotionWizardConfiguration configuration;
    private String previousSettings;

    public PromotionWorkItemSummaryWizardPage(Shell parent, IPromotionWizardConfiguration config) {
        super(parent, (IAutomationWizardConfiguration)config);
        this.setImageDescriptor(PromotionUIPlugin.getImageDescriptor("icons/wizban/promotionsummary_wizban.gif"));
        this.configuration = config;
    }

    public void createCustomContent(Composite parent) {
    }

    protected ISummaryNode getSummaryNode() {
        String currSettings = this.createSettingsState();
        if (this.previousSettings == null || !this.previousSettings.equals(currSettings)) {
            this.summaryNode = null;
        }
        if (this.summaryNode == null) {
            this.previousSettings = currSettings;
            this.summaryNode = new SummaryNode("");
            this.summaryNode.addChild((INode)new SummaryNode(Messages.PromotionWorkItemImpactedFilesWizardPage_QUERYING_SUMMARY));
            Job job = new Job(Messages.PromotionWorkItemImpactedFilesWizardPage_QUERYING_SUMMARY){

                protected IStatus run(IProgressMonitor monitor) {
                    ItemHandleAwareHashSet<IWorkItemHandle> workItemHandles = PromotionWorkItemSummaryWizardPage.this.configuration.getAllWorkItems();
                    boolean isIncludeChildren = PromotionWorkItemSummaryWizardPage.this.configuration.isIncludeChildren();
                    ITeamRepository repository = PromotionWorkItemSummaryWizardPage.this.configuration.getTeamRepository();
                    IPromotionClient promotionClient = (IPromotionClient)repository.getClientLibrary(IPromotionClient.class);
                    try {
                        String[] excludes = PromotionWorkItemSummaryWizardPage.this.configuration.isIncludeImpactedFiles() ? PromotionWorkItemSummaryWizardPage.this.configuration.getExcludedImpactedFiles() : null;
                        String xmlContent = promotionClient.getWorkItemPromotionSummary2((IWorkItemHandle[])workItemHandles.toArray((Object[])new IWorkItemHandle[workItemHandles.size()]), isIncludeChildren, PromotionWorkItemSummaryWizardPage.this.configuration.isIncludeImpactedFiles(), excludes, PromotionWorkItemSummaryWizardPage.this.configuration.getChosenDefinition(), null);
                        PromotionWorkItemSummaryWizardPage.this.setSummaryNode(NodeFactory.getInstance().toSummary(xmlContent));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PromotionWorkItemSummaryWizardPage.this.summaryNode = (ISummaryNode)new SummaryNode("");
                        PromotionWorkItemSummaryWizardPage.this.summaryNode.addChild((INode)new SummaryNode(e.getLocalizedMessage()));
                    }
                    UIJob uiJob = new UIJob(Messages.PromotionWorkItemImpactedFilesWizardPage_UPDATING_UI_SUMMARY_JOB){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!PromotionWorkItemSummaryWizardPage.this.summaryTree.getControl().isDisposed()) {
                                PromotionWorkItemSummaryWizardPage.this.summaryTree.setInput((Object)PromotionWorkItemSummaryWizardPage.this.summaryNode);
                                PromotionWorkItemSummaryWizardPage.this.summaryTree.refresh();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.schedule();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return this.summaryNode;
    }

    private String createSettingsState() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.configuration.isIncludeChildren());
        buf.append('|');
        buf.append(this.configuration.isIncludeImpactedFiles());
        buf.append('|');
        if (this.configuration.isIncludeImpactedFiles() && this.configuration.getExcludedImpactedFiles() != null) {
            String[] stringArray = this.configuration.getExcludedImpactedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String excl = stringArray[n2];
                buf.append(excl);
                buf.append(' ');
                ++n2;
            }
            buf.append('|');
        }
        if (this.configuration.getChosenDefinition() != null) {
            buf.append(this.configuration.getChosenDefinition().getItemId().getUuidValue());
            buf.append('|');
        }
        ArrayList<IWorkItemHandle> sortedWorkItems = new ArrayList<IWorkItemHandle>((Collection<IWorkItemHandle>)this.configuration.getAllWorkItems());
        Collections.sort(sortedWorkItems, new Comparator<IWorkItemHandle>(){

            @Override
            public int compare(IWorkItemHandle object1, IWorkItemHandle object2) {
                return object1.getItemId().compareTo((Object)object2.getItemId());
            }
        });
        for (IWorkItemHandle wi : sortedWorkItems) {
            buf.append(wi.getItemId().getUuidValue());
            buf.append(',');
        }
        return buf.toString();
    }

    protected List<AutomationViewerFilter> getSummaryFilters() {
        List promotionFilters = super.getSummaryFilters();
        promotionFilters.add(new AutomationViewerFilter(Messages.PromotionWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_FILTER_CHANGESETS, (ViewerFilter)new AbstractAutomationChangeSetViewerFilter()));
        return promotionFilters;
    }

    protected String getHelpText() {
        return "com.ibm.team.build.ui.wizard_enterprise_promotion_workitem_summary";
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpText());
    }

    private void setSummaryNode(ISummaryNode summaryNode) {
        this.summaryNode = summaryNode;
    }

    protected void viewChangeSetsInChangeExplorer() {
        IWorkspaceHandle targetStreamHandle = BuildUtils.getTargetStream(this.configuration.getChosenDefinition(), this.configuration.getTeamRepository());
        AutomationUtil.openInChangeExplorer((List)this.collectChangeSets(), (IWorkspaceHandle)targetStreamHandle, (ITeamRepository)this.configuration.getTeamRepository(), (Shell)this.getShell());
    }

    class AbstractAutomationChangeSetViewerFilter
    extends ViewerFilter {
        AbstractAutomationChangeSetViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof IChangeSetNode);
        }
    }
}

