/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.client.promotion.IPromotionClient;
import com.ibm.team.enterprise.build.common.promotion.report.info.BuildMapValidationInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.ChangeSetValidationInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.IErrorInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.ReportInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.ValidationInfo;
import com.ibm.team.enterprise.internal.promotion.ui.PromotionUIPlugin;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.enterprise.internal.promotion.ui.utils.BuildUtils;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.IPromotionWizardConfiguration;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PromotionWorkItemPreviewWizardPage
extends WizardPage
implements SelectionListener {
    private final IPromotionWizardConfiguration configuration;
    private Button previewButton;
    private Button viewButton;
    private Button exportButton;
    private TreeViewer previewOutputTree;
    public static String OUTPUT_DIR = System.getProperty("java.io.tmpdir");
    private ReportInfo info = null;

    public PromotionWorkItemPreviewWizardPage(Shell parent, IPromotionWizardConfiguration config) {
        super("Work Item Preview Page");
        this.setImageDescriptor(PromotionUIPlugin.getImageDescriptor("icons/wizban/promotionpreview_wizban.gif"));
        this.configuration = config;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.PromotionWorkItemPreviewWizardPage_TITLE);
        this.setDescription(Messages.PromotionWorkItemPreviewWizardPage_DESCRIPTION);
        Composite dialogAreaComposite = new Composite(parent, 0);
        dialogAreaComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        dialogAreaComposite.setLayoutData((Object)GridDataFactory.fillDefaults().hint(400, -1).grab(true, false).create());
        this.createPreviewOutput(dialogAreaComposite);
        this.createPreviewContent(dialogAreaComposite);
        this.setControl((Control)dialogAreaComposite);
    }

    private void createPreviewContent(Composite parent) {
        Composite previewComposite = new Composite(parent, 0);
        previewComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(5, 5).create());
        previewComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label previewLabel = new Label(previewComposite, 64);
        previewLabel.setText(Messages.PromotionWorkItemPreviewWizardPage_LABEL_PREVIEW);
        previewLabel.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).align(4, 4).hint(400, -1).grab(true, true).create());
        previewComposite.pack();
        ((GridData)previewLabel.getLayoutData()).widthHint = previewLabel.getBounds().width;
        previewComposite.pack();
        Composite buttonComposite = new Composite(previewComposite, 0);
        buttonComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        buttonComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 4).create());
        this.previewButton = new Button(buttonComposite, 8);
        this.previewButton.setText(Messages.PromotionWorkItemPreviewWizardPage_BUTTON_PREVIEW);
        this.previewButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(0, 10).align(0x1000000, 4).create());
        this.previewButton.addSelectionListener((SelectionListener)this);
        this.viewButton = new Button(buttonComposite, 8);
        this.viewButton.setText(Messages.PromotionWorkItemPreviewWizardPage_BUTTON_VIEW);
        this.viewButton.setEnabled(false);
        this.viewButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(0, 10).align(0x1000000, 4).create());
        this.viewButton.addSelectionListener((SelectionListener)this);
        this.exportButton = new Button(buttonComposite, 8);
        this.exportButton.setText(Messages.PromotionWorkItemPreviewWizardPage_BUTTON_EXPORT);
        this.exportButton.setEnabled(false);
        this.exportButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(0, 10).align(0x1000000, 4).create());
        this.exportButton.addSelectionListener((SelectionListener)this);
    }

    private void createPreviewOutput(Composite parent) {
        Composite outputComposite = new Composite(parent, 0);
        outputComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        outputComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label outputLabel = new Label(outputComposite, 0);
        outputLabel.setText(Messages.PromotionWorkItemPreviewWizardPage_LABEL_OUTPUT);
        outputLabel.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).create());
        this.previewOutputTree = new TreeViewer(outputComposite);
        this.previewOutputTree.getTree().setEnabled(false);
        this.previewOutputTree.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).grab(true, true).create());
        this.previewOutputTree.setContentProvider((IContentProvider)new ITreeContentProvider(){
            private ReportInfo inputReport = null;
            private List<Object> elementList = null;

            public Object[] getElements(Object arg0) {
                return this.elementList.toArray();
            }

            public void dispose() {
                if (this.elementList != null) {
                    this.elementList.clear();
                }
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof ReportInfo) {
                    this.inputReport = (ReportInfo)newInput;
                }
                if (this.inputReport != null) {
                    ValidationInfo validationInfo = this.inputReport.getValidationInfo();
                    List buildMapInfoList = validationInfo.getBuildMapValidationInfos();
                    List changeSetInfoList = validationInfo.getChangeSetValidationInfos();
                    if (this.elementList == null) {
                        this.elementList = new ArrayList<Object>();
                    } else if (!this.elementList.isEmpty()) {
                        this.elementList.clear();
                    }
                    if (this.inputReport.getGeneralErrors().size() > 0) {
                        GeneralErrorNode generalErrorNode = new GeneralErrorNode(Messages.PromotionWorkItemPreviewWizardPage_LABEL_GENERAL_ERRORS);
                        generalErrorNode.addAllErrors(this.inputReport.getGeneralErrors());
                        this.elementList.add(generalErrorNode);
                    }
                    ChangeSetNode changeSetNode = new ChangeSetNode(Messages.PromotionWorkItemPreviewWizardPage_LABEL_CHANGESET_ERRORS);
                    changeSetNode.setChangeSetList(changeSetInfoList);
                    BuildMapNode buildMapNode = new BuildMapNode(Messages.PromotionWorkItemPreviewWizardPage_LABEL_BUILDMAP_ERRORS);
                    buildMapNode.setBuildMapList(buildMapInfoList);
                    this.elementList.add(changeSetNode);
                    this.elementList.add(buildMapNode);
                }
            }

            public Object[] getChildren(Object element) {
                if (element instanceof ChangeSetNode) {
                    return ((ChangeSetNode)element).getChangeSetList().toArray();
                }
                if (element instanceof BuildMapNode) {
                    return ((BuildMapNode)element).getBuildMapList().toArray();
                }
                if (element instanceof GeneralErrorNode) {
                    return ((GeneralErrorNode)element).getErrors().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof ChangeSetNode) {
                    return !((ChangeSetNode)element).getChangeSetList().isEmpty();
                }
                if (element instanceof BuildMapNode) {
                    return !((BuildMapNode)element).getBuildMapList().isEmpty();
                }
                if (element instanceof GeneralErrorNode) {
                    return !((GeneralErrorNode)element).getErrors().isEmpty();
                }
                return false;
            }

            class BuildMapNode
            implements IPreviewNode {
                private final String nodeLabel;
                private final Image nodeIcon;
                private List<BuildMapValidationInfo> buildMapList;

                BuildMapNode(String label) {
                    this.nodeLabel = label;
                    this.nodeIcon = PromotionUIPlugin.getImage("icons/obj16/wi_general.gif");
                    this.buildMapList = null;
                }

                public List<BuildMapValidationInfo> getBuildMapList() {
                    return this.buildMapList;
                }

                public void setBuildMapList(List<BuildMapValidationInfo> buildMapList) {
                    this.buildMapList = buildMapList;
                }

                @Override
                public String getNodeLabel() {
                    return this.nodeLabel;
                }

                @Override
                public Image getNodeIcon() {
                    return this.nodeIcon;
                }
            }

            class ChangeSetNode
            implements IPreviewNode {
                private final String nodeLabel;
                private final Image nodeIcon;
                private List<ChangeSetValidationInfo> changeSetList;

                ChangeSetNode(String label) {
                    this.nodeLabel = label;
                    this.changeSetList = null;
                    this.nodeIcon = PromotionUIPlugin.getImage("icons/obj16/assocchgset_obj.gif");
                }

                public List<ChangeSetValidationInfo> getChangeSetList() {
                    return this.changeSetList;
                }

                public void setChangeSetList(List<ChangeSetValidationInfo> changeSetList) {
                    if (changeSetList != null && changeSetList.size() > 0) {
                        ArrayList<ChangeSetValidationInfo> uniqueInfos = new ArrayList<ChangeSetValidationInfo>(changeSetList.size());
                        HashSet<String> seenMessages = new HashSet<String>(changeSetList.size());
                        for (ChangeSetValidationInfo next : changeSetList) {
                            if (!seenMessages.add(next.getErrorInfo().getErrorMessage())) continue;
                            uniqueInfos.add(next);
                        }
                        changeSetList = uniqueInfos;
                    }
                    this.changeSetList = changeSetList;
                }

                @Override
                public String getNodeLabel() {
                    return this.nodeLabel;
                }

                @Override
                public Image getNodeIcon() {
                    return this.nodeIcon;
                }
            }

            class GeneralErrorNode
            implements IPreviewNode {
                private final String label;
                private final List<String> errors;

                public GeneralErrorNode(String label) {
                    this.label = label;
                    this.errors = new ArrayList<String>();
                }

                @Override
                public Image getNodeIcon() {
                    return null;
                }

                @Override
                public String getNodeLabel() {
                    return this.label;
                }

                public List<String> getErrors() {
                    return this.errors;
                }

                public void addAllErrors(List<String> errors) {
                    this.errors.addAll(errors);
                }
            }
        });
        this.previewOutputTree.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IPreviewNode) {
                    return ((IPreviewNode)element).getNodeIcon();
                }
                return null;
            }

            public String getText(Object element) {
                IErrorInfo errorInfo = null;
                String errorMessage = Messages.PromotionWorkItemPreviewWizardPage_ERROR_UNSUPPORTED_OUTPUTTYPE;
                if (element instanceof IPreviewNode) {
                    return ((IPreviewNode)element).getNodeLabel();
                }
                if (element instanceof BuildMapValidationInfo) {
                    errorInfo = ((BuildMapValidationInfo)element).getErrorInfo();
                    errorMessage = errorInfo.getErrorMessage();
                } else if (element instanceof ChangeSetValidationInfo) {
                    errorInfo = ((ChangeSetValidationInfo)element).getErrorInfo();
                    errorMessage = errorInfo.getErrorMessage();
                } else if (element instanceof String) {
                    errorMessage = (String)element;
                }
                return errorMessage;
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void removeListener(ILabelProviderListener arg0) {
            }
        });
        new TooltipSupport(this.previewOutputTree.getControl(), true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                if (element instanceof BuildMapValidationInfo) {
                    return ((BuildMapValidationInfo)element).getErrorInfo().getErrorMessage();
                }
                if (element instanceof ChangeSetValidationInfo) {
                    return ((ChangeSetValidationInfo)element).getErrorInfo().getErrorMessage();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return null;
            }
        };
    }

    private void updateOutputControlState() {
        this.setErrorMessage(null);
    }

    public void widgetSelected(SelectionEvent event) {
        Object eventObject = event.getSource();
        if (eventObject == this.previewButton) {
            ITeamRepository targetRepository = this.configuration.getTeamRepository();
            final ItemHandleAwareHashSet<IWorkItemHandle> workItemHandles = this.configuration.getAllWorkItems();
            final IBuildDefinition promotionDefinition = this.configuration.getChosenDefinition();
            final IPromotionClient promotionClient = (IPromotionClient)targetRepository.getClientLibrary(IPromotionClient.class);
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("", -1);
                        try {
                            int maxLoop;
                            File file = null;
                            try {
                                File fileRoot = new File(OUTPUT_DIR);
                                if (!fileRoot.exists()) {
                                    fileRoot.mkdirs();
                                }
                                if (!(file = new File(String.valueOf(fileRoot.getCanonicalPath()) + File.separator + "tempOutput.html")).exists()) {
                                    file.createNewFile();
                                } else if (file.delete()) {
                                    file.createNewFile();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            if (PromotionWorkItemPreviewWizardPage.this.getReportInfo() != null) {
                                PromotionWorkItemPreviewWizardPage.this.setReportInfo(null);
                            }
                            if ((maxLoop = BuildUtils.getWorkItemPromotionMaxDelay()) <= 0) {
                                maxLoop = Integer.MAX_VALUE;
                            }
                            int count = 0;
                            String[] properties = new String[7];
                            properties[0] = String.valueOf(!PromotionWorkItemPreviewWizardPage.this.configuration.isSourceOnly());
                            properties[1] = String.valueOf(PromotionWorkItemPreviewWizardPage.this.configuration.isIncludeChildren());
                            properties[2] = String.valueOf(PromotionWorkItemPreviewWizardPage.this.configuration.isConsiderIgnoreChanges());
                            properties[3] = String.valueOf(true);
                            properties[4] = String.valueOf(PromotionWorkItemPreviewWizardPage.this.configuration.isIncludeImpactedFiles());
                            if (!PromotionWorkItemPreviewWizardPage.this.configuration.isIncludeImpactedFiles() || PromotionWorkItemPreviewWizardPage.this.configuration.getExcludedImpactedFiles() == null || PromotionWorkItemPreviewWizardPage.this.configuration.getExcludedImpactedFiles().length == 0) {
                                properties[5] = null;
                            } else {
                                StringBuilder buf = new StringBuilder(100);
                                String[] stringArray = PromotionWorkItemPreviewWizardPage.this.configuration.getExcludedImpactedFiles();
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String next = stringArray[n2];
                                    buf.append(next);
                                    buf.append(' ');
                                    ++n2;
                                }
                                properties[5] = buf.toString();
                            }
                            properties[6] = String.valueOf(PromotionWorkItemPreviewWizardPage.this.configuration.isIgnoreValidationErrorForImpactedFiles());
                            if (monitor.isCanceled()) {
                                return;
                            }
                            ReportInfo reportInfo = null;
                            String requestId = promotionClient.promoteWorkItems5((IWorkItemHandle[])workItemHandles.toArray((Object[])new IWorkItemHandle[0]), (IBuildDefinitionHandle)promotionDefinition, properties, null);
                            while (reportInfo == null && count++ < maxLoop) {
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                reportInfo = (ReportInfo)promotionClient.getPromoteWorkItemStatus(requestId, file, null, null);
                            }
                            if (monitor.isCanceled()) {
                                return;
                            }
                            try {
                                PromotionWorkItemPreviewWizardPage.this.setReportInfo(reportInfo);
                            }
                            catch (TeamRepositoryException e) {
                                PromotionWorkItemPreviewWizardPage.this.showErrorInUiThread(e);
                                PromotionUIPlugin.log(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
                if (this.info != null) {
                    this.previewOutputTree.getTree().setEnabled(true);
                    this.previewOutputTree.setInput((Object)this.info);
                    this.previewOutputTree.refresh();
                }
            }
            catch (InvocationTargetException e) {
                this.showErrorInUiThread(e);
                PromotionUIPlugin.log(e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            File outputFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "tempOutput.html");
            boolean outputSucceeded = outputFile.exists();
            this.viewButton.setEnabled(outputSucceeded);
            this.exportButton.setEnabled(outputSucceeded);
        } else if (eventObject == this.viewButton) {
            Display display = Display.getCurrent();
            Shell shell = new Shell(display, 66800);
            shell.setLayout((Layout)new GridLayout());
            File outputFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "tempOutput.html");
            Browser browser = new Browser((Composite)shell, 0);
            browser.setLayoutData((Object)new GridData(1808));
            if (outputFile.exists()) {
                try {
                    browser.setUrl(outputFile.toURL().toString());
                }
                catch (MalformedURLException e) {
                    MessageBox messageBox = new MessageBox(this.getShell(), 33);
                    messageBox.setMessage(Messages.PromotionWorkItemPreviewWizardPage_ERROR_BROWSERINIT_MESSAGE);
                    messageBox.setText(Messages.PromotionWorkItemPreviewWizardPage_ERROR_BROWSERINIT_BUTTON);
                    messageBox.open();
                    System.exit(-1);
                }
                shell.setText(Messages.PromotionWorkItemPreviewWizardPage_BUILDRESULTOUTPUT_TITLE);
                shell.open();
            } else {
                PromotionUIPlugin.log((IStatus)new Status(4, "com.ibm.team.enterprise.promotion.ui", Messages.PromotionWorkItemPreviewWizardPage_ERROR_OUTPUTFILE_EXIST));
            }
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            shell.dispose();
        } else if (eventObject == this.exportButton) {
            File outputFile;
            FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
            fileDialog.setText(Messages.PromotionWorkItemPreviewWizardPage_FILEDIALOG_SELECTFILE_REPORT);
            fileDialog.setFilterExtensions(new String[]{"*.html"});
            String filePath = fileDialog.open();
            if (filePath != null && filePath.lastIndexOf(".html") == -1) {
                filePath = filePath.concat(".html");
            }
            if (filePath != null && !filePath.equalsIgnoreCase("") && (outputFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "tempOutput.html")).exists()) {
                block37: {
                    File exportFile = new File(filePath);
                    FileInputStream fromStream = null;
                    FileOutputStream toStream = null;
                    try {
                        fromStream = new FileInputStream(outputFile);
                        toStream = new FileOutputStream(exportFile);
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    byte[] buffer = new byte[4096];
                    try {
                        try {
                            if (fromStream != null && toStream != null) {
                                int bytesRead;
                                while ((bytesRead = fromStream.read(buffer)) != -1) {
                                    toStream.write(buffer, 0, bytesRead);
                                }
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                fromStream.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            try {
                                toStream.close();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                            break block37;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            fromStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            toStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        fromStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        toStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                outputFile.delete();
            }
            this.updateOutputControlState();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateOutputControlState();
            String helpText = this.getHelpText();
            if (helpText != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpText());
            }
        }
    }

    private String getHelpText() {
        return "com.ibm.team.build.ui.wizard_enterprise_promotion_workitem_preview";
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpText());
    }

    private void setReportInfo(ReportInfo info) {
        this.info = info;
    }

    private ReportInfo getReportInfo() {
        return this.info;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void showErrorInUiThread(final Throwable t) {
        this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String errorMessage = NLS.bind((String)Messages.Promote_ErrorMessage2, (Object)t.getLocalizedMessage());
                MessageDialog.openError((Shell)PromotionWorkItemPreviewWizardPage.this.getContainer().getShell(), (String)Messages.Promote_ErrorLabel, (String)errorMessage);
            }
        });
    }

    static interface IPreviewNode {
        public String getNodeLabel();

        public Image getNodeIcon();
    }
}

