/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.wizards;

import com.ibm.team.enterprise.build.client.promotion.IPromotionClient;
import com.ibm.team.enterprise.internal.promotion.ui.PromotionUIPlugin;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.IPromotionWizardConfiguration;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class PromotionWorkItemImpactedFilesWizardPage
extends WizardPage {
    private IPromotionWizardConfiguration configuration;
    private TableViewer includeTableViewer;
    private TableViewer excludeTableViewer;
    private Button excludeSelectedButton;
    private Button includeSelectedButton;
    private Button excludeAllButton;
    private Button includeAllButton;
    private Button showFullPathsCheckbox;
    private JSONObject[] includedFiles;
    private JSONObject[] excludedFiles;
    private static final String[] FETCHING_IMPACTED_FILES = new String[]{Messages.PromotionWorkItemImpactedFilesWizardPage_QUERYING_IMPACTED_FILES};
    private static final JSONObject[] EMPTY_ELEMENTS = new JSONObject[0];
    private String previousSettings;

    public PromotionWorkItemImpactedFilesWizardPage(Shell parent, IPromotionWizardConfiguration config) {
        super("Work Item Impacted Files Page");
        this.configuration = config;
        this.setImageDescriptor(PromotionUIPlugin.getImageDescriptor("icons/wizban/promotionsummary_wizban.gif"));
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.PromotionWorkItemImpactedFilesWizardPage_TITLE);
        this.setDescription(Messages.PromotionWorkItemImpactedFilesWizardPage_DESCRIPTION);
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.horizontalSpacing = 5;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 3));
        this.createIncludeTable(comp);
        this.createButtons(comp);
        this.createExcludeTable(comp);
        this.showFullPathsCheckbox = new Button(comp, 32);
        this.showFullPathsCheckbox.setText(Messages.PromotionWorkItemImpactedFilesWizardPage_SHOW_FULL_PATHS_LABEL);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.showFullPathsCheckbox.setLayoutData((Object)gd);
        this.showFullPathsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromotionWorkItemImpactedFilesWizardPage.this.includeTableViewer.refresh();
                PromotionWorkItemImpactedFilesWizardPage.this.excludeTableViewer.refresh();
            }
        });
        this.updateButtons();
        this.setControl((Control)comp);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String currSettings = this.createSettingsState();
            if (this.previousSettings == null || !this.previousSettings.equals(currSettings)) {
                this.previousSettings = currSettings;
                this.includeTableViewer.setInput((Object)FETCHING_IMPACTED_FILES);
                this.includeTableViewer.refresh();
                Job job = new Job(Messages.PromotionWorkItemImpactedFilesWizardPage_QUERYING_IMPACTED_FILES){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ItemHandleAwareHashSet<IWorkItemHandle> workItemHandles = PromotionWorkItemImpactedFilesWizardPage.this.configuration.getAllWorkItems();
                            ITeamRepository repository = PromotionWorkItemImpactedFilesWizardPage.this.configuration.getTeamRepository();
                            IPromotionClient promotionClient = (IPromotionClient)repository.getClientLibrary(IPromotionClient.class);
                            String jsonData = promotionClient.getImpactedFiles((IWorkItemHandle[])workItemHandles.toArray((Object[])new IWorkItemHandle[workItemHandles.size()]), PromotionWorkItemImpactedFilesWizardPage.this.configuration.isIncludeChildren(), null, PromotionWorkItemImpactedFilesWizardPage.this.configuration.getChosenDefinition(), null);
                            JSONArray array = JSONArray.parse((Reader)new StringReader(jsonData));
                            if (PromotionWorkItemImpactedFilesWizardPage.this.excludedFiles != null && PromotionWorkItemImpactedFilesWizardPage.this.excludedFiles.length > 0) {
                                ArrayList<JSONObject> newExcluded = new ArrayList<JSONObject>();
                                int i = 0;
                                while (i < PromotionWorkItemImpactedFilesWizardPage.this.excludedFiles.length) {
                                    if (array.remove((Object)PromotionWorkItemImpactedFilesWizardPage.this.excludedFiles[i])) {
                                        newExcluded.add(PromotionWorkItemImpactedFilesWizardPage.this.excludedFiles[i]);
                                    }
                                    ++i;
                                }
                                PromotionWorkItemImpactedFilesWizardPage.this.excludedFiles = newExcluded.toArray(new JSONObject[newExcluded.size()]);
                                PromotionWorkItemImpactedFilesWizardPage.this.updateConfigurationExcludes();
                            }
                            PromotionWorkItemImpactedFilesWizardPage.this.includedFiles = (JSONObject[])array.toArray((Object[])new JSONObject[array.size()]);
                            UIJob uiJob = new UIJob(Messages.PromotionWorkItemImpactedFilesWizardPage_UPDATING_UI_IMPACTED_JOB){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    if (!PromotionWorkItemImpactedFilesWizardPage.this.includeTableViewer.getControl().isDisposed() && !PromotionWorkItemImpactedFilesWizardPage.this.excludeTableViewer.getControl().isDisposed()) {
                                        PromotionWorkItemImpactedFilesWizardPage.this.includeTableViewer.setInput((Object)PromotionWorkItemImpactedFilesWizardPage.this.includedFiles);
                                        PromotionWorkItemImpactedFilesWizardPage.this.excludeTableViewer.setInput((Object)PromotionWorkItemImpactedFilesWizardPage.this.excludedFiles);
                                        PromotionWorkItemImpactedFilesWizardPage.this.includeTableViewer.refresh();
                                        PromotionWorkItemImpactedFilesWizardPage.this.excludeTableViewer.refresh();
                                        PromotionWorkItemImpactedFilesWizardPage.this.updateButtons();
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            uiJob.schedule();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            UIJob uiJob = new UIJob(Messages.PromotionWorkItemImpactedFilesWizardPage_UPDATING_UI_IMPACTED_JOB){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    if (!PromotionWorkItemImpactedFilesWizardPage.this.includeTableViewer.getControl().isDisposed() && !PromotionWorkItemImpactedFilesWizardPage.this.excludeTableViewer.getControl().isDisposed()) {
                                        PromotionWorkItemImpactedFilesWizardPage.this.includeTableViewer.setInput((Object)e);
                                        PromotionWorkItemImpactedFilesWizardPage.this.includeTableViewer.refresh();
                                        PromotionWorkItemImpactedFilesWizardPage.this.updateButtons();
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            uiJob.schedule();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpText());
        }
    }

    private void updateConfigurationExcludes() {
        if (this.excludedFiles == null || this.excludedFiles.length == 0) {
            this.configuration.setExcludedImpactedFiles(null);
        } else {
            String[] excludes = new String[this.excludedFiles.length];
            int i = 0;
            while (i < this.excludedFiles.length) {
                excludes[i] = (String)this.excludedFiles[i].get((Object)"uuid");
                ++i;
            }
            this.configuration.setExcludedImpactedFiles(excludes);
        }
    }

    private String createSettingsState() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.configuration.isIncludeChildren());
        buf.append('|');
        buf.append(this.configuration.isIncludeImpactedFiles());
        buf.append('|');
        if (this.configuration.getChosenDefinition() != null) {
            buf.append(this.configuration.getChosenDefinition().getItemId().getUuidValue());
            buf.append('|');
        }
        ArrayList<IWorkItemHandle> sortedWorkItems = new ArrayList<IWorkItemHandle>((Collection<IWorkItemHandle>)this.configuration.getAllWorkItems());
        Collections.sort(sortedWorkItems, new Comparator<IWorkItemHandle>(){

            @Override
            public int compare(IWorkItemHandle object1, IWorkItemHandle object2) {
                return object1.getItemId().compareTo((Object)object2.getItemId());
            }
        });
        for (IWorkItemHandle wi : sortedWorkItems) {
            buf.append(wi.getItemId().getUuidValue());
            buf.append(',');
        }
        return buf.toString();
    }

    private void createIncludeTable(Composite parent) {
        Composite includetableComposite = new Composite(parent, 0);
        includetableComposite.setLayoutData((Object)new GridData(1808));
        this.includeTableViewer = new TableViewer(includetableComposite, 68354);
        this.includeTableViewer.getTable().setHeaderVisible(true);
        this.includeTableViewer.getTable().setLinesVisible(true);
        this.includeTableViewer.setLabelProvider((IBaseLabelProvider)new ImpactedFileLabelProvider());
        this.includeTableViewer.setContentProvider((IContentProvider)new IncludedContentProvider());
        this.includeTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PromotionWorkItemImpactedFilesWizardPage.this.updateButtons();
            }
        });
        this.includeTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PromotionWorkItemImpactedFilesWizardPage.this.excludeSelectedItems();
            }
        });
        TableViewerColumn column = new TableViewerColumn(this.includeTableViewer, 0);
        column.getColumn().setText(Messages.PromotionWorkItemImpactedFilesWizardPage_INCLUDED_FILES_LABEL);
        column.setLabelProvider((CellLabelProvider)new ImpactedFileLabelProvider());
        column.getColumn().addSelectionListener((SelectionListener)new ColumnListener(this.includeTableViewer));
        TableColumnLayout tcl = new TableColumnLayout();
        tcl.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        includetableComposite.setLayout((Layout)tcl);
        this.includeTableViewer.getTable().setSortColumn(this.includeTableViewer.getTable().getColumn(0));
        this.includeTableViewer.getTable().setSortDirection(128);
        this.includeTableViewer.setComparator((ViewerComparator)new TableSorter(this.includeTableViewer.getTable()));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.includeTableViewer, (int)2);
    }

    private void createExcludeTable(Composite parent) {
        Composite excludetableComposite = new Composite(parent, 0);
        excludetableComposite.setLayoutData((Object)new GridData(1808));
        this.excludeTableViewer = new TableViewer(excludetableComposite, 68354);
        this.excludeTableViewer.getTable().setHeaderVisible(true);
        this.excludeTableViewer.getTable().setLinesVisible(true);
        this.excludeTableViewer.setLabelProvider((IBaseLabelProvider)new ImpactedFileLabelProvider());
        this.excludeTableViewer.setContentProvider((IContentProvider)new ExcludedContentProvider());
        this.excludeTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PromotionWorkItemImpactedFilesWizardPage.this.updateButtons();
            }
        });
        this.excludeTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PromotionWorkItemImpactedFilesWizardPage.this.includeSelectedItems();
            }
        });
        TableViewerColumn column = new TableViewerColumn(this.excludeTableViewer, 0);
        column.getColumn().setText(Messages.PromotionWorkItemImpactedFilesWizardPage_EXCLUDED_FILES_LABEL);
        column.setLabelProvider((CellLabelProvider)new ImpactedFileLabelProvider());
        column.getColumn().addSelectionListener((SelectionListener)new ColumnListener(this.excludeTableViewer));
        TableColumnLayout tcl = new TableColumnLayout();
        tcl.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        excludetableComposite.setLayout((Layout)tcl);
        this.excludeTableViewer.getTable().setSortColumn(this.excludeTableViewer.getTable().getColumn(0));
        this.excludeTableViewer.getTable().setSortDirection(128);
        this.excludeTableViewer.setComparator((ViewerComparator)new TableSorter(this.excludeTableViewer.getTable()));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.excludeTableViewer, (int)2);
    }

    private void createButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayoutData((Object)new GridData(1028));
        GridLayout gl = new GridLayout(1, false);
        buttonsComposite.setLayout((Layout)gl);
        this.excludeSelectedButton = new Button(buttonsComposite, 8);
        this.excludeSelectedButton.setText(">");
        this.excludeSelectedButton.setLayoutData((Object)new GridData(768));
        this.excludeSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromotionWorkItemImpactedFilesWizardPage.this.excludeSelectedItems();
            }
        });
        this.includeSelectedButton = new Button(buttonsComposite, 8);
        this.includeSelectedButton.setText("<");
        this.includeSelectedButton.setLayoutData((Object)new GridData(768));
        this.includeSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromotionWorkItemImpactedFilesWizardPage.this.includeSelectedItems();
            }
        });
        new Label(buttonsComposite, 0);
        this.excludeAllButton = new Button(buttonsComposite, 8);
        this.excludeAllButton.setText(">>");
        this.excludeAllButton.setLayoutData((Object)new GridData(768));
        this.excludeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromotionWorkItemImpactedFilesWizardPage.this.excludeAllItems();
            }
        });
        this.includeAllButton = new Button(buttonsComposite, 8);
        this.includeAllButton.setText("<<");
        this.includeAllButton.setLayoutData((Object)new GridData(768));
        this.includeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromotionWorkItemImpactedFilesWizardPage.this.includeAllItems();
            }
        });
    }

    private void excludeSelectedItems() {
        ISelection selection = this.includeTableViewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            ArrayList<JSONObject> toMove = new ArrayList<JSONObject>();
            for (Object next : (IStructuredSelection)selection) {
                if (!(next instanceof JSONObject)) continue;
                toMove.add((JSONObject)next);
            }
            if (toMove.size() > 0) {
                if (this.includedFiles != null && this.includedFiles.length > 0) {
                    ArrayList<JSONObject> newIncluded = new ArrayList<JSONObject>(this.includedFiles.length);
                    JSONObject[] jSONObjectArray = this.includedFiles;
                    int n = this.includedFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JSONObject included = jSONObjectArray[n2];
                        if (!toMove.contains(included)) {
                            newIncluded.add(included);
                        }
                        ++n2;
                    }
                    JSONObject[] jSONObjectArray2 = this.includedFiles = newIncluded.size() == 0 ? null : newIncluded.toArray(new JSONObject[newIncluded.size()]);
                }
                if (this.excludedFiles != null && this.excludedFiles.length > 0) {
                    toMove.addAll(Arrays.asList(this.excludedFiles));
                }
                this.excludedFiles = toMove.toArray(new JSONObject[toMove.size()]);
                this.includeTableViewer.setInput((Object)this.includedFiles);
                this.excludeTableViewer.setInput((Object)this.excludedFiles);
                this.includeTableViewer.refresh();
                this.excludeTableViewer.refresh();
                this.updateButtons();
                this.updateConfigurationExcludes();
            }
        }
    }

    private void includeSelectedItems() {
        ISelection selection = this.excludeTableViewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            ArrayList<JSONObject> toMove = new ArrayList<JSONObject>();
            for (Object next : (IStructuredSelection)selection) {
                if (!(next instanceof JSONObject)) continue;
                toMove.add((JSONObject)next);
            }
            if (toMove.size() > 0) {
                if (this.excludedFiles != null && this.excludedFiles.length > 0) {
                    ArrayList<JSONObject> newExcluded = new ArrayList<JSONObject>(this.excludedFiles.length);
                    JSONObject[] jSONObjectArray = this.excludedFiles;
                    int n = this.excludedFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JSONObject excluded = jSONObjectArray[n2];
                        if (!toMove.contains(excluded)) {
                            newExcluded.add(excluded);
                        }
                        ++n2;
                    }
                    JSONObject[] jSONObjectArray2 = this.excludedFiles = newExcluded.size() == 0 ? null : newExcluded.toArray(new JSONObject[newExcluded.size()]);
                }
                if (this.includedFiles != null && this.includedFiles.length > 0) {
                    toMove.addAll(Arrays.asList(this.includedFiles));
                }
                this.includedFiles = toMove.toArray(new JSONObject[toMove.size()]);
                this.includeTableViewer.setInput((Object)this.includedFiles);
                this.excludeTableViewer.setInput((Object)this.excludedFiles);
                this.includeTableViewer.refresh();
                this.excludeTableViewer.refresh();
                this.updateButtons();
                this.updateConfigurationExcludes();
            }
        }
    }

    private void excludeAllItems() {
        if (this.includedFiles != null && this.includedFiles.length > 0) {
            if (this.excludedFiles == null || this.excludedFiles.length == 0) {
                this.excludedFiles = this.includedFiles;
            } else {
                JSONObject[] temp = new JSONObject[this.includedFiles.length + this.excludedFiles.length];
                System.arraycopy(this.includedFiles, 0, temp, 0, this.includedFiles.length);
                System.arraycopy(this.excludedFiles, 0, temp, this.includedFiles.length, this.excludedFiles.length);
                this.excludedFiles = temp;
            }
            this.includedFiles = null;
            this.includeTableViewer.setInput((Object)this.includedFiles);
            this.excludeTableViewer.setInput((Object)this.excludedFiles);
            this.includeTableViewer.refresh();
            this.excludeTableViewer.refresh();
            this.updateButtons();
            this.updateConfigurationExcludes();
        }
    }

    private void includeAllItems() {
        if (this.excludedFiles != null && this.excludedFiles.length > 0) {
            if (this.includedFiles == null || this.includedFiles.length == 0) {
                this.includedFiles = this.excludedFiles;
            } else {
                JSONObject[] temp = new JSONObject[this.excludedFiles.length + this.includedFiles.length];
                System.arraycopy(this.excludedFiles, 0, temp, 0, this.excludedFiles.length);
                System.arraycopy(this.includedFiles, 0, temp, this.excludedFiles.length, this.includedFiles.length);
                this.includedFiles = temp;
            }
            this.excludedFiles = null;
            this.includeTableViewer.setInput((Object)this.includedFiles);
            this.excludeTableViewer.setInput((Object)this.excludedFiles);
            this.includeTableViewer.refresh();
            this.excludeTableViewer.refresh();
            this.updateButtons();
            this.updateConfigurationExcludes();
        }
    }

    private void updateButtons() {
        if (this.includeTableViewer.getInput() == FETCHING_IMPACTED_FILES) {
            this.excludeSelectedButton.setEnabled(false);
            this.includeSelectedButton.setEnabled(false);
            this.excludeAllButton.setEnabled(false);
            this.includeAllButton.setEnabled(false);
        } else {
            this.excludeSelectedButton.setEnabled(!this.includeTableViewer.getSelection().isEmpty());
            this.includeSelectedButton.setEnabled(!this.excludeTableViewer.getSelection().isEmpty());
            this.excludeAllButton.setEnabled(this.includedFiles != null && this.includedFiles.length > 0);
            this.includeAllButton.setEnabled(this.excludedFiles != null && this.excludedFiles.length > 0);
        }
    }

    public String getHelpText() {
        return "com.ibm.team.build.ui.wizard_enterprise_promotion_workitem_impacted";
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpText());
    }

    private class ColumnListener
    extends SelectionAdapter {
        TableViewer viewer;

        public ColumnListener(TableViewer tableViewer) {
            this.viewer = tableViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.viewer.getTable().getSortDirection() == 1024) {
                this.viewer.getTable().setSortDirection(128);
            } else {
                this.viewer.getTable().setSortDirection(1024);
            }
            this.viewer.refresh();
        }
    }

    private class ExcludedContentProvider
    implements IStructuredContentProvider {
        private ExcludedContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return PromotionWorkItemImpactedFilesWizardPage.this.excludedFiles == null ? EMPTY_ELEMENTS : PromotionWorkItemImpactedFilesWizardPage.this.excludedFiles;
        }
    }

    private class ImpactedFileLabelProvider
    extends ColumnLabelProvider {
        private ImpactedFileLabelProvider() {
        }

        public String getText(Object element) {
            Object path;
            if (element instanceof JSONObject && (path = ((JSONObject)element).get((Object)"path")) instanceof String) {
                int lastSlash;
                if (!PromotionWorkItemImpactedFilesWizardPage.this.showFullPathsCheckbox.isDisposed() && !PromotionWorkItemImpactedFilesWizardPage.this.showFullPathsCheckbox.getSelection() && (lastSlash = ((String)path).lastIndexOf(47)) != -1) {
                    path = ((String)path).substring(lastSlash + 1);
                }
                return (String)path;
            }
            return super.getText(element);
        }

        public String getToolTipText(Object element) {
            Object path;
            if (element instanceof JSONObject && (path = ((JSONObject)element).get((Object)"path")) instanceof String) {
                return (String)path;
            }
            if (element instanceof String) {
                return (String)element;
            }
            return super.getToolTipText(element);
        }
    }

    private class IncludedContentProvider
    implements IStructuredContentProvider {
        private IncludedContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == FETCHING_IMPACTED_FILES) {
                return FETCHING_IMPACTED_FILES;
            }
            if (inputElement instanceof Throwable) {
                return new String[]{((Throwable)inputElement).getLocalizedMessage()};
            }
            return PromotionWorkItemImpactedFilesWizardPage.this.includedFiles == null ? EMPTY_ELEMENTS : PromotionWorkItemImpactedFilesWizardPage.this.includedFiles;
        }
    }

    private class TableSorter
    extends ViewerSorter {
        Table table;

        public TableSorter(Table table) {
            this.table = table;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = super.compare(viewer, e1, e2);
            if (this.table.getSortDirection() == 1024) {
                result *= -1;
            }
            return result;
        }
    }
}

