/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.automation.common.internal.summary.NodeFactory;
import com.ibm.team.enterprise.automation.common.summary.IChangeSetNode;
import com.ibm.team.enterprise.automation.common.summary.INode;
import com.ibm.team.enterprise.automation.common.summary.ISummaryNode;
import com.ibm.team.enterprise.automation.common.summary.IWorkItemNode;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.enterprise.automation.internal.ui.wizards.SummaryTreeContentProvider;
import com.ibm.team.enterprise.automation.internal.ui.wizards.SummaryTreeLabelProvider;
import com.ibm.team.enterprise.automation.ui.AutomationUIPlugin;
import com.ibm.team.enterprise.automation.ui.AutomationUtil;
import com.ibm.team.enterprise.build.client.promotion.IPromotionClient;
import com.ibm.team.enterprise.internal.promotion.ui.PromotionUIPlugin;
import com.ibm.team.enterprise.internal.promotion.ui.utils.BuildUtils;
import com.ibm.team.enterprise.internal.promotion.ui.wizards.IPromotionWizardConfiguration;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class PromotionWorkItemChangeSetAnalysisWizardPage
extends WizardPage {
    private IPromotionWizardConfiguration configuration;
    private IChangeSetHandle[] gapFillers;
    private ISummaryNode treeInputRoot;
    private ILinkManager linkManager;
    private List<UUID> selectedWorkItems;
    private String previousSettings;
    private Job currentJob;
    private Composite dialogAreaComposite;
    private Label mainMessage;
    private Composite rerunComposite;
    private Composite gapHandlingComposite;
    private CheckboxTreeViewer treeViewer;
    private GapTreeCheckStateListener checkStateListener;
    private Composite warningComposite;
    private Image changeSetWarningImage;

    public PromotionWorkItemChangeSetAnalysisWizardPage(Shell parent, IPromotionWizardConfiguration config) {
        super("Work Item Change Set Analysis Page");
        this.configuration = config;
        this.linkManager = (ILinkManager)config.getTeamRepository().getClientLibrary(ILinkManager.class);
        this.selectedWorkItems = new ArrayList<UUID>();
        this.setImageDescriptor(PromotionUIPlugin.getImageDescriptor("icons/wizban/promotionsummary_wizban.gif"));
    }

    public void createControl(Composite parent) {
        this.setTitle(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_TITLE);
        this.setDescription(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_DESC);
        this.dialogAreaComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.dialogAreaComposite);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, -1).applyTo((Control)this.dialogAreaComposite);
        this.mainMessage = new Label(this.dialogAreaComposite, 64);
        GridDataFactory.swtDefaults().grab(true, false).align(1, 128).applyTo((Control)this.mainMessage);
        this.createGapHandlingComposite(this.dialogAreaComposite);
        this.rerunComposite = new Composite(this.dialogAreaComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.rerunComposite);
        GridDataFactory.fillDefaults().grab(true, false).hint(400, -1).applyTo((Control)this.rerunComposite);
        Link rerunLink = new Link(this.rerunComposite, 16384);
        rerunLink.setText("<a>" + com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_RERUN_ANALYSIS_LINK + "</a>");
        rerunLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromotionWorkItemChangeSetAnalysisWizardPage.this.runAnalysis();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).indent(0, 15).align(1, 1024).applyTo((Control)rerunLink);
        Label rerunLabel = new Label(this.rerunComposite, 64);
        rerunLabel.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_RERUN_ANALYSIS_DESC);
        GridDataFactory.swtDefaults().grab(true, false).align(1, 128).applyTo((Control)rerunLabel);
        this.setControl((Control)this.dialogAreaComposite);
    }

    private void createGapHandlingComposite(Composite parent) {
        this.gapHandlingComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.gapHandlingComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.gapHandlingComposite);
        Composite warningAndToolbarComposite = new Composite(this.gapHandlingComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(warningAndToolbarComposite);
        GridDataFactory.fillDefaults().grab(true, false).indent(0, 10).applyTo((Control)warningAndToolbarComposite);
        this.warningComposite = new Composite(warningAndToolbarComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.warningComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 1024).hint(400, -1).applyTo((Control)this.warningComposite);
        this.warningComposite.setVisible(false);
        Label warningImage = new Label(this.warningComposite, 0);
        warningImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        Label warningMessage = new Label(this.warningComposite, 64);
        GridDataFactory.fillDefaults().align(1, 1024).applyTo((Control)warningImage);
        warningMessage.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_GAPS_REMAIN);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 1024).applyTo((Control)warningMessage);
        ToolBar treeToolBar = new ToolBar(warningAndToolbarComposite, 0x800100);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000008, 1024).applyTo((Control)treeToolBar);
        ToolItem expandItem = new ToolItem(treeToolBar, 0x800008);
        expandItem.setImage(AutomationUIPlugin.getImage((String)"icons/obj16/expandall_small.gif"));
        expandItem.setToolTipText(Messages.AbstractAutomationWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_EXPANDALL);
        expandItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.expandAll();
            }
        });
        ToolItem collapseItem = new ToolItem(treeToolBar, 0x800008);
        collapseItem.setImage(AutomationUIPlugin.getImage((String)"icons/obj16/collapseall_small.gif"));
        collapseItem.setToolTipText(Messages.AbstractAutomationWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_COLLAPSEALL);
        collapseItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.collapseAll();
            }
        });
        this.treeViewer = new CheckboxTreeViewer(this.gapHandlingComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.treeViewer.getTree());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new GapTreeLabelProvider()){

            public String getToolTipText(Object element) {
                if (!(element instanceof INode)) {
                    return null;
                }
                INode node = (INode)element;
                if (node.getType() == INode.Type.CHANGESET) {
                    if (node.getChildren().size() == 1 && ((INode)node.getChildren().get(0)).getNodeId() == null) {
                        return com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_TOOLTIP_NO_WORKITEM_ASSOCIATED;
                    }
                    if (node.getParent().getType() == INode.Type.WORKITEM) {
                        return com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_TOOLTIP_CHANGESET;
                    }
                    if (!PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.getChecked((Object)node) && !PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.getGrayed((Object)node)) {
                        return com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_TOOLTIP_SELECT_A_WORKITEM;
                    }
                } else if (node.getType() == INode.Type.WORKITEM && node.getNodeId() == null) {
                    return com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_TOOLTIP_NO_WORKITEM_ASSOCIATED;
                }
                return null;
            }

            public boolean useNativeToolTip(Object object) {
                return true;
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new SummaryTreeContentProvider());
        this.checkStateListener = new GapTreeCheckStateListener();
        this.treeViewer.addCheckStateListener((ICheckStateListener)this.checkStateListener);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        Composite viewChangesComposite = new Composite(this.gapHandlingComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(viewChangesComposite);
        GridDataFactory.fillDefaults().grab(true, false).hint(400, -1).applyTo((Control)viewChangesComposite);
        Label viewChangesImage = new Label(viewChangesComposite, 0);
        viewChangesImage.setImage(AutomationUIPlugin.getImage((String)"icons/obj16/assocchgset_obj.gif"));
        GridDataFactory.swtDefaults().align(1, 128).span(1, 2).applyTo((Control)viewChangesImage);
        Link viewChangesLink = new Link(viewChangesComposite, 64);
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)viewChangesLink);
        viewChangesLink.setText("<a>" + Messages.AbstractAutomationWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_VIEWCHANGESET + "</a>");
        viewChangesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionWorkItemChangeSetAnalysisWizardPage.this.treeInputRoot == null) {
                    return;
                }
                ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
                this.collectChangeSets((INode)PromotionWorkItemChangeSetAnalysisWizardPage.this.treeInputRoot, changeSets, new HashSet<UUID>());
                IWorkspaceHandle targetStreamHandle = BuildUtils.getTargetStream(PromotionWorkItemChangeSetAnalysisWizardPage.this.configuration.getChosenDefinition(), PromotionWorkItemChangeSetAnalysisWizardPage.this.configuration.getTeamRepository());
                AutomationUtil.openInChangeExplorer(changeSets, (IWorkspaceHandle)targetStreamHandle, (ITeamRepository)PromotionWorkItemChangeSetAnalysisWizardPage.this.configuration.getTeamRepository(), (Shell)PromotionWorkItemChangeSetAnalysisWizardPage.this.getShell());
            }

            private void collectChangeSets(INode node, List<IChangeSetHandle> changeSets, Set<UUID> seen) {
                if (seen.contains(node.getNodeId())) {
                    return;
                }
                seen.add(node.getNodeId());
                if (node.getType() == INode.Type.CHANGESET) {
                    changeSets.add((IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(node.getNodeId(), null));
                }
                for (INode kid : node.getChildren()) {
                    this.collectChangeSets(kid, changeSets, seen);
                }
            }
        });
        Label viewChangesDesc = new Label(viewChangesComposite, 64);
        viewChangesDesc.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_VIEW_CHANGESETS_DESC);
        GridDataFactory.swtDefaults().grab(true, false).align(1, 128).applyTo((Control)viewChangesDesc);
    }

    private void associateWorkItems(final INode node) {
        if (!(node instanceof IChangeSetNode) || node.getNodeId() == null) {
            return;
        }
        final IWorkItemHandle[] selectedWorkItems = WorkItemSelectionDialog.getWorkItems((Shell)this.getShell(), (ITeamRepository)this.configuration.getTeamRepository());
        if (selectedWorkItems != null && selectedWorkItems.length > 0) {
            Job job = new Job(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_ASSOCIATING_WORKITEMS_JOB){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)PromotionWorkItemChangeSetAnalysisWizardPage.this.configuration.getTeamRepository().getClientLibrary(IFileSystemWorkItemManager.class);
                        IChangeSetHandle csHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(node.getNodeId(), null);
                        workItemManager.createLink(null, csHandle, selectedWorkItems, monitor);
                        IChangeSet changeSet = (IChangeSet)PromotionWorkItemChangeSetAnalysisWizardPage.this.configuration.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)csHandle, 0, Arrays.asList(IChangeSet.COMMENT_PROPERTY, IChangeSet.LAST_CHANGED_DATE_PROPERTY), monitor);
                        node.getChildren().clear();
                        PromotionWorkItemChangeSetAnalysisWizardPage.this.createLinkedWorkItemNodes(changeSet, node, PromotionWorkItemChangeSetAnalysisWizardPage.this.configuration.getTeamRepository(), PromotionWorkItemChangeSetAnalysisWizardPage.this.linkManager, monitor);
                        UIJob uiJob = new UIJob(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_UPDATING_UI_JOB){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.getTree().isDisposed()) {
                                    return Status.CANCEL_STATUS;
                                }
                                PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.refresh((Object)node);
                                PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.setSubtreeChecked((Object)node, true);
                                PromotionWorkItemChangeSetAnalysisWizardPage.this.handleWorkItemNodesChanged(node.getChildren());
                                PromotionWorkItemChangeSetAnalysisWizardPage.this.updateWarningVisibility();
                                return Status.OK_STATUS;
                            }
                        };
                        uiJob.schedule();
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                        PromotionWorkItemChangeSetAnalysisWizardPage.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Status error = new Status(4, "com.ibm.team.enterprise.promotion.ui", e.getLocalizedMessage(), (Throwable)e);
                                ErrorDialog.openError((Shell)PromotionWorkItemChangeSetAnalysisWizardPage.this.getShell(), (String)com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_ASSOCIATE_WORK_ITEM_ERROR_TITLE, (String)com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_ASSOCIATE_WORK_ITEM_ERROR_DESC, (IStatus)error, (int)4);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String currSettings = this.createSettingsState();
            if (this.previousSettings == null || !this.previousSettings.equals(currSettings)) {
                this.previousSettings = currSettings;
                this.runAnalysis();
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpText());
        }
    }

    public void setPreviousPage(IWizardPage page) {
    }

    public void runAnalysisOnNextView() {
        this.previousSettings = null;
    }

    protected void runAnalysis() {
        Job job;
        this.mainMessage.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_RUNNING_ANALYSIS_LABEL);
        this.rerunComposite.setVisible(false);
        this.gapHandlingComposite.setVisible(false);
        this.gapFillers = null;
        this.configuration.getAdditionalWorkItems().clear();
        this.dialogAreaComposite.layout();
        if (this.currentJob != null && this.currentJob.getState() == 4) {
            this.currentJob.cancel();
        }
        this.currentJob = job = new Job(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_RUNNING_ANALYSIS_LABEL){
            boolean canceled;

            protected IStatus run(IProgressMonitor monitor) {
                final Exception[] caughtEx = new Exception[1];
                try {
                    if (this.canceled) {
                        return Status.CANCEL_STATUS;
                    }
                    List workItemHandles = PromotionWorkItemChangeSetAnalysisWizardPage.this.configuration.getSelectionResult();
                    IPromotionClient promotionClient = (IPromotionClient)PromotionWorkItemChangeSetAnalysisWizardPage.this.configuration.getTeamRepository().getClientLibrary(IPromotionClient.class);
                    PromotionWorkItemChangeSetAnalysisWizardPage.this.gapFillers = promotionClient.checkForGaps(workItemHandles.toArray(new IWorkItemHandle[workItemHandles.size()]), PromotionWorkItemChangeSetAnalysisWizardPage.this.configuration.isIncludeChildren(), (IBuildDefinitionHandle)PromotionWorkItemChangeSetAnalysisWizardPage.this.configuration.getChosenDefinition().getItemHandle(), monitor);
                    PromotionWorkItemChangeSetAnalysisWizardPage.this.updateInput(monitor);
                }
                catch (Exception e) {
                    if (e instanceof OperationCanceledException) {
                        this.canceled = true;
                    }
                    e.printStackTrace();
                    caughtEx[0] = e;
                }
                if (this.canceled) {
                    return Status.CANCEL_STATUS;
                }
                UIJob uiJob = new UIJob(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_UPDATING_UI_JOB){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (canceled || PromotionWorkItemChangeSetAnalysisWizardPage.this.mainMessage.isDisposed()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (caughtEx[0] != null) {
                            PromotionWorkItemChangeSetAnalysisWizardPage.this.mainMessage.setText(NLS.bind((String)com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_ANALYSIS_ERROR, (Object)caughtEx[0].getLocalizedMessage()));
                        } else if (PromotionWorkItemChangeSetAnalysisWizardPage.this.gapFillers == null) {
                            PromotionWorkItemChangeSetAnalysisWizardPage.this.mainMessage.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_ANALYSIS_FAILED);
                        } else if (PromotionWorkItemChangeSetAnalysisWizardPage.this.gapFillers.length == 0) {
                            PromotionWorkItemChangeSetAnalysisWizardPage.this.mainMessage.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_NO_GAPS_FOUND);
                        } else {
                            PromotionWorkItemChangeSetAnalysisWizardPage.this.mainMessage.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_GAPS_FOUND);
                            PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.setInput((Object)PromotionWorkItemChangeSetAnalysisWizardPage.this.treeInputRoot);
                            PromotionWorkItemChangeSetAnalysisWizardPage.this.setInitialCheckedStates();
                            PromotionWorkItemChangeSetAnalysisWizardPage.this.gapHandlingComposite.setVisible(true);
                        }
                        PromotionWorkItemChangeSetAnalysisWizardPage.this.updateWarningVisibility();
                        PromotionWorkItemChangeSetAnalysisWizardPage.this.rerunComposite.setVisible(true);
                        PromotionWorkItemChangeSetAnalysisWizardPage.this.dialogAreaComposite.layout();
                        return Status.OK_STATUS;
                    }
                };
                uiJob.schedule();
                return Status.OK_STATUS;
            }

            protected void canceling() {
                super.canceling();
                this.canceled = true;
            }
        };
        this.currentJob.schedule();
    }

    private void updateWarningVisibility() {
        if (this.treeInputRoot != null) {
            boolean visible = false;
            for (INode csNode : this.treeInputRoot.getChildren()) {
                if (this.treeViewer.getChecked((Object)csNode) || this.treeViewer.getGrayed((Object)csNode)) continue;
                visible = true;
                break;
            }
            this.warningComposite.setVisible(visible);
        }
    }

    private void updateInput(IProgressMonitor monitor) throws TeamRepositoryException {
        this.treeInputRoot = NodeFactory.getInstance().createSummaryNode();
        if (this.gapFillers != null && this.gapFillers.length > 0) {
            List resolvedChangeSets = this.configuration.getTeamRepository().itemManager().fetchPartialItems(Arrays.asList(this.gapFillers), 0, Arrays.asList(IChangeSet.COMMENT_PROPERTY, IChangeSet.LAST_CHANGED_DATE_PROPERTY), monitor);
            for (IChangeSet gapFiller : resolvedChangeSets) {
                IChangeSetNode gapFillerNode = NodeFactory.getInstance().createChangeSetNode((INode)this.treeInputRoot, gapFiller);
                this.createLinkedWorkItemNodes(gapFiller, (INode)gapFillerNode, this.configuration.getTeamRepository(), this.linkManager, monitor);
            }
            Collections.sort(this.treeInputRoot.getChildren(), new Comparator<INode>(){

                @Override
                public int compare(INode object1, INode object2) {
                    return object1.getLabel().compareTo(object2.getLabel());
                }
            });
        }
    }

    private void createLinkedWorkItemNodes(IChangeSet changeSet, INode changeSetNode, ITeamRepository repository, ILinkManager linkManager, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IWorkItem> workItems = this.getWorkItemsForChangeSet(changeSet, linkManager, repository, monitor);
        if (workItems == null || workItems.size() == 0) {
            NodeFactory.getInstance().createWorkItemNode(changeSetNode, com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_NO_WORK_ITEM_ASSOCIATED);
        } else {
            for (IWorkItem wi : workItems) {
                IWorkItemNode wiNode = NodeFactory.getInstance().createWorkItemNode(changeSetNode, wi);
                List<IChangeSet> allChangeSets = this.getChangeSetsForWorkItem(wi, linkManager, repository, monitor);
                if (allChangeSets != null) {
                    for (IChangeSet cs : allChangeSets) {
                        NodeFactory.getInstance().createChangeSetNode((INode)wiNode, cs);
                    }
                }
                Collections.sort(wiNode.getChildren(), new Comparator<INode>(){

                    @Override
                    public int compare(INode object1, INode object2) {
                        return object1.getLabel().compareTo(object2.getLabel());
                    }
                });
            }
            Collections.sort(changeSetNode.getChildren(), new Comparator<INode>(){

                @Override
                public int compare(INode object1, INode object2) {
                    return object1.getLabel().compareTo(object2.getLabel());
                }
            });
        }
    }

    private List<IWorkItem> getWorkItemsForChangeSet(IChangeSet changeSet, ILinkManager linkManager, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemReference reference = linkManager.referenceFactory().createReferenceToItem((IItemHandle)changeSet);
        ILinkQueryPage results = linkManager.findLinksBySource(new String[]{"com.ibm.team.filesystem.workitems.change_set"}, (IReference)reference, monitor);
        ILinkCollection links = results.getAllLinksFromHereOn();
        if (links.isEmpty()) {
            return null;
        }
        ArrayList<IWorkItemHandle> workItemHandles = new ArrayList<IWorkItemHandle>(links.size());
        for (ILink link : links) {
            Object resolved = link.getTargetRef().resolve();
            if (!(resolved instanceof IWorkItemHandle)) continue;
            workItemHandles.add((IWorkItemHandle)resolved);
        }
        if (workItemHandles.isEmpty()) {
            return null;
        }
        return repository.itemManager().fetchPartialItems(workItemHandles, 0, Arrays.asList(IWorkItem.SUMMARY_PROPERTY, IWorkItem.ID_PROPERTY), monitor);
    }

    private List<IChangeSet> getChangeSetsForWorkItem(IWorkItem workItem, ILinkManager linkManager, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemReference reference = linkManager.referenceFactory().createReferenceToItem((IItemHandle)workItem);
        ILinkQueryPage results = linkManager.findLinksByTarget(new String[]{"com.ibm.team.filesystem.workitems.change_set"}, (IReference)reference, monitor);
        ILinkCollection links = results.getAllLinksFromHereOn();
        if (links.isEmpty()) {
            return null;
        }
        ArrayList<IChangeSetHandle> changeSetHandles = new ArrayList<IChangeSetHandle>(links.size());
        for (ILink link : links) {
            Object resolved = link.getSourceRef().resolve();
            if (!(resolved instanceof IChangeSetHandle)) continue;
            changeSetHandles.add((IChangeSetHandle)resolved);
        }
        if (changeSetHandles.isEmpty()) {
            return null;
        }
        return repository.itemManager().fetchPartialItems(changeSetHandles, 0, Arrays.asList(IChangeSet.COMMENT_PROPERTY, IChangeSet.LAST_CHANGED_DATE_PROPERTY), monitor);
    }

    private String createSettingsState() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.configuration.isIncludeChildren());
        buf.append('|');
        if (this.configuration.getChosenDefinition() != null) {
            buf.append(this.configuration.getChosenDefinition().getItemId().getUuidValue());
            buf.append('|');
        }
        ArrayList sortedWorkItems = new ArrayList(this.configuration.getSelectionResult());
        Collections.sort(sortedWorkItems, new Comparator<IWorkItemHandle>(){

            @Override
            public int compare(IWorkItemHandle object1, IWorkItemHandle object2) {
                return object1.getItemId().compareTo((Object)object2.getItemId());
            }
        });
        for (IWorkItemHandle wi : sortedWorkItems) {
            buf.append(wi.getItemId().getUuidValue());
            buf.append(',');
        }
        return buf.toString();
    }

    protected String getHelpText() {
        return "com.ibm.team.build.ui.wizard_enterprise_promotion_workitem_analysis";
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpText());
    }

    public void dispose() {
        super.dispose();
        if (this.currentJob != null) {
            this.currentJob.cancel();
        }
        if (this.changeSetWarningImage != null) {
            this.changeSetWarningImage.dispose();
            this.changeSetWarningImage = null;
        }
    }

    private void setInitialCheckedStates() {
        Iterator<UUID> it = this.selectedWorkItems.iterator();
        while (it.hasNext()) {
            UUID uuid = it.next();
            INode matchingNode = null;
            for (INode csNode : this.treeInputRoot.getChildren()) {
                for (INode wiNode : csNode.getChildren()) {
                    if (!uuid.equals((Object)wiNode.getNodeId())) continue;
                    matchingNode = wiNode;
                    break;
                }
                if (matchingNode != null) break;
            }
            if (matchingNode != null) {
                this.treeViewer.setChecked(matchingNode, true);
                this.checkStateListener.checkStateChanged(new CheckStateChangedEvent((ICheckable)this.treeViewer, matchingNode, true));
                continue;
            }
            it.remove();
        }
    }

    private void handleWorkItemNodesChanged(List<INode> workItemNodes) {
        for (INode workItemNode : workItemNodes) {
            UUID uuid = workItemNode.getNodeId();
            if (uuid == null) continue;
            boolean wiChecked = false;
            if (this.treeViewer.getChecked((Object)workItemNode)) {
                wiChecked = true;
                if (!this.selectedWorkItems.contains(uuid)) {
                    this.selectedWorkItems.add(uuid);
                }
            } else {
                this.selectedWorkItems.remove(uuid);
            }
            IWorkItemHandle wiHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(uuid, null);
            if (wiChecked) {
                this.configuration.getAdditionalWorkItems().add((Object)wiHandle);
            } else {
                this.configuration.getAdditionalWorkItems().remove((Object)wiHandle);
            }
            for (INode gapFiller : this.treeInputRoot.getChildren()) {
                boolean refresh = false;
                if (gapFiller != workItemNode) {
                    for (INode workItem : gapFiller.getChildren()) {
                        if (!uuid.equals((Object)workItem.getNodeId())) continue;
                        this.treeViewer.setSubtreeChecked((Object)workItem, wiChecked);
                        this.updateParentNodeStates(workItem);
                        refresh = true;
                        break;
                    }
                }
                if (!refresh) continue;
                this.treeViewer.refresh((Object)gapFiller);
            }
        }
    }

    private void updateParentNodeStates(INode node) {
        INode parent = node.getParent();
        if (parent != null && parent.getType() != INode.Type.SUMMARY) {
            boolean hasChecked = false;
            boolean hasUnchecked = false;
            for (INode kid : parent.getChildren()) {
                if (this.treeViewer.getChecked((Object)kid)) {
                    hasChecked = true;
                } else {
                    hasUnchecked = true;
                }
                if (hasChecked && hasUnchecked) break;
            }
            if (hasChecked && hasUnchecked) {
                this.treeViewer.setGrayChecked((Object)parent, true);
            } else if (hasChecked) {
                this.treeViewer.setGrayed((Object)parent, false);
                this.treeViewer.setChecked((Object)parent, true);
            } else {
                this.treeViewer.setGrayChecked((Object)parent, false);
            }
            this.updateParentNodeStates(parent);
        }
    }

    private class GapTreeCheckStateListener
    implements ICheckStateListener {
        private GapTreeCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (!(element instanceof INode)) {
                return;
            }
            INode node = (INode)element;
            boolean checked = event.getChecked();
            if (node.getType() == INode.Type.CHANGESET && node.getParent() instanceof IWorkItemNode) {
                node = node.getParent();
            }
            if (node.getType() == INode.Type.CHANGESET && node.getChildren().size() == 1 && ((INode)node.getChildren().get(0)).getNodeId() == null) {
                PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.setChecked((Object)node, !checked);
                PromotionWorkItemChangeSetAnalysisWizardPage.this.associateWorkItems(node);
            } else if (node.getType() == INode.Type.WORKITEM && node.getNodeId() == null) {
                PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.setChecked((Object)node, !checked);
                PromotionWorkItemChangeSetAnalysisWizardPage.this.associateWorkItems(node.getParent());
            } else {
                ArrayList<INode> changedWorkItemNodes;
                INode changeSetNode;
                if (node.getType() == INode.Type.WORKITEM) {
                    changeSetNode = node.getParent();
                    changedWorkItemNodes = new ArrayList<INode>(1);
                    changedWorkItemNodes.add(node);
                } else {
                    changeSetNode = node;
                    changedWorkItemNodes = node.getChildren();
                    if (!checked && PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.getGrayed((Object)node)) {
                        checked = true;
                    }
                }
                PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.setGrayed((Object)node, false);
                PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.setSubtreeChecked((Object)node, checked);
                PromotionWorkItemChangeSetAnalysisWizardPage.this.updateParentNodeStates(node);
                PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.refresh((Object)changeSetNode);
                PromotionWorkItemChangeSetAnalysisWizardPage.this.handleWorkItemNodesChanged(changedWorkItemNodes);
                PromotionWorkItemChangeSetAnalysisWizardPage.this.updateWarningVisibility();
            }
        }
    }

    private class GapTreeLabelProvider
    extends SummaryTreeLabelProvider {
        private GapTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = super.getImage(element);
            if (image != null && element instanceof IChangeSetNode && ((IChangeSetNode)element).getParent() instanceof ISummaryNode && !PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.getChecked(element) && !PromotionWorkItemChangeSetAnalysisWizardPage.this.treeViewer.getGrayed(element)) {
                if (PromotionWorkItemChangeSetAnalysisWizardPage.this.changeSetWarningImage == null) {
                    ImageDescriptor overlay = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING");
                    DecorationOverlayIcon warning = new DecorationOverlayIcon(image, overlay, 0);
                    PromotionWorkItemChangeSetAnalysisWizardPage.this.changeSetWarningImage = warning.createImage();
                }
                return PromotionWorkItemChangeSetAnalysisWizardPage.this.changeSetWarningImage;
            }
            return image;
        }

        public String getText(Object element) {
            String label = super.getText(element);
            if (PromotionWorkItemChangeSetAnalysisWizardPage.this.gapFillers != null && element instanceof IChangeSetNode && ((IChangeSetNode)element).getParent() instanceof IWorkItemNode) {
                UUID uuid = ((IChangeSetNode)element).getNodeId();
                boolean isGapFilling = false;
                IChangeSetHandle[] iChangeSetHandleArray = PromotionWorkItemChangeSetAnalysisWizardPage.this.gapFillers;
                int n = iChangeSetHandleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IChangeSetHandle gapFiller = iChangeSetHandleArray[n2];
                    if (uuid.equals((Object)gapFiller.getItemId())) {
                        isGapFilling = true;
                        break;
                    }
                    ++n2;
                }
                if (!isGapFilling) {
                    return NLS.bind((String)com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemChangeSetAnalysisWizardPage_CHANGE_SET_NOT_IN_GAP, (Object)label);
                }
            }
            return label;
        }
    }
}

