/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.utils;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class ResolveBuildDefinitionJob
extends TeamBuildJob {
    private Text buildDefinitionTextField = null;
    private CheckboxTableViewer componentListViewer = null;
    private Button browseButton = null;
    private UUID buildDefinitionUUID = null;
    private IBuildDefinition buildDefinition = null;

    public ResolveBuildDefinitionJob(Text buildDefinitionTextField, Button browseButton, CheckboxTableViewer componentListViewer, UUID buildDefinitionUUID, IBuildDefinition buildDefinition, ITeamRepository repository) {
        super(Messages.PromotionConfigurationEditor_JOBNAME_RESOLVEBUILDDEF, true, repository);
        this.buildDefinitionTextField = buildDefinitionTextField;
        this.browseButton = browseButton;
        this.componentListViewer = componentListViewer;
        this.buildDefinitionUUID = buildDefinitionUUID;
        this.buildDefinition = buildDefinition;
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        this.buildDefinition = this.resolveBuildDefinition();
        return Status.OK_STATUS;
    }

    private IBuildDefinition resolveBuildDefinition() {
        if (this.getJobTeamRepository() != null && this.buildDefinitionUUID != null) {
            IItemHandle definitionHandle = IBuildDefinition.ITEM_TYPE.createItemHandle(this.buildDefinitionUUID, null);
            try {
                return (IBuildDefinition)this.getJobTeamRepository().itemManager().fetchCompleteItem(definitionHandle, 0, null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void jobFinished(IStatus status) {
        if (this.buildDefinitionUUID == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ResolveBuildDefinitionJob.this.isValidControl((Control)ResolveBuildDefinitionJob.this.buildDefinitionTextField)) {
                    ResolveBuildDefinitionJob.this.buildDefinitionTextField.setText(ResolveBuildDefinitionJob.this.buildDefinition != null ? ResolveBuildDefinitionJob.this.buildDefinition.getId() : Messages.PromotionConfigurationEditor_ERROR_ITEMNOTFOUND);
                    ResolveBuildDefinitionJob.this.buildDefinitionTextField.setData((Object)ResolveBuildDefinitionJob.this.buildDefinitionUUID.getUuidValue());
                    if (ResolveBuildDefinitionJob.this.isValidControl(ResolveBuildDefinitionJob.this.componentListViewer.getControl())) {
                        ResolveBuildDefinitionJob.this.componentListViewer.setInput((Object)ResolveBuildDefinitionJob.this.buildDefinitionUUID.getUuidValue());
                    }
                    if (ResolveBuildDefinitionJob.this.isValidControl((Control)ResolveBuildDefinitionJob.this.browseButton)) {
                        ResolveBuildDefinitionJob.this.browseButton.setEnabled(true);
                    }
                }
            }
        });
    }

    private boolean isValidControl(Control control) {
        return control != null && !control.isDisposed();
    }
}

