/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.utils;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.model.dto.BuildResultRecord;
import com.ibm.team.build.internal.publishing.LogPublisher;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class PublishingLogger {
    private PrintStream ps;
    private static String DEFAULT_PROMOTION_LOG = Messages.PromoteLog_CompletePromotionLogName;
    private File logFile;
    private static PublishingLogger logger;
    private String label;

    public static PublishingLogger getPublishingLogger() {
        if (logger == null) {
            logger = new PublishingLogger();
        }
        return logger;
    }

    private PublishingLogger() {
        try {
            this.initLog();
        }
        catch (IOException e) {
            this.ps = null;
        }
    }

    public void log(String message) {
        if (this.ps != null) {
            this.ps.println(message);
        }
    }

    public void logIndent(String message) {
        this.log(String.valueOf('\t') + message);
    }

    public void log(String message, Throwable t) {
        this.log(message);
        this.log(t);
    }

    public void log(Throwable t) {
        if (this.ps != null) {
            t.printStackTrace(this.ps);
            this.ps.println();
        }
    }

    public void newLine() {
        this.log("");
    }

    private void initLog() throws IOException {
        StringBuffer buffer = new StringBuffer(DEFAULT_PROMOTION_LOG).append('_');
        this.logFile = File.createTempFile(buffer.toString(), ".log");
        this.ps = new PrintStream(this.logFile, "UTF-8");
        this.label = Messages.bind((String)Messages.PromoteLog_CompletePromotionLogLabel, (Object)new Date());
    }

    public void publish(BuildResultRecord buildResultRecord) {
        ITeamRepository repo = (ITeamRepository)buildResultRecord.getProjectArea().getOrigin();
        IBuildResult bs = (IBuildResult)buildResultRecord.getBuildResult().getWorkingCopy();
        LogPublisher publisher = new LogPublisher(this.logFile.getAbsolutePath(), this.label);
        try {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                publisher.publish((IBuildResultHandle)bs, BuildStatus.OK, repo);
                bs.modified();
            }
            catch (Exception exception) {
                if (this.logFile != null && this.logFile.exists()) {
                    this.logFile.delete();
                }
                logger = null;
            }
        }
        finally {
            if (this.logFile != null && this.logFile.exists()) {
                this.logFile.delete();
            }
            logger = null;
        }
    }
}

