/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.utils;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.common.promotion.build.IComponentListProperty;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.enterprise.internal.promotion.ui.utils.BuildUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.widgets.Display;

public class FetchComponentsJob
extends TeamBuildJob {
    private CheckboxTableViewer componentTableViewer;
    private UUID workspaceUUID;
    private List<IComponent> components = null;
    List<IComponentListProperty> previousSelectedComponents;

    public FetchComponentsJob(UUID workspaceUUID, CheckboxTableViewer componentTableViewer, List<IComponentListProperty> previousSelectedComponents, ITeamRepository repo) {
        super(Messages.PromotionConfigurationEditor_JOBNAME_FETCHCOMPONENTS, true, repo);
        this.workspaceUUID = workspaceUUID;
        this.componentTableViewer = componentTableViewer;
        this.previousSelectedComponents = previousSelectedComponents;
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        try {
            IWorkspace sourceDefWorkspace = BuildUtils.getWorkspaceFromUUID(this.workspaceUUID, this.getJobTeamRepository());
            IWorkspaceConnection sourceDefWSConnection = BuildUtils.getWorkspaceConnection(this.getJobTeamRepository(), (IWorkspaceHandle)sourceDefWorkspace, (IProgressMonitor)new NullProgressMonitor());
            List<IComponentHandle> sourceDefComps = BuildUtils.getAllComponentHandles(sourceDefWSConnection, (IProgressMonitor)new NullProgressMonitor());
            this.components = new ArrayList<IComponent>();
            for (IComponentHandle compHandle : sourceDefComps) {
                IConfiguration config = sourceDefWSConnection.configuration(compHandle);
                if (config == null) continue;
                this.components.add((IComponent)config.teamRepository().itemManager().fetchCompleteItem((IItemHandle)compHandle, 0, (IProgressMonitor)new NullProgressMonitor()));
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    protected void jobFinished(IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FetchComponentsJob.this.componentTableViewer.getControl().isDisposed()) {
                    FetchComponentsJob.this.componentTableViewer.refresh(true);
                    if (FetchComponentsJob.this.previousSelectedComponents == null) {
                        FetchComponentsJob.this.componentTableViewer.setAllChecked(true);
                    } else {
                        ArrayList<String> checkedIDs = new ArrayList<String>();
                        for (IComponentListProperty prop : FetchComponentsJob.this.previousSelectedComponents) {
                            checkedIDs.add(prop.getComponentUUID());
                        }
                        int numItems = FetchComponentsJob.this.componentTableViewer.getTable().getItemCount();
                        int itemIndex = 0;
                        while (itemIndex < numItems) {
                            IComponent tableElement = (IComponent)FetchComponentsJob.this.componentTableViewer.getElementAt(itemIndex);
                            String elementID = tableElement.getItemId().getUuidValue();
                            if (checkedIDs.contains(elementID)) {
                                FetchComponentsJob.this.componentTableViewer.setChecked((Object)tableElement, true);
                            }
                            ++itemIndex;
                        }
                    }
                }
            }
        });
    }
}

