/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.utils;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.common.promotion.build.PromotionBuildPropertyFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowNode;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildUtils {
    public static IWorkspaceConnection getWorkspaceConnection(ITeamRepository repo, IWorkspaceHandle workspace, IProgressMonitor progress) throws TeamRepositoryException {
        return SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspace, progress);
    }

    public static IWorkspace getWorkspaceFromUUID(String workspaceUUID, ITeamRepository repository) throws TeamRepositoryException {
        UUID workspaceUuid = null;
        try {
            workspaceUuid = UUID.valueOf((String)workspaceUUID);
        }
        catch (IllegalArgumentException exception) {
            throw new TeamRepositoryException(exception.getMessage(), (Throwable)exception);
        }
        return BuildUtils.getWorkspaceFromUUID(workspaceUuid, repository);
    }

    public static IWorkspace getWorkspaceFromUUID(UUID workspaceUuid, ITeamRepository repository) throws TeamRepositoryException {
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
        IItem item = repository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, (IProgressMonitor)new NullProgressMonitor());
        return (IWorkspace)item;
    }

    public static List<IComponentHandle> getAllComponentHandles(IWorkspaceConnection wksConn, IProgressMonitor progress) throws TeamRepositoryException {
        wksConn.refresh(progress);
        return wksConn.getComponents();
    }

    public static ITeamRepository getTeamRepository(String uri, final String username, final String password) throws TeamRepositoryException {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(uri);
        repo.registerLoginHandler(new ITeamRepository.ILoginHandler(){

            public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                return new ITeamRepository.ILoginHandler.ILoginInfo(){

                    public String getUserId() {
                        return username;
                    }

                    public String getPassword() {
                        return password;
                    }
                };
            }
        });
        repo.login(null);
        return repo;
    }

    public static IWorkspace getWorkspaceFromName(String workspaceName, ITeamRepository repository) throws TeamRepositoryException {
        try {
            UUID.valueOf((String)workspaceName);
            BuildUtils.getWorkspaceFromUUID(workspaceName, repository);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArrayList workspaceHandles = new ArrayList();
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setExactName(workspaceName);
        List foundWorkspaceHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).findWorkspaces(criteria, Integer.MAX_VALUE, null);
        workspaceHandles.addAll(foundWorkspaceHandles);
        ArrayList<IWorkspace> workspaces = new ArrayList<IWorkspace>();
        if (workspaceHandles.size() > 0) {
            List fetchedWorkspaces = repository.itemManager().fetchCompleteItems(workspaceHandles, 0, null);
            for (IWorkspace workspace : fetchedWorkspaces) {
                if (workspace == null) continue;
                workspaces.add(workspace);
            }
        }
        if (workspaces.size() > 0) {
            return (IWorkspace)workspaces.get(0);
        }
        return null;
    }

    public static int getWorkItemPromotionMaxDelay() {
        return BuildUtils.parseInt(System.getProperty("workItemPromotionMaxDelay", "-1"));
    }

    private static int parseInt(String aString) {
        try {
            if (aString != null) {
                return Integer.parseInt(aString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static IWorkspaceHandle getTargetStream(IBuildDefinition promotionDefinition, ITeamRepository repository) {
        String promotionConfigurationElementId = PromotionBuildPropertyFactory.getInstance().resolvePropertyId("com.ibm.team.enterprise.promotion.build", promotionDefinition);
        String targetDefUUID = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("team.enterprise.promotion.targetDefinition", promotionConfigurationElementId, promotionDefinition);
        if (targetDefUUID != null && !targetDefUUID.isEmpty()) {
            try {
                IItemHandle targetDefinitionHandle = IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)targetDefUUID), null);
                IBuildDefinition targetDefinition = (IBuildDefinition)repository.itemManager().fetchCompleteItem(targetDefinitionHandle, 0, null);
                if (targetDefinition != null) {
                    String workspaceUUID = DependencyBuildPropertyFactory.getInstance().resolvePropertyId("teamz.scm.workspaceUUID", targetDefinition);
                    IBuildProperty workspaceUUIDProperty = targetDefinition.getProperty(workspaceUUID);
                    IWorkspaceHandle targetWorkspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUIDProperty.getValue()), null);
                    IWorkspace targetWorkspace = (IWorkspace)repository.itemManager().fetchCompleteItem((IItemHandle)targetWorkspaceHandle, 0, null);
                    return BuildUtils.getDefaultAcceptFlow((IWorkspaceHandle)targetWorkspace, repository);
                }
            }
            catch (TeamRepositoryException tre) {
                tre.printStackTrace();
            }
        }
        return null;
    }

    public static IWorkspaceHandle getDefaultAcceptFlow(IWorkspaceHandle workspaceHandle, ITeamRepository teamRepo) throws TeamRepositoryException {
        IWorkspace workspace;
        Objects.requireNonNull(workspaceHandle);
        Objects.requireNonNull(teamRepo);
        IWorkspace iWorkspace = workspace = workspaceHandle instanceof IWorkspace ? (IWorkspace)workspaceHandle : (IWorkspace)teamRepo.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, null);
        if (workspace.isStream()) {
            return workspace;
        }
        IWorkspaceManager wsManager = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepo);
        IWorkspaceConnection wsConnection = wsManager.getWorkspaceConnection((IWorkspaceHandle)workspace, null);
        IFlowNodeHandle flowHandle = wsConnection.getFlowTable().getDefaultAcceptFlow().getFlowNode();
        IFlowNode flowNode = (IFlowNode)teamRepo.itemManager().fetchCompleteItem((IItemHandle)flowHandle, 0, null);
        if (flowNode instanceof IWorkspaceHandle) {
            return (IWorkspaceHandle)flowNode;
        }
        return null;
    }
}

