/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.editors;

import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.internal.promotion.ui.editors.AbstractPromotionConfigurationEditor;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.jface.tooltip.TooltipSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ZosPromotionConfigurationEditor
extends AbstractPromotionConfigurationEditor {
    protected static final String VALIDATION_ERROR_NO_DESTINATION = "validationErrorNoDestination";
    protected static final String VALIDATION_ERROR_NO_ISPF_GATEWAY_SCRIPT = "validationErrorNoIspfGatewayScript";
    protected static final String VALIDATION_ERROR_INVALID_TEMP_PDS_FORMAT = "validationErrorInvalidTemporaryDatasetPrefix";
    protected Text destinationTextField;
    protected Text tempPdsPrefixTextField;
    protected Text ispfGatewayLocationTextField;

    public ZosPromotionConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    protected final PromotionInfo.PromotionBuildType getPromotionBuildType() {
        return PromotionInfo.PromotionBuildType.zos;
    }

    @Override
    protected void layoutSections(Composite parent) {
        Section scopeSection = this.createScopeSection(parent);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, SECTION_INDENT);
        data.right = new FormAttachment(50);
        scopeSection.setLayoutData((Object)data);
        Section toolkitSection = this.createToolkitSection(parent);
        data = new FormData();
        data.left = new FormAttachment((Control)scopeSection, SECTION_INDENT);
        data.right = new FormAttachment(100);
        toolkitSection.setLayoutData((Object)data);
        Section promotionTypeSection = this.createPromotionTypeSection(parent);
        data = new FormData();
        data.top = new FormAttachment((Control)scopeSection, SECTION_INDENT);
        data.left = new FormAttachment(0, SECTION_INDENT);
        data.right = new FormAttachment(50);
        data.bottom = new FormAttachment(100);
        promotionTypeSection.setLayoutData((Object)data);
        Section advancedSection = this.createAdvancedOptionsSection(parent);
        data = new FormData();
        data.top = new FormAttachment((Control)toolkitSection, SECTION_INDENT);
        data.left = new FormAttachment(50, SECTION_INDENT);
        data.right = new FormAttachment(100);
        advancedSection.setLayoutData((Object)data);
        Section antConfigurationSection = this.createAntConfigurationSection(parent);
        data = new FormData();
        data.top = new FormAttachment((Control)advancedSection, SECTION_INDENT);
        data.left = new FormAttachment(50, SECTION_INDENT);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        antConfigurationSection.setLayoutData((Object)data);
    }

    protected Section createToolkitSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 320);
        section.setText(Messages.AbstractPromotionConfigurationEditor_SECTION_TOOLKIT_LABEL);
        section.setLayout((Layout)new FillLayout());
        Composite sectionContainer = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionContainer);
        section.setClient((Control)sectionContainer);
        toolkit.createLabel(sectionContainer, Messages.PromotionConfigurationEditor_TARGET_WORKINGDIR_LABEL);
        this.destinationTextField = toolkit.createText(sectionContainer, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.destinationTextField);
        this.destinationTextField.setText(this.getProperty("team.enterprise.promotion.destinationPath", ""));
        this.destinationTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZosPromotionConfigurationEditor.this.setProperty("team.enterprise.promotion.destinationPath", ZosPromotionConfigurationEditor.this.destinationTextField.getText().trim());
                ZosPromotionConfigurationEditor.this.setDirty(true);
                ZosPromotionConfigurationEditor.this.validate();
            }
        });
        toolkit.createLabel(sectionContainer, Messages.PromotionConfigurationEditor_ZOS_SCRIPT_LABEL);
        this.ispfGatewayLocationTextField = toolkit.createText(sectionContainer, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.ispfGatewayLocationTextField);
        String ispfGatewayScript = this.getProperty("team.promotion.zos.script");
        if (ispfGatewayScript == null || ispfGatewayScript.trim().isEmpty()) {
            ispfGatewayScript = Utils.getDefaultIspfGatewayLocation();
            this.setProperty("team.promotion.zos.script", ispfGatewayScript);
        }
        this.ispfGatewayLocationTextField.setText(ispfGatewayScript);
        this.ispfGatewayLocationTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZosPromotionConfigurationEditor.this.setProperty("team.promotion.zos.script", ZosPromotionConfigurationEditor.this.ispfGatewayLocationTextField.getText().trim());
                ZosPromotionConfigurationEditor.this.setDirty(true);
                ZosPromotionConfigurationEditor.this.validate();
            }
        });
        toolkit.createLabel(sectionContainer, Messages.PromotionConfigurationEditor_TEMPORARY_PDS_PREFIX_LABEL);
        this.tempPdsPrefixTextField = toolkit.createText(sectionContainer, "", 2048);
        String tempPdsPrefix = this.getProperty("team.promotion.zos.tempPdsPrefix", "");
        if (tempPdsPrefix == null) {
            tempPdsPrefix = "";
        }
        this.tempPdsPrefixTextField.setText(this.getProperty("team.promotion.zos.tempPdsPrefix", ""));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.tempPdsPrefixTextField);
        this.tempPdsPrefixTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZosPromotionConfigurationEditor.this.setProperty("team.promotion.zos.tempPdsPrefix", ZosPromotionConfigurationEditor.this.tempPdsPrefixTextField.getText().trim());
                ZosPromotionConfigurationEditor.this.setDirty(true);
                ZosPromotionConfigurationEditor.this.validate();
            }
        });
        new TooltipSupport((Control)this.tempPdsPrefixTextField, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return Messages.PromotionConfigurationEditor_TEMPORARY_PDS_PREFIX_TOOLTIP;
            }

            public Object getElement(Control control, int x, int y) {
                return ZosPromotionConfigurationEditor.this.tempPdsPrefixTextField;
            }
        };
        return section;
    }

    @Override
    public boolean validate() {
        if (this.destinationTextField != null) {
            if (this.destinationTextField.getText().trim().isEmpty()) {
                this.addErrorMessageForRequiredField(VALIDATION_ERROR_NO_DESTINATION, Messages.PromotionConfigurationEditor_DESTINATION_DIR_REQUIRED, (Control)this.destinationTextField);
            } else {
                this.removeMessage(VALIDATION_ERROR_NO_DESTINATION, (Control)this.destinationTextField);
            }
        }
        if (this.ispfGatewayLocationTextField != null) {
            if (this.ispfGatewayLocationTextField.getText().trim().isEmpty()) {
                this.addErrorMessageForRequiredField(VALIDATION_ERROR_NO_ISPF_GATEWAY_SCRIPT, Messages.PromotionConfigurationEditor_ERROR_GATEWAY_SCRIPT_EMPTY, (Control)this.ispfGatewayLocationTextField);
            } else {
                this.removeMessage(VALIDATION_ERROR_NO_ISPF_GATEWAY_SCRIPT, (Control)this.ispfGatewayLocationTextField);
            }
        }
        if (this.tempPdsPrefixTextField != null) {
            MappingValidation validator = new MappingValidation();
            if (this.tempPdsPrefixTextField.getText().trim().isEmpty() || validator.isValidDSName(this.tempPdsPrefixTextField.getText().trim()) == 0) {
                this.removeMessage(VALIDATION_ERROR_INVALID_TEMP_PDS_FORMAT, (Control)this.tempPdsPrefixTextField);
            } else {
                this.addErrorMessageForRequiredField(VALIDATION_ERROR_INVALID_TEMP_PDS_FORMAT, Messages.PromotionConfigurationEditor_ERROR_INVALID_DATASET_FORMAT, (Control)this.tempPdsPrefixTextField);
            }
        }
        return super.validate();
    }

    public void postSave(boolean saveSucceeded) {
        if (saveSucceeded) {
            Utils.saveDefaultIspfGatewayLocation((String)this.ispfGatewayLocationTextField.getText());
        }
    }
}

