/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.editors;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorInput;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.common.promotion.build.ComponentListProperty;
import com.ibm.team.enterprise.build.common.promotion.build.ComponentListPropertyParser;
import com.ibm.team.enterprise.build.common.promotion.build.IComponentListProperty;
import com.ibm.team.enterprise.build.common.promotion.build.PromotionBuildPropertyFactory;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionBuildUtil;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.internal.promotion.ui.PromotionUIPlugin;
import com.ibm.team.enterprise.internal.promotion.ui.dialogs.PromotionBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.enterprise.internal.promotion.ui.utils.BuildUtils;
import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PromotionBuildConfigurationEditor
extends AbstractConfigurationElementEditor
implements SelectionListener,
ICheckStateListener,
ModifyListener {
    private FormToolkit fToolkit;
    protected CTabFolder tabFolder;
    private int tabFolderIndex = 0;
    protected CTabItem generalTab;
    protected CTabItem workitemPromotionTab;
    protected CTabItem componentPromotionTab;
    private Composite WIPromotionTabComposite;
    private Composite componentPromotionTabComposite;
    private Composite generalTabComposite;
    private Section promotionSection;
    private Section targetSection;
    private Section WIPromotionSection;
    private Section componentPromotionSection;
    private Section outputSection;
    private Text sourceBuildDefText;
    private Text targetBuildDefText;
    private Button sourceBuildDefBrowseButton;
    private Button targetBuildDefBrowseButton;
    private CheckboxTableViewer componentTableViewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Button generateButton;
    private Button customButton;
    private Button publishBuildMapLinksButton;
    private Label buildFileLabel;
    private Label buildTargetLabel;
    private Text buildFileDescriptionLabel;
    private Text buildFileText;
    private Text buildTargetText;
    private Text destinationDirText;
    private Button ibmiRestorePfReplaceMethod;
    private Button ibmiRestorePfMigrateMethod;
    private Button ibmiRestorePfUsrCmdMethod;
    private Button pSourceOutputs;
    private Button pSourceOnly;
    private Button pCheckIncludeChildren;
    private Button pConsideredIgnored;
    private Button pIncludeImpacted;
    private Button pDecideWIOptions;
    private Button pDecideIncludeChildren;
    private Button pDecideConsideredIgnored;
    private Button pDecideIncludeImpacted;
    private Button typeEnableBoth;
    private Button typeEnableWI;
    private Button typeEnableComp;
    private Text ibmiRestorePfUsrCmdText;
    private Text antHomeText;
    private Text antArgsText;
    private Text javaHomeText;
    private Text javaArgsText;
    private Text propertiesFileText;
    private Text workingDirText;
    private Text zosScriptText;
    private Text ibmiPreCommandText;
    private Text ibmiPostCommandText;
    private List<Control> tabList;
    private IBuildDefinition buildDefinitionWorkingCopy;
    private String elementId;
    private Button skipTimestampCheckButton;
    private Button createSnapshotButton;
    private PromotionInfo.PromotionBuildType promotionBuildType;
    private Hyperlink fSourceDefinitionTitleHyperlink;
    private Hyperlink fTargetDefinitionTitleHyperlink;
    protected Color fEnabledHyperlinkForegroundColor;
    protected Color fDisabledHyperlinkForegroundColor;
    private Composite streamNoScanningWarningHolder;
    private LinkedList<IBuildEngine> buildEngines = null;
    private UIUpdaterJob job = null;

    protected CTabItem createTab(FormToolkit toolkit, String title) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(title);
        return item;
    }

    public PromotionBuildConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_enterprise_promotion";
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        this.tabFolder = new CTabFolder(parent, 0x800080);
        this.tabFolder.setLayoutData((Object)new TableWrapData(256, 256));
        this.tabFolder.setLayout((Layout)new TableWrapLayout());
        toolkit.adapt((Control)this.tabFolder, true, true);
        toolkit.paintBordersFor((Composite)this.tabFolder);
        this.createGeneralTab();
        if (this.typeEnableBoth.getSelection() || this.typeEnableComp.getSelection()) {
            this.createComponentTab();
        }
        if (this.typeEnableBoth.getSelection() || this.typeEnableWI.getSelection()) {
            this.createWorkItemTab();
        }
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.tabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(22));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromotionBuildConfigurationEditor.this.tabFolderIndex = PromotionBuildConfigurationEditor.this.tabFolder.getSelectionIndex();
            }
        });
        this.tabFolder.setSelection(this.tabFolderIndex);
    }

    private void createGeneralTab() {
        this.generalTab = this.createTab(this.fToolkit, Messages.PromotionConfigurationEditor_TAB_TITLE_GENERAL);
        this.generalTabComposite = this.createContentGeneralTab((Composite)this.tabFolder, this.fToolkit);
        this.generalTab.setControl((Control)this.generalTabComposite);
    }

    private void createComponentTab() {
        this.componentPromotionTab = this.createTab(this.fToolkit, Messages.PromotionConfigurationEditor_TAB_TITLE_COMPONENT);
        this.componentPromotionTabComposite = this.createContentComponentPromotionTab((Composite)this.tabFolder, this.fToolkit);
        this.componentPromotionTab.setControl((Control)this.componentPromotionTabComposite);
        this.componentPromotionTab.addListener(22, new Listener(){

            public void handleEvent(Event event) {
            }
        });
    }

    private void createWorkItemTab() {
        this.workitemPromotionTab = this.createTab(this.fToolkit, Messages.PromotionConfigurationEditor_TAB_TITLE_WORKITEM);
        this.WIPromotionTabComposite = this.createContentWIPromotionTab((Composite)this.tabFolder, this.fToolkit);
        this.workitemPromotionTab.setControl((Control)this.WIPromotionTabComposite);
    }

    public Composite createContentWIPromotionTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 4);
        parent.setLayout((Layout)new TableWrapLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createWIPromotionSection(parent);
        return parent;
    }

    public Composite createContentComponentPromotionTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 0);
        parent.setLayout((Layout)new TableWrapLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createComponentPromotionSection(parent);
        return parent;
    }

    public Composite createContentGeneralTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 0);
        parent.setLayout((Layout)new TableWrapLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createPromotionSection(parent);
        this.createOutputSection(parent);
        if (PromotionBuildUtil.isIBMiPromotionBuild((IBuildDefinition)this.buildDefinitionWorkingCopy)) {
            this.createIBMiPfOptionSection(parent, this.fToolkit);
        }
        this.createBuildTargetSection(parent);
        this.createConfigurationSection(parent);
        return parent;
    }

    private void createComponentPromotionSection(Composite parent) {
        this.componentPromotionSection = this.fToolkit.createSection(parent, 448);
        this.componentPromotionSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.componentPromotionSection.setLayout((Layout)new TableWrapLayout());
        this.componentPromotionSection.setText(Messages.PromotionConfigurationEditor_COMPONENT_PROMOTION_TITLE);
        this.componentPromotionSection.setDescription(Messages.PromotionConfigurationEditor_CONFIG_COMPONENT_LABEL);
        Composite composite = this.fToolkit.createComposite((Composite)this.componentPromotionSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.createComponentSelectionWidgets(composite);
        this.componentPromotionSection.setClient((Control)composite);
    }

    private void setPromotionPropertyValue(String propertyID, boolean value) {
        PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue(propertyID, Boolean.toString(value), this.elementId, this.buildDefinitionWorkingCopy);
    }

    private String getPromotionPropertyValue(String propertyID) {
        return PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue(propertyID, this.elementId, this.buildDefinitionWorkingCopy);
    }

    private void createWIPromotionSection(Composite parent) {
        this.WIPromotionSection = this.fToolkit.createSection(parent, 448);
        this.WIPromotionSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.WIPromotionSection.setLayout((Layout)new TableWrapLayout());
        this.WIPromotionSection.setText(Messages.PromotionConfigurationEditor_WORKITEM_PROMOTION_TITLE);
        this.WIPromotionSection.setDescription(Messages.PromotionConfigurationEditor_WORKITEM_PROMOTION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.WIPromotionSection);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.pDecideWIOptions = this.fToolkit.createButton(composite, Messages.PromotionWorkItemDefinitionSection_DecideAll, 16);
        GridDataFactory.fillDefaults().span(3, 1).indent(0, 5).applyTo((Control)this.pDecideWIOptions);
        this.pDecideWIOptions.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.pDecideWIOptions.getSelection()) {
                    PromotionBuildConfigurationEditor.this.enableSourceOnlySettings(false);
                }
                PromotionBuildConfigurationEditor.this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.in.promotion", PromotionBuildConfigurationEditor.this.pDecideWIOptions.getSelection());
                PromotionBuildConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pSourceOutputs = this.fToolkit.createButton(composite, Messages.PromotionWorkItemWizardPage_TEXT_SOURCEANDOUTPUTS, 16);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.pSourceOutputs);
        this.pSourceOutputs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.pSourceOutputs.getSelection()) {
                    PromotionBuildConfigurationEditor.this.enableSourceOnlySettings(false);
                    PromotionBuildConfigurationEditor.this.setDirty(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pSourceOnly = this.fToolkit.createButton(composite, Messages.PromotionWorkItemWizardPage_TEXT_SOURCEONLY, 16);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.pSourceOnly);
        this.pSourceOnly.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.pSourceOnly.getSelection()) {
                    PromotionBuildConfigurationEditor.this.enableSourceOnlySettings(true);
                    PromotionBuildConfigurationEditor.this.setDirty(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labelIncludeChildren = this.fToolkit.createLabel(composite, String.valueOf(Messages.PromotionWorkItemWizardPage_TEXT_INCLUDECHILDREN) + ":");
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)labelIncludeChildren);
        this.pCheckIncludeChildren = this.fToolkit.createButton(composite, Messages.PromotionWorkItemDefinitionSection_EnableSetting, 32);
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.pCheckIncludeChildren);
        this.pCheckIncludeChildren.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PromotionBuildConfigurationEditor.this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.include.children", PromotionBuildConfigurationEditor.this.pCheckIncludeChildren.getSelection());
                PromotionBuildConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pDecideIncludeChildren = this.fToolkit.createButton(composite, Messages.PromotionWorkItemDefinitionSection_DecideInPromotion, 32);
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.pDecideIncludeChildren);
        this.pDecideIncludeChildren.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.pDecideIncludeChildren.getSelection()) {
                    PromotionBuildConfigurationEditor.this.pCheckIncludeChildren.setEnabled(false);
                    PromotionBuildConfigurationEditor.this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.include.children", true);
                } else {
                    PromotionBuildConfigurationEditor.this.pCheckIncludeChildren.setEnabled(true);
                    PromotionBuildConfigurationEditor.this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.include.children", false);
                }
                PromotionBuildConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labelConsideredIgnored = this.fToolkit.createLabel(composite, String.valueOf(Messages.PromotionWorkItemWizardPage_TEXT_IGNORECHANGES) + ":");
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)labelConsideredIgnored);
        this.pConsideredIgnored = this.fToolkit.createButton(composite, Messages.PromotionWorkItemDefinitionSection_EnableSetting, 32);
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.pConsideredIgnored);
        this.pConsideredIgnored.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PromotionBuildConfigurationEditor.this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.ignore.changes", PromotionBuildConfigurationEditor.this.pConsideredIgnored.getSelection());
                PromotionBuildConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pDecideConsideredIgnored = this.fToolkit.createButton(composite, Messages.PromotionWorkItemDefinitionSection_DecideInPromotion, 32);
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.pDecideConsideredIgnored);
        this.pDecideConsideredIgnored.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.pDecideConsideredIgnored.getSelection()) {
                    PromotionBuildConfigurationEditor.this.pConsideredIgnored.setEnabled(false);
                    PromotionBuildConfigurationEditor.this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.ignore.changes", true);
                } else {
                    PromotionBuildConfigurationEditor.this.pConsideredIgnored.setEnabled(true);
                    PromotionBuildConfigurationEditor.this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.ignore.changes", false);
                }
                PromotionBuildConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labelIncludeImpacted = this.fToolkit.createLabel(composite, String.valueOf(Messages.PromotionWorkItemWizardPage_TEXT_INCLUDEIMPACTED) + ":");
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)labelIncludeImpacted);
        this.pIncludeImpacted = this.fToolkit.createButton(composite, Messages.PromotionWorkItemDefinitionSection_EnableSetting, 32);
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.pIncludeImpacted);
        this.pIncludeImpacted.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PromotionBuildConfigurationEditor.this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.include.impacted", PromotionBuildConfigurationEditor.this.pIncludeImpacted.getSelection());
                PromotionBuildConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pDecideIncludeImpacted = this.fToolkit.createButton(composite, Messages.PromotionWorkItemDefinitionSection_DecideInPromotion, 32);
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.pDecideIncludeImpacted);
        this.pDecideIncludeImpacted.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.pDecideIncludeImpacted.getSelection()) {
                    PromotionBuildConfigurationEditor.this.pIncludeImpacted.setEnabled(false);
                    PromotionBuildConfigurationEditor.this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.include.impacted", true);
                } else {
                    PromotionBuildConfigurationEditor.this.pIncludeImpacted.setEnabled(true);
                    PromotionBuildConfigurationEditor.this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.include.impacted", false);
                }
                PromotionBuildConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.initializeWIPromotionSection();
        this.WIPromotionSection.setClient((Control)composite);
    }

    private void enableSourceOnlySettings(boolean enabled) {
        if (enabled) {
            this.pSourceOutputs.setSelection(false);
            this.pDecideIncludeImpacted.setEnabled(false);
            this.pIncludeImpacted.setEnabled(false);
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.sourceonly", true);
        } else if (!this.pDecideIncludeImpacted.isEnabled() && !this.pIncludeImpacted.isEnabled()) {
            this.pSourceOnly.setSelection(false);
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.sourceonly", false);
            this.initializeIncludeImpactedPart();
        }
    }

    private void initializeWIPromotionSection() {
        boolean isDecideIgnoreChanges;
        String buildPropertyIgnoreChanges;
        boolean isDecideIncludeChildren;
        boolean isSourceOnly = false;
        String buildPropertySourceOnly = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.sourceonly");
        if (buildPropertySourceOnly == null) {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.sourceonly", false);
            buildPropertySourceOnly = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.sourceonly");
        }
        String buildPropertyDecideAll = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.in.promotion");
        boolean isDecideInPromotion = true;
        if (buildPropertyDecideAll == null) {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.in.promotion", true);
            buildPropertyDecideAll = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.in.promotion");
        }
        if (isDecideInPromotion = Boolean.parseBoolean(buildPropertyDecideAll)) {
            this.pDecideWIOptions.setSelection(true);
        } else if (buildPropertySourceOnly != null) {
            isSourceOnly = Boolean.parseBoolean(buildPropertySourceOnly);
            this.pSourceOutputs.setSelection(!isSourceOnly);
            this.pSourceOnly.setSelection(isSourceOnly);
        } else {
            this.pSourceOutputs.setSelection(true);
        }
        String buildPropertyIncludeChildren = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.include.children");
        if (buildPropertyIncludeChildren != null) {
            boolean isIncludeChildren = Boolean.parseBoolean(buildPropertyIncludeChildren);
            this.pCheckIncludeChildren.setSelection(isIncludeChildren);
        } else {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.include.children", false);
        }
        String buildPropertyDecideIncludeChildren = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.include.children");
        if (buildPropertyDecideIncludeChildren == null) {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.include.children", true);
            buildPropertyDecideIncludeChildren = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.include.children");
        }
        if (isDecideIncludeChildren = Boolean.parseBoolean(buildPropertyDecideIncludeChildren)) {
            this.pDecideIncludeChildren.setSelection(true);
            this.pCheckIncludeChildren.setEnabled(false);
        }
        if ((buildPropertyIgnoreChanges = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.ignore.changes")) != null) {
            boolean isIncludeChange = Boolean.parseBoolean(buildPropertyIgnoreChanges);
            this.pConsideredIgnored.setSelection(isIncludeChange);
        } else {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.ignore.changes", false);
        }
        String buildPropertyDecideIgnoreChanges = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.ignore.changes");
        if (buildPropertyDecideIgnoreChanges == null) {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.ignore.changes", true);
            buildPropertyDecideIgnoreChanges = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.ignore.changes");
        }
        if (isDecideIgnoreChanges = Boolean.parseBoolean(buildPropertyDecideIgnoreChanges)) {
            this.pDecideConsideredIgnored.setSelection(true);
            this.pConsideredIgnored.setEnabled(false);
        }
        if (!isSourceOnly) {
            this.initializeIncludeImpactedPart();
        } else {
            this.pDecideIncludeImpacted.setEnabled(false);
            this.pIncludeImpacted.setEnabled(false);
        }
    }

    private void initializeIncludeImpactedPart() {
        boolean isDecideIncludeImpacted;
        String buildPropertyIncludeImpacted = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.include.impacted");
        this.pDecideIncludeImpacted.setEnabled(true);
        this.pIncludeImpacted.setEnabled(true);
        if (buildPropertyIncludeImpacted != null) {
            boolean isIncludeImpacted = Boolean.parseBoolean(buildPropertyIncludeImpacted);
            this.pIncludeImpacted.setSelection(isIncludeImpacted);
        } else {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.include.impacted", false);
        }
        String buildPropertyDecideIncludeImpacted = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.include.impacted");
        if (buildPropertyDecideIncludeImpacted == null) {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.include.impacted", true);
            buildPropertyDecideIncludeImpacted = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.workitem.decide.include.impacted");
        }
        if (isDecideIncludeImpacted = Boolean.parseBoolean(buildPropertyDecideIncludeImpacted)) {
            this.pDecideIncludeImpacted.setSelection(true);
            this.pIncludeImpacted.setEnabled(false);
        }
    }

    private void createIBMiPfOptionSection(Composite parent, FormToolkit toolkit) {
        this.tabList = new ArrayList<Control>();
        IBuildProperty restoreOptionProperty = this.buildDefinitionWorkingCopy.getProperty("team.promotion.ibmi.pfRestoreMethod");
        boolean restoreOptionNotSet = false;
        if (restoreOptionProperty == null || restoreOptionProperty.getValue() == null) {
            restoreOptionNotSet = true;
        }
        Section section = toolkit.createSection(parent, 450);
        TableWrapData sectionData = new TableWrapData(256, 256);
        section.setLayoutData((Object)sectionData);
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(Messages.PromotionConfigurationEditor_SECTION_IBMI_PF);
        section.setDescription(Messages.PromotionConfigurationEditor_SECTION_IBMI_PF_DESCRIPTION);
        Composite composite = toolkit.createComposite((Composite)section);
        TableWrapData compositeData = new TableWrapData(256, 256);
        compositeData.colspan = 2;
        composite.setLayoutData((Object)compositeData);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.ibmiRestorePfReplaceMethod = toolkit.createButton(composite, Messages.PromotionConfigurationEditor_BUTTON_PROMOTION_IBMI_RESTORE_PF_DEFAULT, 16);
        boolean selected = restoreOptionNotSet || "REPLACE".equals(restoreOptionProperty.getValue());
        this.ibmiRestorePfReplaceMethod.setSelection(selected);
        this.ibmiRestorePfReplaceMethod.setData((Object)"REPLACE");
        this.ibmiRestorePfReplaceMethod.setEnabled(true);
        this.ibmiRestorePfReplaceMethod.addSelectionListener(this.getIbmiRstPfReplaceListener());
        this.ibmiRestorePfReplaceMethod.setLayoutData((Object)new TableWrapData());
        this.tabList.add((Control)this.ibmiRestorePfReplaceMethod);
        this.ibmiRestorePfMigrateMethod = toolkit.createButton(composite, Messages.PromotionConfigurationEditor_BUTTON_PROMOTION_IBMI_RESTORE_PF_MIGRATE, 16);
        selected = !restoreOptionNotSet && "MIGRATE".equals(restoreOptionProperty.getValue());
        this.ibmiRestorePfMigrateMethod.setSelection(selected);
        this.ibmiRestorePfMigrateMethod.setData((Object)"MIGRATE");
        this.ibmiRestorePfMigrateMethod.setEnabled(true);
        this.ibmiRestorePfMigrateMethod.addSelectionListener(this.getIbmiRstPfMigrateListener());
        this.ibmiRestorePfMigrateMethod.setLayoutData((Object)new TableWrapData());
        this.tabList.add((Control)this.ibmiRestorePfMigrateMethod);
        this.ibmiRestorePfUsrCmdMethod = toolkit.createButton(composite, Messages.PromotionConfigurationEditor_BUTTON_PROMOTION_IBMI_RESTORE_PF_USRCMD, 16);
        selected = !restoreOptionNotSet && "USRCMD".equals(restoreOptionProperty.getValue());
        this.ibmiRestorePfUsrCmdMethod.setSelection(selected);
        this.ibmiRestorePfUsrCmdMethod.setData((Object)"USRCMD");
        this.ibmiRestorePfUsrCmdMethod.setEnabled(true);
        this.ibmiRestorePfUsrCmdMethod.addSelectionListener(this.getIbmiRstPfUsrCmdListener());
        this.ibmiRestorePfUsrCmdMethod.setLayoutData((Object)new TableWrapData());
        this.tabList.add((Control)this.ibmiRestorePfUsrCmdMethod);
        IBuildProperty property = this.buildDefinitionWorkingCopy.getProperty("team.promotion.ibmi.pfRestoreCommand");
        String propertyValue = "";
        if (property != null) {
            propertyValue = property.getValue();
        }
        this.ibmiRestorePfUsrCmdText = toolkit.createText(composite, propertyValue, 0);
        selected = !restoreOptionNotSet && "USRCMD".equals(restoreOptionProperty.getValue());
        this.ibmiRestorePfUsrCmdText.setEnabled(selected);
        this.ibmiRestorePfUsrCmdText.addModifyListener((ModifyListener)this);
        TableWrapData textEntryData = new TableWrapData(256, 256);
        textEntryData.indent = 15;
        this.ibmiRestorePfUsrCmdText.setLayoutData((Object)textEntryData);
        this.tabList.add((Control)this.ibmiRestorePfUsrCmdText);
    }

    protected SelectionListener getIbmiRstPfReplaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.ibmiRestorePfReplaceMethod.getSelection()) {
                    PromotionBuildConfigurationEditor.this.buildDefinitionWorkingCopy.setProperty("team.promotion.ibmi.pfRestoreMethod", "REPLACE");
                    PromotionBuildConfigurationEditor.this.ibmiRestorePfUsrCmdText.setEnabled(false);
                    PromotionBuildConfigurationEditor.this.setDirty(true);
                }
                PromotionBuildConfigurationEditor.this.validate();
            }
        };
    }

    protected SelectionListener getIbmiRstPfMigrateListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.ibmiRestorePfMigrateMethod.getSelection()) {
                    PromotionBuildConfigurationEditor.this.buildDefinitionWorkingCopy.setProperty("team.promotion.ibmi.pfRestoreMethod", "MIGRATE");
                    PromotionBuildConfigurationEditor.this.ibmiRestorePfUsrCmdText.setEnabled(false);
                    PromotionBuildConfigurationEditor.this.setDirty(true);
                }
                PromotionBuildConfigurationEditor.this.validate();
            }
        };
    }

    protected SelectionListener getIbmiRstPfUsrCmdListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.ibmiRestorePfUsrCmdMethod.getSelection()) {
                    PromotionBuildConfigurationEditor.this.buildDefinitionWorkingCopy.setProperty("team.promotion.ibmi.pfRestoreMethod", "USRCMD");
                    PromotionBuildConfigurationEditor.this.ibmiRestorePfUsrCmdText.setEnabled(true);
                    PromotionBuildConfigurationEditor.this.setDirty(true);
                }
                PromotionBuildConfigurationEditor.this.validate();
            }
        };
    }

    private void createPromotionSection(Composite parent) {
        this.tabList = new ArrayList<Control>();
        this.promotionSection = this.fToolkit.createSection(parent, 384);
        this.promotionSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.promotionSection.setLayout((Layout)new TableWrapLayout());
        this.promotionSection.setText(Messages.PromotionConfigurationEditor_CONFIG_SECTION_TITLE);
        this.promotionSection.setDescription(Messages.PromotionConfigurationEditor_CONFIG_SECTION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.promotionSection);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.createMandatoryWidgets(composite, this.tabList);
        this.promotionSection.setClient((Control)composite);
    }

    private void setPromotionTypeProperty(int type) {
        switch (type) {
            case 1: {
                this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.both", true);
                this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.wi", false);
                this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.comp", false);
                break;
            }
            case 2: {
                this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.both", false);
                this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.wi", true);
                this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.comp", false);
                break;
            }
            case 3: {
                this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.both", false);
                this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.wi", false);
                this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.comp", true);
            }
        }
    }

    private void createMandatoryWidgets(Composite mandatoryComposite, List<Control> tabList) {
        this.fSourceDefinitionTitleHyperlink = this.fToolkit.createHyperlink(mandatoryComposite, Messages.PromotionConfigurationEditor_CONFIG_SOURCE_LABEL, 0);
        this.fSourceDefinitionTitleHyperlink.addHyperlinkListener(this.getBuildDefinitionHyperlinkListener(true));
        this.fEnabledHyperlinkForegroundColor = this.fSourceDefinitionTitleHyperlink.getForeground();
        this.sourceBuildDefText = this.fToolkit.createText(mandatoryComposite, Messages.PromotionConfigurationEditor_JOBNAME_PENDING);
        this.sourceBuildDefText.setLayoutData((Object)new TableWrapData(256));
        this.sourceBuildDefText.setEditable(false);
        this.sourceBuildDefText.setBackground(Display.getCurrent().getSystemColor(19));
        this.sourceBuildDefBrowseButton = this.fToolkit.createButton(mandatoryComposite, Messages.PromotionConfigurationEditor_CONFIG_BUTTON_BROWSE, 8);
        this.sourceBuildDefBrowseButton.setEnabled(false);
        this.fDisabledHyperlinkForegroundColor = this.sourceBuildDefText.getForeground();
        tabList.add((Control)this.sourceBuildDefText);
        tabList.add((Control)this.sourceBuildDefBrowseButton);
        String propertyId = PromotionBuildPropertyFactory.getInstance().resolvePropertyId("team.enterprise.promotion.sourceDefinition", this.buildDefinitionWorkingCopy);
        ResolveBuildDefinitionJob resolveSourceBuildJob = new ResolveBuildDefinitionJob(this.sourceBuildDefText, this.sourceBuildDefBrowseButton, this.fSourceDefinitionTitleHyperlink, propertyId, false);
        resolveSourceBuildJob.schedule();
        this.fTargetDefinitionTitleHyperlink = this.fToolkit.createHyperlink(mandatoryComposite, Messages.PromotionConfigurationEditor_CONFIG_TARGET_LABEL, 0);
        this.fTargetDefinitionTitleHyperlink.addHyperlinkListener(this.getBuildDefinitionHyperlinkListener(false));
        this.targetBuildDefText = this.fToolkit.createText(mandatoryComposite, Messages.PromotionConfigurationEditor_JOBNAME_PENDING);
        this.targetBuildDefText.setLayoutData((Object)new TableWrapData(256));
        this.targetBuildDefText.setEditable(false);
        this.targetBuildDefText.setBackground(Display.getCurrent().getSystemColor(19));
        this.targetBuildDefBrowseButton = this.fToolkit.createButton(mandatoryComposite, Messages.PromotionConfigurationEditor_CONFIG_BUTTON_BROWSE, 8);
        this.targetBuildDefBrowseButton.setEnabled(false);
        this.streamNoScanningWarningHolder = this.createScanningWarningHolder(mandatoryComposite, this.targetBuildDefText);
        TableWrapData holderLayoutData = new TableWrapData();
        holderLayoutData.maxWidth = 0;
        holderLayoutData.maxHeight = 0;
        holderLayoutData.colspan = 3;
        this.streamNoScanningWarningHolder.setLayoutData((Object)holderLayoutData);
        tabList.add((Control)this.targetBuildDefText);
        tabList.add((Control)this.targetBuildDefBrowseButton);
        propertyId = PromotionBuildPropertyFactory.getInstance().resolvePropertyId("team.enterprise.promotion.targetDefinition", this.buildDefinitionWorkingCopy);
        ResolveBuildDefinitionJob resolveTargetBuildJob = new ResolveBuildDefinitionJob(this.targetBuildDefText, this.targetBuildDefBrowseButton, this.fTargetDefinitionTitleHyperlink, propertyId, true);
        resolveTargetBuildJob.schedule();
        this.sourceBuildDefBrowseButton.addSelectionListener((SelectionListener)this);
        this.targetBuildDefBrowseButton.addSelectionListener((SelectionListener)this);
        String buildPropertyTypeBoth = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.both");
        boolean isTypeBoth = true;
        if (buildPropertyTypeBoth == null) {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.both", true);
            isTypeBoth = true;
        } else {
            isTypeBoth = Boolean.parseBoolean(buildPropertyTypeBoth);
        }
        String buildPropertyTypeWI = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.wi");
        boolean isTypeWI = false;
        if (buildPropertyTypeWI == null) {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.wi", false);
            isTypeWI = false;
        } else {
            isTypeWI = Boolean.parseBoolean(buildPropertyTypeWI);
        }
        String buildPropertyTypeComp = this.getPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.comp");
        boolean isTypeComp = false;
        if (buildPropertyTypeComp == null) {
            this.setPromotionPropertyValue("com.ibm.team.enterprise.promotion.type.comp", false);
            isTypeComp = false;
        } else {
            isTypeComp = Boolean.parseBoolean(buildPropertyTypeComp);
        }
        this.typeEnableBoth = this.fToolkit.createButton(mandatoryComposite, Messages.PromotionConfigurationEditor_TAB_TYPE_ENABLE_BOTH, 16);
        TableWrapData tableLayoutData = new TableWrapData(128);
        tableLayoutData.colspan = 3;
        this.typeEnableBoth.setLayoutData((Object)tableLayoutData);
        tabList.add((Control)this.typeEnableBoth);
        this.typeEnableBoth.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.typeEnableBoth.getSelection()) {
                    if (PromotionBuildConfigurationEditor.this.workitemPromotionTab == null || PromotionBuildConfigurationEditor.this.workitemPromotionTab.isDisposed()) {
                        PromotionBuildConfigurationEditor.this.createWorkItemTab();
                    }
                    if (PromotionBuildConfigurationEditor.this.componentPromotionTab == null || PromotionBuildConfigurationEditor.this.componentPromotionTab.isDisposed()) {
                        PromotionBuildConfigurationEditor.this.createComponentTab();
                    }
                    PromotionBuildConfigurationEditor.this.setPromotionTypeProperty(1);
                }
                PromotionBuildConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.typeEnableWI = this.fToolkit.createButton(mandatoryComposite, Messages.PromotionConfigurationEditor_TAB_TYPE_ENABLE_WI, 16);
        tableLayoutData = new TableWrapData(128);
        tableLayoutData.colspan = 3;
        this.typeEnableWI.setLayoutData((Object)tableLayoutData);
        tabList.add((Control)this.typeEnableWI);
        this.typeEnableWI.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.typeEnableWI.getSelection()) {
                    PromotionBuildConfigurationEditor.this.componentPromotionTab.dispose();
                    if (PromotionBuildConfigurationEditor.this.workitemPromotionTab == null || PromotionBuildConfigurationEditor.this.workitemPromotionTab.isDisposed()) {
                        PromotionBuildConfigurationEditor.this.createWorkItemTab();
                    }
                    PromotionBuildConfigurationEditor.this.setPromotionTypeProperty(2);
                    if (PromotionBuildConfigurationEditor.this.componentTableViewer != null && !PromotionBuildConfigurationEditor.this.componentTableViewer.getControl().isDisposed()) {
                        PromotionBuildConfigurationEditor.this.removeMessage(PromotionBuildConfigurationEditor.this.componentTableViewer.getTable(), (Control)PromotionBuildConfigurationEditor.this.componentTableViewer.getTable());
                    }
                }
                PromotionBuildConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.typeEnableComp = this.fToolkit.createButton(mandatoryComposite, Messages.PromotionConfigurationEditor_TAB_TYPE_ENABLE_COMP, 16);
        tableLayoutData = new TableWrapData(128);
        tableLayoutData.colspan = 3;
        this.typeEnableComp.setLayoutData((Object)tableLayoutData);
        tabList.add((Control)this.typeEnableComp);
        this.typeEnableComp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PromotionBuildConfigurationEditor.this.typeEnableComp.getSelection()) {
                    PromotionBuildConfigurationEditor.this.workitemPromotionTab.dispose();
                    if (PromotionBuildConfigurationEditor.this.componentPromotionTab == null || PromotionBuildConfigurationEditor.this.componentPromotionTab.isDisposed()) {
                        PromotionBuildConfigurationEditor.this.createComponentTab();
                    }
                    PromotionBuildConfigurationEditor.this.setPromotionTypeProperty(3);
                }
                PromotionBuildConfigurationEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.typeEnableBoth.setSelection(isTypeBoth);
        this.typeEnableWI.setSelection(isTypeWI);
        this.typeEnableComp.setSelection(isTypeComp);
        this.createSnapshotButton = this.fToolkit.createButton(mandatoryComposite, Messages.PromotionConfigurationEditor_CREATE_SNAPSHOT_LABEL, 32);
        tableLayoutData = new TableWrapData(128);
        tableLayoutData.colspan = 3;
        this.createSnapshotButton.setLayoutData((Object)tableLayoutData);
        boolean value = Boolean.parseBoolean(PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("com.ibm.team.enterprise.promotion.createSnapshot", this.elementId, this.buildDefinitionWorkingCopy));
        this.createSnapshotButton.setSelection(value);
        this.createSnapshotButton.addSelectionListener((SelectionListener)this);
        tabList.add((Control)this.createSnapshotButton);
        mandatoryComposite.setTabList(tabList.toArray(new Control[0]));
    }

    protected void setBuildDefinitionTitleHyperlinkEnablement(Hyperlink hyperlink, boolean enabled) {
        hyperlink.setForeground(enabled ? this.fEnabledHyperlinkForegroundColor : this.fDisabledHyperlinkForegroundColor);
        hyperlink.setUnderlined(enabled);
        hyperlink.setEnabled(enabled);
    }

    protected IHyperlinkListener getBuildDefinitionHyperlinkListener(final boolean isSource) {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PromotionBuildConfigurationEditor.this.openBuildDefinitionEditor(isSource);
            }
        };
    }

    protected void openBuildDefinitionEditor(boolean isSource) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                IBuildDefinition buildDef = isSource ? (IBuildDefinition)this.sourceBuildDefText.getData("buildDefinition") : (IBuildDefinition)this.targetBuildDefText.getData("buildDefinition");
                ITeamRepository repository = this.getTeamRepository();
                IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)buildDef.getProcessArea(), 0, (IProgressMonitor)new NullProgressMonitor());
                BuildDefinitionEditorInput input = new BuildDefinitionEditorInput(buildDef, processArea, this.getTeamRepository(), false);
                page.openEditor((IEditorInput)input, "com.ibm.team.build.ui.editors.buildDefinitionEditor");
            }
            catch (Exception e) {
                PromotionUIPlugin.log(e);
            }
        }
    }

    private void createComponentSelectionWidgets(Composite parent) {
        Table componentTable = this.fToolkit.createTable(parent, 66338);
        componentTable.setSize(200, 150);
        TableWrapData tableData = new TableWrapData(256);
        tableData.colspan = 2;
        tableData.heightHint = 115;
        componentTable.setLayoutData((Object)tableData);
        componentTable.pack();
        this.componentTableViewer = new CheckboxTableViewer(componentTable);
        ComponentSelectionTableContentProvider componentTableContentProvider = new ComponentSelectionTableContentProvider();
        ComponentSelectionTableLabelProvider componentTableLabelProvider = new ComponentSelectionTableLabelProvider();
        this.componentTableViewer.setContentProvider((IContentProvider)componentTableContentProvider);
        this.componentTableViewer.setLabelProvider((IBaseLabelProvider)componentTableLabelProvider);
        Object tableInput = this.sourceBuildDefText.getData();
        if (tableInput instanceof String && !((String)tableInput).equalsIgnoreCase("")) {
            this.componentTableViewer.setInput(tableInput);
        }
        this.componentTableViewer.addCheckStateListener((ICheckStateListener)this);
        Composite buttonComposite = this.fToolkit.createComposite(parent);
        buttonComposite.setLayoutData((Object)new TableWrapData(128));
        TableWrapLayout buttonLayout = new TableWrapLayout();
        buttonLayout.makeColumnsEqualWidth = false;
        buttonLayout.leftMargin = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        this.selectAllButton = this.fToolkit.createButton(buttonComposite, Messages.PromotionConfigurationEditor_CONFIG_BUTTON_SELECTALL, 8);
        TableWrapData buttonData = new TableWrapData(128);
        this.selectAllButton.setLayoutData((Object)buttonData);
        this.selectAllButton.addSelectionListener((SelectionListener)this);
        this.deselectAllButton = this.fToolkit.createButton(buttonComposite, Messages.PromotionConfigurationEditor_CONFIG_BUTTON_DESELECT, 8);
        buttonData = new TableWrapData(128);
        this.deselectAllButton.setLayoutData((Object)buttonData);
        this.deselectAllButton.addSelectionListener((SelectionListener)this);
    }

    private void createBuildTargetSection(Composite parent) {
        this.tabList = new ArrayList<Control>();
        this.targetSection = this.fToolkit.createSection(parent, 418);
        this.targetSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.targetSection.setLayout((Layout)new TableWrapLayout());
        this.targetSection.setText(Messages.PromotionConfigurationEditor_TARGET_SECTION_TITLE);
        this.targetSection.setDescription(Messages.PromotionConfigurationEditor_TARGET_SECTION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.targetSection);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.createBuildTargetControls(composite, this.tabList);
        this.targetSection.setClient((Control)composite);
    }

    private void createOutputSection(Composite parent) {
        this.outputSection = this.fToolkit.createSection(parent, 450);
        this.outputSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.outputSection.setLayout((Layout)new TableWrapLayout());
        this.outputSection.setText(Messages.PromotionBinaryOutputSection_Title);
        this.outputSection.setDescription(Messages.PromotionBinaryOutputSection_Description);
        Composite composite = this.fToolkit.createComposite((Composite)this.outputSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.createDestinationDirWidgets(composite);
        this.createSpacer(composite, 5, 3);
        if (PromotionBuildUtil.isZosPromotionBuild((IBuildDefinition)this.buildDefinitionWorkingCopy)) {
            this.createZosScript(composite);
        } else if (PromotionBuildUtil.isIBMiPromotionBuild((IBuildDefinition)this.buildDefinitionWorkingCopy)) {
            this.createIBMiPrePostCommands(composite);
        }
        this.skipTimestampCheckButton = this.fToolkit.createButton(composite, Messages.PromotionConfigurationEditor_SKIP_TIMESTAMP_CHECK_LABEL, 32);
        TableWrapData tableLayoutData = new TableWrapData(128);
        tableLayoutData.colspan = 3;
        this.skipTimestampCheckButton.setLayoutData((Object)tableLayoutData);
        boolean value = Boolean.parseBoolean(this.buildDefinitionWorkingCopy.getPropertyValue("com.ibm.team.enterprise.promotion.skipTimestampCheck", Boolean.FALSE.toString()));
        this.skipTimestampCheckButton.setSelection(value);
        this.skipTimestampCheckButton.addSelectionListener((SelectionListener)this);
        this.publishBuildMapLinksButton = this.fToolkit.createButton(composite, Messages.PromotionConfigurationEditor_BUTTON_BUILDMAPLINKS, 32);
        String publishBuildMapsValue = PromotionBuildPropertyFactory.getInstance().getBuildPropertyValue("team.enterprise.promotion.suppressBuildMapLinks", this.buildDefinitionWorkingCopy, Boolean.toString(false));
        TableWrapData buttonData = new TableWrapData();
        buttonData = new TableWrapData();
        buttonData.colspan = 2;
        this.publishBuildMapLinksButton.setLayoutData((Object)buttonData);
        this.publishBuildMapLinksButton.setSelection(!Boolean.parseBoolean(publishBuildMapsValue));
        this.publishBuildMapLinksButton.addSelectionListener((SelectionListener)this);
        this.outputSection.setClient((Control)composite);
    }

    private void createBuildTargetControls(Composite parent, List<Control> tabList) {
        String propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("teamz.build.ant.buildFile", this.elementId, this.buildDefinitionWorkingCopy);
        this.generateButton = this.fToolkit.createButton(parent, Messages.PromotionConfigurationEditor_TARGET_BUTTON_GENERATE, 16);
        TableWrapData buttonData = new TableWrapData();
        buttonData.colspan = 2;
        this.generateButton.setLayoutData((Object)buttonData);
        this.generateButton.setSelection(propertyValue == null || propertyValue.trim().equals(""));
        this.generateButton.addSelectionListener((SelectionListener)this);
        this.customButton = this.fToolkit.createButton(parent, Messages.PromotionConfigurationEditor_TARGET_BUTTON_CUSTOM, 16);
        buttonData = new TableWrapData();
        buttonData.colspan = 2;
        this.customButton.setLayoutData((Object)buttonData);
        this.customButton.setSelection(propertyValue != null && !propertyValue.trim().equals(""));
        this.customButton.addSelectionListener((SelectionListener)this);
        tabList.add((Control)this.generateButton);
        tabList.add((Control)this.customButton);
        this.createSpacer(parent, 5, 2);
        this.createBuildFileWidgets(parent, tabList);
        this.createBuildTargetWidgets(parent, tabList);
        this.updateBuildTargetWidgetState();
        parent.setTabList(tabList.toArray(new Control[0]));
    }

    private void createBuildFileWidgets(Composite parent, List<Control> tabList) {
        String propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("teamz.build.ant.buildFile", this.elementId, this.buildDefinitionWorkingCopy);
        this.buildFileLabel = this.fToolkit.createLabel(parent, Messages.PromotionConfigurationEditor_TARGET_BUILDFILE_LABEL);
        TableWrapData labelData = new TableWrapData(128);
        labelData.indent = 15;
        this.buildFileLabel.setLayoutData((Object)labelData);
        this.buildFileText = this.fToolkit.createText(parent, propertyValue);
        this.buildFileText.setLayoutData((Object)new TableWrapData(256));
        this.buildFileText.addModifyListener((ModifyListener)this);
        this.createSpacer(parent, 5, 1);
        this.buildFileDescriptionLabel = new Text(parent, 8);
        this.buildFileDescriptionLabel.setText(Messages.PromotionConfigurationEditor_TARGET_BUILDFILE_DESCRIPTION);
        TableWrapData descriptionData = new TableWrapData(256);
        this.buildFileDescriptionLabel.setLayoutData((Object)descriptionData);
        this.buildFileDescriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        tabList.add((Control)this.buildFileText);
        tabList.add((Control)this.buildFileDescriptionLabel);
    }

    private void createBuildTargetWidgets(Composite parent, List<Control> tabList) {
        String propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("teamz.build.ant.buildTarget", this.elementId, this.buildDefinitionWorkingCopy);
        this.buildTargetLabel = this.fToolkit.createLabel(parent, Messages.PromotionConfigurationEditor_TARGET_BUILDTARGET_LABEL);
        TableWrapData labelData = new TableWrapData(128);
        labelData.indent = 15;
        this.buildTargetLabel.setLayoutData((Object)labelData);
        this.buildTargetText = this.fToolkit.createText(parent, propertyValue);
        this.buildTargetText.setLayoutData((Object)new TableWrapData(256));
        this.buildTargetText.addModifyListener((ModifyListener)this);
        tabList.add((Control)this.buildTargetText);
    }

    private void createDestinationDirWidgets(Composite parent) {
        String propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("team.enterprise.promotion.destinationPath", this.elementId, this.buildDefinitionWorkingCopy);
        this.createSpacer(parent, 5, 3);
        Label dirLabel = this.fToolkit.createLabel(parent, Messages.PromotionConfigurationEditor_TARGET_WORKINGDIR_LABEL);
        TableWrapData labelData = new TableWrapData();
        labelData.colspan = 1;
        dirLabel.setLayoutData((Object)labelData);
        this.destinationDirText = this.fToolkit.createText(parent, propertyValue);
        TableWrapData textData = new TableWrapData(256);
        textData.colspan = 2;
        this.destinationDirText.setLayoutData((Object)textData);
        Text destinationDirTextDesc = new Text(parent, 8);
        destinationDirTextDesc.setText(Messages.PromotionConfigurationEditor_TARGET_WORKINGDIR_DESC);
        TableWrapData descData = new TableWrapData(256);
        descData.colspan = 3;
        destinationDirTextDesc.setLayoutData((Object)descData);
        destinationDirTextDesc.setForeground(Display.getDefault().getSystemColor(16));
        this.destinationDirText.addModifyListener((ModifyListener)this);
    }

    private void createConfigurationSection(Composite parent) {
        Section configurationSection = this.fToolkit.createSection(parent, 418);
        configurationSection.setLayoutData((Object)new TableWrapData(256, 256));
        configurationSection.setLayout((Layout)new TableWrapLayout());
        configurationSection.setText(Messages.AntzConfigurationEditor_CONFIG_SECTION_TEXT);
        configurationSection.setDescription(Messages.AntzConfigurationEditor_CONFIG_SECTION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)configurationSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createAntHomeWidgets(composite);
        this.createAntArgsWidgets(composite);
        this.createWorkingDirWidgets(composite);
        this.createJavaHomeWidgets(composite);
        this.createJavaArgsWidgets(composite);
        this.createPropertiesFileWidgets(composite);
        configurationSection.setClient((Control)composite);
    }

    private void createZosScript(Composite parent) {
        String propertyValue = this.buildDefinitionWorkingCopy.getPropertyValue("team.promotion.zos.script", "/etc/jazz/ccm/startispf.sh");
        Label zosScript = this.fToolkit.createLabel(parent, Messages.PromotionConfigurationEditor_ZOS_SCRIPT_LABEL);
        TableWrapData zosScriptData = new TableWrapData();
        zosScriptData.colspan = 1;
        zosScript.setLayoutData((Object)zosScriptData);
        this.zosScriptText = this.fToolkit.createText(parent, propertyValue);
        TableWrapData data = new TableWrapData(256);
        data.colspan = 2;
        this.zosScriptText.setLayoutData((Object)data);
        this.zosScriptText.addModifyListener((ModifyListener)this);
    }

    private void createAntHomeWidgets(Composite parent) {
        String propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("teamz.build.ant.antHome", this.elementId, this.buildDefinitionWorkingCopy);
        this.fToolkit.createLabel(parent, Messages.AntzConfigurationEditor_ANT_HOME_LABEL);
        this.antHomeText = this.fToolkit.createText(parent, propertyValue);
        this.antHomeText.setLayoutData((Object)new TableWrapData(256));
        this.antHomeText.addModifyListener((ModifyListener)this);
    }

    private void createIBMiPrePostCommands(Composite parent) {
        String property = this.buildDefinitionWorkingCopy.getPropertyValue("team.enterprise.promotion.ibmi.preCommand", "");
        Label preLabel = this.fToolkit.createLabel(parent, Messages.PromotionConfigurationEditor_IBMI_PRE_COMMAND_LABEL);
        TableWrapData preLabelData = new TableWrapData();
        preLabelData.colspan = 1;
        preLabel.setLayoutData((Object)preLabelData);
        this.ibmiPreCommandText = this.fToolkit.createText(parent, property);
        TableWrapData preTextData = new TableWrapData(256);
        preTextData.colspan = 2;
        this.ibmiPreCommandText.setLayoutData((Object)preTextData);
        this.ibmiPreCommandText.addModifyListener((ModifyListener)this);
        property = this.buildDefinitionWorkingCopy.getPropertyValue("team.enterprise.promotion.ibmi.postCommand", "");
        Label postLabel = this.fToolkit.createLabel(parent, Messages.PromotionConfigurationEditor_IBMI_POST_COMMAND_LABEL);
        TableWrapData postLabelData = new TableWrapData();
        postLabelData.colspan = 1;
        postLabel.setLayoutData((Object)postLabelData);
        this.ibmiPostCommandText = this.fToolkit.createText(parent, property);
        TableWrapData textData = new TableWrapData(256);
        textData.colspan = 2;
        this.ibmiPostCommandText.setLayoutData((Object)textData);
        this.ibmiPostCommandText.addModifyListener((ModifyListener)this);
    }

    private void createAntArgsWidgets(Composite parent) {
        String propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("teamz.build.ant.antArgs", this.elementId, this.buildDefinitionWorkingCopy);
        this.fToolkit.createLabel(parent, Messages.AntzConfigurationEditor_ANT_ARGS_LABEL);
        this.antArgsText = this.fToolkit.createText(parent, propertyValue);
        this.antArgsText.setLayoutData((Object)new TableWrapData(256));
        this.antArgsText.addModifyListener((ModifyListener)this);
    }

    private void createWorkingDirWidgets(Composite parent) {
        String propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("teamz.build.ant.workingDir", this.elementId, this.buildDefinitionWorkingCopy);
        this.fToolkit.createLabel(parent, Messages.AntzConfigurationEditor_WORKING_DIR_LABEL);
        this.workingDirText = this.fToolkit.createText(parent, propertyValue);
        this.workingDirText.setLayoutData((Object)new TableWrapData(256));
        this.workingDirText.addModifyListener((ModifyListener)this);
    }

    private void createJavaHomeWidgets(Composite parent) {
        String propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("teamz.build.ant.javaHome", this.elementId, this.buildDefinitionWorkingCopy);
        this.fToolkit.createLabel(parent, Messages.AntzConfigurationEditor_JAVA_HOME_LABEL);
        this.javaHomeText = this.fToolkit.createText(parent, propertyValue);
        this.javaHomeText.setLayoutData((Object)new TableWrapData(256));
        this.javaHomeText.addModifyListener((ModifyListener)this);
    }

    private void createJavaArgsWidgets(Composite parent) {
        String propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("teamz.build.ant.javaVMArgs", this.elementId, this.buildDefinitionWorkingCopy);
        this.fToolkit.createLabel(parent, Messages.AntzConfigurationEditor_VM_ARGS_LABEL);
        this.javaArgsText = this.fToolkit.createText(parent, propertyValue);
        this.javaArgsText.setLayoutData((Object)new TableWrapData(256));
        this.javaArgsText.addModifyListener((ModifyListener)this);
    }

    private void createPropertiesFileWidgets(Composite parent) {
        String propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("teamz.build.ant.propertiesFile", this.elementId, this.buildDefinitionWorkingCopy);
        this.fToolkit.createLabel(parent, Messages.AntzConfigurationEditor_PROPERTIES_LABEL);
        this.propertiesFileText = this.fToolkit.createText(parent, propertyValue);
        this.propertiesFileText.setLayoutData((Object)new TableWrapData(256));
        this.propertiesFileText.addModifyListener((ModifyListener)this);
    }

    protected void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    public void setWorkingCopy(IBuildDefinition buildDefinition) {
        this.buildDefinitionWorkingCopy = buildDefinition;
        this.elementId = PromotionBuildPropertyFactory.getInstance().resolvePropertyId("com.ibm.team.enterprise.promotion.build", this.buildDefinitionWorkingCopy);
        if (this.buildDefinitionWorkingCopy != null) {
            if (PromotionBuildUtil.isIBMiPromotionBuild((IBuildDefinition)this.buildDefinitionWorkingCopy)) {
                this.promotionBuildType = PromotionInfo.PromotionBuildType.ibmi;
            } else if (PromotionBuildUtil.isZosPromotionBuild((IBuildDefinition)this.buildDefinitionWorkingCopy)) {
                this.promotionBuildType = PromotionInfo.PromotionBuildType.zos;
            }
        }
    }

    private IBuildDefinition resolveBuildDefinition(String uuidValue) {
        if (this.getTeamRepository() != null && !uuidValue.equalsIgnoreCase("")) {
            IItemHandle definitionHandle = IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuidValue), null);
            try {
                return (IBuildDefinition)this.getTeamRepository().itemManager().fetchCompleteItem(definitionHandle, 0, null);
            }
            catch (TeamRepositoryException e) {
                return null;
            }
        }
        return null;
    }

    public boolean validate() {
        String targetBuildTemplateId;
        boolean isValid = true;
        boolean isWarning = false;
        boolean isGenerate = true;
        if (!this.generateButton.isDisposed()) {
            isGenerate = this.generateButton.getSelection();
        }
        if (!isGenerate && this.buildFileText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.buildFileText, Messages.PromotionConfigurationEditor_BUILD_FILE_REQUIRED, (Control)this.buildFileText);
            isValid = false;
        } else {
            this.removeMessage(this.buildFileText, (Control)this.buildFileText);
        }
        if (PromotionBuildUtil.isIBMiPromotionBuild((IBuildDefinition)this.buildDefinitionWorkingCopy)) {
            if (this.ibmiRestorePfUsrCmdMethod.getSelection() && this.ibmiRestorePfUsrCmdText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.ibmiRestorePfUsrCmdText, Messages.PromotionConfigurationEditor_PF_USRCMD_NOT_VALID, (Control)this.ibmiRestorePfUsrCmdText);
                isValid = false;
            } else {
                this.removeMessage(this.ibmiRestorePfUsrCmdText, (Control)this.ibmiRestorePfUsrCmdText);
            }
        }
        if (this.destinationDirText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.destinationDirText, Messages.PromotionConfigurationEditor_DESTINATION_DIR_REQUIRED, (Control)this.destinationDirText);
            isValid = false;
        } else {
            this.removeMessage(this.destinationDirText, (Control)this.destinationDirText);
        }
        if (this.sourceBuildDefText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.sourceBuildDefText, Messages.PromotionConfigurationEditor_SOURCE_BUILDDEF_REQUIRED, (Control)this.sourceBuildDefText);
            isValid = false;
        } else {
            this.removeMessage(this.sourceBuildDefText, (Control)this.sourceBuildDefText);
        }
        if (this.targetBuildDefText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.targetBuildDefText, Messages.PromotionConfigurationEditor_TARGET_BUILDDEF_REQUIRED, (Control)this.targetBuildDefText);
            isValid = false;
        } else {
            this.removeMessage(this.targetBuildDefText, (Control)this.targetBuildDefText);
        }
        IBuildDefinition sourceBuildDefinition = (IBuildDefinition)this.sourceBuildDefText.getData("buildDefinition");
        IBuildDefinition targetBuildDefinition = (IBuildDefinition)this.targetBuildDefText.getData("buildDefinition");
        String sourceBuildTemplateId = sourceBuildDefinition != null ? sourceBuildDefinition.getPropertyValue("com.ibm.team.build.internal.template.id", "") : null;
        String string = targetBuildTemplateId = targetBuildDefinition != null ? targetBuildDefinition.getPropertyValue("com.ibm.team.build.internal.template.id", "") : null;
        if (sourceBuildTemplateId != null && targetBuildTemplateId != null && !sourceBuildTemplateId.equals(targetBuildTemplateId)) {
            this.addErrorMessageForRequiredField(this.sourceBuildDefText, Messages.PromotionConfigurationEditor_DIFFERENT_TEMPLATE_ERROR, (Control)this.sourceBuildDefText);
            isValid = false;
        } else {
            this.removeMessage(this.sourceBuildDefText, (Control)this.sourceBuildDefText);
        }
        IScanConfiguration scanConfiguration = (IScanConfiguration)this.targetBuildDefText.getData("scanConfiguration");
        if (scanConfiguration == null && targetBuildTemplateId != null) {
            IWorkspace stream = (IWorkspace)this.targetBuildDefText.getData("stream");
            this.addWarningMessage("STREAM_NOT_SUPPORT_SCANNING_WARNING", NLS.bind((String)Messages.PromotionConfigurationEditor_STREAM_NOT_SUPPORT_SCANNING_WARNING, (Object)targetBuildDefinition.getId(), (Object)stream.getName()), (Control)this.streamNoScanningWarningHolder);
        } else {
            this.removeMessage("STREAM_NOT_SUPPORT_SCANNING_WARNING", (Control)this.streamNoScanningWarningHolder);
        }
        this.validateComponents(isWarning);
        if (PromotionBuildUtil.isZosPromotionBuild((IBuildDefinition)this.buildDefinitionWorkingCopy)) {
            if (this.buildDefinitionWorkingCopy.getPropertyValue("team.promotion.zos.script", "").equals("")) {
                this.addErrorMessageForRequiredField(this.zosScriptText, Messages.PromotionConfigurationEditor_ERROR_GATEWAY_SCRIPT_EMPTY, (Control)this.zosScriptText);
                isValid = false;
            } else {
                this.removeMessage(this.zosScriptText, (Control)this.zosScriptText);
            }
        }
        this.setPageStatusIndicator(!isValid, isWarning);
        return isValid;
    }

    private void validateComponents(boolean isWarning) {
        if (this.typeEnableBoth.getSelection() || this.typeEnableComp.getSelection()) {
            if (this.componentTableViewer.getCheckedElements().length == 0) {
                this.addWarningMessage(this.componentTableViewer.getTable(), Messages.PromotionConfigurationEditor_WARNING_NOCOMPONENTS, (Control)this.componentTableViewer.getTable());
                isWarning = true;
            } else {
                this.removeMessage(this.componentTableViewer.getTable(), (Control)this.componentTableViewer.getTable());
            }
            this.setPageStatusIndicator(false, isWarning);
        }
    }

    private void validateHostNames() {
        String CONFIG_ELEMENT = "com.ibm.rational.buildforge.buildagent";
        String CONFIG_PROPERTY = "com.ibm.rational.buildforge.buildagent.hostname";
        this.removeMessage("promotion.validation.hostname.empty");
        this.removeMessage("promotion.validation.hostname.noengine");
        List supportingEngines = ((BuildDefinitionEditor)this.getEditor()).getSupportingEngines();
        if (!supportingEngines.isEmpty()) {
            String promoBuildEngineHost = null;
            if (supportingEngines.size() > 1) {
                for (IBuildEngine engine : supportingEngines) {
                    String currHost = engine.getConfigurationPropertyValue(CONFIG_ELEMENT, CONFIG_PROPERTY, null);
                    if (promoBuildEngineHost == null) {
                        promoBuildEngineHost = currHost;
                        continue;
                    }
                    if (!promoBuildEngineHost.equalsIgnoreCase(currHost)) {
                        this.addErrorMessage("promotion.validation.hostname.promotion", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_MISMATCH_SHORT, (IStatus)new Status(2, "com.ibm.team.enterprise.promotion.ui", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_MISMATCH_LONG));
                        return;
                    }
                    this.removeMessage("promotion.validation.hostname.promotion");
                }
            } else {
                promoBuildEngineHost = ((IBuildEngine)supportingEngines.get(0)).getConfigurationPropertyValue(CONFIG_ELEMENT, CONFIG_PROPERTY, null);
            }
            if (promoBuildEngineHost != null && this.buildEngines != null) {
                IBuildDefinition targetBuildDefinition;
                LinkedList<IBuildEngine> allEngines = this.buildEngines;
                IBuildDefinition sourceBuildDefinition = (IBuildDefinition)this.sourceBuildDefText.getData("buildDefinition");
                if (sourceBuildDefinition != null) {
                    for (IBuildEngine engine : allEngines) {
                        IBuildEngine currEngine = (IBuildEngine)engine.getWorkingCopy();
                        if (!currEngine.supportsBuildDefinition((IBuildDefinitionHandle)sourceBuildDefinition)) continue;
                        String currEngineHost = currEngine.getConfigurationPropertyValue(CONFIG_ELEMENT, CONFIG_PROPERTY, null);
                        if (!currEngineHost.equalsIgnoreCase(promoBuildEngineHost)) {
                            this.addErrorMessage("promotion.validation.hostname.source", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_SOURCE_MISMATCH_SHORT, (IStatus)new Status(2, "com.ibm.team.enterprise.promotion.ui", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_SOURCE_MISMATCH_LONG));
                            return;
                        }
                        this.removeMessage("promotion.validation.hostname.source");
                    }
                }
                if ((targetBuildDefinition = (IBuildDefinition)this.targetBuildDefText.getData("buildDefinition")) != null) {
                    for (IBuildEngine engine : allEngines) {
                        IBuildEngine currEngine = (IBuildEngine)engine.getWorkingCopy();
                        if (!currEngine.supportsBuildDefinition((IBuildDefinitionHandle)targetBuildDefinition)) continue;
                        String currEngineHost = currEngine.getConfigurationPropertyValue(CONFIG_ELEMENT, CONFIG_PROPERTY, null);
                        if (!currEngineHost.equalsIgnoreCase(promoBuildEngineHost)) {
                            this.addErrorMessage("promotion.validation.hostname.target", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_TARGET_MISMATCH_SHORT, (IStatus)new Status(2, "com.ibm.team.enterprise.promotion.ui", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_TARGET_MISMATCH_LONG));
                            return;
                        }
                        this.removeMessage("promotion.validation.hostname.target");
                    }
                }
            } else {
                this.addErrorMessage("promotion.validation.hostname.empty", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_INVALID_SHORT, (IStatus)new Status(2, "com.ibm.team.enterprise.promotion.ui", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_INVALID_LONG));
            }
        } else {
            this.addErrorMessage("promotion.validation.hostname.noengine", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_EMPTY_SHORT, (IStatus)new Status(2, "com.ibm.team.enterprise.promotion.ui", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_EMPTY_LONG));
        }
    }

    protected void validateHostNamesAndFetchtBuildEnginesInBackground(IProgressMonitor monitor) {
        if (this.job != null) {
            this.job.cancel();
        } else {
            this.job = new UIUpdaterJob(""){

                public IStatus runInBackground(IProgressMonitor monitor) {
                    LinkedList bEngines = new LinkedList();
                    try {
                        if (PromotionBuildConfigurationEditor.this.buildEngines == null) {
                            ITeamRepository repo = (ITeamRepository)PromotionBuildConfigurationEditor.this.buildDefinitionWorkingCopy.getOrigin();
                            if (repo == null) {
                                IProcessAreaHandle processArea = PromotionBuildConfigurationEditor.this.buildDefinitionWorkingCopy.getProcessArea();
                                repo = (ITeamRepository)processArea.getOrigin();
                            }
                            if (repo != null) {
                                IItemManager itemManager = repo.itemManager();
                                IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT);
                                ItemQueryIterator iter = new ItemQueryIterator((ITeamBuildClient)repo.getClientLibrary(ITeamBuildClient.class), itemQuery, IQueryService.EMPTY_PARAMETERS);
                                while (iter.hasNext(monitor)) {
                                    List engineHandles = iter.next(512, monitor);
                                    bEngines.addAll(itemManager.fetchCompleteItems(engineHandles, 1, monitor));
                                }
                                Iterator enginesIter = bEngines.iterator();
                                while (enginesIter.hasNext()) {
                                    Object next = enginesIter.next();
                                    if (next != null) continue;
                                    enginesIter.remove();
                                }
                                PromotionBuildConfigurationEditor.this.buildEngines = bEngines;
                            }
                        }
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    PromotionBuildConfigurationEditor.this.validateHostNames();
                    return super.runInUI(monitor);
                }
            };
        }
        this.job.schedule();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource == this.sourceBuildDefBrowseButton) {
            PromotionBuildDefinitionSelectionDialog selectionDialog = this.getSelectionDialog((String)this.targetBuildDefText.getData());
            if (selectionDialog.open() == 0) {
                IBuildDefinition definition = selectionDialog.getFirstSelectedBuildDefinition();
                PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("team.enterprise.promotion.sourceDefinition", definition.getItemId().getUuidValue(), this.elementId, this.buildDefinitionWorkingCopy);
                this.sourceBuildDefText.setData((Object)definition.getItemId().getUuidValue());
                this.sourceBuildDefText.setData("buildDefinition", (Object)definition);
                this.sourceBuildDefText.setText(definition.getId());
                this.sourceBuildDefText.setBackground(Display.getCurrent().getSystemColor(1));
                this.componentTableViewer.setInput((Object)definition);
                this.setBuildDefinitionTitleHyperlinkEnablement(this.fSourceDefinitionTitleHyperlink, true);
                this.validate();
                this.validateHostNamesAndFetchtBuildEnginesInBackground((IProgressMonitor)new NullProgressMonitor());
            }
        } else if (eventSource == this.targetBuildDefBrowseButton) {
            PromotionBuildDefinitionSelectionDialog selectionDialog = this.getSelectionDialog((String)this.sourceBuildDefText.getData());
            if (selectionDialog.open() == 0) {
                IBuildDefinition definition = selectionDialog.getFirstSelectedBuildDefinition();
                PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("team.enterprise.promotion.targetDefinition", definition.getItemId().getUuidValue(), this.elementId, this.buildDefinitionWorkingCopy);
                this.targetBuildDefText.setData((Object)definition.getItemId().getUuidValue());
                this.targetBuildDefText.setData("buildDefinition", (Object)definition);
                this.targetBuildDefText.setText(definition.getId());
                this.targetBuildDefText.setBackground(Display.getCurrent().getSystemColor(1));
                this.setBuildDefinitionTitleHyperlinkEnablement(this.fTargetDefinitionTitleHyperlink, true);
                this.initializeScanningEnablementStatus(definition, this.targetBuildDefText);
                this.validate();
                this.validateHostNamesAndFetchtBuildEnginesInBackground((IProgressMonitor)new NullProgressMonitor());
            }
        } else if (eventSource == this.generateButton || eventSource == this.customButton) {
            if (eventSource == this.generateButton && this.generateButton.getSelection()) {
                PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.buildFile", "", this.elementId, this.buildDefinitionWorkingCopy);
                PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.buildTarget", "", this.elementId, this.buildDefinitionWorkingCopy);
            } else if (eventSource == this.customButton && this.customButton.getSelection()) {
                PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.buildFile", this.buildFileText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
                PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.buildTarget", this.buildTargetText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
            }
            this.updateBuildTargetWidgetState();
            this.validate();
        } else if (eventSource == this.selectAllButton || eventSource == this.deselectAllButton) {
            this.componentTableViewer.setAllChecked(eventSource == this.selectAllButton);
            this.checkStateChanged(null);
        } else if (eventSource == this.skipTimestampCheckButton) {
            this.buildDefinitionWorkingCopy.setProperty("com.ibm.team.enterprise.promotion.skipTimestampCheck", Boolean.toString(this.skipTimestampCheckButton.getSelection()));
        } else if (eventSource == this.createSnapshotButton) {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("com.ibm.team.enterprise.promotion.createSnapshot", Boolean.toString(this.createSnapshotButton.getSelection()), this.elementId, this.buildDefinitionWorkingCopy);
        } else if (eventSource == this.publishBuildMapLinksButton) {
            this.buildDefinitionWorkingCopy.setProperty("team.enterprise.promotion.suppressBuildMapLinks", Boolean.toString(!this.publishBuildMapLinksButton.getSelection()));
        }
        this.setDirty(true);
    }

    private void updateBuildTargetWidgetState() {
        boolean isCustom = this.customButton.getSelection();
        this.buildFileText.setEnabled(isCustom);
        this.buildFileLabel.setEnabled(isCustom);
        this.buildFileDescriptionLabel.setEnabled(isCustom);
        this.buildTargetText.setEnabled(isCustom);
        this.buildTargetLabel.setEnabled(isCustom);
    }

    private PromotionBuildDefinitionSelectionDialog getSelectionDialog(String excludeUuidValue) {
        return new PromotionBuildDefinitionSelectionDialog(this.getEditorSite().getShell(), BuildUIDialogMessages.RequestBuildDialog_SELECT_DEFINITION_TITLE, BuildUIDialogMessages.RequestBuildDialog_SELECT_DEFINITION_MESSAGE, false, false, excludeUuidValue, this.promotionBuildType, this.buildDefinitionWorkingCopy, this.buildDefinitionWorkingCopy != null ? this.buildDefinitionWorkingCopy.getProcessArea() : null);
    }

    protected void updateSelectionState() {
        int numChecked = this.componentTableViewer.getCheckedElements().length;
        int totalItems = this.componentTableViewer.getTable().getItemCount();
        this.selectAllButton.setEnabled(true);
        if (numChecked == 0) {
            this.deselectAllButton.setEnabled(false);
        } else {
            this.deselectAllButton.setEnabled(true);
            if (numChecked == totalItems) {
                this.selectAllButton.setEnabled(false);
            }
        }
        this.validate();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("team.enterprise.promotion.componentList", this.getCurrentComponentListPropertyValue(), this.elementId, this.buildDefinitionWorkingCopy);
        this.updateSelectionState();
        this.validateComponents(false);
        this.setDirty(true);
    }

    private String getCurrentComponentListPropertyValue() {
        ArrayList<ComponentListProperty> componentList = new ArrayList<ComponentListProperty>();
        Object[] objectArray = this.componentTableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof ComponentListTableItem) {
                componentList.add(new ComponentListProperty((IComponentHandle)((ComponentListTableItem)item).getComponent()));
            }
            ++n2;
        }
        String encodedString = ComponentListPropertyParser.getInstance().encodeString(componentList);
        return encodedString;
    }

    public Control getFocusControl() {
        return this.sourceBuildDefText;
    }

    public void modifyText(ModifyEvent event) {
        Object eventSource = event.getSource();
        if (eventSource == this.buildTargetText) {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.buildTarget", this.buildTargetText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
        } else if (eventSource == this.buildFileText) {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.buildFile", this.buildFileText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
        } else if (eventSource == this.destinationDirText) {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("team.enterprise.promotion.destinationPath", this.destinationDirText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
        } else if (eventSource == this.antHomeText) {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.antHome", this.antHomeText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
        } else if (eventSource == this.antArgsText) {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.antArgs", this.antArgsText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
        } else if (eventSource == this.javaHomeText) {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.javaHome", this.javaHomeText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
        } else if (eventSource == this.javaArgsText) {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.javaVMArgs", this.javaArgsText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
        } else if (eventSource == this.propertiesFileText) {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.propertiesFile", this.propertiesFileText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
        } else if (eventSource == this.workingDirText) {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue("teamz.build.ant.workingDir", this.workingDirText.getText().trim(), this.elementId, this.buildDefinitionWorkingCopy);
        } else if (eventSource == this.zosScriptText) {
            this.buildDefinitionWorkingCopy.setProperty("team.promotion.zos.script", this.zosScriptText.getText().trim());
        } else if (eventSource == this.ibmiPreCommandText) {
            this.buildDefinitionWorkingCopy.setProperty("team.enterprise.promotion.ibmi.preCommand", this.ibmiPreCommandText.getText().trim());
        } else if (eventSource == this.ibmiPostCommandText) {
            this.buildDefinitionWorkingCopy.setProperty("team.enterprise.promotion.ibmi.postCommand", this.ibmiPostCommandText.getText().trim());
        } else if (eventSource == this.ibmiRestorePfUsrCmdText) {
            this.buildDefinitionWorkingCopy.setProperty("team.promotion.ibmi.pfRestoreCommand", this.ibmiRestorePfUsrCmdText.getText().trim());
        } else if (eventSource == this.pSourceOutputs || eventSource == this.pSourceOnly || eventSource == this.pCheckIncludeChildren || eventSource != this.pConsideredIgnored) {
            // empty if block
        }
        this.validate();
        this.setDirty(true);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active && this.zosScriptText != null) {
            String property = this.buildDefinitionWorkingCopy.getPropertyValue("team.promotion.zos.script", "");
            if (!this.zosScriptText.getText().equals(property)) {
                this.zosScriptText.setText(property);
            }
        }
    }

    private Composite createScanningWarningHolder(final Composite composite, final Text textField) {
        Composite holder = new Composite(composite, 0){

            public boolean setFocus() {
                boolean isFocus = textField.setFocus();
                if (isFocus) {
                    final IWorkspace stream = (IWorkspace)textField.getData("stream");
                    boolean yes = MessageDialog.openQuestion((Shell)composite.getShell(), (String)Messages.PromotionConfigurationEditor_SCD_SCANNING_DIALOG_TITLE, (String)NLS.bind((String)Messages.PromotionConfigurationEditor_SCD_SCANNING_DIALOG_PROMPT, (Object)stream.getName()));
                    if (yes) {
                        Job job = new Job(NLS.bind((String)Messages.PromotionConfigurationEditor_SCD_CREATE_SCAN_CONFIGURATION_JOB, (Object)stream.getName())){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    ((IScdClient)PromotionBuildConfigurationEditor.this.getTeamRepository().getClientLibrary(IScdClient.class)).createAndSaveDefaultScanConfiguration(stream);
                                    return Status.OK_STATUS;
                                }
                                catch (TeamRepositoryException e) {
                                    return new Status(4, "com.ibm.team.enterprise.build.ui", NLS.bind((String)Messages.PromotionConfigurationEditor_SCD_CREATE_SCAN_CONFIGURATION_FAILED, (Object)stream.getName()), (Throwable)e);
                                }
                            }
                        };
                        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                textField.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        PromotionBuildConfigurationEditor.this.removeMessage("STREAM_NOT_SUPPORT_SCANNING_WARNING", (Control)PromotionBuildConfigurationEditor.this.streamNoScanningWarningHolder);
                                    }
                                });
                            }
                        });
                        job.schedule();
                    }
                }
                return isFocus;
            }
        };
        holder.setVisible(false);
        return holder;
    }

    private void initializeScanningEnablementStatus(IBuildDefinition buildDefinition, Text textField) {
        String buildWorkspaceUuidValue;
        if (buildDefinition != null && textField != null && (buildWorkspaceUuidValue = buildDefinition.getPropertyValue("teamz.scm.workspaceUUID", null)) != null) {
            IWorkspaceHandle buildWorkspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildWorkspaceUuidValue), null);
            RetrieveScanningEnablementStatusJob job = new RetrieveScanningEnablementStatusJob(buildWorkspaceHandle);
            IScanConfiguration scanConfiguration = job.getScanConfiguration();
            textField.setData("scanConfiguration", (Object)scanConfiguration);
            textField.setData("stream", (Object)job.getStream());
        }
    }

    protected class ComponentListTableItem {
        private final IComponent component;

        public ComponentListTableItem(IComponent comp) {
            this.component = comp;
        }

        public IComponent getComponent() {
            return this.component;
        }
    }

    protected class ComponentSelectionTableContentProvider
    implements IStructuredContentProvider {
        private IBuildDefinition sourceDefinition = null;
        private List<ComponentListTableItem> contentList = null;
        private Job fetchComponentsJob = null;

        public ComponentSelectionTableContentProvider() {
            this.fetchComponentsJob = new FetchComponentsJob(Messages.PromotionConfigurationEditor_JOBNAME_FETCHCOMPONENTS, true, PromotionBuildConfigurationEditor.this.getTeamRepository());
        }

        public List<ComponentListTableItem> getItemList() {
            return this.contentList;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Object input = newInput;
            if (input != null) {
                if (input instanceof String) {
                    IBuildDefinition buildDef = PromotionBuildConfigurationEditor.this.resolveBuildDefinition((String)input);
                    input = buildDef;
                }
                if (input != null && input instanceof IBuildDefinition) {
                    this.sourceDefinition = (IBuildDefinition)input;
                    this.fetchComponentsJob.schedule();
                } else if (this.contentList != null) {
                    this.contentList.clear();
                } else {
                    this.contentList = new ArrayList<ComponentListTableItem>();
                }
            }
        }

        public Object[] getElements(Object arg0) {
            Object[] objectArray;
            if (this.contentList == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = Messages.PromotionConfigurationEditor_JOBNAME_FETCHCOMPONENTS;
            } else {
                objectArray = this.contentList.toArray();
            }
            return objectArray;
        }

        class FetchComponentsJob
        extends TeamBuildJob {
            FetchComponentsJob(String jobName, boolean isUserJob, ITeamRepository repo) {
                super(jobName, isUserJob, repo);
            }

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                TeamRepository sourceDefRepo = (TeamRepository)ComponentSelectionTableContentProvider.this.sourceDefinition.getOrigin();
                String workspaceUUID = DependencyBuildPropertyFactory.getInstance().getBuildPropertyValue("teamz.scm.workspaceUUID", ComponentSelectionTableContentProvider.this.sourceDefinition);
                try {
                    IWorkspace sourceDefWorkspace = BuildUtils.getWorkspaceFromUUID(workspaceUUID, (ITeamRepository)sourceDefRepo);
                    IWorkspaceConnection sourceDefWSConnection = BuildUtils.getWorkspaceConnection((ITeamRepository)sourceDefRepo, (IWorkspaceHandle)sourceDefWorkspace, (IProgressMonitor)new NullProgressMonitor());
                    List<IComponentHandle> sourceDefComps = BuildUtils.getAllComponentHandles(sourceDefWSConnection, (IProgressMonitor)new NullProgressMonitor());
                    if (ComponentSelectionTableContentProvider.this.contentList != null) {
                        ComponentSelectionTableContentProvider.this.contentList.clear();
                    } else {
                        ComponentSelectionTableContentProvider.this.contentList = new ArrayList();
                    }
                    for (IComponentHandle compHandle : sourceDefComps) {
                        IConfiguration config = sourceDefWSConnection.configuration(compHandle);
                        if (config == null) continue;
                        ComponentSelectionTableContentProvider.this.contentList.add(new ComponentListTableItem((IComponent)config.teamRepository().itemManager().fetchCompleteItem((IItemHandle)compHandle, 0, (IProgressMonitor)new NullProgressMonitor())));
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!PromotionBuildConfigurationEditor.this.componentTableViewer.getControl().isDisposed()) {
                            PromotionBuildConfigurationEditor.this.componentTableViewer.refresh(true);
                            IBuildConfigurationElement element = PromotionBuildConfigurationEditor.this.buildDefinitionWorkingCopy.getConfigurationElement(PromotionBuildConfigurationEditor.this.elementId);
                            String propertyId = PromotionBuildPropertyFactory.getInstance().resolvePropertyId("team.enterprise.promotion.componentList", PromotionBuildConfigurationEditor.this.buildDefinitionWorkingCopy);
                            IConfigurationProperty property = element.getConfigurationProperty(propertyId);
                            if (property != null) {
                                if (property.getValue().equalsIgnoreCase("")) {
                                    PromotionBuildConfigurationEditor.this.componentTableViewer.setAllChecked(false);
                                } else {
                                    List propertyList = ComponentListPropertyParser.getInstance().decodeString(property.getValue());
                                    ArrayList<String> checkedIDs = new ArrayList<String>();
                                    for (IComponentListProperty prop : propertyList) {
                                        checkedIDs.add(prop.getComponentUUID());
                                    }
                                    int numItems = PromotionBuildConfigurationEditor.this.componentTableViewer.getTable().getItemCount();
                                    int itemIndex = 0;
                                    while (itemIndex < numItems) {
                                        Object tableElement = PromotionBuildConfigurationEditor.this.componentTableViewer.getElementAt(itemIndex);
                                        String elementID = ((ComponentListTableItem)tableElement).getComponent().getItemId().getUuidValue();
                                        if (checkedIDs.contains(elementID)) {
                                            PromotionBuildConfigurationEditor.this.componentTableViewer.setChecked(tableElement, true);
                                        }
                                        ++itemIndex;
                                    }
                                }
                            } else {
                                PromotionBuildConfigurationEditor.this.componentTableViewer.setAllChecked(true);
                            }
                            PromotionBuildConfigurationEditor.this.updateSelectionState();
                        }
                    }
                });
            }
        }
    }

    protected class ComponentSelectionTableLabelProvider
    implements ITableLabelProvider {
        private IItemManager itemManager = null;

        protected ComponentSelectionTableLabelProvider() {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object item, int arg1) {
            if (this.itemManager == null) {
                this.itemManager = PromotionBuildConfigurationEditor.this.getTeamRepository().itemManager();
            }
            if (item instanceof ComponentListTableItem) {
                IComponent compItem = ((ComponentListTableItem)item).getComponent();
                String columnText = compItem.getName();
                return columnText;
            }
            if (item instanceof String) {
                return (String)item;
            }
            return null;
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    class ResolveBuildDefinitionJob
    extends TeamBuildJob {
        private Text targetWidget;
        private Button targetWidgetButton;
        private Hyperlink targetLink;
        private String propertyID;
        private String propertyValue;
        private IBuildDefinition def;
        private final boolean retrieveScanningEnablementStatus;

        ResolveBuildDefinitionJob(Text targetWidget, Button targetWidgetButton, Hyperlink targetLink, String propertyID, boolean retrieveScanningEnablementStatus) {
            super(Messages.PromotionConfigurationEditor_JOBNAME_RESOLVEBUILDDEF, true, PromotionBuildConfigurationEditor.this.getTeamRepository());
            this.targetWidget = null;
            this.targetWidgetButton = null;
            this.targetLink = null;
            this.propertyID = null;
            this.propertyValue = null;
            this.def = null;
            this.targetWidget = targetWidget;
            this.targetWidgetButton = targetWidgetButton;
            this.targetLink = targetLink;
            this.propertyID = propertyID;
            this.retrieveScanningEnablementStatus = retrieveScanningEnablementStatus;
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            this.propertyValue = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue(this.propertyID, PromotionBuildConfigurationEditor.this.elementId, PromotionBuildConfigurationEditor.this.buildDefinitionWorkingCopy);
            this.def = PromotionBuildConfigurationEditor.this.resolveBuildDefinition(this.propertyValue);
            return Status.OK_STATUS;
        }

        protected void jobFinished(IStatus status) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ResolveBuildDefinitionJob.this.targetWidget != null && !ResolveBuildDefinitionJob.this.targetWidget.isDisposed()) {
                        ResolveBuildDefinitionJob.this.targetWidget.setText(ResolveBuildDefinitionJob.this.propertyValue.equalsIgnoreCase("") ? "" : (ResolveBuildDefinitionJob.this.def != null ? ResolveBuildDefinitionJob.this.def.getId() : Messages.PromotionConfigurationEditor_ERROR_ITEMNOTFOUND));
                        ResolveBuildDefinitionJob.this.targetWidget.setData((Object)ResolveBuildDefinitionJob.this.propertyValue);
                        if (ResolveBuildDefinitionJob.this.propertyValue instanceof String && !ResolveBuildDefinitionJob.this.propertyValue.equalsIgnoreCase("") && ResolveBuildDefinitionJob.this.propertyID.equalsIgnoreCase(PromotionBuildPropertyFactory.getInstance().resolvePropertyId("team.enterprise.promotion.sourceDefinition", PromotionBuildConfigurationEditor.this.buildDefinitionWorkingCopy)) && PromotionBuildConfigurationEditor.this.componentTableViewer != null && !PromotionBuildConfigurationEditor.this.componentTableViewer.getControl().isDisposed()) {
                            PromotionBuildConfigurationEditor.this.componentTableViewer.setInput((Object)ResolveBuildDefinitionJob.this.propertyValue);
                        }
                        ResolveBuildDefinitionJob.this.targetWidget.setData("buildDefinition", (Object)ResolveBuildDefinitionJob.this.def);
                        if (ResolveBuildDefinitionJob.this.def != null) {
                            ResolveBuildDefinitionJob.this.targetWidget.setBackground(Display.getCurrent().getSystemColor(1));
                        }
                        ResolveBuildDefinitionJob.this.targetWidgetButton.setEnabled(true);
                        PromotionBuildConfigurationEditor.this.setBuildDefinitionTitleHyperlinkEnablement(ResolveBuildDefinitionJob.this.targetLink, ResolveBuildDefinitionJob.this.def != null);
                        if (ResolveBuildDefinitionJob.this.retrieveScanningEnablementStatus) {
                            PromotionBuildConfigurationEditor.this.initializeScanningEnablementStatus(ResolveBuildDefinitionJob.this.def, ResolveBuildDefinitionJob.this.targetWidget);
                        }
                    }
                }
            });
        }
    }

    class RetrieveScanningEnablementStatusJob
    extends Job {
        private IScanConfiguration scanConfiguration;
        private IWorkspace stream;
        private final IWorkspaceHandle buildWorkspaceHandle;

        public RetrieveScanningEnablementStatusJob(IWorkspaceHandle buildWorkspaceHandle) {
            super("");
            this.buildWorkspaceHandle = buildWorkspaceHandle;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                CurrentFlows cf;
                IWorkspace buildWorkspace = (IWorkspace)PromotionBuildConfigurationEditor.this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.buildWorkspaceHandle, 0, (IProgressMonitor)progress.newChild(50));
                if (buildWorkspace != null && (cf = ((Workspace)buildWorkspace).getCurrentFlows()) != null && cf.getDefaultDeliverFlow() != null) {
                    IWorkspaceHandle streamHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(cf.getDefaultDeliverFlow(), null);
                    this.stream = (IWorkspace)PromotionBuildConfigurationEditor.this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)streamHandle, 0, Collections.singletonList(IWorkspace.NAME_PROPERTY), (IProgressMonitor)progress.newChild(50));
                    IScdClient scdClient = (IScdClient)PromotionBuildConfigurationEditor.this.getTeamRepository().getClientLibrary(IScdClient.class);
                    this.scanConfiguration = scdClient.getScanConfiguration(streamHandle);
                }
            }
            catch (TeamRepositoryException e) {
                Activator.log((Throwable)e);
            }
            return Status.OK_STATUS;
        }

        public IScanConfiguration getScanConfiguration() {
            try {
                this.schedule();
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.scanConfiguration;
        }

        public IWorkspace getStream() {
            if (this.scanConfiguration == null) {
                this.getScanConfiguration();
            }
            return this.stream;
        }
    }
}

