/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.editors;

import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.enterprise.internal.promotion.ui.editors.AbstractPromotionConfigurationEditor;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class IbmiPromotionConfigurationEditor
extends AbstractPromotionConfigurationEditor {
    protected static final String VALIDATION_ERROR_NO_DESTINATION = "validationErrorNoDestination";
    protected static final String VALIDATION_ERROR_USER_DEFINED_INVALID = "validationErrorUserDefinedInvalid";
    private Text destinationTextField;
    private Text preCommandTextField;
    private Text postCommandTextField;
    private Button ibmiRestorePfReplaceMethodRadio;
    private Button ibmiRestorePfMigrateMethodRadio;
    private Button ibmiRestorePfUsrCmdMethodRadio;
    private Text ibmiRestorePfUsrCmdTextField;

    public IbmiPromotionConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    protected final PromotionInfo.PromotionBuildType getPromotionBuildType() {
        return PromotionInfo.PromotionBuildType.ibmi;
    }

    @Override
    protected void layoutSections(Composite parent) {
        Section scopeSection = this.createScopeSection(parent);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, SECTION_INDENT);
        data.right = new FormAttachment(50);
        scopeSection.setLayoutData((Object)data);
        Section toolkitSection = this.createToolkitSection(parent);
        data = new FormData();
        data.left = new FormAttachment((Control)scopeSection, SECTION_INDENT);
        data.right = new FormAttachment(100);
        toolkitSection.setLayoutData((Object)data);
        Section promotingPhysicalFileSection = this.createIBMiPfOptionSection(parent);
        data = new FormData();
        data.top = new FormAttachment((Control)toolkitSection, SECTION_INDENT);
        data.left = new FormAttachment(50, SECTION_INDENT);
        data.right = new FormAttachment(100);
        promotingPhysicalFileSection.setLayoutData((Object)data);
        Section promotionTypeSection = this.createPromotionTypeSection(parent);
        data = new FormData();
        data.top = new FormAttachment((Control)scopeSection, SECTION_INDENT);
        data.left = new FormAttachment(0, SECTION_INDENT);
        data.right = new FormAttachment(50);
        data.bottom = new FormAttachment(100);
        promotionTypeSection.setLayoutData((Object)data);
        Section advancedSection = this.createAdvancedOptionsSection(parent);
        data = new FormData();
        data.top = new FormAttachment((Control)promotingPhysicalFileSection, SECTION_INDENT);
        data.left = new FormAttachment(50, SECTION_INDENT);
        data.right = new FormAttachment(100);
        advancedSection.setLayoutData((Object)data);
        Section antConfigurationSection = this.createAntConfigurationSection(parent);
        data = new FormData();
        data.top = new FormAttachment((Control)advancedSection, SECTION_INDENT);
        data.left = new FormAttachment(50, SECTION_INDENT);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        antConfigurationSection.setLayoutData((Object)data);
    }

    protected Section createToolkitSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 320);
        section.setText(Messages.AbstractPromotionConfigurationEditor_SECTION_TOOLKIT_LABEL);
        section.setLayout((Layout)new FillLayout());
        Composite sectionContainer = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionContainer);
        section.setClient((Control)sectionContainer);
        toolkit.createLabel(sectionContainer, Messages.PromotionConfigurationEditor_TARGET_WORKINGDIR_LABEL);
        this.destinationTextField = toolkit.createText(sectionContainer, this.getProperty("team.enterprise.promotion.destinationPath", ""), 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.destinationTextField);
        this.destinationTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IbmiPromotionConfigurationEditor.this.setProperty("team.enterprise.promotion.destinationPath", IbmiPromotionConfigurationEditor.this.destinationTextField.getText().trim());
                IbmiPromotionConfigurationEditor.this.setDirty(true);
                IbmiPromotionConfigurationEditor.this.validate();
            }
        });
        toolkit.createLabel(sectionContainer, Messages.PromotionConfigurationEditor_IBMI_PRE_COMMAND_LABEL);
        this.preCommandTextField = toolkit.createText(sectionContainer, this.getProperty("team.enterprise.promotion.ibmi.preCommand", ""), 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.preCommandTextField);
        this.preCommandTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IbmiPromotionConfigurationEditor.this.setProperty("team.enterprise.promotion.ibmi.preCommand", IbmiPromotionConfigurationEditor.this.preCommandTextField.getText().trim());
                IbmiPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        toolkit.createLabel(sectionContainer, Messages.PromotionConfigurationEditor_IBMI_POST_COMMAND_LABEL);
        this.postCommandTextField = toolkit.createText(sectionContainer, this.getProperty("team.enterprise.promotion.ibmi.postCommand", ""));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.postCommandTextField);
        this.postCommandTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IbmiPromotionConfigurationEditor.this.setProperty("team.enterprise.promotion.ibmi.postCommand", IbmiPromotionConfigurationEditor.this.postCommandTextField.getText().trim());
                IbmiPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        return section;
    }

    private Section createIBMiPfOptionSection(Composite parent) {
        String restoreOptionProperty = this.getProperty("team.promotion.ibmi.pfRestoreMethod", null);
        boolean restoreOptionNotSet = restoreOptionProperty == null;
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 450);
        section.setText(Messages.PromotionConfigurationEditor_SECTION_IBMI_PF);
        section.setDescription(Messages.PromotionConfigurationEditor_SECTION_IBMI_PF_DESCRIPTION);
        section.setLayout((Layout)new FillLayout());
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        section.setClient((Control)composite);
        this.ibmiRestorePfReplaceMethodRadio = toolkit.createButton(composite, Messages.PromotionConfigurationEditor_BUTTON_PROMOTION_IBMI_RESTORE_PF_DEFAULT, 16);
        boolean selected = restoreOptionNotSet || "REPLACE".equals(restoreOptionProperty);
        this.ibmiRestorePfReplaceMethodRadio.setSelection(selected);
        this.ibmiRestorePfReplaceMethodRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IbmiPromotionConfigurationEditor.this.setProperty("team.promotion.ibmi.pfRestoreMethod", "REPLACE");
                IbmiPromotionConfigurationEditor.this.ibmiRestorePfUsrCmdTextField.setEnabled(false);
                IbmiPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        this.ibmiRestorePfMigrateMethodRadio = toolkit.createButton(composite, Messages.PromotionConfigurationEditor_BUTTON_PROMOTION_IBMI_RESTORE_PF_MIGRATE, 16);
        selected = !restoreOptionNotSet && "MIGRATE".equals(restoreOptionProperty);
        this.ibmiRestorePfMigrateMethodRadio.setSelection(selected);
        this.ibmiRestorePfMigrateMethodRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IbmiPromotionConfigurationEditor.this.setProperty("team.promotion.ibmi.pfRestoreMethod", "MIGRATE");
                IbmiPromotionConfigurationEditor.this.ibmiRestorePfUsrCmdTextField.setEnabled(false);
                IbmiPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        this.ibmiRestorePfUsrCmdMethodRadio = toolkit.createButton(composite, Messages.PromotionConfigurationEditor_BUTTON_PROMOTION_IBMI_RESTORE_PF_USRCMD, 16);
        selected = !restoreOptionNotSet && "USRCMD".equals(restoreOptionProperty);
        this.ibmiRestorePfUsrCmdMethodRadio.setSelection(selected);
        this.ibmiRestorePfUsrCmdMethodRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IbmiPromotionConfigurationEditor.this.setProperty("team.promotion.ibmi.pfRestoreMethod", "USRCMD");
                IbmiPromotionConfigurationEditor.this.ibmiRestorePfUsrCmdTextField.setEnabled(true);
                IbmiPromotionConfigurationEditor.this.setDirty(true);
                IbmiPromotionConfigurationEditor.this.validate();
            }
        });
        String userDefinedCommand = this.getProperty("team.promotion.ibmi.pfRestoreCommand", "");
        this.ibmiRestorePfUsrCmdTextField = toolkit.createText(composite, userDefinedCommand, 0);
        this.ibmiRestorePfUsrCmdTextField.setEnabled(selected);
        this.ibmiRestorePfUsrCmdTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IbmiPromotionConfigurationEditor.this.setProperty("team.promotion.ibmi.pfRestoreCommand", IbmiPromotionConfigurationEditor.this.ibmiRestorePfUsrCmdTextField.getText().trim());
                IbmiPromotionConfigurationEditor.this.setDirty(true);
                IbmiPromotionConfigurationEditor.this.validate();
            }
        });
        GridDataFactory.fillDefaults().indent(15, -1).grab(true, false).applyTo((Control)this.ibmiRestorePfUsrCmdTextField);
        return section;
    }

    @Override
    public boolean validate() {
        if (this.destinationTextField != null) {
            if (this.destinationTextField.getText().trim().isEmpty()) {
                this.addErrorMessageForRequiredField(VALIDATION_ERROR_NO_DESTINATION, Messages.PromotionConfigurationEditor_DESTINATION_DIR_REQUIRED, (Control)this.destinationTextField);
            } else {
                this.removeMessage(VALIDATION_ERROR_NO_DESTINATION, (Control)this.destinationTextField);
            }
        }
        if (this.ibmiRestorePfUsrCmdMethodRadio != null && this.ibmiRestorePfUsrCmdTextField != null) {
            if (this.ibmiRestorePfUsrCmdMethodRadio.getSelection() && this.ibmiRestorePfUsrCmdTextField.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(VALIDATION_ERROR_USER_DEFINED_INVALID, Messages.PromotionConfigurationEditor_PF_USRCMD_NOT_VALID, (Control)this.ibmiRestorePfUsrCmdTextField);
            } else {
                this.removeMessage(VALIDATION_ERROR_USER_DEFINED_INVALID, (Control)this.ibmiRestorePfUsrCmdTextField);
            }
        }
        return super.validate();
    }
}

