/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.forms.widgets.SizeCache;

public class CheckboxExpandableComposite
extends Canvas {
    public static final int EXPANDED = 2;
    private Button checkbox;
    private Control client;
    private boolean expanded;
    public int marginWidth = 0;
    public int marginHeight = 0;
    static final int IGAP = 4;
    static final int clientIndent = 15;
    static final int clientVerticalSpacing = 3;
    private SelectionListener selectionListener;

    public CheckboxExpandableComposite(Composite parent, String label, int expansionStyle) {
        super(parent, 0);
        super.setLayout((Layout)new ExpandableLayout());
        if ((expansionStyle & 2) != 0) {
            this.expanded = true;
        }
        this.checkbox = new Button((Composite)this, 32);
        this.checkbox.setText(label);
        this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckboxExpandableComposite.this.setExpanded(CheckboxExpandableComposite.this.checkbox.getSelection());
                if (CheckboxExpandableComposite.this.selectionListener != null) {
                    Event newEvent = CheckboxExpandableComposite.this.createEvent();
                    SelectionEvent event = new SelectionEvent(newEvent);
                    CheckboxExpandableComposite.this.selectionListener.widgetSelected(event);
                }
            }
        });
        if (this.expanded) {
            this.checkbox.setSelection(true);
        }
    }

    public boolean forceFocus() {
        return false;
    }

    public void setMenu(Menu menu) {
        if (this.checkbox != null) {
            this.checkbox.setMenu(menu);
        }
        super.setMenu(menu);
    }

    public final void setLayout(Layout layout) {
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.checkbox != null) {
            this.checkbox.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.checkbox != null) {
            this.checkbox.setForeground(fg);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.checkbox != null) {
            this.checkbox.setFont(font);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.checkbox != null) {
            this.checkbox.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public boolean getSelection() {
        return this.checkbox.getSelection();
    }

    public void setClient(Control client) {
        Assert.isTrue((client != null && client.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.client = client;
    }

    public Control getClient() {
        return this.client;
    }

    protected Event createEvent() {
        Event event = new Event();
        event.widget = this;
        return event;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListener = listener;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.internalSetExpanded(expanded);
    }

    protected void internalSetExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.expanded = expanded;
            if (this.client != null) {
                this.client.setVisible(expanded);
            }
            this.layout();
        }
        this.reflow();
    }

    protected void reflow() {
        CheckboxExpandableComposite c = this;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite || c instanceof Shell) break;
        }
        for (c = this; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof SharedScrolledComposite)) continue;
            ((SharedScrolledComposite)c).reflow(true);
            break;
        }
        c = this;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite || c instanceof Shell) break;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        ExpandableLayout layout = (ExpandableLayout)this.getLayout();
        Point size = wHint == -1 || hHint == -1 ? layout.computeSize((Composite)this, wHint, hHint, changed) : new Point(wHint, hHint);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    private class ExpandableLayout
    extends Layout
    implements ILayoutExtension {
        private SizeCache toggleCache = new SizeCache();
        private SizeCache clientCache = new SizeCache();

        private ExpandableLayout() {
        }

        private void initCache(boolean shouldFlush) {
            this.toggleCache.setControl((Control)CheckboxExpandableComposite.this.checkbox);
            this.clientCache.setControl(CheckboxExpandableComposite.this.client);
            if (shouldFlush) {
                this.toggleCache.flush();
                this.clientCache.flush();
            }
        }

        protected void layout(Composite parent, boolean changed) {
            this.initCache(changed);
            int x = CheckboxExpandableComposite.this.marginWidth;
            int y = CheckboxExpandableComposite.this.marginHeight;
            Point toggleSize = this.toggleCache.computeSize(-1, -1);
            this.toggleCache.setBounds(x, y, toggleSize.x, toggleSize.y);
            y += toggleSize.y;
            if (CheckboxExpandableComposite.this.expanded) {
                Point clientSize = this.clientCache.computeSize(-1, -1);
                int clientWidth = clientSize.x - CheckboxExpandableComposite.this.marginWidth - CheckboxExpandableComposite.this.marginWidth;
                int clientHeight = clientSize.y - CheckboxExpandableComposite.this.marginHeight - CheckboxExpandableComposite.this.marginHeight;
                this.clientCache.setBounds(x + 15, y += 3, clientWidth, clientHeight);
            }
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            this.initCache(changed);
            Point toggleSize = this.toggleCache.computeSize(wHint, hHint);
            Point clientSize = this.clientCache.computeSize(wHint, hHint);
            int width = Math.max(toggleSize.x, clientSize.x) + CheckboxExpandableComposite.this.marginWidth + CheckboxExpandableComposite.this.marginWidth;
            if (CheckboxExpandableComposite.this.expanded) {
                width += 15;
            }
            int height = toggleSize.y + 3 + CheckboxExpandableComposite.this.marginHeight + CheckboxExpandableComposite.this.marginHeight;
            if (CheckboxExpandableComposite.this.expanded) {
                height += clientSize.y;
            }
            return new Point(width, height);
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            return this.computeSize((Composite)parent, (int)0, (int)-1, (boolean)changed).x;
        }

        public int computeMaximumWidth(Composite parent, boolean changed) {
            return this.computeSize((Composite)parent, (int)-1, (int)-1, (boolean)changed).x;
        }
    }
}

